/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.node.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.proofpoint.node.NodeConfig;
import com.proofpoint.node.NodeInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.guice.ExportBinder;

public class TestingNodeModule
implements Module {
    private static final AtomicLong nextId = new AtomicLong(ThreadLocalRandom.current().nextInt(1000000));
    private final String environment;
    private final Optional<String> pool;

    public TestingNodeModule() {
        this(Optional.empty());
    }

    public TestingNodeModule(Optional<String> environment) {
        this(environment.orElse("test" + nextId.getAndIncrement()));
    }

    public TestingNodeModule(String environment) {
        this(environment, Optional.empty());
    }

    public TestingNodeModule(String environment, Optional<String> pool) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)environment) ? 1 : 0) != 0, (Object)"environment is null or empty");
        this.environment = environment;
        this.pool = Objects.requireNonNull(pool, "pool is null");
    }

    public TestingNodeModule(String environment, String pool) {
        this(environment, Optional.of(Objects.requireNonNull(pool, "pool is null")));
    }

    public void configure(Binder binder) {
        NodeConfig nodeConfig = new NodeConfig().setEnvironment(this.environment).setNodeInternalIp(TestingNodeModule.getV4Localhost()).setNodeBindIp(TestingNodeModule.getV4Localhost());
        if (this.pool.isPresent()) {
            nodeConfig.setPool(this.pool.get());
        }
        binder.bind(NodeConfig.class).toInstance((Object)nodeConfig);
        ExportBinder.newExporter((Binder)binder).export(NodeInfo.class).withGeneratedName();
    }

    @Provides
    @Singleton
    NodeInfo createNodeInfo(NodeConfig config) {
        return new NodeInfo("test-application", config);
    }

    public static NodeInfo createNodeInfo() {
        return new NodeInfo("test-application", new NodeConfig().setEnvironment("test" + nextId.getAndIncrement()).setNodeInternalIp(TestingNodeModule.getV4Localhost()).setNodeBindIp(TestingNodeModule.getV4Localhost()));
    }

    private static InetAddress getV4Localhost() {
        try {
            return InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)"Could not create localhost address");
        }
    }
}

