/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.node;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.proofpoint.node.ApplicationName;
import com.proofpoint.node.ApplicationVersion;
import com.proofpoint.node.PlatformVersion;
import java.util.Objects;

public class ApplicationNameModule
implements Module {
    private final String applicationName;

    public ApplicationNameModule(String applicationName) {
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName is null");
    }

    public void configure(Binder binder) {
        binder.bindConstant().annotatedWith(ApplicationName.class).to(this.applicationName);
        binder.bindConstant().annotatedWith(ApplicationVersion.class).to(Objects.requireNonNullElse(System.getProperty("launcher.main.version"), ""));
        binder.bindConstant().annotatedWith(PlatformVersion.class).to(Objects.requireNonNullElse(this.getClass().getPackage().getImplementationVersion(), ""));
    }
}

