/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.config;

import com.qingcloud.sdk.request.ParamValidate;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class EnvContext
implements ParamValidate {
    private String accessKey;
    private String accessSecret;
    private String host;
    private String port;
    private String protocol;
    private String uri;
    private String apiLang;
    private String zone;
    private boolean safeOkHttp = true;

    public boolean isSafeOkHttp() {
        return this.safeOkHttp;
    }

    public void setSafeOkHttp(boolean safeOkHttp) {
        this.safeOkHttp = safeOkHttp;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUri() {
        return this.uri;
    }

    public String getRequestUrl() {
        String url = String.format("%s://%s", this.getProtocol(), this.getHost());
        if (!QCStringUtil.isEmpty(this.getPort())) {
            url = String.format("%s:%s", url, this.getPort());
        }
        if (!QCStringUtil.isEmpty(this.getUri())) {
            url = String.format("%s/%s/", url, this.getUri());
        }
        return url;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getApiLang() {
        return this.apiLang;
    }

    public void setApiLang(String apiLang) {
        this.apiLang = apiLang;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    private EnvContext() {
    }

    public EnvContext(String accessKey, String accessSecret) {
        this.setAccessKey(accessKey);
        this.setAccessSecret(accessSecret);
        this.setHost("api.qingcloud.com");
        this.setUri("iaas");
        this.setProtocol("https");
        this.setPort("443");
        this.setZone("pek3b");
        this.setApiLang("zh-cn");
    }

    public EnvContext(String accessKey, String accessSecret, String apiLang) {
        this(accessKey, accessSecret);
        this.setApiLang(apiLang);
    }

    public EnvContext(String protocol, String host, String port, String accessKey, String accessSecret, String apiLang) {
        this.setAccessKey(accessKey);
        this.setAccessSecret(accessSecret);
        this.setProtocol(protocol);
        this.setHost(host);
        this.setPort(port);
        this.setApiLang(apiLang);
        this.setUri("iaas");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnvContext loadFromFile(String filePathName) {
        EnvContext env = new EnvContext();
        File f = new File(filePathName);
        if (f.exists()) {
            BufferedReader br = null;
            HashMap<String, String> confParams = new HashMap<String, String>();
            try {
                String strConf;
                br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                while ((strConf = br.readLine()) != null) {
                    String[] str = strConf.split(":");
                    if (str.length <= 1) continue;
                    confParams.put(str[0].trim(), str[1].trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            env.setAccessKey((String)confParams.get("access_key"));
            env.setAccessSecret((String)confParams.get("access_secret"));
            env.setProtocol((String)confParams.get("protocol"));
            env.setHost((String)confParams.get("host"));
            env.setUri((String)confParams.get("uri"));
            env.setPort((String)confParams.get("port"));
            env.setZone((String)confParams.get("zone"));
        }
        return env;
    }

    @Override
    public String validateParam() {
        if (QCStringUtil.isEmpty(this.getAccessKey())) {
            return QCStringUtil.getParameterRequired("AccessKey", "EnvContext");
        }
        if (QCStringUtil.isEmpty(this.getAccessSecret())) {
            return QCStringUtil.getParameterRequired("AccessSecret", "EnvContext");
        }
        if (QCStringUtil.isEmpty(this.getRequestUrl())) {
            return QCStringUtil.getParameterRequired("host", "EnvContext");
        }
        return null;
    }
}

