/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.request;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.utils.QCParamInvokeUtil;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCOkHttpRequestClient {
    private static final Logger logger = LoggerFactory.getLogger(QCOkHttpRequestClient.class);
    private OkHttpClient client = null;
    private OkHttpClient unsafeClient = null;
    private static QCOkHttpRequestClient ins;

    protected QCOkHttpRequestClient() {
        this.intiOkHttpClient();
    }

    public void intiOkHttpClient() {
        this.client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(100L, TimeUnit.SECONDS).writeTimeout(100L, TimeUnit.SECONDS).build();
        this.unsafeClient = QCOkHttpRequestClient.getUnsafeOkHttpClient();
    }

    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(100L, TimeUnit.SECONDS).writeTimeout(100L, TimeUnit.SECONDS);
            builder.sslSocketFactory(sslSocketFactory, new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            });
            builder.hostnameVerifier((hostname, session) -> true);
            return builder.build();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QCOkHttpRequestClient getInstance() {
        if (ins != null) return ins;
        Class<QCOkHttpRequestClient> clazz = QCOkHttpRequestClient.class;
        synchronized (QCOkHttpRequestClient.class) {
            if (ins != null) return ins;
            ins = new QCOkHttpRequestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    private Call getRequestCall(boolean bSafe, Request request) {
        if (bSafe) {
            return this.client.newCall(request);
        }
        return this.unsafeClient.newCall(request);
    }

    public Request buildGetRequest(String requestUrl, String uri) {
        String url = requestUrl.indexOf("?") > 0 ? String.format("%s&%s", requestUrl, uri) : String.format("%s?%s", requestUrl, uri);
        logger.debug("get url: {}", (Object)url);
        Request.Builder builder = new Request.Builder();
        builder.addHeader("User-Agent", QCStringUtil.getUserAgent());
        return builder.url(url).build();
    }

    public Request buildPostRequest(String requestUrl, String body) {
        logger.debug("post body: {}", (Object)body);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8"), (String)body);
        return new Request.Builder().url(requestUrl).post(requestBody).build();
    }

    public OutputModel requestAction(Request request, boolean bSafe, Class<? extends OutputModel> outputClass) throws QCException {
        Call okhttpCall = this.getRequestCall(bSafe, request);
        OutputModel model = (OutputModel)QCParamInvokeUtil.getOutputModel(outputClass);
        try {
            Response response = okhttpCall.execute();
            model = this.parseResponseToModel(response, outputClass);
        }
        catch (SocketTimeoutException exception) {
            model.setRetCode(5101);
            model.setMessage(String.format("[%s] Connection Timeout! Retry later or contact with admin", request.url().toString()));
            exception.printStackTrace();
        }
        catch (IOException e) {
            model.setRetCode(5000);
            model.setMessage("Fail to execute request");
            e.printStackTrace();
        }
        return model;
    }

    public void requestActionAsync(Request request, boolean bSafe, final ResponseCallBack callBack) {
        Call okhttpCall = this.getRequestCall(bSafe, request);
        okhttpCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                QCOkHttpRequestClient.this.onOkhttpFailure(e.getMessage(), callBack);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (callBack != null) {
                        OutputModel m = QCParamInvokeUtil.getOutputModel(callBack);
                        m = QCOkHttpRequestClient.this.parseResponseToModel(response, m.getClass());
                        callBack.onAPIResponse(m);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    QCOkHttpRequestClient.this.onOkhttpFailure(e.getMessage(), callBack);
                }
                finally {
                    if (response != null) {
                        Util.closeQuietly((Closeable)response.body().source());
                    }
                }
            }
        });
    }

    private void onOkhttpFailure(String message, ResponseCallBack callBack) {
        try {
            if (callBack != null) {
                OutputModel m = QCParamInvokeUtil.getOutputModel(callBack);
                QCOkHttpRequestClient.fillErrorModel(10000, message, m);
                callBack.onAPIResponse(m);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private OutputModel parseResponseToModel(Response response, Class<? extends OutputModel> clazz) throws IOException {
        String responseString = response.body().string();
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return (OutputModel)mapper.readValue(responseString, clazz);
    }

    static void fillErrorModel(int code, String content, OutputModel model) {
        model.setRetCode(code);
        model.setMessage(content);
    }
}

