/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class CacheService {
    private EnvContext envContext;
    private String zone;

    public CacheService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public CacheService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AddCacheNodesOutput addCacheNodes(AddCacheNodesInput input) throws QCException {
        if (input == null) {
            input = new AddCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddCacheNodes");
        context.put("APIName", "AddCacheNodes");
        context.put("ServiceName", "AddCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddCacheNodes");
        input.setAction("AddCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddCacheNodesOutput.class);
        if (backModel != null) {
            return (AddCacheNodesOutput)backModel;
        }
        return null;
    }

    public void addCacheNodes(AddCacheNodesInput input, ResponseCallBack<AddCacheNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new AddCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddCacheNodes");
        context.put("APIName", "AddCacheNodes");
        context.put("ServiceName", "AddCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddCacheNodes");
        input.setAction("AddCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ApplyCacheParameterGroupOutput applyCacheParameterGroup(ApplyCacheParameterGroupInput input) throws QCException {
        if (input == null) {
            input = new ApplyCacheParameterGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplyCacheParameterGroup");
        context.put("APIName", "ApplyCacheParameterGroup");
        context.put("ServiceName", "ApplyCacheParameterGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplyCacheParameterGroup");
        input.setAction("ApplyCacheParameterGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ApplyCacheParameterGroupOutput.class);
        if (backModel != null) {
            return (ApplyCacheParameterGroupOutput)backModel;
        }
        return null;
    }

    public void applyCacheParameterGroup(ApplyCacheParameterGroupInput input, ResponseCallBack<ApplyCacheParameterGroupOutput> callback) throws QCException {
        if (input == null) {
            input = new ApplyCacheParameterGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplyCacheParameterGroup");
        context.put("APIName", "ApplyCacheParameterGroup");
        context.put("ServiceName", "ApplyCacheParameterGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplyCacheParameterGroup");
        input.setAction("ApplyCacheParameterGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ChangeCacheVxNetOutput changeCacheVxNet(ChangeCacheVxNetInput input) throws QCException {
        if (input == null) {
            input = new ChangeCacheVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ChangeCacheVxnet");
        context.put("APIName", "ChangeCacheVxnet");
        context.put("ServiceName", "ChangeCacheVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ChangeCacheVxnet");
        input.setAction("ChangeCacheVxnet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ChangeCacheVxNetOutput.class);
        if (backModel != null) {
            return (ChangeCacheVxNetOutput)backModel;
        }
        return null;
    }

    public void changeCacheVxNet(ChangeCacheVxNetInput input, ResponseCallBack<ChangeCacheVxNetOutput> callback) throws QCException {
        if (input == null) {
            input = new ChangeCacheVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ChangeCacheVxNet");
        context.put("APIName", "ChangeCacheVxNet");
        context.put("ServiceName", "ChangeCacheVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ChangeCacheVxnet");
        input.setAction("ChangeCacheVxNet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateCacheOutput createCache(CreateCacheInput input) throws QCException {
        if (input == null) {
            input = new CreateCacheInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCache");
        context.put("APIName", "CreateCache");
        context.put("ServiceName", "CreateCache");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCache");
        input.setAction("CreateCache");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateCacheOutput.class);
        if (backModel != null) {
            return (CreateCacheOutput)backModel;
        }
        return null;
    }

    public void createCache(CreateCacheInput input, ResponseCallBack<CreateCacheOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateCacheInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCache");
        context.put("APIName", "CreateCache");
        context.put("ServiceName", "CreateCache");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCache");
        input.setAction("CreateCache");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateCacheFromSnapshotOutput createCacheFromSnapshot(CreateCacheFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CreateCacheFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCacheFromSnapshot");
        context.put("APIName", "CreateCacheFromSnapshot");
        context.put("ServiceName", "CreateCacheFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCacheFromSnapshot");
        input.setAction("CreateCacheFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateCacheFromSnapshotOutput.class);
        if (backModel != null) {
            return (CreateCacheFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void createCacheFromSnapshot(CreateCacheFromSnapshotInput input, ResponseCallBack<CreateCacheFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateCacheFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCacheFromSnapshot");
        context.put("APIName", "CreateCacheFromSnapshot");
        context.put("ServiceName", "CreateCacheFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCacheFromSnapshot");
        input.setAction("CreateCacheFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateCacheParameterGroupOutput createCacheParameterGroup(CreateCacheParameterGroupInput input) throws QCException {
        if (input == null) {
            input = new CreateCacheParameterGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCacheParameterGroup");
        context.put("APIName", "CreateCacheParameterGroup");
        context.put("ServiceName", "CreateCacheParameterGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCacheParameterGroup");
        input.setAction("CreateCacheParameterGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateCacheParameterGroupOutput.class);
        if (backModel != null) {
            return (CreateCacheParameterGroupOutput)backModel;
        }
        return null;
    }

    public void createCacheParameterGroup(CreateCacheParameterGroupInput input, ResponseCallBack<CreateCacheParameterGroupOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateCacheParameterGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCacheParameterGroup");
        context.put("APIName", "CreateCacheParameterGroup");
        context.put("ServiceName", "CreateCacheParameterGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCacheParameterGroup");
        input.setAction("CreateCacheParameterGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteCacheNodesOutput deleteCacheNodes(DeleteCacheNodesInput input) throws QCException {
        if (input == null) {
            input = new DeleteCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteCacheNodes");
        context.put("APIName", "DeleteCacheNodes");
        context.put("ServiceName", "DeleteCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteCacheNodes");
        input.setAction("DeleteCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteCacheNodesOutput.class);
        if (backModel != null) {
            return (DeleteCacheNodesOutput)backModel;
        }
        return null;
    }

    public void deleteCacheNodes(DeleteCacheNodesInput input, ResponseCallBack<DeleteCacheNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteCacheNodes");
        context.put("APIName", "DeleteCacheNodes");
        context.put("ServiceName", "DeleteCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteCacheNodes");
        input.setAction("DeleteCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteCacheParameterGroupsOutput deleteCacheParameterGroups(DeleteCacheParameterGroupsInput input) throws QCException {
        if (input == null) {
            input = new DeleteCacheParameterGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteCacheParameterGroups");
        context.put("APIName", "DeleteCacheParameterGroups");
        context.put("ServiceName", "DeleteCacheParameterGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteCacheParameterGroups");
        input.setAction("DeleteCacheParameterGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteCacheParameterGroupsOutput.class);
        if (backModel != null) {
            return (DeleteCacheParameterGroupsOutput)backModel;
        }
        return null;
    }

    public void deleteCacheParameterGroups(DeleteCacheParameterGroupsInput input, ResponseCallBack<DeleteCacheParameterGroupsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteCacheParameterGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteCacheParameterGroups");
        context.put("APIName", "DeleteCacheParameterGroups");
        context.put("ServiceName", "DeleteCacheParameterGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteCacheParameterGroups");
        input.setAction("DeleteCacheParameterGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteCachesOutput deleteCaches(DeleteCachesInput input) throws QCException {
        if (input == null) {
            input = new DeleteCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteCaches");
        context.put("APIName", "DeleteCaches");
        context.put("ServiceName", "DeleteCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteCaches");
        input.setAction("DeleteCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteCachesOutput.class);
        if (backModel != null) {
            return (DeleteCachesOutput)backModel;
        }
        return null;
    }

    public void deleteCaches(DeleteCachesInput input, ResponseCallBack<DeleteCachesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteCaches");
        context.put("APIName", "DeleteCaches");
        context.put("ServiceName", "DeleteCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteCaches");
        input.setAction("DeleteCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeCacheNodesOutput describeCacheNodes(DescribeCacheNodesInput input) throws QCException {
        if (input == null) {
            input = new DescribeCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCacheNodes");
        context.put("APIName", "DescribeCacheNodes");
        context.put("ServiceName", "DescribeCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCacheNodes");
        input.setAction("DescribeCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeCacheNodesOutput.class);
        if (backModel != null) {
            return (DescribeCacheNodesOutput)backModel;
        }
        return null;
    }

    public void describeCacheNodes(DescribeCacheNodesInput input, ResponseCallBack<DescribeCacheNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCacheNodes");
        context.put("APIName", "DescribeCacheNodes");
        context.put("ServiceName", "DescribeCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCacheNodes");
        input.setAction("DescribeCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeCacheParameterGroupsOutput describeCacheParameterGroups(DescribeCacheParameterGroupsInput input) throws QCException {
        if (input == null) {
            input = new DescribeCacheParameterGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCacheParameterGroups");
        context.put("APIName", "DescribeCacheParameterGroups");
        context.put("ServiceName", "DescribeCacheParameterGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCacheParameterGroups");
        input.setAction("DescribeCacheParameterGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeCacheParameterGroupsOutput.class);
        if (backModel != null) {
            return (DescribeCacheParameterGroupsOutput)backModel;
        }
        return null;
    }

    public void describeCacheParameterGroups(DescribeCacheParameterGroupsInput input, ResponseCallBack<DescribeCacheParameterGroupsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeCacheParameterGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCacheParameterGroups");
        context.put("APIName", "DescribeCacheParameterGroups");
        context.put("ServiceName", "DescribeCacheParameterGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCacheParameterGroups");
        input.setAction("DescribeCacheParameterGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeCacheParametersOutput describeCacheParameters(DescribeCacheParametersInput input) throws QCException {
        if (input == null) {
            input = new DescribeCacheParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCacheParameters");
        context.put("APIName", "DescribeCacheParameters");
        context.put("ServiceName", "DescribeCacheParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCacheParameters");
        input.setAction("DescribeCacheParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeCacheParametersOutput.class);
        if (backModel != null) {
            return (DescribeCacheParametersOutput)backModel;
        }
        return null;
    }

    public void describeCacheParameters(DescribeCacheParametersInput input, ResponseCallBack<DescribeCacheParametersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeCacheParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCacheParameters");
        context.put("APIName", "DescribeCacheParameters");
        context.put("ServiceName", "DescribeCacheParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCacheParameters");
        input.setAction("DescribeCacheParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeCachesOutput describeCaches(DescribeCachesInput input) throws QCException {
        if (input == null) {
            input = new DescribeCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCaches");
        context.put("APIName", "DescribeCaches");
        context.put("ServiceName", "DescribeCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCaches");
        input.setAction("DescribeCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeCachesOutput.class);
        if (backModel != null) {
            return (DescribeCachesOutput)backModel;
        }
        return null;
    }

    public void describeCaches(DescribeCachesInput input, ResponseCallBack<DescribeCachesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeCaches");
        context.put("APIName", "DescribeCaches");
        context.put("ServiceName", "DescribeCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeCaches");
        input.setAction("DescribeCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetCacheMonitorOutput getCacheMonitor(GetCacheMonitorInput input) throws QCException {
        if (input == null) {
            input = new GetCacheMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetCacheMonitor");
        context.put("APIName", "GetCacheMonitor");
        context.put("ServiceName", "GetCacheMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetCacheMonitor");
        input.setAction("GetCacheMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetCacheMonitorOutput.class);
        if (backModel != null) {
            return (GetCacheMonitorOutput)backModel;
        }
        return null;
    }

    public void getCacheMonitor(GetCacheMonitorInput input, ResponseCallBack<GetCacheMonitorOutput> callback) throws QCException {
        if (input == null) {
            input = new GetCacheMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetCacheMonitor");
        context.put("APIName", "GetCacheMonitor");
        context.put("ServiceName", "GetCacheMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetCacheMonitor");
        input.setAction("GetCacheMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyCacheAttributesOutput modifyCacheAttributes(ModifyCacheAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyCacheAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyCacheAttributes");
        context.put("APIName", "ModifyCacheAttributes");
        context.put("ServiceName", "ModifyCacheAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyCacheAttributes");
        input.setAction("ModifyCacheAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyCacheAttributesOutput.class);
        if (backModel != null) {
            return (ModifyCacheAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyCacheAttributes(ModifyCacheAttributesInput input, ResponseCallBack<ModifyCacheAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyCacheAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyCacheAttributes");
        context.put("APIName", "ModifyCacheAttributes");
        context.put("ServiceName", "ModifyCacheAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyCacheAttributes");
        input.setAction("ModifyCacheAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyCacheNodeAttributesOutput modifyCacheNodeAttributes(ModifyCacheNodeAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyCacheNodeAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyCacheNodeAttributes");
        context.put("APIName", "ModifyCacheNodeAttributes");
        context.put("ServiceName", "ModifyCacheNodeAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyCacheNodeAttributes");
        input.setAction("ModifyCacheNodeAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyCacheNodeAttributesOutput.class);
        if (backModel != null) {
            return (ModifyCacheNodeAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyCacheNodeAttributes(ModifyCacheNodeAttributesInput input, ResponseCallBack<ModifyCacheNodeAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyCacheNodeAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyCacheNodeAttributes");
        context.put("APIName", "ModifyCacheNodeAttributes");
        context.put("ServiceName", "ModifyCacheNodeAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyCacheNodeAttributes");
        input.setAction("ModifyCacheNodeAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyCacheParameterGroupAttributesOutput modifyCacheParameterGroupAttributes(ModifyCacheParameterGroupAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyCacheParameterGroupAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyCacheParameterGroupAttributes");
        context.put("APIName", "ModifyCacheParameterGroupAttributes");
        context.put("ServiceName", "ModifyCacheParameterGroupAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyCacheParameterGroupAttributes");
        input.setAction("ModifyCacheParameterGroupAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyCacheParameterGroupAttributesOutput.class);
        if (backModel != null) {
            return (ModifyCacheParameterGroupAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyCacheParameterGroupAttributes(ModifyCacheParameterGroupAttributesInput input, ResponseCallBack<ModifyCacheParameterGroupAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyCacheParameterGroupAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyCacheParameterGroupAttributes");
        context.put("APIName", "ModifyCacheParameterGroupAttributes");
        context.put("ServiceName", "ModifyCacheParameterGroupAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyCacheParameterGroupAttributes");
        input.setAction("ModifyCacheParameterGroupAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResetCacheParametersOutput resetCacheParameters(ResetCacheParametersInput input) throws QCException {
        if (input == null) {
            input = new ResetCacheParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResetCacheParameters");
        context.put("APIName", "ResetCacheParameters");
        context.put("ServiceName", "ResetCacheParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResetCacheParameters");
        input.setAction("ResetCacheParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResetCacheParametersOutput.class);
        if (backModel != null) {
            return (ResetCacheParametersOutput)backModel;
        }
        return null;
    }

    public void resetCacheParameters(ResetCacheParametersInput input, ResponseCallBack<ResetCacheParametersOutput> callback) throws QCException {
        if (input == null) {
            input = new ResetCacheParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResetCacheParameters");
        context.put("APIName", "ResetCacheParameters");
        context.put("ServiceName", "ResetCacheParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResetCacheParameters");
        input.setAction("ResetCacheParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResizeCachesOutput resizeCaches(ResizeCachesInput input) throws QCException {
        if (input == null) {
            input = new ResizeCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeCaches");
        context.put("APIName", "ResizeCaches");
        context.put("ServiceName", "ResizeCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeCaches");
        input.setAction("ResizeCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResizeCachesOutput.class);
        if (backModel != null) {
            return (ResizeCachesOutput)backModel;
        }
        return null;
    }

    public void resizeCaches(ResizeCachesInput input, ResponseCallBack<ResizeCachesOutput> callback) throws QCException {
        if (input == null) {
            input = new ResizeCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeCaches");
        context.put("APIName", "ResizeCaches");
        context.put("ServiceName", "ResizeCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeCaches");
        input.setAction("ResizeCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RestartCacheNodesOutput restartCacheNodes(RestartCacheNodesInput input) throws QCException {
        if (input == null) {
            input = new RestartCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartCacheNodes");
        context.put("APIName", "RestartCacheNodes");
        context.put("ServiceName", "RestartCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartCacheNodes");
        input.setAction("RestartCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RestartCacheNodesOutput.class);
        if (backModel != null) {
            return (RestartCacheNodesOutput)backModel;
        }
        return null;
    }

    public void restartCacheNodes(RestartCacheNodesInput input, ResponseCallBack<RestartCacheNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new RestartCacheNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartCacheNodes");
        context.put("APIName", "RestartCacheNodes");
        context.put("ServiceName", "RestartCacheNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartCacheNodes");
        input.setAction("RestartCacheNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RestartCachesOutput restartCaches(RestartCachesInput input) throws QCException {
        if (input == null) {
            input = new RestartCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartCaches");
        context.put("APIName", "RestartCaches");
        context.put("ServiceName", "RestartCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartCaches");
        input.setAction("RestartCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RestartCachesOutput.class);
        if (backModel != null) {
            return (RestartCachesOutput)backModel;
        }
        return null;
    }

    public void restartCaches(RestartCachesInput input, ResponseCallBack<RestartCachesOutput> callback) throws QCException {
        if (input == null) {
            input = new RestartCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartCaches");
        context.put("APIName", "RestartCaches");
        context.put("ServiceName", "RestartCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartCaches");
        input.setAction("RestartCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StartCachesOutput startCaches(StartCachesInput input) throws QCException {
        if (input == null) {
            input = new StartCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartCaches");
        context.put("APIName", "StartCaches");
        context.put("ServiceName", "StartCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartCaches");
        input.setAction("StartCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StartCachesOutput.class);
        if (backModel != null) {
            return (StartCachesOutput)backModel;
        }
        return null;
    }

    public void startCaches(StartCachesInput input, ResponseCallBack<StartCachesOutput> callback) throws QCException {
        if (input == null) {
            input = new StartCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartCaches");
        context.put("APIName", "StartCaches");
        context.put("ServiceName", "StartCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartCaches");
        input.setAction("StartCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StopCachesOutput stopCaches(StopCachesInput input) throws QCException {
        if (input == null) {
            input = new StopCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopCaches");
        context.put("APIName", "StopCaches");
        context.put("ServiceName", "StopCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopCaches");
        input.setAction("StopCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StopCachesOutput.class);
        if (backModel != null) {
            return (StopCachesOutput)backModel;
        }
        return null;
    }

    public void stopCaches(StopCachesInput input, ResponseCallBack<StopCachesOutput> callback) throws QCException {
        if (input == null) {
            input = new StopCachesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopCaches");
        context.put("APIName", "StopCaches");
        context.put("ServiceName", "StopCaches");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopCaches");
        input.setAction("StopCaches");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public UpdateCacheOutput updateCache(UpdateCacheInput input) throws QCException {
        if (input == null) {
            input = new UpdateCacheInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateCache");
        context.put("APIName", "UpdateCache");
        context.put("ServiceName", "UpdateCache");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateCache");
        input.setAction("UpdateCache");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, UpdateCacheOutput.class);
        if (backModel != null) {
            return (UpdateCacheOutput)backModel;
        }
        return null;
    }

    public void updateCache(UpdateCacheInput input, ResponseCallBack<UpdateCacheOutput> callback) throws QCException {
        if (input == null) {
            input = new UpdateCacheInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateCache");
        context.put("APIName", "UpdateCache");
        context.put("ServiceName", "UpdateCache");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateCache");
        input.setAction("UpdateCache");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public UpdateCacheParametersOutput updateCacheParameters(UpdateCacheParametersInput input) throws QCException {
        if (input == null) {
            input = new UpdateCacheParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateCacheParameters");
        context.put("APIName", "UpdateCacheParameters");
        context.put("ServiceName", "UpdateCacheParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateCacheParameters");
        input.setAction("UpdateCacheParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, UpdateCacheParametersOutput.class);
        if (backModel != null) {
            return (UpdateCacheParametersOutput)backModel;
        }
        return null;
    }

    public void updateCacheParameters(UpdateCacheParametersInput input, ResponseCallBack<UpdateCacheParametersOutput> callback) throws QCException {
        if (input == null) {
            input = new UpdateCacheParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateCacheParameters");
        context.put("APIName", "UpdateCacheParameters");
        context.put("ServiceName", "UpdateCacheParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateCacheParameters");
        input.setAction("UpdateCacheParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UpdateCacheParametersOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class UpdateCacheParametersInput
    extends IaasParamBody {
        private String cacheParameterGroup;
        private Types.CacheParameterModel parameters;

        @JsonProperty(value="cache_parameter_group")
        public void setCacheParameterGroup(String cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group")
        public String getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @JsonProperty(value="parameters")
        public void setParameters(Types.CacheParameterModel parameters) {
            this.parameters = parameters;
        }

        @JsonProperty(value="parameters")
        public Types.CacheParameterModel getParameters() {
            return this.parameters;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheParameterGroup())) {
                throw new QCException("CacheParameterGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UpdateCacheOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class UpdateCacheInput
    extends IaasParamBody {
        private String cache;
        private List<Types.CachePrivateIPModel> privateIPs;

        @JsonProperty(value="cache")
        public void setCache(String cache) {
            this.cache = cache;
        }

        @JsonProperty(value="cache")
        public String getCache() {
            return this.cache;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.CachePrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.CachePrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (QCStringUtil.isEmpty(this.getCache())) {
                throw new QCException("Cache is required");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopCachesOutput
    extends OutputModel {
        private String action;
        private List<String> cacheIDs;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_ids")
        public void setCacheIDs(List<String> cacheIDs) {
            this.cacheIDs = cacheIDs;
        }

        @JsonProperty(value="cache_ids")
        public List<String> getCacheIDs() {
            return this.cacheIDs;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StopCachesInput
    extends IaasParamBody {
        private List<String> caches;

        @JsonProperty(value="caches")
        public void setCaches(List<String> caches) {
            this.caches = caches;
        }

        @JsonProperty(value="caches")
        public List<String> getCaches() {
            return this.caches;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StartCachesOutput
    extends OutputModel {
        private String action;
        private List<String> cacheIDs;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_ids")
        public void setCacheIDs(List<String> cacheIDs) {
            this.cacheIDs = cacheIDs;
        }

        @JsonProperty(value="cache_ids")
        public List<String> getCacheIDs() {
            return this.cacheIDs;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StartCachesInput
    extends IaasParamBody {
        private List<String> caches;

        @JsonProperty(value="caches")
        public void setCaches(List<String> caches) {
            this.caches = caches;
        }

        @JsonProperty(value="caches")
        public List<String> getCaches() {
            return this.caches;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RestartCachesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RestartCachesInput
    extends IaasParamBody {
        private List<String> caches;

        @JsonProperty(value="caches")
        public void setCaches(List<String> caches) {
            this.caches = caches;
        }

        @JsonProperty(value="caches")
        public List<String> getCaches() {
            return this.caches;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RestartCacheNodesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RestartCacheNodesInput
    extends IaasParamBody {
        private String cache;
        private List<String> cacheNodes;

        @JsonProperty(value="cache")
        public void setCache(String cache) {
            this.cache = cache;
        }

        @JsonProperty(value="cache")
        public String getCache() {
            return this.cache;
        }

        @JsonProperty(value="cache_nodes")
        public void setCacheNodes(List<String> cacheNodes) {
            this.cacheNodes = cacheNodes;
        }

        @JsonProperty(value="cache_nodes")
        public List<String> getCacheNodes() {
            return this.cacheNodes;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCache())) {
                throw new QCException("Cache is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResizeCachesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ResizeCachesInput
    extends IaasParamBody {
        private Integer cacheSize;
        private List<String> caches;

        @JsonProperty(value="cache_size")
        public void setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
        }

        @JsonProperty(value="cache_size")
        public Integer getCacheSize() {
            return this.cacheSize;
        }

        @JsonProperty(value="caches")
        public void setCaches(List<String> caches) {
            this.caches = caches;
        }

        @JsonProperty(value="caches")
        public List<String> getCaches() {
            return this.caches;
        }

        @Override
        public String validateParam() throws QCException {
            if (this.getCacheSize() < 0) {
                throw new QCException("CacheSize is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResetCacheParametersOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ResetCacheParametersInput
    extends IaasParamBody {
        private String cacheParameterGroup;
        private List<String> cacheParameterNames;

        @JsonProperty(value="cache_parameter_group")
        public void setCacheParameterGroup(String cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group")
        public String getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_names")
        public void setCacheParameterNames(List<String> cacheParameterNames) {
            this.cacheParameterNames = cacheParameterNames;
        }

        @JsonProperty(value="cache_parameter_names")
        public List<String> getCacheParameterNames() {
            return this.cacheParameterNames;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheParameterGroup())) {
                throw new QCException("CacheParameterGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyCacheParameterGroupAttributesOutput
    extends OutputModel {
        private String action;
        private String cacheParameterGroupID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_parameter_group_id")
        public void setCacheParameterGroupID(String cacheParameterGroupID) {
            this.cacheParameterGroupID = cacheParameterGroupID;
        }

        @JsonProperty(value="cache_parameter_group_id")
        public String getCacheParameterGroupID() {
            return this.cacheParameterGroupID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyCacheParameterGroupAttributesInput
    extends IaasParamBody {
        private String cacheParameterGroup;
        private String cacheParameterGroupName;
        private String description;

        @JsonProperty(value="cache_parameter_group")
        public void setCacheParameterGroup(String cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group")
        public String getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group_name")
        public void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @JsonProperty(value="cache_parameter_group_name")
        public String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheParameterGroup())) {
                throw new QCException("CacheParameterGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyCacheNodeAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyCacheNodeAttributesInput
    extends IaasParamBody {
        private String cacheNode;
        private String cacheNodeName;

        @JsonProperty(value="cache_node")
        public void setCacheNode(String cacheNode) {
            this.cacheNode = cacheNode;
        }

        @JsonProperty(value="cache_node")
        public String getCacheNode() {
            return this.cacheNode;
        }

        @JsonProperty(value="cache_node_name")
        public void setCacheNodeName(String cacheNodeName) {
            this.cacheNodeName = cacheNodeName;
        }

        @JsonProperty(value="cache_node_name")
        public String getCacheNodeName() {
            return this.cacheNodeName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheNode())) {
                throw new QCException("CacheNode is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyCacheAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyCacheAttributesInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private String cache;
        private String cacheName;
        private String description;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="cache")
        public void setCache(String cache) {
            this.cache = cache;
        }

        @JsonProperty(value="cache")
        public String getCache() {
            return this.cache;
        }

        @JsonProperty(value="cache_name")
        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        @JsonProperty(value="cache_name")
        public String getCacheName() {
            return this.cacheName;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCache())) {
                throw new QCException("Cache is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetCacheMonitorOutput
    extends OutputModel {
        private String action;
        private List<Types.MeterModel> meterSet;
        private String resourceID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="meter_set")
        public void setMeterSet(List<Types.MeterModel> meterSet) {
            this.meterSet = meterSet;
        }

        @JsonProperty(value="meter_set")
        public List<Types.MeterModel> getMeterSet() {
            return this.meterSet;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetCacheMonitorInput
    extends IaasParamBody {
        private String endTime;
        private List<String> meters;
        private String resource;
        private String startTime;
        private String step;

        @JsonProperty(value="end_time")
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="end_time")
        public String getEndTime() {
            return this.endTime;
        }

        @JsonProperty(value="meters")
        public void setMeters(List<String> meters) {
            this.meters = meters;
        }

        @JsonProperty(value="meters")
        public List<String> getMeters() {
            return this.meters;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public String getResource() {
            return this.resource;
        }

        @JsonProperty(value="start_time")
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @JsonProperty(value="start_time")
        public String getStartTime() {
            return this.startTime;
        }

        @JsonProperty(value="step")
        public void setStep(String step) {
            this.step = step;
        }

        @JsonProperty(value="step")
        public String getStep() {
            return this.step;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getResource())) {
                throw new QCException("Resource is required");
            }
            if (QCStringUtil.isEmpty(this.getStep())) {
                throw new QCException("Step is required");
            }
            String[] stepValidValues = new String[]{"5m", "15m", "2h", "1d"};
            boolean stepIsValid = false;
            for (String v : stepValidValues) {
                Boolean stepIsRequired;
                if (v.equals(this.getStep())) {
                    stepIsValid = true;
                }
                if (!(stepIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getStep() != null) continue;
                stepIsValid = true;
            }
            if (!stepIsValid) {
                throw new QCException("Step value " + this.getStep() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeCachesOutput
    extends OutputModel {
        private String action;
        private List<Types.CacheModel> cacheSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_set")
        public void setCacheSet(List<Types.CacheModel> cacheSet) {
            this.cacheSet = cacheSet;
        }

        @JsonProperty(value="cache_set")
        public List<Types.CacheModel> getCacheSet() {
            return this.cacheSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeCachesInput
    extends IaasParamBody {
        private List<String> cacheType;
        private List<String> caches;
        private Integer limit;
        private Integer offset;
        private String searchWord;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="cache_type")
        public void setCacheType(List<String> cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public List<String> getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="caches")
        public void setCaches(List<String> caches) {
            this.caches = caches;
        }

        @JsonProperty(value="caches")
        public List<String> getCaches() {
            return this.caches;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeCacheParametersOutput
    extends OutputModel {
        private String action;
        private List<Types.CacheParameterModel> cacheParameterSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_parameter_set")
        public void setCacheParameterSet(List<Types.CacheParameterModel> cacheParameterSet) {
            this.cacheParameterSet = cacheParameterSet;
        }

        @JsonProperty(value="cache_parameter_set")
        public List<Types.CacheParameterModel> getCacheParameterSet() {
            return this.cacheParameterSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeCacheParametersInput
    extends IaasParamBody {
        private String cacheParameterGroup;
        private Integer verbose;

        @JsonProperty(value="cache_parameter_group")
        public void setCacheParameterGroup(String cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group")
        public String getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheParameterGroup())) {
                throw new QCException("CacheParameterGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeCacheParameterGroupsOutput
    extends OutputModel {
        private String action;
        private List<Types.CacheParameterGroupModel> cacheParameterGroupSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_parameter_group_set")
        public void setCacheParameterGroupSet(List<Types.CacheParameterGroupModel> cacheParameterGroupSet) {
            this.cacheParameterGroupSet = cacheParameterGroupSet;
        }

        @JsonProperty(value="cache_parameter_group_set")
        public List<Types.CacheParameterGroupModel> getCacheParameterGroupSet() {
            return this.cacheParameterGroupSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeCacheParameterGroupsInput
    extends IaasParamBody {
        private List<String> cacheParameterGroups;
        private String cacheType;
        private Integer limit;
        private Integer offset;
        private String searchWord;
        private Integer verbose;

        @JsonProperty(value="cache_parameter_groups")
        public void setCacheParameterGroups(List<String> cacheParameterGroups) {
            this.cacheParameterGroups = cacheParameterGroups;
        }

        @JsonProperty(value="cache_parameter_groups")
        public List<String> getCacheParameterGroups() {
            return this.cacheParameterGroups;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeCacheNodesOutput
    extends OutputModel {
        private String action;
        private List<Types.CacheNodeModel> cacheNodeSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_node_set")
        public void setCacheNodeSet(List<Types.CacheNodeModel> cacheNodeSet) {
            this.cacheNodeSet = cacheNodeSet;
        }

        @JsonProperty(value="cache_node_set")
        public List<Types.CacheNodeModel> getCacheNodeSet() {
            return this.cacheNodeSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeCacheNodesInput
    extends IaasParamBody {
        private String cache;
        private List<String> cacheNodes;
        private Integer limit;
        private Integer offset;
        private String searchWord;
        private List<String> status;
        private Integer verbose;

        @JsonProperty(value="cache")
        public void setCache(String cache) {
            this.cache = cache;
        }

        @JsonProperty(value="cache")
        public String getCache() {
            return this.cache;
        }

        @JsonProperty(value="cache_nodes")
        public void setCacheNodes(List<String> cacheNodes) {
            this.cacheNodes = cacheNodes;
        }

        @JsonProperty(value="cache_nodes")
        public List<String> getCacheNodes() {
            return this.cacheNodes;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteCachesOutput
    extends OutputModel {
        private String action;
        private List<String> cacheIDs;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_ids")
        public void setCacheIDs(List<String> cacheIDs) {
            this.cacheIDs = cacheIDs;
        }

        @JsonProperty(value="cache_ids")
        public List<String> getCacheIDs() {
            return this.cacheIDs;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteCachesInput
    extends IaasParamBody {
        private List<String> caches;

        @JsonProperty(value="caches")
        public void setCaches(List<String> caches) {
            this.caches = caches;
        }

        @JsonProperty(value="caches")
        public List<String> getCaches() {
            return this.caches;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteCacheParameterGroupsOutput
    extends OutputModel {
        private String action;
        private List<String> parameterGroups;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="parameter_groups")
        public void setParameterGroups(List<String> parameterGroups) {
            this.parameterGroups = parameterGroups;
        }

        @JsonProperty(value="parameter_groups")
        public List<String> getParameterGroups() {
            return this.parameterGroups;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteCacheParameterGroupsInput
    extends IaasParamBody {
        private List<String> cacheParameterGroups;

        @JsonProperty(value="cache_parameter_groups")
        public void setCacheParameterGroups(List<String> cacheParameterGroups) {
            this.cacheParameterGroups = cacheParameterGroups;
        }

        @JsonProperty(value="cache_parameter_groups")
        public List<String> getCacheParameterGroups() {
            return this.cacheParameterGroups;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteCacheNodesOutput
    extends OutputModel {
        private String action;
        private List<String> cacheNodes;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_nodes")
        public void setCacheNodes(List<String> cacheNodes) {
            this.cacheNodes = cacheNodes;
        }

        @JsonProperty(value="cache_nodes")
        public List<String> getCacheNodes() {
            return this.cacheNodes;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteCacheNodesInput
    extends IaasParamBody {
        private String cache;
        private List<String> cacheNodes;

        @JsonProperty(value="cache")
        public void setCache(String cache) {
            this.cache = cache;
        }

        @JsonProperty(value="cache")
        public String getCache() {
            return this.cache;
        }

        @JsonProperty(value="cache_nodes")
        public void setCacheNodes(List<String> cacheNodes) {
            this.cacheNodes = cacheNodes;
        }

        @JsonProperty(value="cache_nodes")
        public List<String> getCacheNodes() {
            return this.cacheNodes;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCache())) {
                throw new QCException("Cache is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateCacheParameterGroupOutput
    extends OutputModel {
        private String action;
        private String cacheParameterGroupID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_parameter_group_id")
        public void setCacheParameterGroupID(String cacheParameterGroupID) {
            this.cacheParameterGroupID = cacheParameterGroupID;
        }

        @JsonProperty(value="cache_parameter_group_id")
        public String getCacheParameterGroupID() {
            return this.cacheParameterGroupID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateCacheParameterGroupInput
    extends IaasParamBody {
        private String cacheParameterGroupName;
        private String cacheType;

        @JsonProperty(value="cache_parameter_group_name")
        public void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @JsonProperty(value="cache_parameter_group_name")
        public String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheType())) {
                throw new QCException("CacheType is required");
            }
            String[] cacheTypeValidValues = new String[]{"redis2.8.17", "memcached1.4.13"};
            boolean cacheTypeIsValid = false;
            for (String v : cacheTypeValidValues) {
                Boolean cacheTypeIsRequired;
                if (v.equals(this.getCacheType())) {
                    cacheTypeIsValid = true;
                }
                if (!(cacheTypeIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getCacheType() != null) continue;
                cacheTypeIsValid = true;
            }
            if (!cacheTypeIsValid) {
                throw new QCException("CacheType value " + this.getCacheType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateCacheFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String cacheID;
        private List<String> cacheNodes;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_id")
        public void setCacheID(String cacheID) {
            this.cacheID = cacheID;
        }

        @JsonProperty(value="cache_id")
        public String getCacheID() {
            return this.cacheID;
        }

        @JsonProperty(value="cache_nodes")
        public void setCacheNodes(List<String> cacheNodes) {
            this.cacheNodes = cacheNodes;
        }

        @JsonProperty(value="cache_nodes")
        public List<String> getCacheNodes() {
            return this.cacheNodes;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateCacheFromSnapshotInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private Integer cacheClass;
        private String cacheName;
        private String cacheParameterGroup;
        private Integer cacheSize;
        private String cacheType;
        private Integer networkType;
        private Integer nodeCount;
        private List<Types.CachePrivateIPModel> privateIPs;
        private String snapshot;
        private String vxNet;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="cache_class")
        public void setCacheClass(Integer cacheClass) {
            this.cacheClass = cacheClass;
        }

        @JsonProperty(value="cache_class")
        public Integer getCacheClass() {
            return this.cacheClass;
        }

        @JsonProperty(value="cache_name")
        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        @JsonProperty(value="cache_name")
        public String getCacheName() {
            return this.cacheName;
        }

        @JsonProperty(value="cache_parameter_group")
        public void setCacheParameterGroup(String cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group")
        public String getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @JsonProperty(value="cache_size")
        public void setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
        }

        @JsonProperty(value="cache_size")
        public Integer getCacheSize() {
            return this.cacheSize;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="network_type")
        public void setNetworkType(Integer networkType) {
            this.networkType = networkType;
        }

        @JsonProperty(value="network_type")
        public Integer getNetworkType() {
            return this.networkType;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.CachePrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.CachePrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] cacheClassValidValues = new String[]{"0", "1"};
            boolean cacheClassIsValid = false;
            for (String v : cacheClassValidValues) {
                Boolean cacheClassIsRequired;
                if (v.equals(this.getCacheClass() + "")) {
                    cacheClassIsValid = true;
                }
                if (!(cacheClassIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCacheClass() != null) continue;
                cacheClassIsValid = true;
            }
            if (!cacheClassIsValid) {
                throw new QCException("CacheClass value " + this.getCacheClass() + "is invalid");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getSnapshot())) {
                throw new QCException("Snapshot is required");
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateCacheOutput
    extends OutputModel {
        private String action;
        private String cacheID;
        private List<String> cacheNodes;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_id")
        public void setCacheID(String cacheID) {
            this.cacheID = cacheID;
        }

        @JsonProperty(value="cache_id")
        public String getCacheID() {
            return this.cacheID;
        }

        @JsonProperty(value="cache_nodes")
        public void setCacheNodes(List<String> cacheNodes) {
            this.cacheNodes = cacheNodes;
        }

        @JsonProperty(value="cache_nodes")
        public List<String> getCacheNodes() {
            return this.cacheNodes;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateCacheInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private Integer cacheClass;
        private String cacheName;
        private String cacheParameterGroup;
        private Integer cacheSize;
        private String cacheType;
        private Integer masterCount;
        private Integer networkType;
        private Integer nodeCount;
        private List<Types.CachePrivateIPModel> privateIPs;
        private Integer replicateCount;
        private String vxNet;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="cache_class")
        public void setCacheClass(Integer cacheClass) {
            this.cacheClass = cacheClass;
        }

        @JsonProperty(value="cache_class")
        public Integer getCacheClass() {
            return this.cacheClass;
        }

        @JsonProperty(value="cache_name")
        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        @JsonProperty(value="cache_name")
        public String getCacheName() {
            return this.cacheName;
        }

        @JsonProperty(value="cache_parameter_group")
        public void setCacheParameterGroup(String cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group")
        public String getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @JsonProperty(value="cache_size")
        public void setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
        }

        @JsonProperty(value="cache_size")
        public Integer getCacheSize() {
            return this.cacheSize;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="master_count")
        public void setMasterCount(Integer masterCount) {
            this.masterCount = masterCount;
        }

        @JsonProperty(value="master_count")
        public Integer getMasterCount() {
            return this.masterCount;
        }

        @JsonProperty(value="network_type")
        public void setNetworkType(Integer networkType) {
            this.networkType = networkType;
        }

        @JsonProperty(value="network_type")
        public Integer getNetworkType() {
            return this.networkType;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.CachePrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.CachePrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="replicate_count")
        public void setReplicateCount(Integer replicateCount) {
            this.replicateCount = replicateCount;
        }

        @JsonProperty(value="replicate_count")
        public Integer getReplicateCount() {
            return this.replicateCount;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] cacheClassValidValues = new String[]{"0", "1"};
            boolean cacheClassIsValid = false;
            for (String v : cacheClassValidValues) {
                Boolean cacheClassIsRequired;
                if (v.equals(this.getCacheClass() + "")) {
                    cacheClassIsValid = true;
                }
                if (!(cacheClassIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCacheClass() != null) continue;
                cacheClassIsValid = true;
            }
            if (!cacheClassIsValid) {
                throw new QCException("CacheClass value " + this.getCacheClass() + "is invalid");
            }
            if (this.getCacheSize() < 0) {
                throw new QCException("CacheSize is required");
            }
            if (QCStringUtil.isEmpty(this.getCacheType())) {
                throw new QCException("CacheType is required");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ChangeCacheVxNetOutput
    extends OutputModel {
        private String action;
        private String cacheID;
        private String jobID;
        private Integer retCode;
        private String vxNetID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_id")
        public void setCacheID(String cacheID) {
            this.cacheID = cacheID;
        }

        @JsonProperty(value="cache_id")
        public String getCacheID() {
            return this.cacheID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }
    }

    public static class ChangeCacheVxNetInput
    extends IaasParamBody {
        private String cache;
        private List<Types.CachePrivateIPModel> privateIPs;
        private String vxNet;

        @JsonProperty(value="cache")
        public void setCache(String cache) {
            this.cache = cache;
        }

        @JsonProperty(value="cache")
        public String getCache() {
            return this.cache;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.CachePrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.CachePrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (QCStringUtil.isEmpty(this.getCache())) {
                throw new QCException("Cache is required");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplyCacheParameterGroupOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ApplyCacheParameterGroupInput
    extends IaasParamBody {
        private String cacheParameterGroup;
        private List<String> caches;

        @JsonProperty(value="cache_parameter_group")
        public void setCacheParameterGroup(String cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        @JsonProperty(value="cache_parameter_group")
        public String getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @JsonProperty(value="caches")
        public void setCaches(List<String> caches) {
            this.caches = caches;
        }

        @JsonProperty(value="caches")
        public List<String> getCaches() {
            return this.caches;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheParameterGroup())) {
                throw new QCException("CacheParameterGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddCacheNodesOutput
    extends OutputModel {
        private String action;
        private List<String> cacheNodes;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cache_nodes")
        public void setCacheNodes(List<String> cacheNodes) {
            this.cacheNodes = cacheNodes;
        }

        @JsonProperty(value="cache_nodes")
        public List<String> getCacheNodes() {
            return this.cacheNodes;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AddCacheNodesInput
    extends IaasParamBody {
        private String cache;
        private Integer nodeCount;
        private List<Types.CachePrivateIPModel> privateIPs;

        @JsonProperty(value="cache")
        public void setCache(String cache) {
            this.cache = cache;
        }

        @JsonProperty(value="cache")
        public String getCache() {
            return this.cache;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.CachePrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.CachePrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (QCStringUtil.isEmpty(this.getCache())) {
                throw new QCException("Cache is required");
            }
            if (this.getNodeCount() < 0) {
                throw new QCException("NodeCount is required");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            return null;
        }
    }
}

