/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterService {
    private EnvContext envContext;
    private String zone;

    public ClusterService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public ClusterService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AddClusterNodesOutput addClusterNodes(AddClusterNodesInput input) throws QCException {
        if (input == null) {
            input = new AddClusterNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddClusterNodes");
        context.put("APIName", "AddClusterNodes");
        context.put("ServiceName", "AddClusterNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddClusterNodes");
        input.setAction("AddClusterNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddClusterNodesOutput.class);
        if (backModel != null) {
            return (AddClusterNodesOutput)backModel;
        }
        return null;
    }

    public void addClusterNodes(AddClusterNodesInput input, ResponseCallBack<AddClusterNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new AddClusterNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddClusterNodes");
        context.put("APIName", "AddClusterNodes");
        context.put("ServiceName", "AddClusterNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddClusterNodes");
        input.setAction("AddClusterNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public AssociateEIPToClusterNodeOutput associateEIPToClusterNode(AssociateEIPToClusterNodeInput input) throws QCException {
        if (input == null) {
            input = new AssociateEIPToClusterNodeInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AssociateEipToClusterNode");
        context.put("APIName", "AssociateEipToClusterNode");
        context.put("ServiceName", "AssociateEipToClusterNode");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AssociateEipToClusterNode");
        input.setAction("AssociateEipToClusterNode");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AssociateEIPToClusterNodeOutput.class);
        if (backModel != null) {
            return (AssociateEIPToClusterNodeOutput)backModel;
        }
        return null;
    }

    public void associateEIPToClusterNode(AssociateEIPToClusterNodeInput input, ResponseCallBack<AssociateEIPToClusterNodeOutput> callback) throws QCException {
        if (input == null) {
            input = new AssociateEIPToClusterNodeInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AssociateEIPToClusterNode");
        context.put("APIName", "AssociateEIPToClusterNode");
        context.put("ServiceName", "AssociateEipToClusterNode");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AssociateEipToClusterNode");
        input.setAction("AssociateEIPToClusterNode");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CeaseClustersOutput ceaseClusters(CeaseClustersInput input) throws QCException {
        if (input == null) {
            input = new CeaseClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CeaseClusters");
        context.put("APIName", "CeaseClusters");
        context.put("ServiceName", "CeaseClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CeaseClusters");
        input.setAction("CeaseClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CeaseClustersOutput.class);
        if (backModel != null) {
            return (CeaseClustersOutput)backModel;
        }
        return null;
    }

    public void ceaseClusters(CeaseClustersInput input, ResponseCallBack<CeaseClustersOutput> callback) throws QCException {
        if (input == null) {
            input = new CeaseClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CeaseClusters");
        context.put("APIName", "CeaseClusters");
        context.put("ServiceName", "CeaseClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CeaseClusters");
        input.setAction("CeaseClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ChangeClusterVxNetOutput changeClusterVxNet(ChangeClusterVxNetInput input) throws QCException {
        if (input == null) {
            input = new ChangeClusterVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ChangeClusterVxnet");
        context.put("APIName", "ChangeClusterVxnet");
        context.put("ServiceName", "ChangeClusterVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ChangeClusterVxnet");
        input.setAction("ChangeClusterVxnet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ChangeClusterVxNetOutput.class);
        if (backModel != null) {
            return (ChangeClusterVxNetOutput)backModel;
        }
        return null;
    }

    public void changeClusterVxNet(ChangeClusterVxNetInput input, ResponseCallBack<ChangeClusterVxNetOutput> callback) throws QCException {
        if (input == null) {
            input = new ChangeClusterVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ChangeClusterVxNet");
        context.put("APIName", "ChangeClusterVxNet");
        context.put("ServiceName", "ChangeClusterVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ChangeClusterVxnet");
        input.setAction("ChangeClusterVxNet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateClusterOutput createCluster(CreateClusterInput input) throws QCException {
        if (input == null) {
            input = new CreateClusterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCluster");
        context.put("APIName", "CreateCluster");
        context.put("ServiceName", "CreateCluster");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCluster");
        input.setAction("CreateCluster");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateClusterOutput.class);
        if (backModel != null) {
            return (CreateClusterOutput)backModel;
        }
        return null;
    }

    public void createCluster(CreateClusterInput input, ResponseCallBack<CreateClusterOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateClusterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateCluster");
        context.put("APIName", "CreateCluster");
        context.put("ServiceName", "CreateCluster");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateCluster");
        input.setAction("CreateCluster");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateClusterFromSnapshotOutput createClusterFromSnapshot(CreateClusterFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CreateClusterFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateClusterFromSnapshot");
        context.put("APIName", "CreateClusterFromSnapshot");
        context.put("ServiceName", "CreateClusterFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateClusterFromSnapshot");
        input.setAction("CreateClusterFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateClusterFromSnapshotOutput.class);
        if (backModel != null) {
            return (CreateClusterFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void createClusterFromSnapshot(CreateClusterFromSnapshotInput input, ResponseCallBack<CreateClusterFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateClusterFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateClusterFromSnapshot");
        context.put("APIName", "CreateClusterFromSnapshot");
        context.put("ServiceName", "CreateClusterFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateClusterFromSnapshot");
        input.setAction("CreateClusterFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteClusterNodesOutput deleteClusterNodes(DeleteClusterNodesInput input) throws QCException {
        if (input == null) {
            input = new DeleteClusterNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteClusterNodes");
        context.put("APIName", "DeleteClusterNodes");
        context.put("ServiceName", "DeleteClusterNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteClusterNodes");
        input.setAction("DeleteClusterNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteClusterNodesOutput.class);
        if (backModel != null) {
            return (DeleteClusterNodesOutput)backModel;
        }
        return null;
    }

    public void deleteClusterNodes(DeleteClusterNodesInput input, ResponseCallBack<DeleteClusterNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteClusterNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteClusterNodes");
        context.put("APIName", "DeleteClusterNodes");
        context.put("ServiceName", "DeleteClusterNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteClusterNodes");
        input.setAction("DeleteClusterNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteClustersOutput deleteClusters(DeleteClustersInput input) throws QCException {
        if (input == null) {
            input = new DeleteClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteClusters");
        context.put("APIName", "DeleteClusters");
        context.put("ServiceName", "DeleteClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteClusters");
        input.setAction("DeleteClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteClustersOutput.class);
        if (backModel != null) {
            return (DeleteClustersOutput)backModel;
        }
        return null;
    }

    public void deleteClusters(DeleteClustersInput input, ResponseCallBack<DeleteClustersOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteClusters");
        context.put("APIName", "DeleteClusters");
        context.put("ServiceName", "DeleteClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteClusters");
        input.setAction("DeleteClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeClusterDisplayTabsOutput describeClusterDisplayTabs(DescribeClusterDisplayTabsInput input) throws QCException {
        if (input == null) {
            input = new DescribeClusterDisplayTabsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusterDisplayTabs");
        context.put("APIName", "DescribeClusterDisplayTabs");
        context.put("ServiceName", "DescribeClusterDisplayTabs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusterDisplayTabs");
        input.setAction("DescribeClusterDisplayTabs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeClusterDisplayTabsOutput.class);
        if (backModel != null) {
            return (DescribeClusterDisplayTabsOutput)backModel;
        }
        return null;
    }

    public void describeClusterDisplayTabs(DescribeClusterDisplayTabsInput input, ResponseCallBack<DescribeClusterDisplayTabsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeClusterDisplayTabsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusterDisplayTabs");
        context.put("APIName", "DescribeClusterDisplayTabs");
        context.put("ServiceName", "DescribeClusterDisplayTabs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusterDisplayTabs");
        input.setAction("DescribeClusterDisplayTabs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeClusterNodesOutput describeClusterNodes(DescribeClusterNodesInput input) throws QCException {
        if (input == null) {
            input = new DescribeClusterNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusterNodes");
        context.put("APIName", "DescribeClusterNodes");
        context.put("ServiceName", "DescribeClusterNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusterNodes");
        input.setAction("DescribeClusterNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeClusterNodesOutput.class);
        if (backModel != null) {
            return (DescribeClusterNodesOutput)backModel;
        }
        return null;
    }

    public void describeClusterNodes(DescribeClusterNodesInput input, ResponseCallBack<DescribeClusterNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeClusterNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusterNodes");
        context.put("APIName", "DescribeClusterNodes");
        context.put("ServiceName", "DescribeClusterNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusterNodes");
        input.setAction("DescribeClusterNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeClusterUsersOutput describeClusterUsers(DescribeClusterUsersInput input) throws QCException {
        if (input == null) {
            input = new DescribeClusterUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusterUsers");
        context.put("APIName", "DescribeClusterUsers");
        context.put("ServiceName", "DescribeClusterUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusterUsers");
        input.setAction("DescribeClusterUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeClusterUsersOutput.class);
        if (backModel != null) {
            return (DescribeClusterUsersOutput)backModel;
        }
        return null;
    }

    public void describeClusterUsers(DescribeClusterUsersInput input, ResponseCallBack<DescribeClusterUsersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeClusterUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusterUsers");
        context.put("APIName", "DescribeClusterUsers");
        context.put("ServiceName", "DescribeClusterUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusterUsers");
        input.setAction("DescribeClusterUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeClustersOutput describeClusters(DescribeClustersInput input) throws QCException {
        if (input == null) {
            input = new DescribeClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusters");
        context.put("APIName", "DescribeClusters");
        context.put("ServiceName", "DescribeClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusters");
        input.setAction("DescribeClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeClustersOutput.class);
        if (backModel != null) {
            return (DescribeClustersOutput)backModel;
        }
        return null;
    }

    public void describeClusters(DescribeClustersInput input, ResponseCallBack<DescribeClustersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeClusters");
        context.put("APIName", "DescribeClusters");
        context.put("ServiceName", "DescribeClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeClusters");
        input.setAction("DescribeClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DissociateEIPFromClusterNodeOutput dissociateEIPFromClusterNode(DissociateEIPFromClusterNodeInput input) throws QCException {
        if (input == null) {
            input = new DissociateEIPFromClusterNodeInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DissociateEipFromClusterNode");
        context.put("APIName", "DissociateEipFromClusterNode");
        context.put("ServiceName", "DissociateEipFromClusterNode");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DissociateEipFromClusterNode");
        input.setAction("DissociateEipFromClusterNode");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DissociateEIPFromClusterNodeOutput.class);
        if (backModel != null) {
            return (DissociateEIPFromClusterNodeOutput)backModel;
        }
        return null;
    }

    public void dissociateEIPFromClusterNode(DissociateEIPFromClusterNodeInput input, ResponseCallBack<DissociateEIPFromClusterNodeOutput> callback) throws QCException {
        if (input == null) {
            input = new DissociateEIPFromClusterNodeInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DissociateEIPFromClusterNode");
        context.put("APIName", "DissociateEIPFromClusterNode");
        context.put("ServiceName", "DissociateEipFromClusterNode");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DissociateEipFromClusterNode");
        input.setAction("DissociateEIPFromClusterNode");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyClusterAttributesOutput modifyClusterAttributes(ModifyClusterAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyClusterAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyClusterAttributes");
        context.put("APIName", "ModifyClusterAttributes");
        context.put("ServiceName", "ModifyClusterAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyClusterAttributes");
        input.setAction("ModifyClusterAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyClusterAttributesOutput.class);
        if (backModel != null) {
            return (ModifyClusterAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyClusterAttributes(ModifyClusterAttributesInput input, ResponseCallBack<ModifyClusterAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyClusterAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyClusterAttributes");
        context.put("APIName", "ModifyClusterAttributes");
        context.put("ServiceName", "ModifyClusterAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyClusterAttributes");
        input.setAction("ModifyClusterAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyClusterNodeAttributesOutput modifyClusterNodeAttributes(ModifyClusterNodeAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyClusterNodeAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyClusterNodeAttributes");
        context.put("APIName", "ModifyClusterNodeAttributes");
        context.put("ServiceName", "ModifyClusterNodeAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyClusterNodeAttributes");
        input.setAction("ModifyClusterNodeAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyClusterNodeAttributesOutput.class);
        if (backModel != null) {
            return (ModifyClusterNodeAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyClusterNodeAttributes(ModifyClusterNodeAttributesInput input, ResponseCallBack<ModifyClusterNodeAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyClusterNodeAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyClusterNodeAttributes");
        context.put("APIName", "ModifyClusterNodeAttributes");
        context.put("ServiceName", "ModifyClusterNodeAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyClusterNodeAttributes");
        input.setAction("ModifyClusterNodeAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RecoverClustersOutput recoverClusters(RecoverClustersInput input) throws QCException {
        if (input == null) {
            input = new RecoverClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RecoverClusters");
        context.put("APIName", "RecoverClusters");
        context.put("ServiceName", "Lease");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RecoverClusters");
        input.setAction("RecoverClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RecoverClustersOutput.class);
        if (backModel != null) {
            return (RecoverClustersOutput)backModel;
        }
        return null;
    }

    public void recoverClusters(RecoverClustersInput input, ResponseCallBack<RecoverClustersOutput> callback) throws QCException {
        if (input == null) {
            input = new RecoverClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RecoverClusters");
        context.put("APIName", "RecoverClusters");
        context.put("ServiceName", "Lease");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RecoverClusters");
        input.setAction("RecoverClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResizeClusterOutput resizeCluster(ResizeClusterInput input) throws QCException {
        if (input == null) {
            input = new ResizeClusterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeCluster");
        context.put("APIName", "ResizeCluster");
        context.put("ServiceName", "ResizeCluster");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeCluster");
        input.setAction("ResizeCluster");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResizeClusterOutput.class);
        if (backModel != null) {
            return (ResizeClusterOutput)backModel;
        }
        return null;
    }

    public void resizeCluster(ResizeClusterInput input, ResponseCallBack<ResizeClusterOutput> callback) throws QCException {
        if (input == null) {
            input = new ResizeClusterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeCluster");
        context.put("APIName", "ResizeCluster");
        context.put("ServiceName", "ResizeCluster");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeCluster");
        input.setAction("ResizeCluster");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RestartClusterServiceOutput restartClusterService(RestartClusterServiceInput input) throws QCException {
        if (input == null) {
            input = new RestartClusterServiceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartClusterService");
        context.put("APIName", "RestartClusterService");
        context.put("ServiceName", "RestartClusterService");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartClusterService");
        input.setAction("RestartClusterService");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RestartClusterServiceOutput.class);
        if (backModel != null) {
            return (RestartClusterServiceOutput)backModel;
        }
        return null;
    }

    public void restartClusterService(RestartClusterServiceInput input, ResponseCallBack<RestartClusterServiceOutput> callback) throws QCException {
        if (input == null) {
            input = new RestartClusterServiceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartClusterService");
        context.put("APIName", "RestartClusterService");
        context.put("ServiceName", "RestartClusterService");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartClusterService");
        input.setAction("RestartClusterService");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RestoreClusterFromSnapshotOutput restoreClusterFromSnapshot(RestoreClusterFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new RestoreClusterFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestoreClusterFromSnapshot");
        context.put("APIName", "RestoreClusterFromSnapshot");
        context.put("ServiceName", "RestoreClusterFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestoreClusterFromSnapshot");
        input.setAction("RestoreClusterFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RestoreClusterFromSnapshotOutput.class);
        if (backModel != null) {
            return (RestoreClusterFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void restoreClusterFromSnapshot(RestoreClusterFromSnapshotInput input, ResponseCallBack<RestoreClusterFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new RestoreClusterFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestoreClusterFromSnapshot");
        context.put("APIName", "RestoreClusterFromSnapshot");
        context.put("ServiceName", "RestoreClusterFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestoreClusterFromSnapshot");
        input.setAction("RestoreClusterFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RunClusterCustomServiceOutput runClusterCustomService(RunClusterCustomServiceInput input) throws QCException {
        if (input == null) {
            input = new RunClusterCustomServiceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RunClusterCustomService");
        context.put("APIName", "RunClusterCustomService");
        context.put("ServiceName", "RunClusterCustomService");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RunClusterCustomService");
        input.setAction("RunClusterCustomService");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RunClusterCustomServiceOutput.class);
        if (backModel != null) {
            return (RunClusterCustomServiceOutput)backModel;
        }
        return null;
    }

    public void runClusterCustomService(RunClusterCustomServiceInput input, ResponseCallBack<RunClusterCustomServiceOutput> callback) throws QCException {
        if (input == null) {
            input = new RunClusterCustomServiceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RunClusterCustomService");
        context.put("APIName", "RunClusterCustomService");
        context.put("ServiceName", "RunClusterCustomService");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RunClusterCustomService");
        input.setAction("RunClusterCustomService");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StartClustersOutput startClusters(StartClustersInput input) throws QCException {
        if (input == null) {
            input = new StartClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartClusters");
        context.put("APIName", "StartClusters");
        context.put("ServiceName", "StartClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartClusters");
        input.setAction("StartClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StartClustersOutput.class);
        if (backModel != null) {
            return (StartClustersOutput)backModel;
        }
        return null;
    }

    public void startClusters(StartClustersInput input, ResponseCallBack<StartClustersOutput> callback) throws QCException {
        if (input == null) {
            input = new StartClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartClusters");
        context.put("APIName", "StartClusters");
        context.put("ServiceName", "StartClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartClusters");
        input.setAction("StartClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StopClustersOutput stopClusters(StopClustersInput input) throws QCException {
        if (input == null) {
            input = new StopClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopClusters");
        context.put("APIName", "StopClusters");
        context.put("ServiceName", "StopClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopClusters");
        input.setAction("StopClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StopClustersOutput.class);
        if (backModel != null) {
            return (StopClustersOutput)backModel;
        }
        return null;
    }

    public void stopClusters(StopClustersInput input, ResponseCallBack<StopClustersOutput> callback) throws QCException {
        if (input == null) {
            input = new StopClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopClusters");
        context.put("APIName", "StopClusters");
        context.put("ServiceName", "StopClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopClusters");
        input.setAction("StopClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public UpdateClusterEnvironmentOutput updateClusterEnvironment(UpdateClusterEnvironmentInput input) throws QCException {
        if (input == null) {
            input = new UpdateClusterEnvironmentInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateClusterEnvironment");
        context.put("APIName", "UpdateClusterEnvironment");
        context.put("ServiceName", "UpdateClusterEnvironment");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateClusterEnvironment");
        input.setAction("UpdateClusterEnvironment");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, UpdateClusterEnvironmentOutput.class);
        if (backModel != null) {
            return (UpdateClusterEnvironmentOutput)backModel;
        }
        return null;
    }

    public void updateClusterEnvironment(UpdateClusterEnvironmentInput input, ResponseCallBack<UpdateClusterEnvironmentOutput> callback) throws QCException {
        if (input == null) {
            input = new UpdateClusterEnvironmentInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateClusterEnvironment");
        context.put("APIName", "UpdateClusterEnvironment");
        context.put("ServiceName", "UpdateClusterEnvironment");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateClusterEnvironment");
        input.setAction("UpdateClusterEnvironment");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public UpgradeClustersOutput upgradeClusters(UpgradeClustersInput input) throws QCException {
        if (input == null) {
            input = new UpgradeClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpgradeClusters");
        context.put("APIName", "UpgradeClusters");
        context.put("ServiceName", "UpgradeClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpgradeClusters");
        input.setAction("UpgradeClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, UpgradeClustersOutput.class);
        if (backModel != null) {
            return (UpgradeClustersOutput)backModel;
        }
        return null;
    }

    public void upgradeClusters(UpgradeClustersInput input, ResponseCallBack<UpgradeClustersOutput> callback) throws QCException {
        if (input == null) {
            input = new UpgradeClustersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpgradeClusters");
        context.put("APIName", "UpgradeClusters");
        context.put("ServiceName", "UpgradeClusters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpgradeClusters");
        input.setAction("UpgradeClusters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UpgradeClustersOutput
    extends OutputModel {
        private String action;
        private List<String> clusterID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(List<String> clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public List<String> getClusterID() {
            return this.clusterID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class UpgradeClustersInput
    extends IaasParamBody {
        private String appVersion;
        private List<String> clusters;
        private String serviceParams;

        @JsonProperty(value="app_version")
        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @JsonProperty(value="app_version")
        public String getAppVersion() {
            return this.appVersion;
        }

        @JsonProperty(value="clusters")
        public void setClusters(List<String> clusters) {
            this.clusters = clusters;
        }

        @JsonProperty(value="clusters")
        public List<String> getClusters() {
            return this.clusters;
        }

        @JsonProperty(value="service_params")
        public void setServiceParams(String serviceParams) {
            this.serviceParams = serviceParams;
        }

        @JsonProperty(value="service_params")
        public String getServiceParams() {
            return this.serviceParams;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UpdateClusterEnvironmentOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class UpdateClusterEnvironmentInput
    extends IaasParamBody {
        private String cluster;
        private Types.Model env;
        private List<String> roles;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="env")
        public void setEnv(Types.Model env) {
            this.env = env;
        }

        @JsonProperty(value="env")
        public Types.Model getEnv() {
            return this.env;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="roles")
        public List<String> getRoles() {
            return this.roles;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopClustersOutput
    extends OutputModel {
        private String action;
        private Map jobIDs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_ids")
        public void setJobIDs(Map jobIDs) {
            this.jobIDs = jobIDs;
        }

        @JsonProperty(value="job_ids")
        public Map getJobIDs() {
            return this.jobIDs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StopClustersInput
    extends IaasParamBody {
        private List<String> clusters;
        private Integer force;

        @JsonProperty(value="clusters")
        public void setClusters(List<String> clusters) {
            this.clusters = clusters;
        }

        @JsonProperty(value="clusters")
        public List<String> getClusters() {
            return this.clusters;
        }

        @JsonProperty(value="force")
        public void setForce(Integer force) {
            this.force = force;
        }

        @JsonProperty(value="force")
        public Integer getForce() {
            return this.force;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StartClustersOutput
    extends OutputModel {
        private String action;
        private Map jobIDs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_ids")
        public void setJobIDs(Map jobIDs) {
            this.jobIDs = jobIDs;
        }

        @JsonProperty(value="job_ids")
        public Map getJobIDs() {
            return this.jobIDs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StartClustersInput
    extends IaasParamBody {
        private List<String> clusters;

        @JsonProperty(value="clusters")
        public void setClusters(List<String> clusters) {
            this.clusters = clusters;
        }

        @JsonProperty(value="clusters")
        public List<String> getClusters() {
            return this.clusters;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RunClusterCustomServiceOutput
    extends OutputModel {
        private String action;
        private String clusterID;
        private String jobID;
        private Integer retCode;
        private String role;
        private String service;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="service")
        public String getService() {
            return this.service;
        }
    }

    public static class RunClusterCustomServiceInput
    extends IaasParamBody {
        private String cluster;
        private String role;
        private String service;
        private String serviceParams;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="service")
        public String getService() {
            return this.service;
        }

        @JsonProperty(value="service_params")
        public void setServiceParams(String serviceParams) {
            this.serviceParams = serviceParams;
        }

        @JsonProperty(value="service_params")
        public String getServiceParams() {
            return this.serviceParams;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            if (QCStringUtil.isEmpty(this.getService())) {
                throw new QCException("Service is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RestoreClusterFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String clusterID;
        private String jobID;
        private Integer retCode;
        private String serviceParams;
        private String snapshotID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="service_params")
        public void setServiceParams(String serviceParams) {
            this.serviceParams = serviceParams;
        }

        @JsonProperty(value="service_params")
        public String getServiceParams() {
            return this.serviceParams;
        }

        @JsonProperty(value="snapshot_id")
        public void setSnapshotID(String snapshotID) {
            this.snapshotID = snapshotID;
        }

        @JsonProperty(value="snapshot_id")
        public String getSnapshotID() {
            return this.snapshotID;
        }
    }

    public static class RestoreClusterFromSnapshotInput
    extends IaasParamBody {
        private String cluster;
        private String serviceParams;
        private String snapshot;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="service_params")
        public void setServiceParams(String serviceParams) {
            this.serviceParams = serviceParams;
        }

        @JsonProperty(value="service_params")
        public String getServiceParams() {
            return this.serviceParams;
        }

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            if (QCStringUtil.isEmpty(this.getSnapshot())) {
                throw new QCException("Snapshot is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RestartClusterServiceOutput
    extends OutputModel {
        private String action;
        private String clusterID;
        private String jobID;
        private Integer retCode;
        private String role;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }
    }

    public static class RestartClusterServiceInput
    extends IaasParamBody {
        private String cluster;
        private String role;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResizeClusterOutput
    extends OutputModel {
        private String action;
        private String clusterID;
        private Integer cPU;
        private Integer gpu;
        private String jobID;
        private Integer memory;
        private Integer retCode;
        private String role;
        private Integer storageSize;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="cpu")
        public void setCPU(Integer cPU) {
            this.cPU = cPU;
        }

        @JsonProperty(value="cpu")
        public Integer getCPU() {
            return this.cPU;
        }

        @JsonProperty(value="gpu")
        public void setGpu(Integer gpu) {
            this.gpu = gpu;
        }

        @JsonProperty(value="gpu")
        public Integer getGpu() {
            return this.gpu;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="memory")
        public void setMemory(Integer memory) {
            this.memory = memory;
        }

        @JsonProperty(value="memory")
        public Integer getMemory() {
            return this.memory;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }
    }

    public static class ResizeClusterInput
    extends IaasParamBody {
        private String cluster;
        private Integer cPU;
        private Integer gpu;
        private Integer memory;
        private String nodeRole;
        private Integer storageSize;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="cpu")
        public void setCPU(Integer cPU) {
            this.cPU = cPU;
        }

        @JsonProperty(value="cpu")
        public Integer getCPU() {
            return this.cPU;
        }

        @JsonProperty(value="gpu")
        public void setGpu(Integer gpu) {
            this.gpu = gpu;
        }

        @JsonProperty(value="gpu")
        public Integer getGpu() {
            return this.gpu;
        }

        @JsonProperty(value="memory")
        public void setMemory(Integer memory) {
            this.memory = memory;
        }

        @JsonProperty(value="memory")
        public Integer getMemory() {
            return this.memory;
        }

        @JsonProperty(value="node_role")
        public void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        @JsonProperty(value="node_role")
        public String getNodeRole() {
            return this.nodeRole;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RecoverClustersOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RecoverClustersInput
    extends IaasParamBody {
        private List<String> resources;

        @JsonProperty(value="resources")
        public void setResources(List<String> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="resources")
        public List<String> getResources() {
            return this.resources;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyClusterNodeAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyClusterNodeAttributesInput
    extends IaasParamBody {
        private String clusterNode;
        private String name;

        @JsonProperty(value="cluster_node")
        public void setClusterNode(String clusterNode) {
            this.clusterNode = clusterNode;
        }

        @JsonProperty(value="cluster_node")
        public String getClusterNode() {
            return this.clusterNode;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getClusterNode())) {
                throw new QCException("ClusterNode is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyClusterAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyClusterAttributesInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private String cluster;
        private String description;
        private String name;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DissociateEIPFromClusterNodeOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DissociateEIPFromClusterNodeInput
    extends IaasParamBody {
        private List<String> eIPs;

        @JsonProperty(value="eips")
        public void setEIPs(List<String> eIPs) {
            this.eIPs = eIPs;
        }

        @JsonProperty(value="eips")
        public List<String> getEIPs() {
            return this.eIPs;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeClustersOutput
    extends OutputModel {
        private String action;
        private List<Types.ClusterModel> clusterSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_set")
        public void setClusterSet(List<Types.ClusterModel> clusterSet) {
            this.clusterSet = clusterSet;
        }

        @JsonProperty(value="cluster_set")
        public List<Types.ClusterModel> getClusterSet() {
            return this.clusterSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeClustersInput
    extends IaasParamBody {
        private List<String> appVersions;
        private List<String> apps;
        private String cfgmgmtID;
        private List<String> clusters;
        private String console;
        private String externalClusterID;
        private Integer limit;
        private String link;
        private String name;
        private Integer offset;
        private String owner;
        private Integer reverse;
        private String role;
        private String scope;
        private String searchWord;
        private String sortKey;
        private String status;
        private String transitionStatus;
        private List<String> users;
        private Integer verbose;
        private String vxNet;

        @JsonProperty(value="app_versions")
        public void setAppVersions(List<String> appVersions) {
            this.appVersions = appVersions;
        }

        @JsonProperty(value="app_versions")
        public List<String> getAppVersions() {
            return this.appVersions;
        }

        @JsonProperty(value="apps")
        public void setApps(List<String> apps) {
            this.apps = apps;
        }

        @JsonProperty(value="apps")
        public List<String> getApps() {
            return this.apps;
        }

        @JsonProperty(value="cfgmgmt_id")
        public void setCfgmgmtID(String cfgmgmtID) {
            this.cfgmgmtID = cfgmgmtID;
        }

        @JsonProperty(value="cfgmgmt_id")
        public String getCfgmgmtID() {
            return this.cfgmgmtID;
        }

        @JsonProperty(value="clusters")
        public void setClusters(List<String> clusters) {
            this.clusters = clusters;
        }

        @JsonProperty(value="clusters")
        public List<String> getClusters() {
            return this.clusters;
        }

        @JsonProperty(value="console")
        public void setConsole(String console) {
            this.console = console;
        }

        @JsonProperty(value="console")
        public String getConsole() {
            return this.console;
        }

        @JsonProperty(value="external_cluster_id")
        public void setExternalClusterID(String externalClusterID) {
            this.externalClusterID = externalClusterID;
        }

        @JsonProperty(value="external_cluster_id")
        public String getExternalClusterID() {
            return this.externalClusterID;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="link")
        public void setLink(String link) {
            this.link = link;
        }

        @JsonProperty(value="link")
        public String getLink() {
            return this.link;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="reverse")
        public void setReverse(Integer reverse) {
            this.reverse = reverse;
        }

        @JsonProperty(value="reverse")
        public Integer getReverse() {
            return this.reverse;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="scope")
        public void setScope(String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="scope")
        public String getScope() {
            return this.scope;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="sort_key")
        public void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        @JsonProperty(value="sort_key")
        public String getSortKey() {
            return this.sortKey;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="users")
        public void setUsers(List<String> users) {
            this.users = users;
        }

        @JsonProperty(value="users")
        public List<String> getUsers() {
            return this.users;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            String[] scopeValidValues = new String[]{"all", "cfgmgmt"};
            boolean scopeIsValid = false;
            for (String v : scopeValidValues) {
                Boolean scopeIsRequired;
                if (v.equals(this.getScope())) {
                    scopeIsValid = true;
                }
                if (!(scopeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getScope() != null) continue;
                scopeIsValid = true;
            }
            if (!scopeIsValid) {
                throw new QCException("Scope value " + this.getScope() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeClusterUsersOutput
    extends OutputModel {
        private String action;
        private List<String> apps;
        private Integer retCode;
        private Map users;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="apps")
        public void setApps(List<String> apps) {
            this.apps = apps;
        }

        @JsonProperty(value="apps")
        public List<String> getApps() {
            return this.apps;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="users")
        public void setUsers(Map users) {
            this.users = users;
        }

        @JsonProperty(value="users")
        public Map getUsers() {
            return this.users;
        }
    }

    public static class DescribeClusterUsersInput
    extends IaasParamBody {
        private List<String> appVersions;
        private List<String> apps;
        private List<String> clusterStatus;
        private Integer limit;
        private Integer offset;
        private List<String> users;
        private List<String> zones;

        @JsonProperty(value="app_versions")
        public void setAppVersions(List<String> appVersions) {
            this.appVersions = appVersions;
        }

        @JsonProperty(value="app_versions")
        public List<String> getAppVersions() {
            return this.appVersions;
        }

        @JsonProperty(value="apps")
        public void setApps(List<String> apps) {
            this.apps = apps;
        }

        @JsonProperty(value="apps")
        public List<String> getApps() {
            return this.apps;
        }

        @JsonProperty(value="cluster_status")
        public void setClusterStatus(List<String> clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @JsonProperty(value="cluster_status")
        public List<String> getClusterStatus() {
            return this.clusterStatus;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="users")
        public void setUsers(List<String> users) {
            this.users = users;
        }

        @JsonProperty(value="users")
        public List<String> getUsers() {
            return this.users;
        }

        @JsonProperty(value="zones")
        public void setZones(List<String> zones) {
            this.zones = zones;
        }

        @JsonProperty(value="zones")
        public List<String> getZones() {
            return this.zones;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeClusterNodesOutput
    extends OutputModel {
        private String action;
        private List<Types.ClusterNodeModel> nodeSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="node_set")
        public void setNodeSet(List<Types.ClusterNodeModel> nodeSet) {
            this.nodeSet = nodeSet;
        }

        @JsonProperty(value="node_set")
        public List<Types.ClusterNodeModel> getNodeSet() {
            return this.nodeSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeClusterNodesInput
    extends IaasParamBody {
        private String cluster;
        private String console;
        private Integer limit;
        private List<String> nodes;
        private Integer offset;
        private String owner;
        private Integer reverse;
        private String role;
        private String searchWord;
        private String sortKey;
        private String status;
        private Integer verbose;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="console")
        public void setConsole(String console) {
            this.console = console;
        }

        @JsonProperty(value="console")
        public String getConsole() {
            return this.console;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="nodes")
        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }

        @JsonProperty(value="nodes")
        public List<String> getNodes() {
            return this.nodes;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="reverse")
        public void setReverse(Integer reverse) {
            this.reverse = reverse;
        }

        @JsonProperty(value="reverse")
        public Integer getReverse() {
            return this.reverse;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="sort_key")
        public void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        @JsonProperty(value="sort_key")
        public String getSortKey() {
            return this.sortKey;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeClusterDisplayTabsOutput
    extends OutputModel {
        private String action;
        private Map displayTabs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="display_tabs")
        public void setDisplayTabs(Map displayTabs) {
            this.displayTabs = displayTabs;
        }

        @JsonProperty(value="display_tabs")
        public Map getDisplayTabs() {
            return this.displayTabs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeClusterDisplayTabsInput
    extends IaasParamBody {
        private String cluster;
        private String displayTabs;
        private String role;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="display_tabs")
        public void setDisplayTabs(String displayTabs) {
            this.displayTabs = displayTabs;
        }

        @JsonProperty(value="display_tabs")
        public String getDisplayTabs() {
            return this.displayTabs;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            if (QCStringUtil.isEmpty(this.getDisplayTabs())) {
                throw new QCException("DisplayTabs is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteClustersOutput
    extends OutputModel {
        private String action;
        private Map jobIDs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_ids")
        public void setJobIDs(Map jobIDs) {
            this.jobIDs = jobIDs;
        }

        @JsonProperty(value="job_ids")
        public Map getJobIDs() {
            return this.jobIDs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteClustersInput
    extends IaasParamBody {
        private List<String> clusters;
        private Integer force;

        @JsonProperty(value="clusters")
        public void setClusters(List<String> clusters) {
            this.clusters = clusters;
        }

        @JsonProperty(value="clusters")
        public List<String> getClusters() {
            return this.clusters;
        }

        @JsonProperty(value="force")
        public void setForce(Integer force) {
            this.force = force;
        }

        @JsonProperty(value="force")
        public Integer getForce() {
            return this.force;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteClusterNodesOutput
    extends OutputModel {
        private String action;
        private String clusterID;
        private List<String> deletedNodeIDs;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="deleted_node_ids")
        public void setDeletedNodeIDs(List<String> deletedNodeIDs) {
            this.deletedNodeIDs = deletedNodeIDs;
        }

        @JsonProperty(value="deleted_node_ids")
        public List<String> getDeletedNodeIDs() {
            return this.deletedNodeIDs;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteClusterNodesInput
    extends IaasParamBody {
        private String cluster;
        private Integer force;
        private List<String> nodes;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="force")
        public void setForce(Integer force) {
            this.force = force;
        }

        @JsonProperty(value="force")
        public Integer getForce() {
            return this.force;
        }

        @JsonProperty(value="nodes")
        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }

        @JsonProperty(value="nodes")
        public List<String> getNodes() {
            return this.nodes;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateClusterFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String appID;
        private String appVersion;
        private String clusterID;
        private String clusterName;
        private String jobID;
        private List<String> nodeIDs;
        private Integer retCode;
        private String vxNetID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="app_id")
        public void setAppID(String appID) {
            this.appID = appID;
        }

        @JsonProperty(value="app_id")
        public String getAppID() {
            return this.appID;
        }

        @JsonProperty(value="app_version")
        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @JsonProperty(value="app_version")
        public String getAppVersion() {
            return this.appVersion;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="cluster_name")
        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @JsonProperty(value="cluster_name")
        public String getClusterName() {
            return this.clusterName;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="node_ids")
        public void setNodeIDs(List<String> nodeIDs) {
            this.nodeIDs = nodeIDs;
        }

        @JsonProperty(value="node_ids")
        public List<String> getNodeIDs() {
            return this.nodeIDs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }
    }

    public static class CreateClusterFromSnapshotInput
    extends IaasParamBody {
        private String conf;
        private String snapshotID;

        @JsonProperty(value="conf")
        public void setConf(String conf) {
            this.conf = conf;
        }

        @JsonProperty(value="conf")
        public String getConf() {
            return this.conf;
        }

        @JsonProperty(value="snapshot_id")
        public void setSnapshotID(String snapshotID) {
            this.snapshotID = snapshotID;
        }

        @JsonProperty(value="snapshot_id")
        public String getSnapshotID() {
            return this.snapshotID;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getConf())) {
                throw new QCException("Conf is required");
            }
            if (QCStringUtil.isEmpty(this.getSnapshotID())) {
                throw new QCException("SnapshotID is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateClusterOutput
    extends OutputModel {
        private String action;
        private String appID;
        private String appVersion;
        private String clusterID;
        private String clusterName;
        private String jobID;
        private List<String> nodeIDs;
        private Integer retCode;
        private String vxNetID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="app_id")
        public void setAppID(String appID) {
            this.appID = appID;
        }

        @JsonProperty(value="app_id")
        public String getAppID() {
            return this.appID;
        }

        @JsonProperty(value="app_version")
        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @JsonProperty(value="app_version")
        public String getAppVersion() {
            return this.appVersion;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="cluster_name")
        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @JsonProperty(value="cluster_name")
        public String getClusterName() {
            return this.clusterName;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="node_ids")
        public void setNodeIDs(List<String> nodeIDs) {
            this.nodeIDs = nodeIDs;
        }

        @JsonProperty(value="node_ids")
        public List<String> getNodeIDs() {
            return this.nodeIDs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }
    }

    public static class CreateClusterInput
    extends IaasParamBody {
        private String conf;

        @JsonProperty(value="conf")
        public void setConf(String conf) {
            this.conf = conf;
        }

        @JsonProperty(value="conf")
        public String getConf() {
            return this.conf;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getConf())) {
                throw new QCException("Conf is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ChangeClusterVxNetOutput
    extends OutputModel {
        private String action;
        private String clusterID;
        private String jobID;
        private Integer retCode;
        private String vxNetID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }
    }

    public static class ChangeClusterVxNetInput
    extends IaasParamBody {
        private String cluster;
        private Types.Model privateIPs;
        private List<String> roles;
        private String vxNet;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(Types.Model privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public Types.Model getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="roles")
        public List<String> getRoles() {
            return this.roles;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CeaseClustersOutput
    extends OutputModel {
        private String action;
        private Map jobIDs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_ids")
        public void setJobIDs(Map jobIDs) {
            this.jobIDs = jobIDs;
        }

        @JsonProperty(value="job_ids")
        public Map getJobIDs() {
            return this.jobIDs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CeaseClustersInput
    extends IaasParamBody {
        private List<String> clusters;

        @JsonProperty(value="clusters")
        public void setClusters(List<String> clusters) {
            this.clusters = clusters;
        }

        @JsonProperty(value="clusters")
        public List<String> getClusters() {
            return this.clusters;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AssociateEIPToClusterNodeOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AssociateEIPToClusterNodeInput
    extends IaasParamBody {
        private String clusterNode;
        private String eIP;
        private String nIC;

        @JsonProperty(value="cluster_node")
        public void setClusterNode(String clusterNode) {
            this.clusterNode = clusterNode;
        }

        @JsonProperty(value="cluster_node")
        public String getClusterNode() {
            return this.clusterNode;
        }

        @JsonProperty(value="eip")
        public void setEIP(String eIP) {
            this.eIP = eIP;
        }

        @JsonProperty(value="eip")
        public String getEIP() {
            return this.eIP;
        }

        @JsonProperty(value="nic")
        public void setNIC(String nIC) {
            this.nIC = nIC;
        }

        @JsonProperty(value="nic")
        public String getNIC() {
            return this.nIC;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getClusterNode())) {
                throw new QCException("ClusterNode is required");
            }
            if (QCStringUtil.isEmpty(this.getEIP())) {
                throw new QCException("EIP is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddClusterNodesOutput
    extends OutputModel {
        private String action;
        private String clusterID;
        private String jobID;
        private List<String> newNodeIDs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="new_node_ids")
        public void setNewNodeIDs(List<String> newNodeIDs) {
            this.newNodeIDs = newNodeIDs;
        }

        @JsonProperty(value="new_node_ids")
        public List<String> getNewNodeIDs() {
            return this.newNodeIDs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AddClusterNodesInput
    extends IaasParamBody {
        private String cluster;
        private Integer nodeCount;
        private String nodeName;
        private String nodeRole;
        private List<String> privateIPs;
        private String resourceConf;

        @JsonProperty(value="cluster")
        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public String getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="node_name")
        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @JsonProperty(value="node_name")
        public String getNodeName() {
            return this.nodeName;
        }

        @JsonProperty(value="node_role")
        public void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        @JsonProperty(value="node_role")
        public String getNodeRole() {
            return this.nodeRole;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<String> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<String> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="resource_conf")
        public void setResourceConf(String resourceConf) {
            this.resourceConf = resourceConf;
        }

        @JsonProperty(value="resource_conf")
        public String getResourceConf() {
            return this.resourceConf;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCluster())) {
                throw new QCException("Cluster is required");
            }
            if (this.getNodeCount() < 0) {
                throw new QCException("NodeCount is required");
            }
            return null;
        }
    }
}

