/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class InstanceService {
    private EnvContext envContext;
    private String zone;

    public InstanceService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public InstanceService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public CeaseInstancesOutput ceaseInstances(CeaseInstancesInput input) throws QCException {
        if (input == null) {
            input = new CeaseInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CeaseInstances");
        context.put("APIName", "CeaseInstances");
        context.put("ServiceName", "CeaseInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CeaseInstances");
        input.setAction("CeaseInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CeaseInstancesOutput.class);
        if (backModel != null) {
            return (CeaseInstancesOutput)backModel;
        }
        return null;
    }

    public void ceaseInstances(CeaseInstancesInput input, ResponseCallBack<CeaseInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new CeaseInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CeaseInstances");
        context.put("APIName", "CeaseInstances");
        context.put("ServiceName", "CeaseInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CeaseInstances");
        input.setAction("CeaseInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeInstanceTypesOutput describeInstanceTypes(DescribeInstanceTypesInput input) throws QCException {
        if (input == null) {
            input = new DescribeInstanceTypesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeInstanceTypes");
        context.put("APIName", "DescribeInstanceTypes");
        context.put("ServiceName", "DescribeInstanceTypes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeInstanceTypes");
        input.setAction("DescribeInstanceTypes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeInstanceTypesOutput.class);
        if (backModel != null) {
            return (DescribeInstanceTypesOutput)backModel;
        }
        return null;
    }

    public void describeInstanceTypes(DescribeInstanceTypesInput input, ResponseCallBack<DescribeInstanceTypesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeInstanceTypesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeInstanceTypes");
        context.put("APIName", "DescribeInstanceTypes");
        context.put("ServiceName", "DescribeInstanceTypes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeInstanceTypes");
        input.setAction("DescribeInstanceTypes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeInstancesOutput describeInstances(DescribeInstancesInput input) throws QCException {
        if (input == null) {
            input = new DescribeInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeInstances");
        context.put("APIName", "DescribeInstances");
        context.put("ServiceName", "DescribeInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeInstances");
        input.setAction("DescribeInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeInstancesOutput.class);
        if (backModel != null) {
            return (DescribeInstancesOutput)backModel;
        }
        return null;
    }

    public void describeInstances(DescribeInstancesInput input, ResponseCallBack<DescribeInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeInstances");
        context.put("APIName", "DescribeInstances");
        context.put("ServiceName", "DescribeInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeInstances");
        input.setAction("DescribeInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyInstanceAttributesOutput modifyInstanceAttributes(ModifyInstanceAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyInstanceAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyInstanceAttributes");
        context.put("APIName", "ModifyInstanceAttributes");
        context.put("ServiceName", "ModifyInstanceAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyInstanceAttributes");
        input.setAction("ModifyInstanceAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyInstanceAttributesOutput.class);
        if (backModel != null) {
            return (ModifyInstanceAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyInstanceAttributes(ModifyInstanceAttributesInput input, ResponseCallBack<ModifyInstanceAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyInstanceAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyInstanceAttributes");
        context.put("APIName", "ModifyInstanceAttributes");
        context.put("ServiceName", "ModifyInstanceAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyInstanceAttributes");
        input.setAction("ModifyInstanceAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResetInstancesOutput resetInstances(ResetInstancesInput input) throws QCException {
        if (input == null) {
            input = new ResetInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResetInstances");
        context.put("APIName", "ResetInstances");
        context.put("ServiceName", "ResetInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResetInstances");
        input.setAction("ResetInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResetInstancesOutput.class);
        if (backModel != null) {
            return (ResetInstancesOutput)backModel;
        }
        return null;
    }

    public void resetInstances(ResetInstancesInput input, ResponseCallBack<ResetInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new ResetInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResetInstances");
        context.put("APIName", "ResetInstances");
        context.put("ServiceName", "ResetInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResetInstances");
        input.setAction("ResetInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResizeInstancesOutput resizeInstances(ResizeInstancesInput input) throws QCException {
        if (input == null) {
            input = new ResizeInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeInstances");
        context.put("APIName", "ResizeInstances");
        context.put("ServiceName", "ResizeInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeInstances");
        input.setAction("ResizeInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResizeInstancesOutput.class);
        if (backModel != null) {
            return (ResizeInstancesOutput)backModel;
        }
        return null;
    }

    public void resizeInstances(ResizeInstancesInput input, ResponseCallBack<ResizeInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new ResizeInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeInstances");
        context.put("APIName", "ResizeInstances");
        context.put("ServiceName", "ResizeInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeInstances");
        input.setAction("ResizeInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RestartInstancesOutput restartInstances(RestartInstancesInput input) throws QCException {
        if (input == null) {
            input = new RestartInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartInstances");
        context.put("APIName", "RestartInstances");
        context.put("ServiceName", "RestartInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartInstances");
        input.setAction("RestartInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RestartInstancesOutput.class);
        if (backModel != null) {
            return (RestartInstancesOutput)backModel;
        }
        return null;
    }

    public void restartInstances(RestartInstancesInput input, ResponseCallBack<RestartInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new RestartInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RestartInstances");
        context.put("APIName", "RestartInstances");
        context.put("ServiceName", "RestartInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RestartInstances");
        input.setAction("RestartInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RunInstancesOutput runInstances(RunInstancesInput input) throws QCException {
        if (input == null) {
            input = new RunInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RunInstances");
        context.put("APIName", "RunInstances");
        context.put("ServiceName", "RunInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RunInstances");
        input.setAction("RunInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RunInstancesOutput.class);
        if (backModel != null) {
            return (RunInstancesOutput)backModel;
        }
        return null;
    }

    public void runInstances(RunInstancesInput input, ResponseCallBack<RunInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new RunInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RunInstances");
        context.put("APIName", "RunInstances");
        context.put("ServiceName", "RunInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RunInstances");
        input.setAction("RunInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StartInstancesOutput startInstances(StartInstancesInput input) throws QCException {
        if (input == null) {
            input = new StartInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartInstances");
        context.put("APIName", "StartInstances");
        context.put("ServiceName", "StartInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartInstances");
        input.setAction("StartInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StartInstancesOutput.class);
        if (backModel != null) {
            return (StartInstancesOutput)backModel;
        }
        return null;
    }

    public void startInstances(StartInstancesInput input, ResponseCallBack<StartInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new StartInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartInstances");
        context.put("APIName", "StartInstances");
        context.put("ServiceName", "StartInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartInstances");
        input.setAction("StartInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StopInstancesOutput stopInstances(StopInstancesInput input) throws QCException {
        if (input == null) {
            input = new StopInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopInstances");
        context.put("APIName", "StopInstances");
        context.put("ServiceName", "StopInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopInstances");
        input.setAction("StopInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StopInstancesOutput.class);
        if (backModel != null) {
            return (StopInstancesOutput)backModel;
        }
        return null;
    }

    public void stopInstances(StopInstancesInput input, ResponseCallBack<StopInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new StopInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopInstances");
        context.put("APIName", "StopInstances");
        context.put("ServiceName", "StopInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopInstances");
        input.setAction("StopInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public TerminateInstancesOutput terminateInstances(TerminateInstancesInput input) throws QCException {
        if (input == null) {
            input = new TerminateInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "TerminateInstances");
        context.put("APIName", "TerminateInstances");
        context.put("ServiceName", "TerminateInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/TerminateInstances");
        input.setAction("TerminateInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, TerminateInstancesOutput.class);
        if (backModel != null) {
            return (TerminateInstancesOutput)backModel;
        }
        return null;
    }

    public void terminateInstances(TerminateInstancesInput input, ResponseCallBack<TerminateInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new TerminateInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "TerminateInstances");
        context.put("APIName", "TerminateInstances");
        context.put("ServiceName", "TerminateInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/TerminateInstances");
        input.setAction("TerminateInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TerminateInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class TerminateInstancesInput
    extends IaasParamBody {
        private List<String> instances;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StopInstancesInput
    extends IaasParamBody {
        private Integer force;
        private List<String> instances;

        @JsonProperty(value="force")
        public void setForce(Integer force) {
            this.force = force;
        }

        @JsonProperty(value="force")
        public Integer getForce() {
            return this.force;
        }

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @Override
        public String validateParam() throws QCException {
            String[] forceValidValues = new String[]{"0", "1"};
            boolean forceIsValid = false;
            for (String v : forceValidValues) {
                Boolean forceIsRequired;
                if (v.equals(this.getForce() + "")) {
                    forceIsValid = true;
                }
                if (!(forceIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getForce() != null) continue;
                forceIsValid = true;
            }
            if (!forceIsValid) {
                throw new QCException("Force value " + this.getForce() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StartInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StartInstancesInput
    extends IaasParamBody {
        private List<String> instances;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RunInstancesOutput
    extends OutputModel {
        private String action;
        private List<String> instances;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RunInstancesInput
    extends IaasParamBody {
        private String billingID;
        private Integer count;
        private Integer cPU;
        private Integer cPUMax;
        private String cPUModel;
        private Integer gpu;
        private String hostname;
        private String imageID;
        private Integer instanceClass;
        private String instanceName;
        private String instanceType;
        private String loginKeyPair;
        private String loginMode;
        private String loginPasswd;
        private Integer memMax;
        private Integer memory;
        private Integer needNewSID;
        private Integer needUserdata;
        private Integer oSDiskSize;
        private String securityGroup;
        private String uIType;
        private String userdataFile;
        private String userdataPath;
        private String userdataType;
        private String userdataValue;
        private List<String> volumes;
        private List<String> vxNets;

        @JsonProperty(value="billing_id")
        public void setBillingID(String billingID) {
            this.billingID = billingID;
        }

        @JsonProperty(value="billing_id")
        public String getBillingID() {
            return this.billingID;
        }

        @JsonProperty(value="count")
        public void setCount(Integer count) {
            this.count = count;
        }

        @JsonProperty(value="count")
        public Integer getCount() {
            return this.count;
        }

        @JsonProperty(value="cpu")
        public void setCPU(Integer cPU) {
            this.cPU = cPU;
        }

        @JsonProperty(value="cpu")
        public Integer getCPU() {
            return this.cPU;
        }

        @JsonProperty(value="cpu_max")
        public void setCPUMax(Integer cPUMax) {
            this.cPUMax = cPUMax;
        }

        @JsonProperty(value="cpu_max")
        public Integer getCPUMax() {
            return this.cPUMax;
        }

        @JsonProperty(value="cpu_model")
        public void setCPUModel(String cPUModel) {
            this.cPUModel = cPUModel;
        }

        @JsonProperty(value="cpu_model")
        public String getCPUModel() {
            return this.cPUModel;
        }

        @JsonProperty(value="gpu")
        public void setGpu(Integer gpu) {
            this.gpu = gpu;
        }

        @JsonProperty(value="gpu")
        public Integer getGpu() {
            return this.gpu;
        }

        @JsonProperty(value="hostname")
        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @JsonProperty(value="hostname")
        public String getHostname() {
            return this.hostname;
        }

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="instance_class")
        public void setInstanceClass(Integer instanceClass) {
            this.instanceClass = instanceClass;
        }

        @JsonProperty(value="instance_class")
        public Integer getInstanceClass() {
            return this.instanceClass;
        }

        @JsonProperty(value="instance_name")
        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @JsonProperty(value="instance_name")
        public String getInstanceName() {
            return this.instanceName;
        }

        @JsonProperty(value="instance_type")
        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @JsonProperty(value="instance_type")
        public String getInstanceType() {
            return this.instanceType;
        }

        @JsonProperty(value="login_keypair")
        public void setLoginKeyPair(String loginKeyPair) {
            this.loginKeyPair = loginKeyPair;
        }

        @JsonProperty(value="login_keypair")
        public String getLoginKeyPair() {
            return this.loginKeyPair;
        }

        @JsonProperty(value="login_mode")
        public void setLoginMode(String loginMode) {
            this.loginMode = loginMode;
        }

        @JsonProperty(value="login_mode")
        public String getLoginMode() {
            return this.loginMode;
        }

        @JsonProperty(value="login_passwd")
        public void setLoginPasswd(String loginPasswd) {
            this.loginPasswd = loginPasswd;
        }

        @JsonProperty(value="login_passwd")
        public String getLoginPasswd() {
            return this.loginPasswd;
        }

        @JsonProperty(value="mem_max")
        public void setMemMax(Integer memMax) {
            this.memMax = memMax;
        }

        @JsonProperty(value="mem_max")
        public Integer getMemMax() {
            return this.memMax;
        }

        @JsonProperty(value="memory")
        public void setMemory(Integer memory) {
            this.memory = memory;
        }

        @JsonProperty(value="memory")
        public Integer getMemory() {
            return this.memory;
        }

        @JsonProperty(value="need_newsid")
        public void setNeedNewSID(Integer needNewSID) {
            this.needNewSID = needNewSID;
        }

        @JsonProperty(value="need_newsid")
        public Integer getNeedNewSID() {
            return this.needNewSID;
        }

        @JsonProperty(value="need_userdata")
        public void setNeedUserdata(Integer needUserdata) {
            this.needUserdata = needUserdata;
        }

        @JsonProperty(value="need_userdata")
        public Integer getNeedUserdata() {
            return this.needUserdata;
        }

        @JsonProperty(value="os_disk_size")
        public void setOSDiskSize(Integer oSDiskSize) {
            this.oSDiskSize = oSDiskSize;
        }

        @JsonProperty(value="os_disk_size")
        public Integer getOSDiskSize() {
            return this.oSDiskSize;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="ui_type")
        public void setUIType(String uIType) {
            this.uIType = uIType;
        }

        @JsonProperty(value="ui_type")
        public String getUIType() {
            return this.uIType;
        }

        @JsonProperty(value="userdata_file")
        public void setUserdataFile(String userdataFile) {
            this.userdataFile = userdataFile;
        }

        @JsonProperty(value="userdata_file")
        public String getUserdataFile() {
            return this.userdataFile;
        }

        @JsonProperty(value="userdata_path")
        public void setUserdataPath(String userdataPath) {
            this.userdataPath = userdataPath;
        }

        @JsonProperty(value="userdata_path")
        public String getUserdataPath() {
            return this.userdataPath;
        }

        @JsonProperty(value="userdata_type")
        public void setUserdataType(String userdataType) {
            this.userdataType = userdataType;
        }

        @JsonProperty(value="userdata_type")
        public String getUserdataType() {
            return this.userdataType;
        }

        @JsonProperty(value="userdata_value")
        public void setUserdataValue(String userdataValue) {
            this.userdataValue = userdataValue;
        }

        @JsonProperty(value="userdata_value")
        public String getUserdataValue() {
            return this.userdataValue;
        }

        @JsonProperty(value="volumes")
        public void setVolumes(List<String> volumes) {
            this.volumes = volumes;
        }

        @JsonProperty(value="volumes")
        public List<String> getVolumes() {
            return this.volumes;
        }

        @JsonProperty(value="vxnets")
        public void setVxNets(List<String> vxNets) {
            this.vxNets = vxNets;
        }

        @JsonProperty(value="vxnets")
        public List<String> getVxNets() {
            return this.vxNets;
        }

        @Override
        public String validateParam() throws QCException {
            String[] cPUValidValues = new String[]{"1", "2", "4", "8", "16"};
            boolean cPUIsValid = false;
            for (String v : cPUValidValues) {
                Boolean cPUIsRequired;
                if (v.equals(this.getCPU() + "")) {
                    cPUIsValid = true;
                }
                if (!(cPUIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCPU() != null) continue;
                cPUIsValid = true;
            }
            if (!cPUIsValid) {
                throw new QCException("CPU value " + this.getCPU() + "is invalid");
            }
            String[] cPUMaxValidValues = new String[]{"1", "2", "4", "8", "16"};
            boolean cPUMaxIsValid = false;
            for (String v : cPUMaxValidValues) {
                Boolean cPUMaxIsRequired;
                if (v.equals(this.getCPUMax() + "")) {
                    cPUMaxIsValid = true;
                }
                if (!(cPUMaxIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCPUMax() != null) continue;
                cPUMaxIsValid = true;
            }
            if (!cPUMaxIsValid) {
                throw new QCException("CPUMax value " + this.getCPUMax() + "is invalid");
            }
            String[] cPUModelValidValues = new String[]{"Westmere", "SandyBridge", "IvyBridge", "Haswell", "Broadwell"};
            boolean cPUModelIsValid = false;
            for (String v : cPUModelValidValues) {
                Boolean cPUModelIsRequired;
                if (v.equals(this.getCPUModel())) {
                    cPUModelIsValid = true;
                }
                if (!(cPUModelIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCPUModel() != null) continue;
                cPUModelIsValid = true;
            }
            if (!cPUModelIsValid) {
                throw new QCException("CPUModel value " + this.getCPUModel() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getImageID())) {
                throw new QCException("ImageID is required");
            }
            String[] instanceClassValidValues = new String[]{"0", "1", "2", "3", "4", "5", "6", "100", "101", "200", "201", "300", "301"};
            boolean instanceClassIsValid = false;
            for (String v : instanceClassValidValues) {
                Boolean instanceClassIsRequired;
                if (v.equals(this.getInstanceClass() + "")) {
                    instanceClassIsValid = true;
                }
                if (!(instanceClassIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getInstanceClass() != null) continue;
                instanceClassIsValid = true;
            }
            if (!instanceClassIsValid) {
                throw new QCException("InstanceClass value " + this.getInstanceClass() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getLoginMode())) {
                throw new QCException("LoginMode is required");
            }
            String[] loginModeValidValues = new String[]{"keypair", "passwd"};
            boolean loginModeIsValid = false;
            for (String v : loginModeValidValues) {
                Boolean loginModeIsRequired;
                if (v.equals(this.getLoginMode())) {
                    loginModeIsValid = true;
                }
                if (!(loginModeIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getLoginMode() != null) continue;
                loginModeIsValid = true;
            }
            if (!loginModeIsValid) {
                throw new QCException("LoginMode value " + this.getLoginMode() + "is invalid");
            }
            String[] memMaxValidValues = new String[]{"1024", "2048", "4096", "6144", "8192", "12288", "16384", "24576", "32768"};
            boolean memMaxIsValid = false;
            for (String v : memMaxValidValues) {
                Boolean memMaxIsRequired;
                if (v.equals(this.getMemMax() + "")) {
                    memMaxIsValid = true;
                }
                if (!(memMaxIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getMemMax() != null) continue;
                memMaxIsValid = true;
            }
            if (!memMaxIsValid) {
                throw new QCException("MemMax value " + this.getMemMax() + "is invalid");
            }
            String[] memoryValidValues = new String[]{"1024", "2048", "4096", "6144", "8192", "12288", "16384", "24576", "32768"};
            boolean memoryIsValid = false;
            for (String v : memoryValidValues) {
                Boolean memoryIsRequired;
                if (v.equals(this.getMemory() + "")) {
                    memoryIsValid = true;
                }
                if (!(memoryIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getMemory() != null) continue;
                memoryIsValid = true;
            }
            if (!memoryIsValid) {
                throw new QCException("Memory value " + this.getMemory() + "is invalid");
            }
            String[] needNewSIDValidValues = new String[]{"0", "1"};
            boolean needNewSIDIsValid = false;
            for (String v : needNewSIDValidValues) {
                Boolean needNewSIDIsRequired;
                if (v.equals(this.getNeedNewSID() + "")) {
                    needNewSIDIsValid = true;
                }
                if (!(needNewSIDIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getNeedNewSID() != null) continue;
                needNewSIDIsValid = true;
            }
            if (!needNewSIDIsValid) {
                throw new QCException("NeedNewSID value " + this.getNeedNewSID() + "is invalid");
            }
            String[] needUserdataValidValues = new String[]{"0", "1"};
            boolean needUserdataIsValid = false;
            for (String v : needUserdataValidValues) {
                Boolean needUserdataIsRequired;
                if (v.equals(this.getNeedUserdata() + "")) {
                    needUserdataIsValid = true;
                }
                if (!(needUserdataIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getNeedUserdata() != null) continue;
                needUserdataIsValid = true;
            }
            if (!needUserdataIsValid) {
                throw new QCException("NeedUserdata value " + this.getNeedUserdata() + "is invalid");
            }
            String[] userdataTypeValidValues = new String[]{"plain", "exec", "tar"};
            boolean userdataTypeIsValid = false;
            for (String v : userdataTypeValidValues) {
                Boolean userdataTypeIsRequired;
                if (v.equals(this.getUserdataType())) {
                    userdataTypeIsValid = true;
                }
                if (!(userdataTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getUserdataType() != null) continue;
                userdataTypeIsValid = true;
            }
            if (!userdataTypeIsValid) {
                throw new QCException("UserdataType value " + this.getUserdataType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RestartInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RestartInstancesInput
    extends IaasParamBody {
        private List<String> instances;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResizeInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ResizeInstancesInput
    extends IaasParamBody {
        private Integer cPU;
        private String cPUModel;
        private Integer gpu;
        private String instanceType;
        private List<String> instances;
        private Integer memory;
        private Integer oSDiskSize;

        @JsonProperty(value="cpu")
        public void setCPU(Integer cPU) {
            this.cPU = cPU;
        }

        @JsonProperty(value="cpu")
        public Integer getCPU() {
            return this.cPU;
        }

        @JsonProperty(value="cpu_model")
        public void setCPUModel(String cPUModel) {
            this.cPUModel = cPUModel;
        }

        @JsonProperty(value="cpu_model")
        public String getCPUModel() {
            return this.cPUModel;
        }

        @JsonProperty(value="gpu")
        public void setGpu(Integer gpu) {
            this.gpu = gpu;
        }

        @JsonProperty(value="gpu")
        public Integer getGpu() {
            return this.gpu;
        }

        @JsonProperty(value="instance_type")
        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @JsonProperty(value="instance_type")
        public String getInstanceType() {
            return this.instanceType;
        }

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="memory")
        public void setMemory(Integer memory) {
            this.memory = memory;
        }

        @JsonProperty(value="memory")
        public Integer getMemory() {
            return this.memory;
        }

        @JsonProperty(value="os_disk_size")
        public void setOSDiskSize(Integer oSDiskSize) {
            this.oSDiskSize = oSDiskSize;
        }

        @JsonProperty(value="os_disk_size")
        public Integer getOSDiskSize() {
            return this.oSDiskSize;
        }

        @Override
        public String validateParam() throws QCException {
            String[] cPUValidValues = new String[]{"1", "2", "4", "8", "16"};
            boolean cPUIsValid = false;
            for (String v : cPUValidValues) {
                Boolean cPUIsRequired;
                if (v.equals(this.getCPU() + "")) {
                    cPUIsValid = true;
                }
                if (!(cPUIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCPU() != null) continue;
                cPUIsValid = true;
            }
            if (!cPUIsValid) {
                throw new QCException("CPU value " + this.getCPU() + "is invalid");
            }
            String[] memoryValidValues = new String[]{"1024", "2048", "4096", "6144", "8192", "12288", "16384", "24576", "32768"};
            boolean memoryIsValid = false;
            for (String v : memoryValidValues) {
                Boolean memoryIsRequired;
                if (v.equals(this.getMemory() + "")) {
                    memoryIsValid = true;
                }
                if (!(memoryIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getMemory() != null) continue;
                memoryIsValid = true;
            }
            if (!memoryIsValid) {
                throw new QCException("Memory value " + this.getMemory() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResetInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ResetInstancesInput
    extends IaasParamBody {
        private List<String> instances;
        private String loginKeyPair;
        private String loginMode;
        private String loginPasswd;
        private Integer needNewSID;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="login_keypair")
        public void setLoginKeyPair(String loginKeyPair) {
            this.loginKeyPair = loginKeyPair;
        }

        @JsonProperty(value="login_keypair")
        public String getLoginKeyPair() {
            return this.loginKeyPair;
        }

        @JsonProperty(value="login_mode")
        public void setLoginMode(String loginMode) {
            this.loginMode = loginMode;
        }

        @JsonProperty(value="login_mode")
        public String getLoginMode() {
            return this.loginMode;
        }

        @JsonProperty(value="login_passwd")
        public void setLoginPasswd(String loginPasswd) {
            this.loginPasswd = loginPasswd;
        }

        @JsonProperty(value="login_passwd")
        public String getLoginPasswd() {
            return this.loginPasswd;
        }

        @JsonProperty(value="need_newsid")
        public void setNeedNewSID(Integer needNewSID) {
            this.needNewSID = needNewSID;
        }

        @JsonProperty(value="need_newsid")
        public Integer getNeedNewSID() {
            return this.needNewSID;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoginMode())) {
                throw new QCException("LoginMode is required");
            }
            String[] loginModeValidValues = new String[]{"keypair", "passwd"};
            boolean loginModeIsValid = false;
            for (String v : loginModeValidValues) {
                Boolean loginModeIsRequired;
                if (v.equals(this.getLoginMode())) {
                    loginModeIsValid = true;
                }
                if (!(loginModeIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getLoginMode() != null) continue;
                loginModeIsValid = true;
            }
            if (!loginModeIsValid) {
                throw new QCException("LoginMode value " + this.getLoginMode() + "is invalid");
            }
            String[] needNewSIDValidValues = new String[]{"0", "1"};
            boolean needNewSIDIsValid = false;
            for (String v : needNewSIDValidValues) {
                Boolean needNewSIDIsRequired;
                if (v.equals(this.getNeedNewSID() + "")) {
                    needNewSIDIsValid = true;
                }
                if (!(needNewSIDIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getNeedNewSID() != null) continue;
                needNewSIDIsValid = true;
            }
            if (!needNewSIDIsValid) {
                throw new QCException("NeedNewSID value " + this.getNeedNewSID() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyInstanceAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyInstanceAttributesInput
    extends IaasParamBody {
        private String description;
        private String instance;
        private String instanceName;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="instance")
        public void setInstance(String instance) {
            this.instance = instance;
        }

        @JsonProperty(value="instance")
        public String getInstance() {
            return this.instance;
        }

        @JsonProperty(value="instance_name")
        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @JsonProperty(value="instance_name")
        public String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getInstance())) {
                throw new QCException("Instance is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeInstancesOutput
    extends OutputModel {
        private String action;
        private List<Types.InstanceModel> instanceSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="instance_set")
        public void setInstanceSet(List<Types.InstanceModel> instanceSet) {
            this.instanceSet = instanceSet;
        }

        @JsonProperty(value="instance_set")
        public List<Types.InstanceModel> getInstanceSet() {
            return this.instanceSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeInstancesInput
    extends IaasParamBody {
        private List<String> imageID;
        private Integer instanceClass;
        private List<String> instanceType;
        private List<String> instances;
        private Integer isClusterNode;
        private Integer limit;
        private Integer offset;
        private String owner;
        private String searchWord;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="image_id")
        public void setImageID(List<String> imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public List<String> getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="instance_class")
        public void setInstanceClass(Integer instanceClass) {
            this.instanceClass = instanceClass;
        }

        @JsonProperty(value="instance_class")
        public Integer getInstanceClass() {
            return this.instanceClass;
        }

        @JsonProperty(value="instance_type")
        public void setInstanceType(List<String> instanceType) {
            this.instanceType = instanceType;
        }

        @JsonProperty(value="instance_type")
        public List<String> getInstanceType() {
            return this.instanceType;
        }

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="is_cluster_node")
        public void setIsClusterNode(Integer isClusterNode) {
            this.isClusterNode = isClusterNode;
        }

        @JsonProperty(value="is_cluster_node")
        public Integer getIsClusterNode() {
            return this.isClusterNode;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            String[] instanceClassValidValues = new String[]{"0", "1"};
            boolean instanceClassIsValid = false;
            for (String v : instanceClassValidValues) {
                Boolean instanceClassIsRequired;
                if (v.equals(this.getInstanceClass() + "")) {
                    instanceClassIsValid = true;
                }
                if (!(instanceClassIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getInstanceClass() != null) continue;
                instanceClassIsValid = true;
            }
            if (!instanceClassIsValid) {
                throw new QCException("InstanceClass value " + this.getInstanceClass() + "is invalid");
            }
            String[] verboseValidValues = new String[]{"0", "1"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeInstanceTypesOutput
    extends OutputModel {
        private String action;
        private List<Types.InstanceTypeModel> instanceTypeSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="instance_type_set")
        public void setInstanceTypeSet(List<Types.InstanceTypeModel> instanceTypeSet) {
            this.instanceTypeSet = instanceTypeSet;
        }

        @JsonProperty(value="instance_type_set")
        public List<Types.InstanceTypeModel> getInstanceTypeSet() {
            return this.instanceTypeSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeInstanceTypesInput
    extends IaasParamBody {
        private List<String> instanceTypes;

        @JsonProperty(value="instance_types")
        public void setInstanceTypes(List<String> instanceTypes) {
            this.instanceTypes = instanceTypes;
        }

        @JsonProperty(value="instance_types")
        public List<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CeaseInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CeaseInstancesInput
    extends IaasParamBody {
        private List<String> instances;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }
}

