/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class JobService {
    private EnvContext envContext;
    private String zone;

    public JobService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public JobService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public DescribeJobsOutput describeJobs(DescribeJobsInput input) throws QCException {
        if (input == null) {
            input = new DescribeJobsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeJobs");
        context.put("APIName", "DescribeJobs");
        context.put("ServiceName", "DescribeJobs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeJobs");
        input.setAction("DescribeJobs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeJobsOutput.class);
        if (backModel != null) {
            return (DescribeJobsOutput)backModel;
        }
        return null;
    }

    public void describeJobs(DescribeJobsInput input, ResponseCallBack<DescribeJobsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeJobsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeJobs");
        context.put("APIName", "DescribeJobs");
        context.put("ServiceName", "DescribeJobs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeJobs");
        input.setAction("DescribeJobs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeJobsOutput
    extends OutputModel {
        private String action;
        private List<Types.JobModel> jobSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_set")
        public void setJobSet(List<Types.JobModel> jobSet) {
            this.jobSet = jobSet;
        }

        @JsonProperty(value="job_set")
        public List<Types.JobModel> getJobSet() {
            return this.jobSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeJobsInput
    extends IaasParamBody {
        private List<String> jobs;
        private Integer limit;
        private Integer offset;
        private String owner;
        private List<String> status;
        private Integer verbose;

        @JsonProperty(value="jobs")
        public void setJobs(List<String> jobs) {
            this.jobs = jobs;
        }

        @JsonProperty(value="jobs")
        public List<String> getJobs() {
            return this.jobs;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            String[] verboseValidValues = new String[]{"0"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            return null;
        }
    }
}

