/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class LoadBalancerService {
    private EnvContext envContext;
    private String zone;

    public LoadBalancerService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public LoadBalancerService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AddLoadBalancerBackendsOutput addLoadBalancerBackends(AddLoadBalancerBackendsInput input) throws QCException {
        if (input == null) {
            input = new AddLoadBalancerBackendsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddLoadBalancerBackends");
        context.put("APIName", "AddLoadBalancerBackends");
        context.put("ServiceName", "AddLoadBalancerBackends");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddLoadBalancerBackends");
        input.setAction("AddLoadBalancerBackends");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddLoadBalancerBackendsOutput.class);
        if (backModel != null) {
            return (AddLoadBalancerBackendsOutput)backModel;
        }
        return null;
    }

    public void addLoadBalancerBackends(AddLoadBalancerBackendsInput input, ResponseCallBack<AddLoadBalancerBackendsOutput> callback) throws QCException {
        if (input == null) {
            input = new AddLoadBalancerBackendsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddLoadBalancerBackends");
        context.put("APIName", "AddLoadBalancerBackends");
        context.put("ServiceName", "AddLoadBalancerBackends");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddLoadBalancerBackends");
        input.setAction("AddLoadBalancerBackends");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public AddLoadBalancerListenersOutput addLoadBalancerListeners(AddLoadBalancerListenersInput input) throws QCException {
        if (input == null) {
            input = new AddLoadBalancerListenersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddLoadBalancerListeners");
        context.put("APIName", "AddLoadBalancerListeners");
        context.put("ServiceName", "AddLoadBalancerListeners");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddLoadBalancerListeners");
        input.setAction("AddLoadBalancerListeners");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddLoadBalancerListenersOutput.class);
        if (backModel != null) {
            return (AddLoadBalancerListenersOutput)backModel;
        }
        return null;
    }

    public void addLoadBalancerListeners(AddLoadBalancerListenersInput input, ResponseCallBack<AddLoadBalancerListenersOutput> callback) throws QCException {
        if (input == null) {
            input = new AddLoadBalancerListenersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddLoadBalancerListeners");
        context.put("APIName", "AddLoadBalancerListeners");
        context.put("ServiceName", "AddLoadBalancerListeners");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddLoadBalancerListeners");
        input.setAction("AddLoadBalancerListeners");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public AddLoadBalancerPolicyRulesOutput addLoadBalancerPolicyRules(AddLoadBalancerPolicyRulesInput input) throws QCException {
        if (input == null) {
            input = new AddLoadBalancerPolicyRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddLoadBalancerPolicyRules");
        context.put("APIName", "AddLoadBalancerPolicyRules");
        context.put("ServiceName", "AddLoadBalancerPolicyRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddLoadBalancerPolicyRules");
        input.setAction("AddLoadBalancerPolicyRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddLoadBalancerPolicyRulesOutput.class);
        if (backModel != null) {
            return (AddLoadBalancerPolicyRulesOutput)backModel;
        }
        return null;
    }

    public void addLoadBalancerPolicyRules(AddLoadBalancerPolicyRulesInput input, ResponseCallBack<AddLoadBalancerPolicyRulesOutput> callback) throws QCException {
        if (input == null) {
            input = new AddLoadBalancerPolicyRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddLoadBalancerPolicyRules");
        context.put("APIName", "AddLoadBalancerPolicyRules");
        context.put("ServiceName", "AddLoadBalancerPolicyRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddLoadBalancerPolicyRules");
        input.setAction("AddLoadBalancerPolicyRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ApplyLoadBalancerPolicyOutput applyLoadBalancerPolicy(ApplyLoadBalancerPolicyInput input) throws QCException {
        if (input == null) {
            input = new ApplyLoadBalancerPolicyInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplyLoadBalancerPolicy");
        context.put("APIName", "ApplyLoadBalancerPolicy");
        context.put("ServiceName", "ApplyLoadBalancerPolicy");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplyLoadBalancerPolicy");
        input.setAction("ApplyLoadBalancerPolicy");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ApplyLoadBalancerPolicyOutput.class);
        if (backModel != null) {
            return (ApplyLoadBalancerPolicyOutput)backModel;
        }
        return null;
    }

    public void applyLoadBalancerPolicy(ApplyLoadBalancerPolicyInput input, ResponseCallBack<ApplyLoadBalancerPolicyOutput> callback) throws QCException {
        if (input == null) {
            input = new ApplyLoadBalancerPolicyInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplyLoadBalancerPolicy");
        context.put("APIName", "ApplyLoadBalancerPolicy");
        context.put("ServiceName", "ApplyLoadBalancerPolicy");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplyLoadBalancerPolicy");
        input.setAction("ApplyLoadBalancerPolicy");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public AssociateEIPsToLoadBalancerOutput associateEIPsToLoadBalancer(AssociateEIPsToLoadBalancerInput input) throws QCException {
        if (input == null) {
            input = new AssociateEIPsToLoadBalancerInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AssociateEipsToLoadBalancer");
        context.put("APIName", "AssociateEipsToLoadBalancer");
        context.put("ServiceName", "AssociateEipsToLoadBalancer");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AssociateEipsToLoadBalancer");
        input.setAction("AssociateEipsToLoadBalancer");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AssociateEIPsToLoadBalancerOutput.class);
        if (backModel != null) {
            return (AssociateEIPsToLoadBalancerOutput)backModel;
        }
        return null;
    }

    public void associateEIPsToLoadBalancer(AssociateEIPsToLoadBalancerInput input, ResponseCallBack<AssociateEIPsToLoadBalancerOutput> callback) throws QCException {
        if (input == null) {
            input = new AssociateEIPsToLoadBalancerInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AssociateEIPsToLoadBalancer");
        context.put("APIName", "AssociateEIPsToLoadBalancer");
        context.put("ServiceName", "AssociateEipsToLoadBalancer");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AssociateEipsToLoadBalancer");
        input.setAction("AssociateEIPsToLoadBalancer");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateLoadBalancerOutput createLoadBalancer(CreateLoadBalancerInput input) throws QCException {
        if (input == null) {
            input = new CreateLoadBalancerInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateLoadBalancer");
        context.put("APIName", "CreateLoadBalancer");
        context.put("ServiceName", "CreateLoadBalancer");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateLoadBalancer");
        input.setAction("CreateLoadBalancer");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateLoadBalancerOutput.class);
        if (backModel != null) {
            return (CreateLoadBalancerOutput)backModel;
        }
        return null;
    }

    public void createLoadBalancer(CreateLoadBalancerInput input, ResponseCallBack<CreateLoadBalancerOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateLoadBalancerInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateLoadBalancer");
        context.put("APIName", "CreateLoadBalancer");
        context.put("ServiceName", "CreateLoadBalancer");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateLoadBalancer");
        input.setAction("CreateLoadBalancer");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateLoadBalancerPolicyOutput createLoadBalancerPolicy(CreateLoadBalancerPolicyInput input) throws QCException {
        if (input == null) {
            input = new CreateLoadBalancerPolicyInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateLoadBalancerPolicy");
        context.put("APIName", "CreateLoadBalancerPolicy");
        context.put("ServiceName", "CreateLoadBalancerPolicy");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateLoadBalancerPolicy");
        input.setAction("CreateLoadBalancerPolicy");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateLoadBalancerPolicyOutput.class);
        if (backModel != null) {
            return (CreateLoadBalancerPolicyOutput)backModel;
        }
        return null;
    }

    public void createLoadBalancerPolicy(CreateLoadBalancerPolicyInput input, ResponseCallBack<CreateLoadBalancerPolicyOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateLoadBalancerPolicyInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateLoadBalancerPolicy");
        context.put("APIName", "CreateLoadBalancerPolicy");
        context.put("ServiceName", "CreateLoadBalancerPolicy");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateLoadBalancerPolicy");
        input.setAction("CreateLoadBalancerPolicy");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateServerCertificateOutput createServerCertificate(CreateServerCertificateInput input) throws QCException {
        if (input == null) {
            input = new CreateServerCertificateInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateServerCertificate");
        context.put("APIName", "CreateServerCertificate");
        context.put("ServiceName", "CreateServerCertificate");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/iaas/CreateServerCertificate");
        input.setAction("CreateServerCertificate");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateServerCertificateOutput.class);
        if (backModel != null) {
            return (CreateServerCertificateOutput)backModel;
        }
        return null;
    }

    public void createServerCertificate(CreateServerCertificateInput input, ResponseCallBack<CreateServerCertificateOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateServerCertificateInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateServerCertificate");
        context.put("APIName", "CreateServerCertificate");
        context.put("ServiceName", "CreateServerCertificate");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/iaas/CreateServerCertificate");
        input.setAction("CreateServerCertificate");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteLoadBalancerBackendsOutput deleteLoadBalancerBackends(DeleteLoadBalancerBackendsInput input) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerBackendsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerBackends");
        context.put("APIName", "DeleteLoadBalancerBackends");
        context.put("ServiceName", "DeleteLoadBalancerBackends");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerBackends");
        input.setAction("DeleteLoadBalancerBackends");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteLoadBalancerBackendsOutput.class);
        if (backModel != null) {
            return (DeleteLoadBalancerBackendsOutput)backModel;
        }
        return null;
    }

    public void deleteLoadBalancerBackends(DeleteLoadBalancerBackendsInput input, ResponseCallBack<DeleteLoadBalancerBackendsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerBackendsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerBackends");
        context.put("APIName", "DeleteLoadBalancerBackends");
        context.put("ServiceName", "DeleteLoadBalancerBackends");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerBackends");
        input.setAction("DeleteLoadBalancerBackends");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteLoadBalancerListenersOutput deleteLoadBalancerListeners(DeleteLoadBalancerListenersInput input) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerListenersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerListeners");
        context.put("APIName", "DeleteLoadBalancerListeners");
        context.put("ServiceName", "DeleteLoadBalancerListeners");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerListeners");
        input.setAction("DeleteLoadBalancerListeners");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteLoadBalancerListenersOutput.class);
        if (backModel != null) {
            return (DeleteLoadBalancerListenersOutput)backModel;
        }
        return null;
    }

    public void deleteLoadBalancerListeners(DeleteLoadBalancerListenersInput input, ResponseCallBack<DeleteLoadBalancerListenersOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerListenersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerListeners");
        context.put("APIName", "DeleteLoadBalancerListeners");
        context.put("ServiceName", "DeleteLoadBalancerListeners");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerListeners");
        input.setAction("DeleteLoadBalancerListeners");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteLoadBalancerPoliciesOutput deleteLoadBalancerPolicies(DeleteLoadBalancerPoliciesInput input) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerPoliciesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerPolicies");
        context.put("APIName", "DeleteLoadBalancerPolicies");
        context.put("ServiceName", "DeleteLoadBalancerPolicies");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerPolicies");
        input.setAction("DeleteLoadBalancerPolicies");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteLoadBalancerPoliciesOutput.class);
        if (backModel != null) {
            return (DeleteLoadBalancerPoliciesOutput)backModel;
        }
        return null;
    }

    public void deleteLoadBalancerPolicies(DeleteLoadBalancerPoliciesInput input, ResponseCallBack<DeleteLoadBalancerPoliciesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerPoliciesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerPolicies");
        context.put("APIName", "DeleteLoadBalancerPolicies");
        context.put("ServiceName", "DeleteLoadBalancerPolicies");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerPolicies");
        input.setAction("DeleteLoadBalancerPolicies");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteLoadBalancerPolicyRulesOutput deleteLoadBalancerPolicyRules(DeleteLoadBalancerPolicyRulesInput input) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerPolicyRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerPolicyRules");
        context.put("APIName", "DeleteLoadBalancerPolicyRules");
        context.put("ServiceName", "DeleteLoadBalancerPolicyRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerPolicyRules");
        input.setAction("DeleteLoadBalancerPolicyRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteLoadBalancerPolicyRulesOutput.class);
        if (backModel != null) {
            return (DeleteLoadBalancerPolicyRulesOutput)backModel;
        }
        return null;
    }

    public void deleteLoadBalancerPolicyRules(DeleteLoadBalancerPolicyRulesInput input, ResponseCallBack<DeleteLoadBalancerPolicyRulesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancerPolicyRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancerPolicyRules");
        context.put("APIName", "DeleteLoadBalancerPolicyRules");
        context.put("ServiceName", "DeleteLoadBalancerPolicyRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancerPolicyRules");
        input.setAction("DeleteLoadBalancerPolicyRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteLoadBalancersOutput deleteLoadBalancers(DeleteLoadBalancersInput input) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancers");
        context.put("APIName", "DeleteLoadBalancers");
        context.put("ServiceName", "DeleteLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancers");
        input.setAction("DeleteLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteLoadBalancersOutput.class);
        if (backModel != null) {
            return (DeleteLoadBalancersOutput)backModel;
        }
        return null;
    }

    public void deleteLoadBalancers(DeleteLoadBalancersInput input, ResponseCallBack<DeleteLoadBalancersOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteLoadBalancers");
        context.put("APIName", "DeleteLoadBalancers");
        context.put("ServiceName", "DeleteLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteLoadBalancers");
        input.setAction("DeleteLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteServerCertificatesOutput deleteServerCertificates(DeleteServerCertificatesInput input) throws QCException {
        if (input == null) {
            input = new DeleteServerCertificatesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteServerCertificates");
        context.put("APIName", "DeleteServerCertificates");
        context.put("ServiceName", "DeleteServerCertificates");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteServerCertificates");
        input.setAction("DeleteServerCertificates");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteServerCertificatesOutput.class);
        if (backModel != null) {
            return (DeleteServerCertificatesOutput)backModel;
        }
        return null;
    }

    public void deleteServerCertificates(DeleteServerCertificatesInput input, ResponseCallBack<DeleteServerCertificatesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteServerCertificatesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteServerCertificates");
        context.put("APIName", "DeleteServerCertificates");
        context.put("ServiceName", "DeleteServerCertificates");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteServerCertificates");
        input.setAction("DeleteServerCertificates");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeLoadBalancerBackendsOutput describeLoadBalancerBackends(DescribeLoadBalancerBackendsInput input) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerBackendsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerBackends");
        context.put("APIName", "DescribeLoadBalancerBackends");
        context.put("ServiceName", "DescribeLoadBalancerBackends");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerBackends");
        input.setAction("DescribeLoadBalancerBackends");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeLoadBalancerBackendsOutput.class);
        if (backModel != null) {
            return (DescribeLoadBalancerBackendsOutput)backModel;
        }
        return null;
    }

    public void describeLoadBalancerBackends(DescribeLoadBalancerBackendsInput input, ResponseCallBack<DescribeLoadBalancerBackendsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerBackendsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerBackends");
        context.put("APIName", "DescribeLoadBalancerBackends");
        context.put("ServiceName", "DescribeLoadBalancerBackends");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerBackends");
        input.setAction("DescribeLoadBalancerBackends");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeLoadBalancerListenersOutput describeLoadBalancerListeners(DescribeLoadBalancerListenersInput input) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerListenersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerListeners");
        context.put("APIName", "DescribeLoadBalancerListeners");
        context.put("ServiceName", "DescribeLoadBalancerListeners");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerListeners");
        input.setAction("DescribeLoadBalancerListeners");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeLoadBalancerListenersOutput.class);
        if (backModel != null) {
            return (DescribeLoadBalancerListenersOutput)backModel;
        }
        return null;
    }

    public void describeLoadBalancerListeners(DescribeLoadBalancerListenersInput input, ResponseCallBack<DescribeLoadBalancerListenersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerListenersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerListeners");
        context.put("APIName", "DescribeLoadBalancerListeners");
        context.put("ServiceName", "DescribeLoadBalancerListeners");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerListeners");
        input.setAction("DescribeLoadBalancerListeners");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeLoadBalancerPoliciesOutput describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesInput input) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerPoliciesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerPolicies");
        context.put("APIName", "DescribeLoadBalancerPolicies");
        context.put("ServiceName", "DescribeLoadBalancerPolicies");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerPolicies");
        input.setAction("DescribeLoadBalancerPolicies");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeLoadBalancerPoliciesOutput.class);
        if (backModel != null) {
            return (DescribeLoadBalancerPoliciesOutput)backModel;
        }
        return null;
    }

    public void describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesInput input, ResponseCallBack<DescribeLoadBalancerPoliciesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerPoliciesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerPolicies");
        context.put("APIName", "DescribeLoadBalancerPolicies");
        context.put("ServiceName", "DescribeLoadBalancerPolicies");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerPolicies");
        input.setAction("DescribeLoadBalancerPolicies");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeLoadBalancerPolicyRulesOutput describeLoadBalancerPolicyRules(DescribeLoadBalancerPolicyRulesInput input) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerPolicyRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerPolicyRules");
        context.put("APIName", "DescribeLoadBalancerPolicyRules");
        context.put("ServiceName", "DescribeLoadBalancerPolicyRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerPolicyRules");
        input.setAction("DescribeLoadBalancerPolicyRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeLoadBalancerPolicyRulesOutput.class);
        if (backModel != null) {
            return (DescribeLoadBalancerPolicyRulesOutput)backModel;
        }
        return null;
    }

    public void describeLoadBalancerPolicyRules(DescribeLoadBalancerPolicyRulesInput input, ResponseCallBack<DescribeLoadBalancerPolicyRulesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancerPolicyRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancerPolicyRules");
        context.put("APIName", "DescribeLoadBalancerPolicyRules");
        context.put("ServiceName", "DescribeLoadBalancerPolicyRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancerPolicyRules");
        input.setAction("DescribeLoadBalancerPolicyRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeLoadBalancersOutput describeLoadBalancers(DescribeLoadBalancersInput input) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancers");
        context.put("APIName", "DescribeLoadBalancers");
        context.put("ServiceName", "DescribeLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancers");
        input.setAction("DescribeLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeLoadBalancersOutput.class);
        if (backModel != null) {
            return (DescribeLoadBalancersOutput)backModel;
        }
        return null;
    }

    public void describeLoadBalancers(DescribeLoadBalancersInput input, ResponseCallBack<DescribeLoadBalancersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeLoadBalancers");
        context.put("APIName", "DescribeLoadBalancers");
        context.put("ServiceName", "DescribeLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeLoadBalancers");
        input.setAction("DescribeLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeServerCertificatesOutput describeServerCertificates(DescribeServerCertificatesInput input) throws QCException {
        if (input == null) {
            input = new DescribeServerCertificatesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeServerCertificates");
        context.put("APIName", "DescribeServerCertificates");
        context.put("ServiceName", "DescribeServerCertificates");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeServerCertificates");
        input.setAction("DescribeServerCertificates");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeServerCertificatesOutput.class);
        if (backModel != null) {
            return (DescribeServerCertificatesOutput)backModel;
        }
        return null;
    }

    public void describeServerCertificates(DescribeServerCertificatesInput input, ResponseCallBack<DescribeServerCertificatesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeServerCertificatesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeServerCertificates");
        context.put("APIName", "DescribeServerCertificates");
        context.put("ServiceName", "DescribeServerCertificates");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeServerCertificates");
        input.setAction("DescribeServerCertificates");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DissociateEIPsFromLoadBalancerOutput dissociateEIPsFromLoadBalancer(DissociateEIPsFromLoadBalancerInput input) throws QCException {
        if (input == null) {
            input = new DissociateEIPsFromLoadBalancerInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DissociateEipsFromLoadBalancer");
        context.put("APIName", "DissociateEipsFromLoadBalancer");
        context.put("ServiceName", "DissociateEipsFromLoadBalancer");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DissociateEipsFromLoadBalancer");
        input.setAction("DissociateEipsFromLoadBalancer");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DissociateEIPsFromLoadBalancerOutput.class);
        if (backModel != null) {
            return (DissociateEIPsFromLoadBalancerOutput)backModel;
        }
        return null;
    }

    public void dissociateEIPsFromLoadBalancer(DissociateEIPsFromLoadBalancerInput input, ResponseCallBack<DissociateEIPsFromLoadBalancerOutput> callback) throws QCException {
        if (input == null) {
            input = new DissociateEIPsFromLoadBalancerInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DissociateEIPsFromLoadBalancer");
        context.put("APIName", "DissociateEIPsFromLoadBalancer");
        context.put("ServiceName", "DissociateEipsFromLoadBalancer");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DissociateEipsFromLoadBalancer");
        input.setAction("DissociateEIPsFromLoadBalancer");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetLoadBalancerMonitorOutput getLoadBalancerMonitor(GetLoadBalancerMonitorInput input) throws QCException {
        if (input == null) {
            input = new GetLoadBalancerMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetLoadBalancerMonitor");
        context.put("APIName", "GetLoadBalancerMonitor");
        context.put("ServiceName", "GetLoadBalancerMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetLoadBalancerMonitor");
        input.setAction("GetLoadBalancerMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetLoadBalancerMonitorOutput.class);
        if (backModel != null) {
            return (GetLoadBalancerMonitorOutput)backModel;
        }
        return null;
    }

    public void getLoadBalancerMonitor(GetLoadBalancerMonitorInput input, ResponseCallBack<GetLoadBalancerMonitorOutput> callback) throws QCException {
        if (input == null) {
            input = new GetLoadBalancerMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetLoadBalancerMonitor");
        context.put("APIName", "GetLoadBalancerMonitor");
        context.put("ServiceName", "GetLoadBalancerMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetLoadBalancerMonitor");
        input.setAction("GetLoadBalancerMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyLoadBalancerAttributesOutput modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerAttributes");
        context.put("APIName", "ModifyLoadBalancerAttributes");
        context.put("ServiceName", "ModifyLoadBalancerAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerAttributes");
        input.setAction("ModifyLoadBalancerAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyLoadBalancerAttributesOutput.class);
        if (backModel != null) {
            return (ModifyLoadBalancerAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesInput input, ResponseCallBack<ModifyLoadBalancerAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerAttributes");
        context.put("APIName", "ModifyLoadBalancerAttributes");
        context.put("ServiceName", "ModifyLoadBalancerAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerAttributes");
        input.setAction("ModifyLoadBalancerAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyLoadBalancerBackendAttributesOutput modifyLoadBalancerBackendAttributes(ModifyLoadBalancerBackendAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerBackendAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerBackendAttributes");
        context.put("APIName", "ModifyLoadBalancerBackendAttributes");
        context.put("ServiceName", "ModifyLoadBalancerBackendAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerBackendAttributes");
        input.setAction("ModifyLoadBalancerBackendAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyLoadBalancerBackendAttributesOutput.class);
        if (backModel != null) {
            return (ModifyLoadBalancerBackendAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyLoadBalancerBackendAttributes(ModifyLoadBalancerBackendAttributesInput input, ResponseCallBack<ModifyLoadBalancerBackendAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerBackendAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerBackendAttributes");
        context.put("APIName", "ModifyLoadBalancerBackendAttributes");
        context.put("ServiceName", "ModifyLoadBalancerBackendAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerBackendAttributes");
        input.setAction("ModifyLoadBalancerBackendAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyLoadBalancerListenerAttributesOutput modifyLoadBalancerListenerAttributes(ModifyLoadBalancerListenerAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerListenerAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerListenerAttributes");
        context.put("APIName", "ModifyLoadBalancerListenerAttributes");
        context.put("ServiceName", "ModifyLoadBalancerListenerAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerListenerAttributes");
        input.setAction("ModifyLoadBalancerListenerAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyLoadBalancerListenerAttributesOutput.class);
        if (backModel != null) {
            return (ModifyLoadBalancerListenerAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyLoadBalancerListenerAttributes(ModifyLoadBalancerListenerAttributesInput input, ResponseCallBack<ModifyLoadBalancerListenerAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerListenerAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerListenerAttributes");
        context.put("APIName", "ModifyLoadBalancerListenerAttributes");
        context.put("ServiceName", "ModifyLoadBalancerListenerAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerListenerAttributes");
        input.setAction("ModifyLoadBalancerListenerAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyLoadBalancerPolicyAttributesOutput modifyLoadBalancerPolicyAttributes(ModifyLoadBalancerPolicyAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerPolicyAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerPolicyAttributes");
        context.put("APIName", "ModifyLoadBalancerPolicyAttributes");
        context.put("ServiceName", "ModifyLoadBalancerPolicyAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerPolicyAttributes");
        input.setAction("ModifyLoadBalancerPolicyAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyLoadBalancerPolicyAttributesOutput.class);
        if (backModel != null) {
            return (ModifyLoadBalancerPolicyAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyLoadBalancerPolicyAttributes(ModifyLoadBalancerPolicyAttributesInput input, ResponseCallBack<ModifyLoadBalancerPolicyAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerPolicyAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerPolicyAttributes");
        context.put("APIName", "ModifyLoadBalancerPolicyAttributes");
        context.put("ServiceName", "ModifyLoadBalancerPolicyAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerPolicyAttributes");
        input.setAction("ModifyLoadBalancerPolicyAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyLoadBalancerPolicyRuleAttributesOutput modifyLoadBalancerPolicyRuleAttributes(ModifyLoadBalancerPolicyRuleAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerPolicyRuleAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerPolicyRuleAttributes");
        context.put("APIName", "ModifyLoadBalancerPolicyRuleAttributes");
        context.put("ServiceName", "ModifyLoadBalancerPolicyRuleAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerPolicyRuleAttributes");
        input.setAction("ModifyLoadBalancerPolicyRuleAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyLoadBalancerPolicyRuleAttributesOutput.class);
        if (backModel != null) {
            return (ModifyLoadBalancerPolicyRuleAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyLoadBalancerPolicyRuleAttributes(ModifyLoadBalancerPolicyRuleAttributesInput input, ResponseCallBack<ModifyLoadBalancerPolicyRuleAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyLoadBalancerPolicyRuleAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyLoadBalancerPolicyRuleAttributes");
        context.put("APIName", "ModifyLoadBalancerPolicyRuleAttributes");
        context.put("ServiceName", "ModifyLoadBalancerPolicyRuleAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyLoadBalancerPolicyRuleAttributes");
        input.setAction("ModifyLoadBalancerPolicyRuleAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyServerCertificateAttributesOutput modifyServerCertificateAttributes(ModifyServerCertificateAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyServerCertificateAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyServerCertificateAttributes");
        context.put("APIName", "ModifyServerCertificateAttributes");
        context.put("ServiceName", "ModifyServerCertificateAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyServerCertificateAttributes");
        input.setAction("ModifyServerCertificateAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyServerCertificateAttributesOutput.class);
        if (backModel != null) {
            return (ModifyServerCertificateAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyServerCertificateAttributes(ModifyServerCertificateAttributesInput input, ResponseCallBack<ModifyServerCertificateAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyServerCertificateAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyServerCertificateAttributes");
        context.put("APIName", "ModifyServerCertificateAttributes");
        context.put("ServiceName", "ModifyServerCertificateAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyServerCertificateAttributes");
        input.setAction("ModifyServerCertificateAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResizeLoadBalancersOutput resizeLoadBalancers(ResizeLoadBalancersInput input) throws QCException {
        if (input == null) {
            input = new ResizeLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeLoadBalancers");
        context.put("APIName", "ResizeLoadBalancers");
        context.put("ServiceName", "ResizeLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeLoadBalancers");
        input.setAction("ResizeLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResizeLoadBalancersOutput.class);
        if (backModel != null) {
            return (ResizeLoadBalancersOutput)backModel;
        }
        return null;
    }

    public void resizeLoadBalancers(ResizeLoadBalancersInput input, ResponseCallBack<ResizeLoadBalancersOutput> callback) throws QCException {
        if (input == null) {
            input = new ResizeLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeLoadBalancers");
        context.put("APIName", "ResizeLoadBalancers");
        context.put("ServiceName", "ResizeLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeLoadBalancers");
        input.setAction("ResizeLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StartLoadBalancersOutput startLoadBalancers(StartLoadBalancersInput input) throws QCException {
        if (input == null) {
            input = new StartLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartLoadBalancers");
        context.put("APIName", "StartLoadBalancers");
        context.put("ServiceName", "StartLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartLoadBalancers");
        input.setAction("StartLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StartLoadBalancersOutput.class);
        if (backModel != null) {
            return (StartLoadBalancersOutput)backModel;
        }
        return null;
    }

    public void startLoadBalancers(StartLoadBalancersInput input, ResponseCallBack<StartLoadBalancersOutput> callback) throws QCException {
        if (input == null) {
            input = new StartLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartLoadBalancers");
        context.put("APIName", "StartLoadBalancers");
        context.put("ServiceName", "StartLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartLoadBalancers");
        input.setAction("StartLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StopLoadBalancersOutput stopLoadBalancers(StopLoadBalancersInput input) throws QCException {
        if (input == null) {
            input = new StopLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopLoadBalancers");
        context.put("APIName", "StopLoadBalancers");
        context.put("ServiceName", "StopLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopLoadBalancers");
        input.setAction("StopLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StopLoadBalancersOutput.class);
        if (backModel != null) {
            return (StopLoadBalancersOutput)backModel;
        }
        return null;
    }

    public void stopLoadBalancers(StopLoadBalancersInput input, ResponseCallBack<StopLoadBalancersOutput> callback) throws QCException {
        if (input == null) {
            input = new StopLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopLoadBalancers");
        context.put("APIName", "StopLoadBalancers");
        context.put("ServiceName", "StopLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopLoadBalancers");
        input.setAction("StopLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public UpdateLoadBalancersOutput updateLoadBalancers(UpdateLoadBalancersInput input) throws QCException {
        if (input == null) {
            input = new UpdateLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateLoadBalancers");
        context.put("APIName", "UpdateLoadBalancers");
        context.put("ServiceName", "UpdateLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateLoadBalancers");
        input.setAction("UpdateLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, UpdateLoadBalancersOutput.class);
        if (backModel != null) {
            return (UpdateLoadBalancersOutput)backModel;
        }
        return null;
    }

    public void updateLoadBalancers(UpdateLoadBalancersInput input, ResponseCallBack<UpdateLoadBalancersOutput> callback) throws QCException {
        if (input == null) {
            input = new UpdateLoadBalancersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateLoadBalancers");
        context.put("APIName", "UpdateLoadBalancers");
        context.put("ServiceName", "UpdateLoadBalancers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateLoadBalancers");
        input.setAction("UpdateLoadBalancers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UpdateLoadBalancersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class UpdateLoadBalancersInput
    extends IaasParamBody {
        private List<String> loadBalancers;

        @JsonProperty(value="loadbalancers")
        public void setLoadBalancers(List<String> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        @JsonProperty(value="loadbalancers")
        public List<String> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopLoadBalancersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StopLoadBalancersInput
    extends IaasParamBody {
        private List<String> loadBalancers;

        @JsonProperty(value="loadbalancers")
        public void setLoadBalancers(List<String> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        @JsonProperty(value="loadbalancers")
        public List<String> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StartLoadBalancersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StartLoadBalancersInput
    extends IaasParamBody {
        private List<String> loadBalancers;

        @JsonProperty(value="loadbalancers")
        public void setLoadBalancers(List<String> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        @JsonProperty(value="loadbalancers")
        public List<String> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResizeLoadBalancersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ResizeLoadBalancersInput
    extends IaasParamBody {
        private Integer loadBalancerType;
        private List<String> loadBalancers;

        @JsonProperty(value="loadbalancer_type")
        public void setLoadBalancerType(Integer loadBalancerType) {
            this.loadBalancerType = loadBalancerType;
        }

        @JsonProperty(value="loadbalancer_type")
        public Integer getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @JsonProperty(value="loadbalancers")
        public void setLoadBalancers(List<String> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        @JsonProperty(value="loadbalancers")
        public List<String> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public String validateParam() throws QCException {
            String[] loadBalancerTypeValidValues = new String[]{"0", "1", "2", "3", "4", "5"};
            boolean loadBalancerTypeIsValid = false;
            for (String v : loadBalancerTypeValidValues) {
                Boolean loadBalancerTypeIsRequired;
                if (v.equals(this.getLoadBalancerType() + "")) {
                    loadBalancerTypeIsValid = true;
                }
                if (!(loadBalancerTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getLoadBalancerType() != null) continue;
                loadBalancerTypeIsValid = true;
            }
            if (!loadBalancerTypeIsValid) {
                throw new QCException("LoadBalancerType value " + this.getLoadBalancerType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyServerCertificateAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyServerCertificateAttributesInput
    extends IaasParamBody {
        private String description;
        private String serverCertificate;
        private String serverCertificateName;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="server_certificate")
        public void setServerCertificate(String serverCertificate) {
            this.serverCertificate = serverCertificate;
        }

        @JsonProperty(value="server_certificate")
        public String getServerCertificate() {
            return this.serverCertificate;
        }

        @JsonProperty(value="server_certificate_name")
        public void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        @JsonProperty(value="server_certificate_name")
        public String getServerCertificateName() {
            return this.serverCertificateName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getServerCertificate())) {
                throw new QCException("ServerCertificate is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyLoadBalancerPolicyRuleAttributesOutput
    extends OutputModel {
        private String action;
        private String loadBalancerPolicyRuleID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policy_rule_id")
        public void setLoadBalancerPolicyRuleID(String loadBalancerPolicyRuleID) {
            this.loadBalancerPolicyRuleID = loadBalancerPolicyRuleID;
        }

        @JsonProperty(value="loadbalancer_policy_rule_id")
        public String getLoadBalancerPolicyRuleID() {
            return this.loadBalancerPolicyRuleID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyLoadBalancerPolicyRuleAttributesInput
    extends IaasParamBody {
        private String loadBalancerPolicyRule;
        private String loadBalancerPolicyRuleName;
        private String val;

        @JsonProperty(value="loadbalancer_policy_rule")
        public void setLoadBalancerPolicyRule(String loadBalancerPolicyRule) {
            this.loadBalancerPolicyRule = loadBalancerPolicyRule;
        }

        @JsonProperty(value="loadbalancer_policy_rule")
        public String getLoadBalancerPolicyRule() {
            return this.loadBalancerPolicyRule;
        }

        @JsonProperty(value="loadbalancer_policy_rule_name")
        public void setLoadBalancerPolicyRuleName(String loadBalancerPolicyRuleName) {
            this.loadBalancerPolicyRuleName = loadBalancerPolicyRuleName;
        }

        @JsonProperty(value="loadbalancer_policy_rule_name")
        public String getLoadBalancerPolicyRuleName() {
            return this.loadBalancerPolicyRuleName;
        }

        @JsonProperty(value="val")
        public void setVal(String val) {
            this.val = val;
        }

        @JsonProperty(value="val")
        public String getVal() {
            return this.val;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancerPolicyRule())) {
                throw new QCException("LoadBalancerPolicyRule is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyLoadBalancerPolicyAttributesOutput
    extends OutputModel {
        private String action;
        private String loadBalancerPolicyID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public void setLoadBalancerPolicyID(String loadBalancerPolicyID) {
            this.loadBalancerPolicyID = loadBalancerPolicyID;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public String getLoadBalancerPolicyID() {
            return this.loadBalancerPolicyID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyLoadBalancerPolicyAttributesInput
    extends IaasParamBody {
        private String loadBalancerPolicy;
        private String loadBalancerPolicyName;
        private String operator;

        @JsonProperty(value="loadbalancer_policy")
        public void setLoadBalancerPolicy(String loadBalancerPolicy) {
            this.loadBalancerPolicy = loadBalancerPolicy;
        }

        @JsonProperty(value="loadbalancer_policy")
        public String getLoadBalancerPolicy() {
            return this.loadBalancerPolicy;
        }

        @JsonProperty(value="loadbalancer_policy_name")
        public void setLoadBalancerPolicyName(String loadBalancerPolicyName) {
            this.loadBalancerPolicyName = loadBalancerPolicyName;
        }

        @JsonProperty(value="loadbalancer_policy_name")
        public String getLoadBalancerPolicyName() {
            return this.loadBalancerPolicyName;
        }

        @JsonProperty(value="operator")
        public void setOperator(String operator) {
            this.operator = operator;
        }

        @JsonProperty(value="operator")
        public String getOperator() {
            return this.operator;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancerPolicy())) {
                throw new QCException("LoadBalancerPolicy is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyLoadBalancerListenerAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyLoadBalancerListenerAttributesInput
    extends IaasParamBody {
        private String balanceMode;
        private Integer forwardfor;
        private String healthyCheckMethod;
        private String healthyCheckOption;
        private Integer listenerOption;
        private String loadBalancerListener;
        private String loadBalancerListenerName;
        private List<String> serverCertificateID;
        private String sessionSticky;
        private Integer timeout;

        @JsonProperty(value="balance_mode")
        public void setBalanceMode(String balanceMode) {
            this.balanceMode = balanceMode;
        }

        @JsonProperty(value="balance_mode")
        public String getBalanceMode() {
            return this.balanceMode;
        }

        @JsonProperty(value="forwardfor")
        public void setForwardfor(Integer forwardfor) {
            this.forwardfor = forwardfor;
        }

        @JsonProperty(value="forwardfor")
        public Integer getForwardfor() {
            return this.forwardfor;
        }

        @JsonProperty(value="healthy_check_method")
        public void setHealthyCheckMethod(String healthyCheckMethod) {
            this.healthyCheckMethod = healthyCheckMethod;
        }

        @JsonProperty(value="healthy_check_method")
        public String getHealthyCheckMethod() {
            return this.healthyCheckMethod;
        }

        @JsonProperty(value="healthy_check_option")
        public void setHealthyCheckOption(String healthyCheckOption) {
            this.healthyCheckOption = healthyCheckOption;
        }

        @JsonProperty(value="healthy_check_option")
        public String getHealthyCheckOption() {
            return this.healthyCheckOption;
        }

        @JsonProperty(value="listener_option")
        public void setListenerOption(Integer listenerOption) {
            this.listenerOption = listenerOption;
        }

        @JsonProperty(value="listener_option")
        public Integer getListenerOption() {
            return this.listenerOption;
        }

        @JsonProperty(value="loadbalancer_listener")
        public void setLoadBalancerListener(String loadBalancerListener) {
            this.loadBalancerListener = loadBalancerListener;
        }

        @JsonProperty(value="loadbalancer_listener")
        public String getLoadBalancerListener() {
            return this.loadBalancerListener;
        }

        @JsonProperty(value="loadbalancer_listener_name")
        public void setLoadBalancerListenerName(String loadBalancerListenerName) {
            this.loadBalancerListenerName = loadBalancerListenerName;
        }

        @JsonProperty(value="loadbalancer_listener_name")
        public String getLoadBalancerListenerName() {
            return this.loadBalancerListenerName;
        }

        @JsonProperty(value="server_certificate_id")
        public void setServerCertificateID(List<String> serverCertificateID) {
            this.serverCertificateID = serverCertificateID;
        }

        @JsonProperty(value="server_certificate_id")
        public List<String> getServerCertificateID() {
            return this.serverCertificateID;
        }

        @JsonProperty(value="session_sticky")
        public void setSessionSticky(String sessionSticky) {
            this.sessionSticky = sessionSticky;
        }

        @JsonProperty(value="session_sticky")
        public String getSessionSticky() {
            return this.sessionSticky;
        }

        @JsonProperty(value="timeout")
        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @JsonProperty(value="timeout")
        public Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancerListener())) {
                throw new QCException("LoadBalancerListener is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyLoadBalancerBackendAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyLoadBalancerBackendAttributesInput
    extends IaasParamBody {
        private Integer disabled;
        private String loadBalancerBackend;
        private String loadBalancerBackendName;
        private String loadBalancerPolicyID;
        private Integer port;
        private Integer weight;

        @JsonProperty(value="disabled")
        public void setDisabled(Integer disabled) {
            this.disabled = disabled;
        }

        @JsonProperty(value="disabled")
        public Integer getDisabled() {
            return this.disabled;
        }

        @JsonProperty(value="loadbalancer_backend")
        public void setLoadBalancerBackend(String loadBalancerBackend) {
            this.loadBalancerBackend = loadBalancerBackend;
        }

        @JsonProperty(value="loadbalancer_backend")
        public String getLoadBalancerBackend() {
            return this.loadBalancerBackend;
        }

        @JsonProperty(value="loadbalancer_backend_name")
        public void setLoadBalancerBackendName(String loadBalancerBackendName) {
            this.loadBalancerBackendName = loadBalancerBackendName;
        }

        @JsonProperty(value="loadbalancer_backend_name")
        public String getLoadBalancerBackendName() {
            return this.loadBalancerBackendName;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public void setLoadBalancerPolicyID(String loadBalancerPolicyID) {
            this.loadBalancerPolicyID = loadBalancerPolicyID;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public String getLoadBalancerPolicyID() {
            return this.loadBalancerPolicyID;
        }

        @JsonProperty(value="port")
        public void setPort(Integer port) {
            this.port = port;
        }

        @JsonProperty(value="port")
        public Integer getPort() {
            return this.port;
        }

        @JsonProperty(value="weight")
        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        @JsonProperty(value="weight")
        public Integer getWeight() {
            return this.weight;
        }

        @Override
        public String validateParam() throws QCException {
            String[] disabledValidValues = new String[]{"0", "1"};
            boolean disabledIsValid = false;
            for (String v : disabledValidValues) {
                Boolean disabledIsRequired;
                if (v.equals(this.getDisabled() + "")) {
                    disabledIsValid = true;
                }
                if (!(disabledIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getDisabled() != null) continue;
                disabledIsValid = true;
            }
            if (!disabledIsValid) {
                throw new QCException("Disabled value " + this.getDisabled() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyLoadBalancerAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyLoadBalancerAttributesInput
    extends IaasParamBody {
        private String description;
        private Integer hTTPHeaderSize;
        private String loadBalancer;
        private String loadBalancerName;
        private Integer nodeCount;
        private String privateIP;
        private String securityGroup;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="http_header_size")
        public void setHTTPHeaderSize(Integer hTTPHeaderSize) {
            this.hTTPHeaderSize = hTTPHeaderSize;
        }

        @JsonProperty(value="http_header_size")
        public Integer getHTTPHeaderSize() {
            return this.hTTPHeaderSize;
        }

        @JsonProperty(value="loadbalancer")
        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        @JsonProperty(value="loadbalancer")
        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        @JsonProperty(value="loadbalancer_name")
        public void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @JsonProperty(value="loadbalancer_name")
        public String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancer())) {
                throw new QCException("LoadBalancer is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetLoadBalancerMonitorOutput
    extends OutputModel {
        private String action;
        private List<Types.MeterModel> meterSet;
        private String resourceID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="meter_set")
        public void setMeterSet(List<Types.MeterModel> meterSet) {
            this.meterSet = meterSet;
        }

        @JsonProperty(value="meter_set")
        public List<Types.MeterModel> getMeterSet() {
            return this.meterSet;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetLoadBalancerMonitorInput
    extends IaasParamBody {
        private String endTime;
        private List<String> meters;
        private String resource;
        private String resourceType;
        private String startTime;
        private String step;

        @JsonProperty(value="end_time")
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="end_time")
        public String getEndTime() {
            return this.endTime;
        }

        @JsonProperty(value="meters")
        public void setMeters(List<String> meters) {
            this.meters = meters;
        }

        @JsonProperty(value="meters")
        public List<String> getMeters() {
            return this.meters;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public String getResource() {
            return this.resource;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @JsonProperty(value="start_time")
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @JsonProperty(value="start_time")
        public String getStartTime() {
            return this.startTime;
        }

        @JsonProperty(value="step")
        public void setStep(String step) {
            this.step = step;
        }

        @JsonProperty(value="step")
        public String getStep() {
            return this.step;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getResource())) {
                throw new QCException("Resource is required");
            }
            if (QCStringUtil.isEmpty(this.getStep())) {
                throw new QCException("Step is required");
            }
            String[] stepValidValues = new String[]{"5m", "15m", "2h", "1d"};
            boolean stepIsValid = false;
            for (String v : stepValidValues) {
                Boolean stepIsRequired;
                if (v.equals(this.getStep())) {
                    stepIsValid = true;
                }
                if (!(stepIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getStep() != null) continue;
                stepIsValid = true;
            }
            if (!stepIsValid) {
                throw new QCException("Step value " + this.getStep() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DissociateEIPsFromLoadBalancerOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DissociateEIPsFromLoadBalancerInput
    extends IaasParamBody {
        private List<String> eIPs;
        private String loadBalancer;

        @JsonProperty(value="eips")
        public void setEIPs(List<String> eIPs) {
            this.eIPs = eIPs;
        }

        @JsonProperty(value="eips")
        public List<String> getEIPs() {
            return this.eIPs;
        }

        @JsonProperty(value="loadbalancer")
        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        @JsonProperty(value="loadbalancer")
        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancer())) {
                throw new QCException("LoadBalancer is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeServerCertificatesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.ServerCertificateModel> serverCertificateSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="server_certificate_set")
        public void setServerCertificateSet(List<Types.ServerCertificateModel> serverCertificateSet) {
            this.serverCertificateSet = serverCertificateSet;
        }

        @JsonProperty(value="server_certificate_set")
        public List<Types.ServerCertificateModel> getServerCertificateSet() {
            return this.serverCertificateSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeServerCertificatesInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String owner;
        private String searchWord;
        private List<String> serverCertificates;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="server_certificates")
        public void setServerCertificates(List<String> serverCertificates) {
            this.serverCertificates = serverCertificates;
        }

        @JsonProperty(value="server_certificates")
        public List<String> getServerCertificates() {
            return this.serverCertificates;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeLoadBalancersOutput
    extends OutputModel {
        private String action;
        private List<Types.LoadBalancerModel> loadBalancerSet;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_set")
        public void setLoadBalancerSet(List<Types.LoadBalancerModel> loadBalancerSet) {
            this.loadBalancerSet = loadBalancerSet;
        }

        @JsonProperty(value="loadbalancer_set")
        public List<Types.LoadBalancerModel> getLoadBalancerSet() {
            return this.loadBalancerSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeLoadBalancersInput
    extends IaasParamBody {
        private Integer limit;
        private List<String> loadBalancers;
        private Integer offset;
        private String owner;
        private String searchWord;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="loadbalancers")
        public void setLoadBalancers(List<String> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        @JsonProperty(value="loadbalancers")
        public List<String> getLoadBalancers() {
            return this.loadBalancers;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeLoadBalancerPolicyRulesOutput
    extends OutputModel {
        private String action;
        private List<Types.LoadBalancerPolicyRuleModel> loadBalancerPolicyRuleSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policy_rule_set")
        public void setLoadBalancerPolicyRuleSet(List<Types.LoadBalancerPolicyRuleModel> loadBalancerPolicyRuleSet) {
            this.loadBalancerPolicyRuleSet = loadBalancerPolicyRuleSet;
        }

        @JsonProperty(value="loadbalancer_policy_rule_set")
        public List<Types.LoadBalancerPolicyRuleModel> getLoadBalancerPolicyRuleSet() {
            return this.loadBalancerPolicyRuleSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeLoadBalancerPolicyRulesInput
    extends IaasParamBody {
        private Integer limit;
        private String loadBalancerPolicy;
        private List<String> loadBalancerPolicyRules;
        private Integer offset;
        private String owner;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="loadbalancer_policy")
        public void setLoadBalancerPolicy(String loadBalancerPolicy) {
            this.loadBalancerPolicy = loadBalancerPolicy;
        }

        @JsonProperty(value="loadbalancer_policy")
        public String getLoadBalancerPolicy() {
            return this.loadBalancerPolicy;
        }

        @JsonProperty(value="loadbalancer_policy_rules")
        public void setLoadBalancerPolicyRules(List<String> loadBalancerPolicyRules) {
            this.loadBalancerPolicyRules = loadBalancerPolicyRules;
        }

        @JsonProperty(value="loadbalancer_policy_rules")
        public List<String> getLoadBalancerPolicyRules() {
            return this.loadBalancerPolicyRules;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeLoadBalancerPoliciesOutput
    extends OutputModel {
        private String action;
        private List<Types.LoadBalancerPolicyModel> loadBalancerPolicySet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policy_set")
        public void setLoadBalancerPolicySet(List<Types.LoadBalancerPolicyModel> loadBalancerPolicySet) {
            this.loadBalancerPolicySet = loadBalancerPolicySet;
        }

        @JsonProperty(value="loadbalancer_policy_set")
        public List<Types.LoadBalancerPolicyModel> getLoadBalancerPolicySet() {
            return this.loadBalancerPolicySet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeLoadBalancerPoliciesInput
    extends IaasParamBody {
        private Integer limit;
        private List<String> loadBalancerPolicies;
        private Integer offset;
        private String owner;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="loadbalancer_policies")
        public void setLoadBalancerPolicies(List<String> loadBalancerPolicies) {
            this.loadBalancerPolicies = loadBalancerPolicies;
        }

        @JsonProperty(value="loadbalancer_policies")
        public List<String> getLoadBalancerPolicies() {
            return this.loadBalancerPolicies;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeLoadBalancerListenersOutput
    extends OutputModel {
        private String action;
        private List<Types.LoadBalancerListenerModel> loadBalancerListenerSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_listener_set")
        public void setLoadBalancerListenerSet(List<Types.LoadBalancerListenerModel> loadBalancerListenerSet) {
            this.loadBalancerListenerSet = loadBalancerListenerSet;
        }

        @JsonProperty(value="loadbalancer_listener_set")
        public List<Types.LoadBalancerListenerModel> getLoadBalancerListenerSet() {
            return this.loadBalancerListenerSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeLoadBalancerListenersInput
    extends IaasParamBody {
        private Integer limit;
        private String loadBalancer;
        private List<String> loadBalancerListeners;
        private Integer offset;
        private String owner;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="loadbalancer")
        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        @JsonProperty(value="loadbalancer")
        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        @JsonProperty(value="loadbalancer_listeners")
        public void setLoadBalancerListeners(List<String> loadBalancerListeners) {
            this.loadBalancerListeners = loadBalancerListeners;
        }

        @JsonProperty(value="loadbalancer_listeners")
        public List<String> getLoadBalancerListeners() {
            return this.loadBalancerListeners;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeLoadBalancerBackendsOutput
    extends OutputModel {
        private String action;
        private List<Types.LoadBalancerBackendModel> loadBalancerBackendSet;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_backend_set")
        public void setLoadBalancerBackendSet(List<Types.LoadBalancerBackendModel> loadBalancerBackendSet) {
            this.loadBalancerBackendSet = loadBalancerBackendSet;
        }

        @JsonProperty(value="loadbalancer_backend_set")
        public List<Types.LoadBalancerBackendModel> getLoadBalancerBackendSet() {
            return this.loadBalancerBackendSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeLoadBalancerBackendsInput
    extends IaasParamBody {
        private Integer limit;
        private String loadBalancer;
        private List<String> loadBalancerBackends;
        private String loadBalancerListener;
        private Integer offset;
        private String owner;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="loadbalancer")
        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        @JsonProperty(value="loadbalancer")
        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        @JsonProperty(value="loadbalancer_backends")
        public void setLoadBalancerBackends(List<String> loadBalancerBackends) {
            this.loadBalancerBackends = loadBalancerBackends;
        }

        @JsonProperty(value="loadbalancer_backends")
        public List<String> getLoadBalancerBackends() {
            return this.loadBalancerBackends;
        }

        @JsonProperty(value="loadbalancer_listener")
        public void setLoadBalancerListener(String loadBalancerListener) {
            this.loadBalancerListener = loadBalancerListener;
        }

        @JsonProperty(value="loadbalancer_listener")
        public String getLoadBalancerListener() {
            return this.loadBalancerListener;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteServerCertificatesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> serverCertificates;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="server_certificates")
        public void setServerCertificates(List<String> serverCertificates) {
            this.serverCertificates = serverCertificates;
        }

        @JsonProperty(value="server_certificates")
        public List<String> getServerCertificates() {
            return this.serverCertificates;
        }
    }

    public static class DeleteServerCertificatesInput
    extends IaasParamBody {
        private List<String> serverCertificates;

        @JsonProperty(value="server_certificates")
        public void setServerCertificates(List<String> serverCertificates) {
            this.serverCertificates = serverCertificates;
        }

        @JsonProperty(value="server_certificates")
        public List<String> getServerCertificates() {
            return this.serverCertificates;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteLoadBalancersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> loadBalancers;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="loadbalancers")
        public void setLoadBalancers(List<String> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        @JsonProperty(value="loadbalancers")
        public List<String> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteLoadBalancersInput
    extends IaasParamBody {
        private List<String> loadBalancers;

        @JsonProperty(value="loadbalancers")
        public void setLoadBalancers(List<String> loadBalancers) {
            this.loadBalancers = loadBalancers;
        }

        @JsonProperty(value="loadbalancers")
        public List<String> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteLoadBalancerPolicyRulesOutput
    extends OutputModel {
        private String action;
        private List<String> loadBalancerPolicyRules;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policy_rules")
        public void setLoadBalancerPolicyRules(List<String> loadBalancerPolicyRules) {
            this.loadBalancerPolicyRules = loadBalancerPolicyRules;
        }

        @JsonProperty(value="loadbalancer_policy_rules")
        public List<String> getLoadBalancerPolicyRules() {
            return this.loadBalancerPolicyRules;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteLoadBalancerPolicyRulesInput
    extends IaasParamBody {
        private List<String> loadBalancerPolicyRules;

        @JsonProperty(value="loadbalancer_policy_rules")
        public void setLoadBalancerPolicyRules(List<String> loadBalancerPolicyRules) {
            this.loadBalancerPolicyRules = loadBalancerPolicyRules;
        }

        @JsonProperty(value="loadbalancer_policy_rules")
        public List<String> getLoadBalancerPolicyRules() {
            return this.loadBalancerPolicyRules;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteLoadBalancerPoliciesOutput
    extends OutputModel {
        private String action;
        private List<String> loadBalancerPolicies;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policies")
        public void setLoadBalancerPolicies(List<String> loadBalancerPolicies) {
            this.loadBalancerPolicies = loadBalancerPolicies;
        }

        @JsonProperty(value="loadbalancer_policies")
        public List<String> getLoadBalancerPolicies() {
            return this.loadBalancerPolicies;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteLoadBalancerPoliciesInput
    extends IaasParamBody {
        private List<String> loadBalancerPolicies;

        @JsonProperty(value="loadbalancer_policies")
        public void setLoadBalancerPolicies(List<String> loadBalancerPolicies) {
            this.loadBalancerPolicies = loadBalancerPolicies;
        }

        @JsonProperty(value="loadbalancer_policies")
        public List<String> getLoadBalancerPolicies() {
            return this.loadBalancerPolicies;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteLoadBalancerListenersOutput
    extends OutputModel {
        private String action;
        private List<String> loadBalancerListeners;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_listeners")
        public void setLoadBalancerListeners(List<String> loadBalancerListeners) {
            this.loadBalancerListeners = loadBalancerListeners;
        }

        @JsonProperty(value="loadbalancer_listeners")
        public List<String> getLoadBalancerListeners() {
            return this.loadBalancerListeners;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteLoadBalancerListenersInput
    extends IaasParamBody {
        private List<String> loadBalancerListeners;

        @JsonProperty(value="loadbalancer_listeners")
        public void setLoadBalancerListeners(List<String> loadBalancerListeners) {
            this.loadBalancerListeners = loadBalancerListeners;
        }

        @JsonProperty(value="loadbalancer_listeners")
        public List<String> getLoadBalancerListeners() {
            return this.loadBalancerListeners;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteLoadBalancerBackendsOutput
    extends OutputModel {
        private String action;
        private List<String> loadBalancerBackends;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_backends")
        public void setLoadBalancerBackends(List<String> loadBalancerBackends) {
            this.loadBalancerBackends = loadBalancerBackends;
        }

        @JsonProperty(value="loadbalancer_backends")
        public List<String> getLoadBalancerBackends() {
            return this.loadBalancerBackends;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteLoadBalancerBackendsInput
    extends IaasParamBody {
        private List<String> loadBalancerBackends;

        @JsonProperty(value="loadbalancer_backends")
        public void setLoadBalancerBackends(List<String> loadBalancerBackends) {
            this.loadBalancerBackends = loadBalancerBackends;
        }

        @JsonProperty(value="loadbalancer_backends")
        public List<String> getLoadBalancerBackends() {
            return this.loadBalancerBackends;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateServerCertificateOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String serverCertificateID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="server_certificate_id")
        public void setServerCertificateID(String serverCertificateID) {
            this.serverCertificateID = serverCertificateID;
        }

        @JsonProperty(value="server_certificate_id")
        public String getServerCertificateID() {
            return this.serverCertificateID;
        }
    }

    public static class CreateServerCertificateInput
    extends IaasParamBody {
        private String certificateContent;
        private String privateKey;
        private String serverCertificateName;

        @JsonProperty(value="certificate_content")
        public void setCertificateContent(String certificateContent) {
            this.certificateContent = certificateContent;
        }

        @JsonProperty(value="certificate_content")
        public String getCertificateContent() {
            return this.certificateContent;
        }

        @JsonProperty(value="private_key")
        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @JsonProperty(value="private_key")
        public String getPrivateKey() {
            return this.privateKey;
        }

        @JsonProperty(value="server_certificate_name")
        public void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        @JsonProperty(value="server_certificate_name")
        public String getServerCertificateName() {
            return this.serverCertificateName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCertificateContent())) {
                throw new QCException("CertificateContent is required");
            }
            if (QCStringUtil.isEmpty(this.getPrivateKey())) {
                throw new QCException("PrivateKey is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateLoadBalancerPolicyOutput
    extends OutputModel {
        private String action;
        private String loadBalancerPolicyID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public void setLoadBalancerPolicyID(String loadBalancerPolicyID) {
            this.loadBalancerPolicyID = loadBalancerPolicyID;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public String getLoadBalancerPolicyID() {
            return this.loadBalancerPolicyID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateLoadBalancerPolicyInput
    extends IaasParamBody {
        private String loadBalancerPolicyName;
        private String operator;

        @JsonProperty(value="loadbalancer_policy_name")
        public void setLoadBalancerPolicyName(String loadBalancerPolicyName) {
            this.loadBalancerPolicyName = loadBalancerPolicyName;
        }

        @JsonProperty(value="loadbalancer_policy_name")
        public String getLoadBalancerPolicyName() {
            return this.loadBalancerPolicyName;
        }

        @JsonProperty(value="operator")
        public void setOperator(String operator) {
            this.operator = operator;
        }

        @JsonProperty(value="operator")
        public String getOperator() {
            return this.operator;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancerPolicyName())) {
                throw new QCException("LoadBalancerPolicyName is required");
            }
            String[] operatorValidValues = new String[]{"or", "and"};
            boolean operatorIsValid = false;
            for (String v : operatorValidValues) {
                Boolean operatorIsRequired;
                if (v.equals(this.getOperator())) {
                    operatorIsValid = true;
                }
                if (!(operatorIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getOperator() != null) continue;
                operatorIsValid = true;
            }
            if (!operatorIsValid) {
                throw new QCException("Operator value " + this.getOperator() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateLoadBalancerOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String loadBalancerID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="loadbalancer_id")
        public void setLoadBalancerID(String loadBalancerID) {
            this.loadBalancerID = loadBalancerID;
        }

        @JsonProperty(value="loadbalancer_id")
        public String getLoadBalancerID() {
            return this.loadBalancerID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateLoadBalancerInput
    extends IaasParamBody {
        private List<String> eIPs;
        private Integer hTTPHeaderSize;
        private String loadBalancerName;
        private Integer loadBalancerType;
        private Integer nodeCount;
        private String privateIP;
        private String securityGroup;
        private String vxNet;

        @JsonProperty(value="eips")
        public void setEIPs(List<String> eIPs) {
            this.eIPs = eIPs;
        }

        @JsonProperty(value="eips")
        public List<String> getEIPs() {
            return this.eIPs;
        }

        @JsonProperty(value="http_header_size")
        public void setHTTPHeaderSize(Integer hTTPHeaderSize) {
            this.hTTPHeaderSize = hTTPHeaderSize;
        }

        @JsonProperty(value="http_header_size")
        public Integer getHTTPHeaderSize() {
            return this.hTTPHeaderSize;
        }

        @JsonProperty(value="loadbalancer_name")
        public void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @JsonProperty(value="loadbalancer_name")
        public String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @JsonProperty(value="loadbalancer_type")
        public void setLoadBalancerType(Integer loadBalancerType) {
            this.loadBalancerType = loadBalancerType;
        }

        @JsonProperty(value="loadbalancer_type")
        public Integer getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            String[] loadBalancerTypeValidValues = new String[]{"0", "1", "2", "3", "4", "5"};
            boolean loadBalancerTypeIsValid = false;
            for (String v : loadBalancerTypeValidValues) {
                Boolean loadBalancerTypeIsRequired;
                if (v.equals(this.getLoadBalancerType() + "")) {
                    loadBalancerTypeIsValid = true;
                }
                if (!(loadBalancerTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getLoadBalancerType() != null) continue;
                loadBalancerTypeIsValid = true;
            }
            if (!loadBalancerTypeIsValid) {
                throw new QCException("LoadBalancerType value " + this.getLoadBalancerType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AssociateEIPsToLoadBalancerOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AssociateEIPsToLoadBalancerInput
    extends IaasParamBody {
        private List<String> eIPs;
        private String loadBalancer;

        @JsonProperty(value="eips")
        public void setEIPs(List<String> eIPs) {
            this.eIPs = eIPs;
        }

        @JsonProperty(value="eips")
        public List<String> getEIPs() {
            return this.eIPs;
        }

        @JsonProperty(value="loadbalancer")
        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        @JsonProperty(value="loadbalancer")
        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancer())) {
                throw new QCException("LoadBalancer is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplyLoadBalancerPolicyOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ApplyLoadBalancerPolicyInput
    extends IaasParamBody {
        private String loadBalancerPolicy;

        @JsonProperty(value="loadbalancer_policy")
        public void setLoadBalancerPolicy(String loadBalancerPolicy) {
            this.loadBalancerPolicy = loadBalancerPolicy;
        }

        @JsonProperty(value="loadbalancer_policy")
        public String getLoadBalancerPolicy() {
            return this.loadBalancerPolicy;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getLoadBalancerPolicy())) {
                throw new QCException("LoadBalancerPolicy is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddLoadBalancerPolicyRulesOutput
    extends OutputModel {
        private String action;
        private List<String> loadBalancerPolicyRules;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_policy_rules")
        public void setLoadBalancerPolicyRules(List<String> loadBalancerPolicyRules) {
            this.loadBalancerPolicyRules = loadBalancerPolicyRules;
        }

        @JsonProperty(value="loadbalancer_policy_rules")
        public List<String> getLoadBalancerPolicyRules() {
            return this.loadBalancerPolicyRules;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AddLoadBalancerPolicyRulesInput
    extends IaasParamBody {
        private String loadBalancerPolicy;
        private List<Types.LoadBalancerPolicyRuleModel> rules;

        @JsonProperty(value="loadbalancer_policy")
        public void setLoadBalancerPolicy(String loadBalancerPolicy) {
            this.loadBalancerPolicy = loadBalancerPolicy;
        }

        @JsonProperty(value="loadbalancer_policy")
        public String getLoadBalancerPolicy() {
            return this.loadBalancerPolicy;
        }

        @JsonProperty(value="rules")
        public void setRules(List<Types.LoadBalancerPolicyRuleModel> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="rules")
        public List<Types.LoadBalancerPolicyRuleModel> getRules() {
            return this.rules;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getRules() != null && this.getRules().size() > 0 && (i = 0) < this.getRules().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddLoadBalancerListenersOutput
    extends OutputModel {
        private String action;
        private List<String> loadBalancerListeners;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_listeners")
        public void setLoadBalancerListeners(List<String> loadBalancerListeners) {
            this.loadBalancerListeners = loadBalancerListeners;
        }

        @JsonProperty(value="loadbalancer_listeners")
        public List<String> getLoadBalancerListeners() {
            return this.loadBalancerListeners;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AddLoadBalancerListenersInput
    extends IaasParamBody {
        private List<Types.LoadBalancerListenerModel> listeners;
        private String loadBalancer;

        @JsonProperty(value="listeners")
        public void setListeners(List<Types.LoadBalancerListenerModel> listeners) {
            this.listeners = listeners;
        }

        @JsonProperty(value="listeners")
        public List<Types.LoadBalancerListenerModel> getListeners() {
            return this.listeners;
        }

        @JsonProperty(value="loadbalancer")
        public void setLoadBalancer(String loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        @JsonProperty(value="loadbalancer")
        public String getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getListeners() != null && this.getListeners().size() > 0 && (i = 0) < this.getListeners().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddLoadBalancerBackendsOutput
    extends OutputModel {
        private String action;
        private List<String> loadBalancerBackends;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="loadbalancer_backends")
        public void setLoadBalancerBackends(List<String> loadBalancerBackends) {
            this.loadBalancerBackends = loadBalancerBackends;
        }

        @JsonProperty(value="loadbalancer_backends")
        public List<String> getLoadBalancerBackends() {
            return this.loadBalancerBackends;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AddLoadBalancerBackendsInput
    extends IaasParamBody {
        private List<Types.LoadBalancerBackendModel> backends;
        private String loadBalancerListener;

        @JsonProperty(value="backends")
        public void setBackends(List<Types.LoadBalancerBackendModel> backends) {
            this.backends = backends;
        }

        @JsonProperty(value="backends")
        public List<Types.LoadBalancerBackendModel> getBackends() {
            return this.backends;
        }

        @JsonProperty(value="loadbalancer_listener")
        public void setLoadBalancerListener(String loadBalancerListener) {
            this.loadBalancerListener = loadBalancerListener;
        }

        @JsonProperty(value="loadbalancer_listener")
        public String getLoadBalancerListener() {
            return this.loadBalancerListener;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getBackends() != null && this.getBackends().size() > 0 && (i = 0) < this.getBackends().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getLoadBalancerListener())) {
                throw new QCException("LoadBalancerListener is required");
            }
            return null;
        }
    }
}

