/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class MiscService {
    private EnvContext envContext;
    private String zone;

    public MiscService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public MiscService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public GetQuotaLeftOutput getQuotaLeft(GetQuotaLeftInput input) throws QCException {
        if (input == null) {
            input = new GetQuotaLeftInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetQuotaLeft");
        context.put("APIName", "GetQuotaLeft");
        context.put("ServiceName", "GetQuotaLeft");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetQuotaLeft");
        input.setAction("GetQuotaLeft");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetQuotaLeftOutput.class);
        if (backModel != null) {
            return (GetQuotaLeftOutput)backModel;
        }
        return null;
    }

    public void getQuotaLeft(GetQuotaLeftInput input, ResponseCallBack<GetQuotaLeftOutput> callback) throws QCException {
        if (input == null) {
            input = new GetQuotaLeftInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetQuotaLeft");
        context.put("APIName", "GetQuotaLeft");
        context.put("ServiceName", "GetQuotaLeft");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetQuotaLeft");
        input.setAction("GetQuotaLeft");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetQuotaLeftOutput
    extends OutputModel {
        private String action;
        private List<Types.QuotaLeftModel> quotaLeftSet;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="quota_left_set")
        public void setQuotaLeftSet(List<Types.QuotaLeftModel> quotaLeftSet) {
            this.quotaLeftSet = quotaLeftSet;
        }

        @JsonProperty(value="quota_left_set")
        public List<Types.QuotaLeftModel> getQuotaLeftSet() {
            return this.quotaLeftSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetQuotaLeftInput
    extends IaasParamBody {
        private List<String> resourceTypes;
        private String zone;

        @JsonProperty(value="resource_types")
        public void setResourceTypes(List<String> resourceTypes) {
            this.resourceTypes = resourceTypes;
        }

        @JsonProperty(value="resource_types")
        public List<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        @JsonProperty(value="zone")
        public void setZone(String zone) {
            this.zone = zone;
        }

        @Override
        @JsonProperty(value="zone")
        public String getZone() {
            return this.zone;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getZone())) {
                throw new QCException("Zone is required");
            }
            return null;
        }
    }
}

