/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class MongoService {
    private EnvContext envContext;
    private String zone;

    public MongoService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public MongoService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AddMongoInstancesOutput addMongoInstances(AddMongoInstancesInput input) throws QCException {
        if (input == null) {
            input = new AddMongoInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddMongoInstances");
        context.put("APIName", "AddMongoInstances");
        context.put("ServiceName", "AddMongoInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddMongoInstances");
        input.setAction("AddMongoInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddMongoInstancesOutput.class);
        if (backModel != null) {
            return (AddMongoInstancesOutput)backModel;
        }
        return null;
    }

    public void addMongoInstances(AddMongoInstancesInput input, ResponseCallBack<AddMongoInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new AddMongoInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddMongoInstances");
        context.put("APIName", "AddMongoInstances");
        context.put("ServiceName", "AddMongoInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddMongoInstances");
        input.setAction("AddMongoInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ChangeMongoVxNetOutput changeMongoVxNet(ChangeMongoVxNetInput input) throws QCException {
        if (input == null) {
            input = new ChangeMongoVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ChangeMongoVxnet");
        context.put("APIName", "ChangeMongoVxnet");
        context.put("ServiceName", "ChangeMongoVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ChangeMongoVxnet");
        input.setAction("ChangeMongoVxnet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ChangeMongoVxNetOutput.class);
        if (backModel != null) {
            return (ChangeMongoVxNetOutput)backModel;
        }
        return null;
    }

    public void changeMongoVxNet(ChangeMongoVxNetInput input, ResponseCallBack<ChangeMongoVxNetOutput> callback) throws QCException {
        if (input == null) {
            input = new ChangeMongoVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ChangeMongoVxNet");
        context.put("APIName", "ChangeMongoVxNet");
        context.put("ServiceName", "ChangeMongoVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ChangeMongoVxnet");
        input.setAction("ChangeMongoVxNet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateMongoOutput createMongo(CreateMongoInput input) throws QCException {
        if (input == null) {
            input = new CreateMongoInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateMongo");
        context.put("APIName", "CreateMongo");
        context.put("ServiceName", "CreateMongo");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateMongo");
        input.setAction("CreateMongo");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateMongoOutput.class);
        if (backModel != null) {
            return (CreateMongoOutput)backModel;
        }
        return null;
    }

    public void createMongo(CreateMongoInput input, ResponseCallBack<CreateMongoOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateMongoInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateMongo");
        context.put("APIName", "CreateMongo");
        context.put("ServiceName", "CreateMongo");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateMongo");
        input.setAction("CreateMongo");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateMongoFromSnapshotOutput createMongoFromSnapshot(CreateMongoFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CreateMongoFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateMongoFromSnapshot");
        context.put("APIName", "CreateMongoFromSnapshot");
        context.put("ServiceName", "CreateMongoFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateMongoFromSnapshot");
        input.setAction("CreateMongoFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateMongoFromSnapshotOutput.class);
        if (backModel != null) {
            return (CreateMongoFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void createMongoFromSnapshot(CreateMongoFromSnapshotInput input, ResponseCallBack<CreateMongoFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateMongoFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateMongoFromSnapshot");
        context.put("APIName", "CreateMongoFromSnapshot");
        context.put("ServiceName", "CreateMongoFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateMongoFromSnapshot");
        input.setAction("CreateMongoFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteMongosOutput deleteMongos(DeleteMongosInput input) throws QCException {
        if (input == null) {
            input = new DeleteMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteMongos");
        context.put("APIName", "DeleteMongos");
        context.put("ServiceName", "DeleteMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteMongos");
        input.setAction("DeleteMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteMongosOutput.class);
        if (backModel != null) {
            return (DeleteMongosOutput)backModel;
        }
        return null;
    }

    public void deleteMongos(DeleteMongosInput input, ResponseCallBack<DeleteMongosOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteMongos");
        context.put("APIName", "DeleteMongos");
        context.put("ServiceName", "DeleteMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteMongos");
        input.setAction("DeleteMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeMongoNodesOutput describeMongoNodes(DescribeMongoNodesInput input) throws QCException {
        if (input == null) {
            input = new DescribeMongoNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeMongoNodes");
        context.put("APIName", "DescribeMongoNodes");
        context.put("ServiceName", "DescribeMongoNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeMongoNodes");
        input.setAction("DescribeMongoNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeMongoNodesOutput.class);
        if (backModel != null) {
            return (DescribeMongoNodesOutput)backModel;
        }
        return null;
    }

    public void describeMongoNodes(DescribeMongoNodesInput input, ResponseCallBack<DescribeMongoNodesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeMongoNodesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeMongoNodes");
        context.put("APIName", "DescribeMongoNodes");
        context.put("ServiceName", "DescribeMongoNodes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeMongoNodes");
        input.setAction("DescribeMongoNodes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeMongoParametersOutput describeMongoParameters(DescribeMongoParametersInput input) throws QCException {
        if (input == null) {
            input = new DescribeMongoParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeMongoParameters");
        context.put("APIName", "DescribeMongoParameters");
        context.put("ServiceName", "DescribeMongoParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeMongoParameters");
        input.setAction("DescribeMongoParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeMongoParametersOutput.class);
        if (backModel != null) {
            return (DescribeMongoParametersOutput)backModel;
        }
        return null;
    }

    public void describeMongoParameters(DescribeMongoParametersInput input, ResponseCallBack<DescribeMongoParametersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeMongoParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeMongoParameters");
        context.put("APIName", "DescribeMongoParameters");
        context.put("ServiceName", "DescribeMongoParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeMongoParameters");
        input.setAction("DescribeMongoParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeMongosOutput describeMongos(DescribeMongosInput input) throws QCException {
        if (input == null) {
            input = new DescribeMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeMongos");
        context.put("APIName", "DescribeMongos");
        context.put("ServiceName", "DescribeMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeMongos");
        input.setAction("DescribeMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeMongosOutput.class);
        if (backModel != null) {
            return (DescribeMongosOutput)backModel;
        }
        return null;
    }

    public void describeMongos(DescribeMongosInput input, ResponseCallBack<DescribeMongosOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeMongos");
        context.put("APIName", "DescribeMongos");
        context.put("ServiceName", "DescribeMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeMongos");
        input.setAction("DescribeMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetMongoMonitorOutput getMongoMonitor(GetMongoMonitorInput input) throws QCException {
        if (input == null) {
            input = new GetMongoMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetMongoMonitor");
        context.put("APIName", "GetMongoMonitor");
        context.put("ServiceName", "GetMongoMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetMongoMonitor");
        input.setAction("GetMongoMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetMongoMonitorOutput.class);
        if (backModel != null) {
            return (GetMongoMonitorOutput)backModel;
        }
        return null;
    }

    public void getMongoMonitor(GetMongoMonitorInput input, ResponseCallBack<GetMongoMonitorOutput> callback) throws QCException {
        if (input == null) {
            input = new GetMongoMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetMongoMonitor");
        context.put("APIName", "GetMongoMonitor");
        context.put("ServiceName", "GetMongoMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetMongoMonitor");
        input.setAction("GetMongoMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyMongoAttributesOutput modifyMongoAttributes(ModifyMongoAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyMongoAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyMongoAttributes");
        context.put("APIName", "ModifyMongoAttributes");
        context.put("ServiceName", "ModifyMongoAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyMongoAttributes");
        input.setAction("ModifyMongoAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyMongoAttributesOutput.class);
        if (backModel != null) {
            return (ModifyMongoAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyMongoAttributes(ModifyMongoAttributesInput input, ResponseCallBack<ModifyMongoAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyMongoAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyMongoAttributes");
        context.put("APIName", "ModifyMongoAttributes");
        context.put("ServiceName", "ModifyMongoAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyMongoAttributes");
        input.setAction("ModifyMongoAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyMongoInstancesOutput modifyMongoInstances(ModifyMongoInstancesInput input) throws QCException {
        if (input == null) {
            input = new ModifyMongoInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyMongoInstances");
        context.put("APIName", "ModifyMongoInstances");
        context.put("ServiceName", "ModifyMongoInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyMongoInstances");
        input.setAction("ModifyMongoInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyMongoInstancesOutput.class);
        if (backModel != null) {
            return (ModifyMongoInstancesOutput)backModel;
        }
        return null;
    }

    public void modifyMongoInstances(ModifyMongoInstancesInput input, ResponseCallBack<ModifyMongoInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyMongoInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyMongoInstances");
        context.put("APIName", "ModifyMongoInstances");
        context.put("ServiceName", "ModifyMongoInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyMongoInstances");
        input.setAction("ModifyMongoInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RemoveMongoInstancesOutput removeMongoInstances(RemoveMongoInstancesInput input) throws QCException {
        if (input == null) {
            input = new RemoveMongoInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RemoveMongoInstances");
        context.put("APIName", "RemoveMongoInstances");
        context.put("ServiceName", "RemoveMongoInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RemoveMongoInstances");
        input.setAction("RemoveMongoInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RemoveMongoInstancesOutput.class);
        if (backModel != null) {
            return (RemoveMongoInstancesOutput)backModel;
        }
        return null;
    }

    public void removeMongoInstances(RemoveMongoInstancesInput input, ResponseCallBack<RemoveMongoInstancesOutput> callback) throws QCException {
        if (input == null) {
            input = new RemoveMongoInstancesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RemoveMongoInstances");
        context.put("APIName", "RemoveMongoInstances");
        context.put("ServiceName", "RemoveMongoInstances");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RemoveMongoInstances");
        input.setAction("RemoveMongoInstances");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResizeMongosOutput resizeMongos(ResizeMongosInput input) throws QCException {
        if (input == null) {
            input = new ResizeMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeMongos");
        context.put("APIName", "ResizeMongos");
        context.put("ServiceName", "ResizeMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeMongos");
        input.setAction("ResizeMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResizeMongosOutput.class);
        if (backModel != null) {
            return (ResizeMongosOutput)backModel;
        }
        return null;
    }

    public void resizeMongos(ResizeMongosInput input, ResponseCallBack<ResizeMongosOutput> callback) throws QCException {
        if (input == null) {
            input = new ResizeMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeMongos");
        context.put("APIName", "ResizeMongos");
        context.put("ServiceName", "ResizeMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeMongos");
        input.setAction("ResizeMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StartMongosOutput startMongos(StartMongosInput input) throws QCException {
        if (input == null) {
            input = new StartMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartMongos");
        context.put("APIName", "StartMongos");
        context.put("ServiceName", "StartMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartMongos");
        input.setAction("StartMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StartMongosOutput.class);
        if (backModel != null) {
            return (StartMongosOutput)backModel;
        }
        return null;
    }

    public void startMongos(StartMongosInput input, ResponseCallBack<StartMongosOutput> callback) throws QCException {
        if (input == null) {
            input = new StartMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartMongos");
        context.put("APIName", "StartMongos");
        context.put("ServiceName", "StartMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartMongos");
        input.setAction("StartMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StopMongosOutput stopMongos(StopMongosInput input) throws QCException {
        if (input == null) {
            input = new StopMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopMongos");
        context.put("APIName", "StopMongos");
        context.put("ServiceName", "StopMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopMongos");
        input.setAction("StopMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StopMongosOutput.class);
        if (backModel != null) {
            return (StopMongosOutput)backModel;
        }
        return null;
    }

    public void stopMongos(StopMongosInput input, ResponseCallBack<StopMongosOutput> callback) throws QCException {
        if (input == null) {
            input = new StopMongosInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopMongos");
        context.put("APIName", "StopMongos");
        context.put("ServiceName", "StopMongos");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopMongos");
        input.setAction("StopMongos");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopMongosOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StopMongosInput
    extends IaasParamBody {
        private List<String> mongos;

        @JsonProperty(value="mongos")
        public void setMongos(List<String> mongos) {
            this.mongos = mongos;
        }

        @JsonProperty(value="mongos")
        public List<String> getMongos() {
            return this.mongos;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StartMongosOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StartMongosInput
    extends IaasParamBody {
        private String mongos;

        @JsonProperty(value="mongos")
        public void setMongos(String mongos) {
            this.mongos = mongos;
        }

        @JsonProperty(value="mongos")
        public String getMongos() {
            return this.mongos;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getMongos())) {
                throw new QCException("Mongos is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResizeMongosOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> mongos;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongos")
        public void setMongos(List<String> mongos) {
            this.mongos = mongos;
        }

        @JsonProperty(value="mongos")
        public List<String> getMongos() {
            return this.mongos;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ResizeMongosInput
    extends IaasParamBody {
        private Integer mongoType;
        private List<String> mongos;
        private Integer storageSize;

        @JsonProperty(value="mongo_type")
        public void setMongoType(Integer mongoType) {
            this.mongoType = mongoType;
        }

        @JsonProperty(value="mongo_type")
        public Integer getMongoType() {
            return this.mongoType;
        }

        @JsonProperty(value="mongos")
        public void setMongos(List<String> mongos) {
            this.mongos = mongos;
        }

        @JsonProperty(value="mongos")
        public List<String> getMongos() {
            return this.mongos;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RemoveMongoInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String mongo;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RemoveMongoInstancesInput
    extends IaasParamBody {
        private String mongo;
        private List<String> mongoInstances;

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="mongo_instances")
        public void setMongoInstances(List<String> mongoInstances) {
            this.mongoInstances = mongoInstances;
        }

        @JsonProperty(value="mongo_instances")
        public List<String> getMongoInstances() {
            return this.mongoInstances;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getMongo())) {
                throw new QCException("Mongo is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyMongoInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String mongo;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyMongoInstancesInput
    extends IaasParamBody {
        private String mongo;
        private List<Types.MongoPrivateIPModel> privateIPs;

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.MongoPrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.MongoPrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (QCStringUtil.isEmpty(this.getMongo())) {
                throw new QCException("Mongo is required");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyMongoAttributesOutput
    extends OutputModel {
        private String action;
        private String mongo;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyMongoAttributesInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private String description;
        private String mongo;
        private String mongoName;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="mongo_name")
        public void setMongoName(String mongoName) {
            this.mongoName = mongoName;
        }

        @JsonProperty(value="mongo_name")
        public String getMongoName() {
            return this.mongoName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getMongo())) {
                throw new QCException("Mongo is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetMongoMonitorOutput
    extends OutputModel {
        private String action;
        private List<Types.MeterModel> meterSet;
        private String resourceID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="meter_set")
        public void setMeterSet(List<Types.MeterModel> meterSet) {
            this.meterSet = meterSet;
        }

        @JsonProperty(value="meter_set")
        public List<Types.MeterModel> getMeterSet() {
            return this.meterSet;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetMongoMonitorInput
    extends IaasParamBody {
        private String endTime;
        private List<String> meters;
        private String resource;
        private String startTime;
        private String step;

        @JsonProperty(value="end_time")
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="end_time")
        public String getEndTime() {
            return this.endTime;
        }

        @JsonProperty(value="meters")
        public void setMeters(List<String> meters) {
            this.meters = meters;
        }

        @JsonProperty(value="meters")
        public List<String> getMeters() {
            return this.meters;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public String getResource() {
            return this.resource;
        }

        @JsonProperty(value="start_time")
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @JsonProperty(value="start_time")
        public String getStartTime() {
            return this.startTime;
        }

        @JsonProperty(value="step")
        public void setStep(String step) {
            this.step = step;
        }

        @JsonProperty(value="step")
        public String getStep() {
            return this.step;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getResource())) {
                throw new QCException("Resource is required");
            }
            if (QCStringUtil.isEmpty(this.getStep())) {
                throw new QCException("Step is required");
            }
            String[] stepValidValues = new String[]{"5m", "15m", "2h", "1d"};
            boolean stepIsValid = false;
            for (String v : stepValidValues) {
                Boolean stepIsRequired;
                if (v.equals(this.getStep())) {
                    stepIsValid = true;
                }
                if (!(stepIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getStep() != null) continue;
                stepIsValid = true;
            }
            if (!stepIsValid) {
                throw new QCException("Step value " + this.getStep() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeMongosOutput
    extends OutputModel {
        private String action;
        private List<Types.MongoModel> mongoSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="mongo_set")
        public void setMongoSet(List<Types.MongoModel> mongoSet) {
            this.mongoSet = mongoSet;
        }

        @JsonProperty(value="mongo_set")
        public List<Types.MongoModel> getMongoSet() {
            return this.mongoSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeMongosInput
    extends IaasParamBody {
        private Integer limit;
        private String mongoName;
        private List<String> mongos;
        private Integer offset;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="mongo_name")
        public void setMongoName(String mongoName) {
            this.mongoName = mongoName;
        }

        @JsonProperty(value="mongo_name")
        public String getMongoName() {
            return this.mongoName;
        }

        @JsonProperty(value="mongos")
        public void setMongos(List<String> mongos) {
            this.mongos = mongos;
        }

        @JsonProperty(value="mongos")
        public List<String> getMongos() {
            return this.mongos;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeMongoParametersOutput
    extends OutputModel {
        private String action;
        private List<Types.MongoParameterModel> parameterSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="parameter_set")
        public void setParameterSet(List<Types.MongoParameterModel> parameterSet) {
            this.parameterSet = parameterSet;
        }

        @JsonProperty(value="parameter_set")
        public List<Types.MongoParameterModel> getParameterSet() {
            return this.parameterSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeMongoParametersInput
    extends IaasParamBody {
        private Integer limit;
        private String mongo;
        private Integer offset;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getMongo())) {
                throw new QCException("Mongo is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeMongoNodesOutput
    extends OutputModel {
        private String action;
        private List<Types.MongoNodeModel> mongoNodeSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="mongo_node_set")
        public void setMongoNodeSet(List<Types.MongoNodeModel> mongoNodeSet) {
            this.mongoNodeSet = mongoNodeSet;
        }

        @JsonProperty(value="mongo_node_set")
        public List<Types.MongoNodeModel> getMongoNodeSet() {
            return this.mongoNodeSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeMongoNodesInput
    extends IaasParamBody {
        private Integer limit;
        private String mongo;
        private Integer offset;
        private List<String> status;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getMongo())) {
                throw new QCException("Mongo is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteMongosOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> mongos;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongos")
        public void setMongos(List<String> mongos) {
            this.mongos = mongos;
        }

        @JsonProperty(value="mongos")
        public List<String> getMongos() {
            return this.mongos;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteMongosInput
    extends IaasParamBody {
        private List<String> mongos;

        @JsonProperty(value="mongos")
        public void setMongos(List<String> mongos) {
            this.mongos = mongos;
        }

        @JsonProperty(value="mongos")
        public List<String> getMongos() {
            return this.mongos;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMongoFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String mongo;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateMongoFromSnapshotInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private String mongoName;
        private Integer mongoType;
        private Integer mongoVersion;
        private Integer resourceClass;
        private String snapshot;
        private Integer storageSize;
        private String vxNet;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="mongo_name")
        public void setMongoName(String mongoName) {
            this.mongoName = mongoName;
        }

        @JsonProperty(value="mongo_name")
        public String getMongoName() {
            return this.mongoName;
        }

        @JsonProperty(value="mongo_type")
        public void setMongoType(Integer mongoType) {
            this.mongoType = mongoType;
        }

        @JsonProperty(value="mongo_type")
        public Integer getMongoType() {
            return this.mongoType;
        }

        @JsonProperty(value="mongo_version")
        public void setMongoVersion(Integer mongoVersion) {
            this.mongoVersion = mongoVersion;
        }

        @JsonProperty(value="mongo_version")
        public Integer getMongoVersion() {
            return this.mongoVersion;
        }

        @JsonProperty(value="resource_class")
        public void setResourceClass(Integer resourceClass) {
            this.resourceClass = resourceClass;
        }

        @JsonProperty(value="resource_class")
        public Integer getResourceClass() {
            return this.resourceClass;
        }

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMongoOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String mongo;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateMongoInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private String description;
        private String mongoName;
        private String mongoPassword;
        private Integer mongoType;
        private String mongoUsername;
        private String mongoVersion;
        private List<Types.MongoPrivateIPModel> privateIPs;
        private Integer resourceClass;
        private Integer storageSize;
        private String vxNet;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="mongo_name")
        public void setMongoName(String mongoName) {
            this.mongoName = mongoName;
        }

        @JsonProperty(value="mongo_name")
        public String getMongoName() {
            return this.mongoName;
        }

        @JsonProperty(value="mongo_password")
        public void setMongoPassword(String mongoPassword) {
            this.mongoPassword = mongoPassword;
        }

        @JsonProperty(value="mongo_password")
        public String getMongoPassword() {
            return this.mongoPassword;
        }

        @JsonProperty(value="mongo_type")
        public void setMongoType(Integer mongoType) {
            this.mongoType = mongoType;
        }

        @JsonProperty(value="mongo_type")
        public Integer getMongoType() {
            return this.mongoType;
        }

        @JsonProperty(value="mongo_username")
        public void setMongoUsername(String mongoUsername) {
            this.mongoUsername = mongoUsername;
        }

        @JsonProperty(value="mongo_username")
        public String getMongoUsername() {
            return this.mongoUsername;
        }

        @JsonProperty(value="mongo_version")
        public void setMongoVersion(String mongoVersion) {
            this.mongoVersion = mongoVersion;
        }

        @JsonProperty(value="mongo_version")
        public String getMongoVersion() {
            return this.mongoVersion;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.MongoPrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.MongoPrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="resource_class")
        public void setResourceClass(Integer resourceClass) {
            this.resourceClass = resourceClass;
        }

        @JsonProperty(value="resource_class")
        public Integer getResourceClass() {
            return this.resourceClass;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getMongoType() < 0) {
                throw new QCException("MongoType is required");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            if (this.getStorageSize() < 0) {
                throw new QCException("StorageSize is required");
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ChangeMongoVxNetOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String mongo;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ChangeMongoVxNetInput
    extends IaasParamBody {
        private String mongo;
        private List<Types.MongoPrivateIPModel> privateIPs;
        private String vxNet;

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.MongoPrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.MongoPrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (QCStringUtil.isEmpty(this.getMongo())) {
                throw new QCException("Mongo is required");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddMongoInstancesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String mongo;
        private List<String> mongoNode;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="mongo_node")
        public void setMongoNode(List<String> mongoNode) {
            this.mongoNode = mongoNode;
        }

        @JsonProperty(value="mongo_node")
        public List<String> getMongoNode() {
            return this.mongoNode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AddMongoInstancesInput
    extends IaasParamBody {
        private String mongo;
        private Integer nodeCount;
        private List<Types.MongoPrivateIPModel> privateIPs;

        @JsonProperty(value="mongo")
        public void setMongo(String mongo) {
            this.mongo = mongo;
        }

        @JsonProperty(value="mongo")
        public String getMongo() {
            return this.mongo;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.MongoPrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.MongoPrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            return null;
        }
    }
}

