/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class MonitorService {
    private EnvContext envContext;
    private String zone;

    public MonitorService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public MonitorService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public GetMonitorOutput getMonitor(GetMonitorInput input) throws QCException {
        if (input == null) {
            input = new GetMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetMonitor");
        context.put("APIName", "GetMonitor");
        context.put("ServiceName", "GetMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetMonitor");
        input.setAction("GetMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetMonitorOutput.class);
        if (backModel != null) {
            return (GetMonitorOutput)backModel;
        }
        return null;
    }

    public void getMonitor(GetMonitorInput input, ResponseCallBack<GetMonitorOutput> callback) throws QCException {
        if (input == null) {
            input = new GetMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetMonitor");
        context.put("APIName", "GetMonitor");
        context.put("ServiceName", "GetMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetMonitor");
        input.setAction("GetMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetMonitorOutput
    extends OutputModel {
        private String action;
        private List<Types.MeterModel> meterSet;
        private String resourceID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="meter_set")
        public void setMeterSet(List<Types.MeterModel> meterSet) {
            this.meterSet = meterSet;
        }

        @JsonProperty(value="meter_set")
        public List<Types.MeterModel> getMeterSet() {
            return this.meterSet;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetMonitorInput
    extends IaasParamBody {
        private String endTime;
        private List<String> meters;
        private String resource;
        private String startTime;
        private String step;

        @JsonProperty(value="end_time")
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="end_time")
        public String getEndTime() {
            return this.endTime;
        }

        @JsonProperty(value="meters")
        public void setMeters(List<String> meters) {
            this.meters = meters;
        }

        @JsonProperty(value="meters")
        public List<String> getMeters() {
            return this.meters;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public String getResource() {
            return this.resource;
        }

        @JsonProperty(value="start_time")
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @JsonProperty(value="start_time")
        public String getStartTime() {
            return this.startTime;
        }

        @JsonProperty(value="step")
        public void setStep(String step) {
            this.step = step;
        }

        @JsonProperty(value="step")
        public String getStep() {
            return this.step;
        }

        @Override
        public String validateParam() throws QCException {
            String[] stepValidValues = new String[]{"5m", "15m", "2h", "1d"};
            boolean stepIsValid = false;
            for (String v : stepValidValues) {
                Boolean stepIsRequired;
                if (v.equals(this.getStep())) {
                    stepIsValid = true;
                }
                if (!(stepIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStep() != null) continue;
                stepIsValid = true;
            }
            if (!stepIsValid) {
                throw new QCException("Step value " + this.getStep() + "is invalid");
            }
            return null;
        }
    }
}

