/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class RDBService {
    private EnvContext envContext;
    private String zone;

    public RDBService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public RDBService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public ApplyRDBParameterGroupOutput applyRDBParameterGroup(ApplyRDBParameterGroupInput input) throws QCException {
        if (input == null) {
            input = new ApplyRDBParameterGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplyRDBParameterGroup");
        context.put("APIName", "ApplyRDBParameterGroup");
        context.put("ServiceName", "ApplyRDBParameterGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplyRDBParameterGroup");
        input.setAction("ApplyRDBParameterGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ApplyRDBParameterGroupOutput.class);
        if (backModel != null) {
            return (ApplyRDBParameterGroupOutput)backModel;
        }
        return null;
    }

    public void applyRDBParameterGroup(ApplyRDBParameterGroupInput input, ResponseCallBack<ApplyRDBParameterGroupOutput> callback) throws QCException {
        if (input == null) {
            input = new ApplyRDBParameterGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplyRDBParameterGroup");
        context.put("APIName", "ApplyRDBParameterGroup");
        context.put("ServiceName", "ApplyRDBParameterGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplyRDBParameterGroup");
        input.setAction("ApplyRDBParameterGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CeaseRDBInstanceOutput ceaseRDBInstance(CeaseRDBInstanceInput input) throws QCException {
        if (input == null) {
            input = new CeaseRDBInstanceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CeaseRDBInstance");
        context.put("APIName", "CeaseRDBInstance");
        context.put("ServiceName", "CeaseRDBInstance");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CeaseRDBInstance");
        input.setAction("CeaseRDBInstance");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CeaseRDBInstanceOutput.class);
        if (backModel != null) {
            return (CeaseRDBInstanceOutput)backModel;
        }
        return null;
    }

    public void ceaseRDBInstance(CeaseRDBInstanceInput input, ResponseCallBack<CeaseRDBInstanceOutput> callback) throws QCException {
        if (input == null) {
            input = new CeaseRDBInstanceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CeaseRDBInstance");
        context.put("APIName", "CeaseRDBInstance");
        context.put("ServiceName", "CeaseRDBInstance");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CeaseRDBInstance");
        input.setAction("CeaseRDBInstance");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CopyRDBInstanceFilesToFTPOutput copyRDBInstanceFilesToFTP(CopyRDBInstanceFilesToFTPInput input) throws QCException {
        if (input == null) {
            input = new CopyRDBInstanceFilesToFTPInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CopyRDBInstanceFilesToFTP");
        context.put("APIName", "CopyRDBInstanceFilesToFTP");
        context.put("ServiceName", "CopyRDBInstanceFilesToFTP");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CopyRDBInstanceFilesToFTP");
        input.setAction("CopyRDBInstanceFilesToFTP");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CopyRDBInstanceFilesToFTPOutput.class);
        if (backModel != null) {
            return (CopyRDBInstanceFilesToFTPOutput)backModel;
        }
        return null;
    }

    public void copyRDBInstanceFilesToFTP(CopyRDBInstanceFilesToFTPInput input, ResponseCallBack<CopyRDBInstanceFilesToFTPOutput> callback) throws QCException {
        if (input == null) {
            input = new CopyRDBInstanceFilesToFTPInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CopyRDBInstanceFilesToFTP");
        context.put("APIName", "CopyRDBInstanceFilesToFTP");
        context.put("ServiceName", "CopyRDBInstanceFilesToFTP");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CopyRDBInstanceFilesToFTP");
        input.setAction("CopyRDBInstanceFilesToFTP");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateRDBOutput createRDB(CreateRDBInput input) throws QCException {
        if (input == null) {
            input = new CreateRDBInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateRDB");
        context.put("APIName", "CreateRDB");
        context.put("ServiceName", "CreateRDB");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateRDB");
        input.setAction("CreateRDB");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateRDBOutput.class);
        if (backModel != null) {
            return (CreateRDBOutput)backModel;
        }
        return null;
    }

    public void createRDB(CreateRDBInput input, ResponseCallBack<CreateRDBOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateRDBInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateRDB");
        context.put("APIName", "CreateRDB");
        context.put("ServiceName", "CreateRDB");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateRDB");
        input.setAction("CreateRDB");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateRDBFromSnapshotOutput createRDBFromSnapshot(CreateRDBFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CreateRDBFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateRDBFromSnapshot");
        context.put("APIName", "CreateRDBFromSnapshot");
        context.put("ServiceName", "CreateRDBFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateRDBFromSnapshot");
        input.setAction("CreateRDBFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateRDBFromSnapshotOutput.class);
        if (backModel != null) {
            return (CreateRDBFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void createRDBFromSnapshot(CreateRDBFromSnapshotInput input, ResponseCallBack<CreateRDBFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateRDBFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateRDBFromSnapshot");
        context.put("APIName", "CreateRDBFromSnapshot");
        context.put("ServiceName", "CreateRDBFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateRDBFromSnapshot");
        input.setAction("CreateRDBFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateTempRDBInstanceFromSnapshotOutput createTempRDBInstanceFromSnapshot(CreateTempRDBInstanceFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CreateTempRDBInstanceFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateTempRDBInstanceFromSnapshot");
        context.put("APIName", "CreateTempRDBInstanceFromSnapshot");
        context.put("ServiceName", "CreateTempRDBInstanceFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateTempRDBInstanceFromSnapshot");
        input.setAction("CreateTempRDBInstanceFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateTempRDBInstanceFromSnapshotOutput.class);
        if (backModel != null) {
            return (CreateTempRDBInstanceFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void createTempRDBInstanceFromSnapshot(CreateTempRDBInstanceFromSnapshotInput input, ResponseCallBack<CreateTempRDBInstanceFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateTempRDBInstanceFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateTempRDBInstanceFromSnapshot");
        context.put("APIName", "CreateTempRDBInstanceFromSnapshot");
        context.put("ServiceName", "CreateTempRDBInstanceFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateTempRDBInstanceFromSnapshot");
        input.setAction("CreateTempRDBInstanceFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteRDBsOutput deleteRDBs(DeleteRDBsInput input) throws QCException {
        if (input == null) {
            input = new DeleteRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRDBs");
        context.put("APIName", "DeleteRDBs");
        context.put("ServiceName", "DeleteRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRDBs");
        input.setAction("DeleteRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteRDBsOutput.class);
        if (backModel != null) {
            return (DeleteRDBsOutput)backModel;
        }
        return null;
    }

    public void deleteRDBs(DeleteRDBsInput input, ResponseCallBack<DeleteRDBsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRDBs");
        context.put("APIName", "DeleteRDBs");
        context.put("ServiceName", "DeleteRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRDBs");
        input.setAction("DeleteRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeRDBParametersOutput describeRDBParameters(DescribeRDBParametersInput input) throws QCException {
        if (input == null) {
            input = new DescribeRDBParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRDBParameters");
        context.put("APIName", "DescribeRDBParameters");
        context.put("ServiceName", "DescribeRDBParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRDBParameters");
        input.setAction("DescribeRDBParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeRDBParametersOutput.class);
        if (backModel != null) {
            return (DescribeRDBParametersOutput)backModel;
        }
        return null;
    }

    public void describeRDBParameters(DescribeRDBParametersInput input, ResponseCallBack<DescribeRDBParametersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeRDBParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRDBParameters");
        context.put("APIName", "DescribeRDBParameters");
        context.put("ServiceName", "DescribeRDBParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRDBParameters");
        input.setAction("DescribeRDBParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeRDBsOutput describeRDBs(DescribeRDBsInput input) throws QCException {
        if (input == null) {
            input = new DescribeRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRDBs");
        context.put("APIName", "DescribeRDBs");
        context.put("ServiceName", "DescribeRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRDBs");
        input.setAction("DescribeRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeRDBsOutput.class);
        if (backModel != null) {
            return (DescribeRDBsOutput)backModel;
        }
        return null;
    }

    public void describeRDBs(DescribeRDBsInput input, ResponseCallBack<DescribeRDBsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRDBs");
        context.put("APIName", "DescribeRDBs");
        context.put("ServiceName", "DescribeRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRDBs");
        input.setAction("DescribeRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetRDBInstanceFilesOutput getRDBInstanceFiles(GetRDBInstanceFilesInput input) throws QCException {
        if (input == null) {
            input = new GetRDBInstanceFilesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetRDBInstanceFiles");
        context.put("APIName", "GetRDBInstanceFiles");
        context.put("ServiceName", "GetRDBInstanceFiles");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetRDBInstanceFiles");
        input.setAction("GetRDBInstanceFiles");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetRDBInstanceFilesOutput.class);
        if (backModel != null) {
            return (GetRDBInstanceFilesOutput)backModel;
        }
        return null;
    }

    public void getRDBInstanceFiles(GetRDBInstanceFilesInput input, ResponseCallBack<GetRDBInstanceFilesOutput> callback) throws QCException {
        if (input == null) {
            input = new GetRDBInstanceFilesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetRDBInstanceFiles");
        context.put("APIName", "GetRDBInstanceFiles");
        context.put("ServiceName", "GetRDBInstanceFiles");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetRDBInstanceFiles");
        input.setAction("GetRDBInstanceFiles");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetRDBMonitorOutput getRDBMonitor(GetRDBMonitorInput input) throws QCException {
        if (input == null) {
            input = new GetRDBMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetRDBMonitor");
        context.put("APIName", "GetRDBMonitor");
        context.put("ServiceName", "GetRDBMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetRDBMonitor");
        input.setAction("GetRDBMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetRDBMonitorOutput.class);
        if (backModel != null) {
            return (GetRDBMonitorOutput)backModel;
        }
        return null;
    }

    public void getRDBMonitor(GetRDBMonitorInput input, ResponseCallBack<GetRDBMonitorOutput> callback) throws QCException {
        if (input == null) {
            input = new GetRDBMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetRDBMonitor");
        context.put("APIName", "GetRDBMonitor");
        context.put("ServiceName", "GetRDBMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetRDBMonitor");
        input.setAction("GetRDBMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyRDBParametersOutput modifyRDBParameters(ModifyRDBParametersInput input) throws QCException {
        if (input == null) {
            input = new ModifyRDBParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRDBParameters");
        context.put("APIName", "ModifyRDBParameters");
        context.put("ServiceName", "ModifyRDBParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRDBParameters");
        input.setAction("ModifyRDBParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyRDBParametersOutput.class);
        if (backModel != null) {
            return (ModifyRDBParametersOutput)backModel;
        }
        return null;
    }

    public void modifyRDBParameters(ModifyRDBParametersInput input, ResponseCallBack<ModifyRDBParametersOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyRDBParametersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRDBParameters");
        context.put("APIName", "ModifyRDBParameters");
        context.put("ServiceName", "ModifyRDBParameters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRDBParameters");
        input.setAction("ModifyRDBParameters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RDBsJoinVxNetOutput rDBsJoinVxNet(RDBsJoinVxNetInput input) throws QCException {
        if (input == null) {
            input = new RDBsJoinVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RDBsJoinVxnet");
        context.put("APIName", "RDBsJoinVxnet");
        context.put("ServiceName", "RDBsJoinVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RDBsJoinVxnet");
        input.setAction("RDBsJoinVxnet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RDBsJoinVxNetOutput.class);
        if (backModel != null) {
            return (RDBsJoinVxNetOutput)backModel;
        }
        return null;
    }

    public void rDBsJoinVxNet(RDBsJoinVxNetInput input, ResponseCallBack<RDBsJoinVxNetOutput> callback) throws QCException {
        if (input == null) {
            input = new RDBsJoinVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RDBsJoinVxNet");
        context.put("APIName", "RDBsJoinVxNet");
        context.put("ServiceName", "RDBsJoinVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RDBsJoinVxnet");
        input.setAction("RDBsJoinVxNet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RDBsLeaveVxNetOutput rDBsLeaveVxNet(RDBsLeaveVxNetInput input) throws QCException {
        if (input == null) {
            input = new RDBsLeaveVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RDBsLeaveVxnet");
        context.put("APIName", "RDBsLeaveVxnet");
        context.put("ServiceName", "RDBsLeaveVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RDBsLeaveVxnet");
        input.setAction("RDBsLeaveVxnet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RDBsLeaveVxNetOutput.class);
        if (backModel != null) {
            return (RDBsLeaveVxNetOutput)backModel;
        }
        return null;
    }

    public void rDBsLeaveVxNet(RDBsLeaveVxNetInput input, ResponseCallBack<RDBsLeaveVxNetOutput> callback) throws QCException {
        if (input == null) {
            input = new RDBsLeaveVxNetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RDBsLeaveVxNet");
        context.put("APIName", "RDBsLeaveVxNet");
        context.put("ServiceName", "RDBsLeaveVxnet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RDBsLeaveVxnet");
        input.setAction("RDBsLeaveVxNet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ResizeRDBsOutput resizeRDBs(ResizeRDBsInput input) throws QCException {
        if (input == null) {
            input = new ResizeRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeRDBs");
        context.put("APIName", "ResizeRDBs");
        context.put("ServiceName", "ResizeRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeRDBs");
        input.setAction("ResizeRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ResizeRDBsOutput.class);
        if (backModel != null) {
            return (ResizeRDBsOutput)backModel;
        }
        return null;
    }

    public void resizeRDBs(ResizeRDBsInput input, ResponseCallBack<ResizeRDBsOutput> callback) throws QCException {
        if (input == null) {
            input = new ResizeRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ResizeRDBs");
        context.put("APIName", "ResizeRDBs");
        context.put("ServiceName", "ResizeRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ResizeRDBs");
        input.setAction("ResizeRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StartRDBsOutput startRDBs(StartRDBsInput input) throws QCException {
        if (input == null) {
            input = new StartRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartRDBs");
        context.put("APIName", "StartRDBs");
        context.put("ServiceName", "StartRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartRDBs");
        input.setAction("StartRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StartRDBsOutput.class);
        if (backModel != null) {
            return (StartRDBsOutput)backModel;
        }
        return null;
    }

    public void startRDBs(StartRDBsInput input, ResponseCallBack<StartRDBsOutput> callback) throws QCException {
        if (input == null) {
            input = new StartRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StartRDBs");
        context.put("APIName", "StartRDBs");
        context.put("ServiceName", "StartRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StartRDBs");
        input.setAction("StartRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public StopRDBsOutput stopRDBs(StopRDBsInput input) throws QCException {
        if (input == null) {
            input = new StopRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopRDBs");
        context.put("APIName", "StopRDBs");
        context.put("ServiceName", "StopRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopRDBs");
        input.setAction("StopRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, StopRDBsOutput.class);
        if (backModel != null) {
            return (StopRDBsOutput)backModel;
        }
        return null;
    }

    public void stopRDBs(StopRDBsInput input, ResponseCallBack<StopRDBsOutput> callback) throws QCException {
        if (input == null) {
            input = new StopRDBsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "StopRDBs");
        context.put("APIName", "StopRDBs");
        context.put("ServiceName", "StopRDBs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/StopRDBs");
        input.setAction("StopRDBs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StopRDBsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> rDBs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StopRDBsInput
    extends IaasParamBody {
        private List<String> rDBs;

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class StartRDBsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> rDBs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class StartRDBsInput
    extends IaasParamBody {
        private List<String> rDBs;

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResizeRDBsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> rDBs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ResizeRDBsInput
    extends IaasParamBody {
        private Integer rDBType;
        private List<String> rDBs;
        private Integer storageSize;

        @JsonProperty(value="rdb_type")
        public void setRDBType(Integer rDBType) {
            this.rDBType = rDBType;
        }

        @JsonProperty(value="rdb_type")
        public Integer getRDBType() {
            return this.rDBType;
        }

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @Override
        public String validateParam() throws QCException {
            String[] rDBTypeValidValues = new String[]{"1", "2", "4", "8", "16", "32"};
            boolean rDBTypeIsValid = false;
            for (String v : rDBTypeValidValues) {
                Boolean rDBTypeIsRequired;
                if (v.equals(this.getRDBType() + "")) {
                    rDBTypeIsValid = true;
                }
                if (!(rDBTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getRDBType() != null) continue;
                rDBTypeIsValid = true;
            }
            if (!rDBTypeIsValid) {
                throw new QCException("RDBType value " + this.getRDBType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RDBsLeaveVxNetOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RDBsLeaveVxNetInput
    extends IaasParamBody {
        private List<String> rDBs;
        private String vxNet;

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RDBsJoinVxNetOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> rDBs;
        private Integer retCode;
        private String vxNet;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }
    }

    public static class RDBsJoinVxNetInput
    extends IaasParamBody {
        private List<String> rDBs;
        private String vxNet;

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyRDBParametersOutput
    extends OutputModel {
        private String action;
        private String rDB;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyRDBParametersInput
    extends IaasParamBody {
        private List<Types.RDBParametersModel> parameters;
        private String rDB;

        @JsonProperty(value="parameters")
        public void setParameters(List<Types.RDBParametersModel> parameters) {
            this.parameters = parameters;
        }

        @JsonProperty(value="parameters")
        public List<Types.RDBParametersModel> getParameters() {
            return this.parameters;
        }

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getParameters() != null && this.getParameters().size() > 0 && (i = 0) < this.getParameters().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getRDB())) {
                throw new QCException("RDB is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetRDBMonitorOutput
    extends OutputModel {
        private String action;
        private List<Types.MeterModel> meterSet;
        private String resourceID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="meter_set")
        public void setMeterSet(List<Types.MeterModel> meterSet) {
            this.meterSet = meterSet;
        }

        @JsonProperty(value="meter_set")
        public List<Types.MeterModel> getMeterSet() {
            return this.meterSet;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetRDBMonitorInput
    extends IaasParamBody {
        private String endTime;
        private List<String> meters;
        private String rDBEngine;
        private String rDBInstance;
        private String resource;
        private String role;
        private String startTime;
        private String step;

        @JsonProperty(value="end_time")
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="end_time")
        public String getEndTime() {
            return this.endTime;
        }

        @JsonProperty(value="meters")
        public void setMeters(List<String> meters) {
            this.meters = meters;
        }

        @JsonProperty(value="meters")
        public List<String> getMeters() {
            return this.meters;
        }

        @JsonProperty(value="rdb_engine")
        public void setRDBEngine(String rDBEngine) {
            this.rDBEngine = rDBEngine;
        }

        @JsonProperty(value="rdb_engine")
        public String getRDBEngine() {
            return this.rDBEngine;
        }

        @JsonProperty(value="rdb_instance")
        public void setRDBInstance(String rDBInstance) {
            this.rDBInstance = rDBInstance;
        }

        @JsonProperty(value="rdb_instance")
        public String getRDBInstance() {
            return this.rDBInstance;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public String getResource() {
            return this.resource;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="start_time")
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @JsonProperty(value="start_time")
        public String getStartTime() {
            return this.startTime;
        }

        @JsonProperty(value="step")
        public void setStep(String step) {
            this.step = step;
        }

        @JsonProperty(value="step")
        public String getStep() {
            return this.step;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRDBEngine())) {
                throw new QCException("RDBEngine is required");
            }
            if (QCStringUtil.isEmpty(this.getResource())) {
                throw new QCException("Resource is required");
            }
            if (QCStringUtil.isEmpty(this.getRole())) {
                throw new QCException("Role is required");
            }
            if (QCStringUtil.isEmpty(this.getStep())) {
                throw new QCException("Step is required");
            }
            String[] stepValidValues = new String[]{"5m", "15m", "2h", "1d"};
            boolean stepIsValid = false;
            for (String v : stepValidValues) {
                Boolean stepIsRequired;
                if (v.equals(this.getStep())) {
                    stepIsValid = true;
                }
                if (!(stepIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getStep() != null) continue;
                stepIsValid = true;
            }
            if (!stepIsValid) {
                throw new QCException("Step value " + this.getStep() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetRDBInstanceFilesOutput
    extends OutputModel {
        private String action;
        private Types.RDBFileModel files;
        private String rDBInstance;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="files")
        public void setFiles(Types.RDBFileModel files) {
            this.files = files;
        }

        @JsonProperty(value="files")
        public Types.RDBFileModel getFiles() {
            return this.files;
        }

        @JsonProperty(value="rdb_instance")
        public void setRDBInstance(String rDBInstance) {
            this.rDBInstance = rDBInstance;
        }

        @JsonProperty(value="rdb_instance")
        public String getRDBInstance() {
            return this.rDBInstance;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetRDBInstanceFilesInput
    extends IaasParamBody {
        private String rDBInstance;

        @JsonProperty(value="rdb_instance")
        public void setRDBInstance(String rDBInstance) {
            this.rDBInstance = rDBInstance;
        }

        @JsonProperty(value="rdb_instance")
        public String getRDBInstance() {
            return this.rDBInstance;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRDBInstance())) {
                throw new QCException("RDBInstance is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeRDBsOutput
    extends OutputModel {
        private String action;
        private List<Types.RDBModel> rDBSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="rdb_set")
        public void setRDBSet(List<Types.RDBModel> rDBSet) {
            this.rDBSet = rDBSet;
        }

        @JsonProperty(value="rdb_set")
        public List<Types.RDBModel> getRDBSet() {
            return this.rDBSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeRDBsInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String rDBEngine;
        private String rDBName;
        private List<String> rDBs;
        private String searchWord;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="rdb_engine")
        public void setRDBEngine(String rDBEngine) {
            this.rDBEngine = rDBEngine;
        }

        @JsonProperty(value="rdb_engine")
        public String getRDBEngine() {
            return this.rDBEngine;
        }

        @JsonProperty(value="rdb_name")
        public void setRDBName(String rDBName) {
            this.rDBName = rDBName;
        }

        @JsonProperty(value="rdb_name")
        public String getRDBName() {
            return this.rDBName;
        }

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeRDBParametersOutput
    extends OutputModel {
        private String action;
        private List<Types.RDBParameterModel> parameterSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="parameter_set")
        public void setParameterSet(List<Types.RDBParameterModel> parameterSet) {
            this.parameterSet = parameterSet;
        }

        @JsonProperty(value="parameter_set")
        public List<Types.RDBParameterModel> getParameterSet() {
            return this.parameterSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeRDBParametersInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String parameterGroup;
        private String rDB;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="parameter_group")
        public void setParameterGroup(String parameterGroup) {
            this.parameterGroup = parameterGroup;
        }

        @JsonProperty(value="parameter_group")
        public String getParameterGroup() {
            return this.parameterGroup;
        }

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRDB())) {
                throw new QCException("RDB is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteRDBsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private List<String> rDBs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteRDBsInput
    extends IaasParamBody {
        private List<String> rDBs;

        @JsonProperty(value="rdbs")
        public void setRDBs(List<String> rDBs) {
            this.rDBs = rDBs;
        }

        @JsonProperty(value="rdbs")
        public List<String> getRDBs() {
            return this.rDBs;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateTempRDBInstanceFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String rDB;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateTempRDBInstanceFromSnapshotInput
    extends IaasParamBody {
        private String rDB;
        private String snapshot;

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRDB())) {
                throw new QCException("RDB is required");
            }
            if (QCStringUtil.isEmpty(this.getSnapshot())) {
                throw new QCException("Snapshot is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateRDBFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String rDB;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateRDBFromSnapshotInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private String description;
        private String engineVersion;
        private Integer nodeCount;
        private List<Types.RDBPrivateIPModel> privateIPs;
        private Integer proxyCount;
        private String rDBEngine;
        private String rDBName;
        private Integer rDBType;
        private String snapshot;
        private Integer storageSize;
        private String vxNet;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="engine_version")
        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @JsonProperty(value="engine_version")
        public String getEngineVersion() {
            return this.engineVersion;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.RDBPrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.RDBPrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="proxy_count")
        public void setProxyCount(Integer proxyCount) {
            this.proxyCount = proxyCount;
        }

        @JsonProperty(value="proxy_count")
        public Integer getProxyCount() {
            return this.proxyCount;
        }

        @JsonProperty(value="rdb_engine")
        public void setRDBEngine(String rDBEngine) {
            this.rDBEngine = rDBEngine;
        }

        @JsonProperty(value="rdb_engine")
        public String getRDBEngine() {
            return this.rDBEngine;
        }

        @JsonProperty(value="rdb_name")
        public void setRDBName(String rDBName) {
            this.rDBName = rDBName;
        }

        @JsonProperty(value="rdb_name")
        public String getRDBName() {
            return this.rDBName;
        }

        @JsonProperty(value="rdb_type")
        public void setRDBType(Integer rDBType) {
            this.rDBType = rDBType;
        }

        @JsonProperty(value="rdb_type")
        public Integer getRDBType() {
            return this.rDBType;
        }

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] engineVersionValidValues = new String[]{"mysql,5.5", "mysql,5.6", "mysql,5.7", "psql,9.3", "psql,9.4"};
            boolean engineVersionIsValid = false;
            for (String v : engineVersionValidValues) {
                Boolean engineVersionIsRequired;
                if (v.equals(this.getEngineVersion())) {
                    engineVersionIsValid = true;
                }
                if (!(engineVersionIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getEngineVersion() != null) continue;
                engineVersionIsValid = true;
            }
            if (!engineVersionIsValid) {
                throw new QCException("EngineVersion value " + this.getEngineVersion() + "is invalid");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            String[] rDBEngineValidValues = new String[]{"mysql", "psql"};
            boolean rDBEngineIsValid = false;
            for (String v : rDBEngineValidValues) {
                Boolean rDBEngineIsRequired;
                if (v.equals(this.getRDBEngine())) {
                    rDBEngineIsValid = true;
                }
                if (!(rDBEngineIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getRDBEngine() != null) continue;
                rDBEngineIsValid = true;
            }
            if (!rDBEngineIsValid) {
                throw new QCException("RDBEngine value " + this.getRDBEngine() + "is invalid");
            }
            if (this.getRDBType() < 0) {
                throw new QCException("RDBType is required");
            }
            String[] rDBTypeValidValues = new String[]{"1", "2", "4", "8", "16", "32"};
            boolean rDBTypeIsValid = false;
            for (String v : rDBTypeValidValues) {
                Boolean rDBTypeIsRequired;
                if (v.equals(this.getRDBType() + "")) {
                    rDBTypeIsValid = true;
                }
                if (!(rDBTypeIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getRDBType() != null) continue;
                rDBTypeIsValid = true;
            }
            if (!rDBTypeIsValid) {
                throw new QCException("RDBType value " + this.getRDBType() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getSnapshot())) {
                throw new QCException("Snapshot is required");
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateRDBOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String rDB;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateRDBInput
    extends IaasParamBody {
        private Integer autoBackupTime;
        private String description;
        private String engineVersion;
        private Integer nodeCount;
        private List<Types.RDBPrivateIPModel> privateIPs;
        private Integer proxyCount;
        private Integer rDBClass;
        private String rDBEngine;
        private String rDBName;
        private String rDBPassword;
        private Integer rDBType;
        private String rDBUsername;
        private Integer storageSize;
        private String vxNet;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="engine_version")
        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @JsonProperty(value="engine_version")
        public String getEngineVersion() {
            return this.engineVersion;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<Types.RDBPrivateIPModel> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<Types.RDBPrivateIPModel> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="proxy_count")
        public void setProxyCount(Integer proxyCount) {
            this.proxyCount = proxyCount;
        }

        @JsonProperty(value="proxy_count")
        public Integer getProxyCount() {
            return this.proxyCount;
        }

        @JsonProperty(value="rdb_class")
        public void setRDBClass(Integer rDBClass) {
            this.rDBClass = rDBClass;
        }

        @JsonProperty(value="rdb_class")
        public Integer getRDBClass() {
            return this.rDBClass;
        }

        @JsonProperty(value="rdb_engine")
        public void setRDBEngine(String rDBEngine) {
            this.rDBEngine = rDBEngine;
        }

        @JsonProperty(value="rdb_engine")
        public String getRDBEngine() {
            return this.rDBEngine;
        }

        @JsonProperty(value="rdb_name")
        public void setRDBName(String rDBName) {
            this.rDBName = rDBName;
        }

        @JsonProperty(value="rdb_name")
        public String getRDBName() {
            return this.rDBName;
        }

        @JsonProperty(value="rdb_password")
        public void setRDBPassword(String rDBPassword) {
            this.rDBPassword = rDBPassword;
        }

        @JsonProperty(value="rdb_password")
        public String getRDBPassword() {
            return this.rDBPassword;
        }

        @JsonProperty(value="rdb_type")
        public void setRDBType(Integer rDBType) {
            this.rDBType = rDBType;
        }

        @JsonProperty(value="rdb_type")
        public Integer getRDBType() {
            return this.rDBType;
        }

        @JsonProperty(value="rdb_username")
        public void setRDBUsername(String rDBUsername) {
            this.rDBUsername = rDBUsername;
        }

        @JsonProperty(value="rdb_username")
        public String getRDBUsername() {
            return this.rDBUsername;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] engineVersionValidValues = new String[]{"mysql,5.5", "mysql,5.6", "mysql,5.7", "psql,9.3", "psql,9.4"};
            boolean engineVersionIsValid = false;
            for (String v : engineVersionValidValues) {
                Boolean engineVersionIsRequired;
                if (v.equals(this.getEngineVersion())) {
                    engineVersionIsValid = true;
                }
                if (!(engineVersionIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getEngineVersion() != null) continue;
                engineVersionIsValid = true;
            }
            if (!engineVersionIsValid) {
                throw new QCException("EngineVersion value " + this.getEngineVersion() + "is invalid");
            }
            if (this.getPrivateIPs() != null && this.getPrivateIPs().size() > 0 && (i = 0) < this.getPrivateIPs().size()) {
                return null;
            }
            String[] rDBEngineValidValues = new String[]{"mysql", "psql"};
            boolean rDBEngineIsValid = false;
            for (String v : rDBEngineValidValues) {
                Boolean rDBEngineIsRequired;
                if (v.equals(this.getRDBEngine())) {
                    rDBEngineIsValid = true;
                }
                if (!(rDBEngineIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getRDBEngine() != null) continue;
                rDBEngineIsValid = true;
            }
            if (!rDBEngineIsValid) {
                throw new QCException("RDBEngine value " + this.getRDBEngine() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getRDBPassword())) {
                throw new QCException("RDBPassword is required");
            }
            if (this.getRDBType() < 0) {
                throw new QCException("RDBType is required");
            }
            String[] rDBTypeValidValues = new String[]{"1", "2", "4", "8", "16", "32"};
            boolean rDBTypeIsValid = false;
            for (String v : rDBTypeValidValues) {
                Boolean rDBTypeIsRequired;
                if (v.equals(this.getRDBType() + "")) {
                    rDBTypeIsValid = true;
                }
                if (!(rDBTypeIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getRDBType() != null) continue;
                rDBTypeIsValid = true;
            }
            if (!rDBTypeIsValid) {
                throw new QCException("RDBType value " + this.getRDBType() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getRDBUsername())) {
                throw new QCException("RDBUsername is required");
            }
            if (this.getStorageSize() < 0) {
                throw new QCException("StorageSize is required");
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CopyRDBInstanceFilesToFTPOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String rDBInstance;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdb_instance")
        public void setRDBInstance(String rDBInstance) {
            this.rDBInstance = rDBInstance;
        }

        @JsonProperty(value="rdb_instance")
        public String getRDBInstance() {
            return this.rDBInstance;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CopyRDBInstanceFilesToFTPInput
    extends IaasParamBody {
        private List<String> files;
        private String rDBInstance;

        @JsonProperty(value="files")
        public void setFiles(List<String> files) {
            this.files = files;
        }

        @JsonProperty(value="files")
        public List<String> getFiles() {
            return this.files;
        }

        @JsonProperty(value="rdb_instance")
        public void setRDBInstance(String rDBInstance) {
            this.rDBInstance = rDBInstance;
        }

        @JsonProperty(value="rdb_instance")
        public String getRDBInstance() {
            return this.rDBInstance;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRDBInstance())) {
                throw new QCException("RDBInstance is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CeaseRDBInstanceOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CeaseRDBInstanceInput
    extends IaasParamBody {
        private String rDB;
        private String rDBInstance;

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @JsonProperty(value="rdb_instance")
        public void setRDBInstance(String rDBInstance) {
            this.rDBInstance = rDBInstance;
        }

        @JsonProperty(value="rdb_instance")
        public String getRDBInstance() {
            return this.rDBInstance;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRDB())) {
                throw new QCException("RDB is required");
            }
            if (QCStringUtil.isEmpty(this.getRDBInstance())) {
                throw new QCException("RDBInstance is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplyRDBParameterGroupOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private String rDB;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ApplyRDBParameterGroupInput
    extends IaasParamBody {
        private String rDB;

        @JsonProperty(value="rdb")
        public void setRDB(String rDB) {
            this.rDB = rDB;
        }

        @JsonProperty(value="rdb")
        public String getRDB() {
            return this.rDB;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRDB())) {
                throw new QCException("RDB is required");
            }
            return null;
        }
    }
}

