/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class RouterService {
    private EnvContext envContext;
    private String zone;

    public RouterService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public RouterService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AddRouterStaticEntriesOutput addRouterStaticEntries(AddRouterStaticEntriesInput input) throws QCException {
        if (input == null) {
            input = new AddRouterStaticEntriesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddRouterStaticEntries");
        context.put("APIName", "AddRouterStaticEntries");
        context.put("ServiceName", "AddRouterStaticEntries");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddRouterStaticEntries");
        input.setAction("AddRouterStaticEntries");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddRouterStaticEntriesOutput.class);
        if (backModel != null) {
            return (AddRouterStaticEntriesOutput)backModel;
        }
        return null;
    }

    public void addRouterStaticEntries(AddRouterStaticEntriesInput input, ResponseCallBack<AddRouterStaticEntriesOutput> callback) throws QCException {
        if (input == null) {
            input = new AddRouterStaticEntriesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddRouterStaticEntries");
        context.put("APIName", "AddRouterStaticEntries");
        context.put("ServiceName", "AddRouterStaticEntries");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddRouterStaticEntries");
        input.setAction("AddRouterStaticEntries");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public AddRouterStaticsOutput addRouterStatics(AddRouterStaticsInput input) throws QCException {
        if (input == null) {
            input = new AddRouterStaticsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddRouterStatics");
        context.put("APIName", "AddRouterStatics");
        context.put("ServiceName", "AddRouterStatics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddRouterStatics");
        input.setAction("AddRouterStatics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddRouterStaticsOutput.class);
        if (backModel != null) {
            return (AddRouterStaticsOutput)backModel;
        }
        return null;
    }

    public void addRouterStatics(AddRouterStaticsInput input, ResponseCallBack<AddRouterStaticsOutput> callback) throws QCException {
        if (input == null) {
            input = new AddRouterStaticsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddRouterStatics");
        context.put("APIName", "AddRouterStatics");
        context.put("ServiceName", "AddRouterStatics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddRouterStatics");
        input.setAction("AddRouterStatics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateRoutersOutput createRouters(CreateRoutersInput input) throws QCException {
        if (input == null) {
            input = new CreateRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateRouters");
        context.put("APIName", "CreateRouters");
        context.put("ServiceName", "CreateRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateRouters");
        input.setAction("CreateRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateRoutersOutput.class);
        if (backModel != null) {
            return (CreateRoutersOutput)backModel;
        }
        return null;
    }

    public void createRouters(CreateRoutersInput input, ResponseCallBack<CreateRoutersOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateRouters");
        context.put("APIName", "CreateRouters");
        context.put("ServiceName", "CreateRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateRouters");
        input.setAction("CreateRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteRouterStaticEntriesOutput deleteRouterStaticEntries(DeleteRouterStaticEntriesInput input) throws QCException {
        if (input == null) {
            input = new DeleteRouterStaticEntriesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRouterStaticEntries");
        context.put("APIName", "DeleteRouterStaticEntries");
        context.put("ServiceName", "DeleteRouterStaticEntries");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRouterStaticEntries");
        input.setAction("DeleteRouterStaticEntries");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteRouterStaticEntriesOutput.class);
        if (backModel != null) {
            return (DeleteRouterStaticEntriesOutput)backModel;
        }
        return null;
    }

    public void deleteRouterStaticEntries(DeleteRouterStaticEntriesInput input, ResponseCallBack<DeleteRouterStaticEntriesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteRouterStaticEntriesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRouterStaticEntries");
        context.put("APIName", "DeleteRouterStaticEntries");
        context.put("ServiceName", "DeleteRouterStaticEntries");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRouterStaticEntries");
        input.setAction("DeleteRouterStaticEntries");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteRouterStaticsOutput deleteRouterStatics(DeleteRouterStaticsInput input) throws QCException {
        if (input == null) {
            input = new DeleteRouterStaticsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRouterStatics");
        context.put("APIName", "DeleteRouterStatics");
        context.put("ServiceName", "DeleteRouterStatics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRouterStatics");
        input.setAction("DeleteRouterStatics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteRouterStaticsOutput.class);
        if (backModel != null) {
            return (DeleteRouterStaticsOutput)backModel;
        }
        return null;
    }

    public void deleteRouterStatics(DeleteRouterStaticsInput input, ResponseCallBack<DeleteRouterStaticsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteRouterStaticsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRouterStatics");
        context.put("APIName", "DeleteRouterStatics");
        context.put("ServiceName", "DeleteRouterStatics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRouterStatics");
        input.setAction("DeleteRouterStatics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteRoutersOutput deleteRouters(DeleteRoutersInput input) throws QCException {
        if (input == null) {
            input = new DeleteRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRouters");
        context.put("APIName", "DeleteRouters");
        context.put("ServiceName", "DeleteRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRouters");
        input.setAction("DeleteRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteRoutersOutput.class);
        if (backModel != null) {
            return (DeleteRoutersOutput)backModel;
        }
        return null;
    }

    public void deleteRouters(DeleteRoutersInput input, ResponseCallBack<DeleteRoutersOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteRouters");
        context.put("APIName", "DeleteRouters");
        context.put("ServiceName", "DeleteRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteRouters");
        input.setAction("DeleteRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeRouterStaticEntriesOutput describeRouterStaticEntries(DescribeRouterStaticEntriesInput input) throws QCException {
        if (input == null) {
            input = new DescribeRouterStaticEntriesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouterStaticEntries");
        context.put("APIName", "DescribeRouterStaticEntries");
        context.put("ServiceName", "DescribeRouterStaticEntries");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouterStaticEntries");
        input.setAction("DescribeRouterStaticEntries");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeRouterStaticEntriesOutput.class);
        if (backModel != null) {
            return (DescribeRouterStaticEntriesOutput)backModel;
        }
        return null;
    }

    public void describeRouterStaticEntries(DescribeRouterStaticEntriesInput input, ResponseCallBack<DescribeRouterStaticEntriesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeRouterStaticEntriesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouterStaticEntries");
        context.put("APIName", "DescribeRouterStaticEntries");
        context.put("ServiceName", "DescribeRouterStaticEntries");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouterStaticEntries");
        input.setAction("DescribeRouterStaticEntries");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeRouterStaticsOutput describeRouterStatics(DescribeRouterStaticsInput input) throws QCException {
        if (input == null) {
            input = new DescribeRouterStaticsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouterStatics");
        context.put("APIName", "DescribeRouterStatics");
        context.put("ServiceName", "DescribeRouterStatics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouterStatics");
        input.setAction("DescribeRouterStatics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeRouterStaticsOutput.class);
        if (backModel != null) {
            return (DescribeRouterStaticsOutput)backModel;
        }
        return null;
    }

    public void describeRouterStatics(DescribeRouterStaticsInput input, ResponseCallBack<DescribeRouterStaticsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeRouterStaticsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouterStatics");
        context.put("APIName", "DescribeRouterStatics");
        context.put("ServiceName", "DescribeRouterStatics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouterStatics");
        input.setAction("DescribeRouterStatics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeRouterVxNetsOutput describeRouterVxNets(DescribeRouterVxNetsInput input) throws QCException {
        if (input == null) {
            input = new DescribeRouterVxNetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouterVxnets");
        context.put("APIName", "DescribeRouterVxnets");
        context.put("ServiceName", "DescribeRouterVxnets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouterVxnets");
        input.setAction("DescribeRouterVxnets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeRouterVxNetsOutput.class);
        if (backModel != null) {
            return (DescribeRouterVxNetsOutput)backModel;
        }
        return null;
    }

    public void describeRouterVxNets(DescribeRouterVxNetsInput input, ResponseCallBack<DescribeRouterVxNetsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeRouterVxNetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouterVxNets");
        context.put("APIName", "DescribeRouterVxNets");
        context.put("ServiceName", "DescribeRouterVxnets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouterVxnets");
        input.setAction("DescribeRouterVxNets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeRoutersOutput describeRouters(DescribeRoutersInput input) throws QCException {
        if (input == null) {
            input = new DescribeRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouters");
        context.put("APIName", "DescribeRouters");
        context.put("ServiceName", "DescribeRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouters");
        input.setAction("DescribeRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeRoutersOutput.class);
        if (backModel != null) {
            return (DescribeRoutersOutput)backModel;
        }
        return null;
    }

    public void describeRouters(DescribeRoutersInput input, ResponseCallBack<DescribeRoutersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeRouters");
        context.put("APIName", "DescribeRouters");
        context.put("ServiceName", "DescribeRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeRouters");
        input.setAction("DescribeRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetRouterMonitorOutput getRouterMonitor(GetRouterMonitorInput input) throws QCException {
        if (input == null) {
            input = new GetRouterMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetRouterMonitor");
        context.put("APIName", "GetRouterMonitor");
        context.put("ServiceName", "GetMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetRouterMonitor");
        input.setAction("GetRouterMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetRouterMonitorOutput.class);
        if (backModel != null) {
            return (GetRouterMonitorOutput)backModel;
        }
        return null;
    }

    public void getRouterMonitor(GetRouterMonitorInput input, ResponseCallBack<GetRouterMonitorOutput> callback) throws QCException {
        if (input == null) {
            input = new GetRouterMonitorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetRouterMonitor");
        context.put("APIName", "GetRouterMonitor");
        context.put("ServiceName", "GetMonitor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetRouterMonitor");
        input.setAction("GetRouterMonitor");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetVPNCertsOutput getVPNCerts(GetVPNCertsInput input) throws QCException {
        if (input == null) {
            input = new GetVPNCertsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetVPNCerts");
        context.put("APIName", "GetVPNCerts");
        context.put("ServiceName", "GetVPNCerts");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetVPNCerts");
        input.setAction("GetVPNCerts");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetVPNCertsOutput.class);
        if (backModel != null) {
            return (GetVPNCertsOutput)backModel;
        }
        return null;
    }

    public void getVPNCerts(GetVPNCertsInput input, ResponseCallBack<GetVPNCertsOutput> callback) throws QCException {
        if (input == null) {
            input = new GetVPNCertsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetVPNCerts");
        context.put("APIName", "GetVPNCerts");
        context.put("ServiceName", "GetVPNCerts");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetVPNCerts");
        input.setAction("GetVPNCerts");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public JoinRouterOutput joinRouter(JoinRouterInput input) throws QCException {
        if (input == null) {
            input = new JoinRouterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "JoinRouter");
        context.put("APIName", "JoinRouter");
        context.put("ServiceName", "JoinRouter");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/JoinRouter");
        input.setAction("JoinRouter");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, JoinRouterOutput.class);
        if (backModel != null) {
            return (JoinRouterOutput)backModel;
        }
        return null;
    }

    public void joinRouter(JoinRouterInput input, ResponseCallBack<JoinRouterOutput> callback) throws QCException {
        if (input == null) {
            input = new JoinRouterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "JoinRouter");
        context.put("APIName", "JoinRouter");
        context.put("ServiceName", "JoinRouter");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/JoinRouter");
        input.setAction("JoinRouter");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public LeaveRouterOutput leaveRouter(LeaveRouterInput input) throws QCException {
        if (input == null) {
            input = new LeaveRouterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "LeaveRouter");
        context.put("APIName", "LeaveRouter");
        context.put("ServiceName", "LeaveRouter");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/LeaveRouter");
        input.setAction("LeaveRouter");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, LeaveRouterOutput.class);
        if (backModel != null) {
            return (LeaveRouterOutput)backModel;
        }
        return null;
    }

    public void leaveRouter(LeaveRouterInput input, ResponseCallBack<LeaveRouterOutput> callback) throws QCException {
        if (input == null) {
            input = new LeaveRouterInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "LeaveRouter");
        context.put("APIName", "LeaveRouter");
        context.put("ServiceName", "LeaveRouter");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/LeaveRouter");
        input.setAction("LeaveRouter");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyRouterAttributesOutput modifyRouterAttributes(ModifyRouterAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyRouterAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRouterAttributes");
        context.put("APIName", "ModifyRouterAttributes");
        context.put("ServiceName", "ModifyRouterAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRouterAttributes");
        input.setAction("ModifyRouterAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyRouterAttributesOutput.class);
        if (backModel != null) {
            return (ModifyRouterAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyRouterAttributes(ModifyRouterAttributesInput input, ResponseCallBack<ModifyRouterAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyRouterAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRouterAttributes");
        context.put("APIName", "ModifyRouterAttributes");
        context.put("ServiceName", "ModifyRouterAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRouterAttributes");
        input.setAction("ModifyRouterAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyRouterStaticAttributesOutput modifyRouterStaticAttributes(ModifyRouterStaticAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyRouterStaticAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRouterStaticAttributes");
        context.put("APIName", "ModifyRouterStaticAttributes");
        context.put("ServiceName", "ModifyRouterStaticAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRouterStaticAttributes");
        input.setAction("ModifyRouterStaticAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyRouterStaticAttributesOutput.class);
        if (backModel != null) {
            return (ModifyRouterStaticAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyRouterStaticAttributes(ModifyRouterStaticAttributesInput input, ResponseCallBack<ModifyRouterStaticAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyRouterStaticAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRouterStaticAttributes");
        context.put("APIName", "ModifyRouterStaticAttributes");
        context.put("ServiceName", "ModifyRouterStaticAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRouterStaticAttributes");
        input.setAction("ModifyRouterStaticAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyRouterStaticEntryAttributesOutput modifyRouterStaticEntryAttributes(ModifyRouterStaticEntryAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyRouterStaticEntryAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRouterStaticEntryAttributes");
        context.put("APIName", "ModifyRouterStaticEntryAttributes");
        context.put("ServiceName", "ModifyRouterStaticEntryAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRouterStaticEntryAttributes");
        input.setAction("ModifyRouterStaticEntryAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyRouterStaticEntryAttributesOutput.class);
        if (backModel != null) {
            return (ModifyRouterStaticEntryAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyRouterStaticEntryAttributes(ModifyRouterStaticEntryAttributesInput input, ResponseCallBack<ModifyRouterStaticEntryAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyRouterStaticEntryAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyRouterStaticEntryAttributes");
        context.put("APIName", "ModifyRouterStaticEntryAttributes");
        context.put("ServiceName", "ModifyRouterStaticEntryAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyRouterStaticEntryAttributes");
        input.setAction("ModifyRouterStaticEntryAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public PowerOffRoutersOutput powerOffRouters(PowerOffRoutersInput input) throws QCException {
        if (input == null) {
            input = new PowerOffRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "PowerOffRouters");
        context.put("APIName", "PowerOffRouters");
        context.put("ServiceName", "PowerOffRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/PowerOffRouters");
        input.setAction("PowerOffRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, PowerOffRoutersOutput.class);
        if (backModel != null) {
            return (PowerOffRoutersOutput)backModel;
        }
        return null;
    }

    public void powerOffRouters(PowerOffRoutersInput input, ResponseCallBack<PowerOffRoutersOutput> callback) throws QCException {
        if (input == null) {
            input = new PowerOffRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "PowerOffRouters");
        context.put("APIName", "PowerOffRouters");
        context.put("ServiceName", "PowerOffRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/PowerOffRouters");
        input.setAction("PowerOffRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public PowerOnRoutersOutput powerOnRouters(PowerOnRoutersInput input) throws QCException {
        if (input == null) {
            input = new PowerOnRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "PowerOnRouters");
        context.put("APIName", "PowerOnRouters");
        context.put("ServiceName", "PowerOnRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/PowerOnRouters");
        input.setAction("PowerOnRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, PowerOnRoutersOutput.class);
        if (backModel != null) {
            return (PowerOnRoutersOutput)backModel;
        }
        return null;
    }

    public void powerOnRouters(PowerOnRoutersInput input, ResponseCallBack<PowerOnRoutersOutput> callback) throws QCException {
        if (input == null) {
            input = new PowerOnRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "PowerOnRouters");
        context.put("APIName", "PowerOnRouters");
        context.put("ServiceName", "PowerOnRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/PowerOnRouters");
        input.setAction("PowerOnRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public UpdateRoutersOutput updateRouters(UpdateRoutersInput input) throws QCException {
        if (input == null) {
            input = new UpdateRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateRouters");
        context.put("APIName", "UpdateRouters");
        context.put("ServiceName", "UpdateRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateRouters");
        input.setAction("UpdateRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, UpdateRoutersOutput.class);
        if (backModel != null) {
            return (UpdateRoutersOutput)backModel;
        }
        return null;
    }

    public void updateRouters(UpdateRoutersInput input, ResponseCallBack<UpdateRoutersOutput> callback) throws QCException {
        if (input == null) {
            input = new UpdateRoutersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UpdateRouters");
        context.put("APIName", "UpdateRouters");
        context.put("ServiceName", "UpdateRouters");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/UpdateRouters");
        input.setAction("UpdateRouters");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UpdateRoutersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class UpdateRoutersInput
    extends IaasParamBody {
        private List<String> routers;

        @JsonProperty(value="routers")
        public void setRouters(List<String> routers) {
            this.routers = routers;
        }

        @JsonProperty(value="routers")
        public List<String> getRouters() {
            return this.routers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PowerOnRoutersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class PowerOnRoutersInput
    extends IaasParamBody {
        private List<String> routers;

        @JsonProperty(value="routers")
        public void setRouters(List<String> routers) {
            this.routers = routers;
        }

        @JsonProperty(value="routers")
        public List<String> getRouters() {
            return this.routers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PowerOffRoutersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class PowerOffRoutersInput
    extends IaasParamBody {
        private List<String> routers;

        @JsonProperty(value="routers")
        public void setRouters(List<String> routers) {
            this.routers = routers;
        }

        @JsonProperty(value="routers")
        public List<String> getRouters() {
            return this.routers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyRouterStaticEntryAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String routerStaticEntry;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_static_entry")
        public void setRouterStaticEntry(String routerStaticEntry) {
            this.routerStaticEntry = routerStaticEntry;
        }

        @JsonProperty(value="router_static_entry")
        public String getRouterStaticEntry() {
            return this.routerStaticEntry;
        }
    }

    public static class ModifyRouterStaticEntryAttributesInput
    extends IaasParamBody {
        private String routerStaticEntry;
        private String routerStaticEntryName;
        private String val1;
        private String val2;

        @JsonProperty(value="router_static_entry")
        public void setRouterStaticEntry(String routerStaticEntry) {
            this.routerStaticEntry = routerStaticEntry;
        }

        @JsonProperty(value="router_static_entry")
        public String getRouterStaticEntry() {
            return this.routerStaticEntry;
        }

        @JsonProperty(value="router_static_entry_name")
        public void setRouterStaticEntryName(String routerStaticEntryName) {
            this.routerStaticEntryName = routerStaticEntryName;
        }

        @JsonProperty(value="router_static_entry_name")
        public String getRouterStaticEntryName() {
            return this.routerStaticEntryName;
        }

        @JsonProperty(value="val1")
        public void setVal1(String val1) {
            this.val1 = val1;
        }

        @JsonProperty(value="val1")
        public String getVal1() {
            return this.val1;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRouterStaticEntry())) {
                throw new QCException("RouterStaticEntry is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyRouterStaticAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String routerStaticID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_static_id")
        public void setRouterStaticID(String routerStaticID) {
            this.routerStaticID = routerStaticID;
        }

        @JsonProperty(value="router_static_id")
        public String getRouterStaticID() {
            return this.routerStaticID;
        }
    }

    public static class ModifyRouterStaticAttributesInput
    extends IaasParamBody {
        private String routerStatic;
        private String routerStaticName;
        private String val1;
        private String val2;
        private String val3;
        private String val4;
        private String val5;
        private String val6;
        private String val7;
        private String val8;
        private String val9;

        @JsonProperty(value="router_static")
        public void setRouterStatic(String routerStatic) {
            this.routerStatic = routerStatic;
        }

        @JsonProperty(value="router_static")
        public String getRouterStatic() {
            return this.routerStatic;
        }

        @JsonProperty(value="router_static_name")
        public void setRouterStaticName(String routerStaticName) {
            this.routerStaticName = routerStaticName;
        }

        @JsonProperty(value="router_static_name")
        public String getRouterStaticName() {
            return this.routerStaticName;
        }

        @JsonProperty(value="val1")
        public void setVal1(String val1) {
            this.val1 = val1;
        }

        @JsonProperty(value="val1")
        public String getVal1() {
            return this.val1;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @JsonProperty(value="val3")
        public void setVal3(String val3) {
            this.val3 = val3;
        }

        @JsonProperty(value="val3")
        public String getVal3() {
            return this.val3;
        }

        @JsonProperty(value="val4")
        public void setVal4(String val4) {
            this.val4 = val4;
        }

        @JsonProperty(value="val4")
        public String getVal4() {
            return this.val4;
        }

        @JsonProperty(value="val5")
        public void setVal5(String val5) {
            this.val5 = val5;
        }

        @JsonProperty(value="val5")
        public String getVal5() {
            return this.val5;
        }

        @JsonProperty(value="val6")
        public void setVal6(String val6) {
            this.val6 = val6;
        }

        @JsonProperty(value="val6")
        public String getVal6() {
            return this.val6;
        }

        @JsonProperty(value="val7")
        public void setVal7(String val7) {
            this.val7 = val7;
        }

        @JsonProperty(value="val7")
        public String getVal7() {
            return this.val7;
        }

        @JsonProperty(value="val8")
        public void setVal8(String val8) {
            this.val8 = val8;
        }

        @JsonProperty(value="val8")
        public String getVal8() {
            return this.val8;
        }

        @JsonProperty(value="val9")
        public void setVal9(String val9) {
            this.val9 = val9;
        }

        @JsonProperty(value="val9")
        public String getVal9() {
            return this.val9;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRouterStatic())) {
                throw new QCException("RouterStatic is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyRouterAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyRouterAttributesInput
    extends IaasParamBody {
        private String description;
        private String dYNIPEnd;
        private String dYNIPStart;
        private String eIP;
        private Integer features;
        private String router;
        private String routerName;
        private String securityGroup;
        private String vxNet;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="dyn_ip_end")
        public void setDYNIPEnd(String dYNIPEnd) {
            this.dYNIPEnd = dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_end")
        public String getDYNIPEnd() {
            return this.dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_start")
        public void setDYNIPStart(String dYNIPStart) {
            this.dYNIPStart = dYNIPStart;
        }

        @JsonProperty(value="dyn_ip_start")
        public String getDYNIPStart() {
            return this.dYNIPStart;
        }

        @JsonProperty(value="eip")
        public void setEIP(String eIP) {
            this.eIP = eIP;
        }

        @JsonProperty(value="eip")
        public String getEIP() {
            return this.eIP;
        }

        @JsonProperty(value="features")
        public void setFeatures(Integer features) {
            this.features = features;
        }

        @JsonProperty(value="features")
        public Integer getFeatures() {
            return this.features;
        }

        @JsonProperty(value="router")
        public void setRouter(String router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public String getRouter() {
            return this.router;
        }

        @JsonProperty(value="router_name")
        public void setRouterName(String routerName) {
            this.routerName = routerName;
        }

        @JsonProperty(value="router_name")
        public String getRouterName() {
            return this.routerName;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            String[] featuresValidValues = new String[]{"1", "2"};
            boolean featuresIsValid = false;
            for (String v : featuresValidValues) {
                Boolean featuresIsRequired;
                if (v.equals(this.getFeatures() + "")) {
                    featuresIsValid = true;
                }
                if (!(featuresIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getFeatures() != null) continue;
                featuresIsValid = true;
            }
            if (!featuresIsValid) {
                throw new QCException("Features value " + this.getFeatures() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getRouter())) {
                throw new QCException("Router is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LeaveRouterOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;
        private String routerID;
        private List<String> vxNets;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_id")
        public void setRouterID(String routerID) {
            this.routerID = routerID;
        }

        @JsonProperty(value="router_id")
        public String getRouterID() {
            return this.routerID;
        }

        @JsonProperty(value="vxnets")
        public void setVxNets(List<String> vxNets) {
            this.vxNets = vxNets;
        }

        @JsonProperty(value="vxnets")
        public List<String> getVxNets() {
            return this.vxNets;
        }
    }

    public static class LeaveRouterInput
    extends IaasParamBody {
        private String router;
        private List<String> vxNets;

        @JsonProperty(value="router")
        public void setRouter(String router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public String getRouter() {
            return this.router;
        }

        @JsonProperty(value="vxnets")
        public void setVxNets(List<String> vxNets) {
            this.vxNets = vxNets;
        }

        @JsonProperty(value="vxnets")
        public List<String> getVxNets() {
            return this.vxNets;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRouter())) {
                throw new QCException("Router is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JoinRouterOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;
        private String routerID;
        private String vxNetID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_id")
        public void setRouterID(String routerID) {
            this.routerID = routerID;
        }

        @JsonProperty(value="router_id")
        public String getRouterID() {
            return this.routerID;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }
    }

    public static class JoinRouterInput
    extends IaasParamBody {
        private String dYNIPEnd;
        private String dYNIPStart;
        private Integer features;
        private String iPNetwork;
        private String managerIP;
        private String router;
        private String vxNet;

        @JsonProperty(value="dyn_ip_end")
        public void setDYNIPEnd(String dYNIPEnd) {
            this.dYNIPEnd = dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_end")
        public String getDYNIPEnd() {
            return this.dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_start")
        public void setDYNIPStart(String dYNIPStart) {
            this.dYNIPStart = dYNIPStart;
        }

        @JsonProperty(value="dyn_ip_start")
        public String getDYNIPStart() {
            return this.dYNIPStart;
        }

        @JsonProperty(value="features")
        public void setFeatures(Integer features) {
            this.features = features;
        }

        @JsonProperty(value="features")
        public Integer getFeatures() {
            return this.features;
        }

        @JsonProperty(value="ip_network")
        public void setIPNetwork(String iPNetwork) {
            this.iPNetwork = iPNetwork;
        }

        @JsonProperty(value="ip_network")
        public String getIPNetwork() {
            return this.iPNetwork;
        }

        @JsonProperty(value="manager_ip")
        public void setManagerIP(String managerIP) {
            this.managerIP = managerIP;
        }

        @JsonProperty(value="manager_ip")
        public String getManagerIP() {
            return this.managerIP;
        }

        @JsonProperty(value="router")
        public void setRouter(String router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public String getRouter() {
            return this.router;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            String[] featuresValidValues = new String[]{"1"};
            boolean featuresIsValid = false;
            for (String v : featuresValidValues) {
                Boolean featuresIsRequired;
                if (v.equals(this.getFeatures() + "")) {
                    featuresIsValid = true;
                }
                if (!(featuresIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getFeatures() != null) continue;
                featuresIsValid = true;
            }
            if (!featuresIsValid) {
                throw new QCException("Features value " + this.getFeatures() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getIPNetwork())) {
                throw new QCException("IPNetwork is required");
            }
            if (QCStringUtil.isEmpty(this.getRouter())) {
                throw new QCException("Router is required");
            }
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetVPNCertsOutput
    extends OutputModel {
        private String action;
        private String caCert;
        private String clientCrt;
        private String clientKey;
        private String linuxConfSample;
        private String macConfSample;
        private String platform;
        private Integer retCode;
        private String routerID;
        private String staticKey;
        private String windowsConfSample;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="ca_cert")
        public void setCaCert(String caCert) {
            this.caCert = caCert;
        }

        @JsonProperty(value="ca_cert")
        public String getCaCert() {
            return this.caCert;
        }

        @JsonProperty(value="client_crt")
        public void setClientCrt(String clientCrt) {
            this.clientCrt = clientCrt;
        }

        @JsonProperty(value="client_crt")
        public String getClientCrt() {
            return this.clientCrt;
        }

        @JsonProperty(value="client_key")
        public void setClientKey(String clientKey) {
            this.clientKey = clientKey;
        }

        @JsonProperty(value="client_key")
        public String getClientKey() {
            return this.clientKey;
        }

        @JsonProperty(value="linux_conf_sample")
        public void setLinuxConfSample(String linuxConfSample) {
            this.linuxConfSample = linuxConfSample;
        }

        @JsonProperty(value="linux_conf_sample")
        public String getLinuxConfSample() {
            return this.linuxConfSample;
        }

        @JsonProperty(value="mac_conf_sample")
        public void setMacConfSample(String macConfSample) {
            this.macConfSample = macConfSample;
        }

        @JsonProperty(value="mac_conf_sample")
        public String getMacConfSample() {
            return this.macConfSample;
        }

        @JsonProperty(value="platform")
        public void setPlatform(String platform) {
            this.platform = platform;
        }

        @JsonProperty(value="platform")
        public String getPlatform() {
            return this.platform;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_id")
        public void setRouterID(String routerID) {
            this.routerID = routerID;
        }

        @JsonProperty(value="router_id")
        public String getRouterID() {
            return this.routerID;
        }

        @JsonProperty(value="static_key")
        public void setStaticKey(String staticKey) {
            this.staticKey = staticKey;
        }

        @JsonProperty(value="static_key")
        public String getStaticKey() {
            return this.staticKey;
        }

        @JsonProperty(value="windows_conf_sample")
        public void setWindowsConfSample(String windowsConfSample) {
            this.windowsConfSample = windowsConfSample;
        }

        @JsonProperty(value="windows_conf_sample")
        public String getWindowsConfSample() {
            return this.windowsConfSample;
        }
    }

    public static class GetVPNCertsInput
    extends IaasParamBody {
        private String platform;
        private String router;

        @JsonProperty(value="platform")
        public void setPlatform(String platform) {
            this.platform = platform;
        }

        @JsonProperty(value="platform")
        public String getPlatform() {
            return this.platform;
        }

        @JsonProperty(value="router")
        public void setRouter(String router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public String getRouter() {
            return this.router;
        }

        @Override
        public String validateParam() throws QCException {
            String[] platformValidValues = new String[]{"windows", "linux", "mac"};
            boolean platformIsValid = false;
            for (String v : platformValidValues) {
                Boolean platformIsRequired;
                if (v.equals(this.getPlatform())) {
                    platformIsValid = true;
                }
                if (!(platformIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getPlatform() != null) continue;
                platformIsValid = true;
            }
            if (!platformIsValid) {
                throw new QCException("Platform value " + this.getPlatform() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getRouter())) {
                throw new QCException("Router is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetRouterMonitorOutput
    extends OutputModel {
        private String action;
        private List<Types.MeterModel> meterSet;
        private String resourceID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="meter_set")
        public void setMeterSet(List<Types.MeterModel> meterSet) {
            this.meterSet = meterSet;
        }

        @JsonProperty(value="meter_set")
        public List<Types.MeterModel> getMeterSet() {
            return this.meterSet;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetRouterMonitorInput
    extends IaasParamBody {
        private String endTime;
        private List<String> meters;
        private String resource;
        private String startTime;
        private String step;

        @JsonProperty(value="end_time")
        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @JsonProperty(value="end_time")
        public String getEndTime() {
            return this.endTime;
        }

        @JsonProperty(value="meters")
        public void setMeters(List<String> meters) {
            this.meters = meters;
        }

        @JsonProperty(value="meters")
        public List<String> getMeters() {
            return this.meters;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public String getResource() {
            return this.resource;
        }

        @JsonProperty(value="start_time")
        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @JsonProperty(value="start_time")
        public String getStartTime() {
            return this.startTime;
        }

        @JsonProperty(value="step")
        public void setStep(String step) {
            this.step = step;
        }

        @JsonProperty(value="step")
        public String getStep() {
            return this.step;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getResource())) {
                throw new QCException("Resource is required");
            }
            if (QCStringUtil.isEmpty(this.getStep())) {
                throw new QCException("Step is required");
            }
            String[] stepValidValues = new String[]{"5m", "15m", "2h", "1d"};
            boolean stepIsValid = false;
            for (String v : stepValidValues) {
                Boolean stepIsRequired;
                if (v.equals(this.getStep())) {
                    stepIsValid = true;
                }
                if (!(stepIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getStep() != null) continue;
                stepIsValid = true;
            }
            if (!stepIsValid) {
                throw new QCException("Step value " + this.getStep() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeRoutersOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.RouterModel> routerSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_set")
        public void setRouterSet(List<Types.RouterModel> routerSet) {
            this.routerSet = routerSet;
        }

        @JsonProperty(value="router_set")
        public List<Types.RouterModel> getRouterSet() {
            return this.routerSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeRoutersInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String owner;
        private List<String> routers;
        private String searchWord;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;
        private String vxNet;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="routers")
        public void setRouters(List<String> routers) {
            this.routers = routers;
        }

        @JsonProperty(value="routers")
        public List<String> getRouters() {
            return this.routers;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            String[] verboseValidValues = new String[]{"0", "1"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeRouterVxNetsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.RouterVxNetModel> routerVxNetSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_vxnet_set")
        public void setRouterVxNetSet(List<Types.RouterVxNetModel> routerVxNetSet) {
            this.routerVxNetSet = routerVxNetSet;
        }

        @JsonProperty(value="router_vxnet_set")
        public List<Types.RouterVxNetModel> getRouterVxNetSet() {
            return this.routerVxNetSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeRouterVxNetsInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String router;
        private Integer verbose;
        private String vxNet;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="router")
        public void setRouter(String router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public String getRouter() {
            return this.router;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRouter())) {
                throw new QCException("Router is required");
            }
            String[] verboseValidValues = new String[]{"0", "1"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeRouterStaticsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.RouterStaticModel> routerStaticSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_static_set")
        public void setRouterStaticSet(List<Types.RouterStaticModel> routerStaticSet) {
            this.routerStaticSet = routerStaticSet;
        }

        @JsonProperty(value="router_static_set")
        public List<Types.RouterStaticModel> getRouterStaticSet() {
            return this.routerStaticSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeRouterStaticsInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String owner;
        private String router;
        private List<String> routerStatics;
        private Integer staticType;
        private Integer verbose;
        private String vxNet;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="router")
        public void setRouter(String router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public String getRouter() {
            return this.router;
        }

        @JsonProperty(value="router_statics")
        public void setRouterStatics(List<String> routerStatics) {
            this.routerStatics = routerStatics;
        }

        @JsonProperty(value="router_statics")
        public List<String> getRouterStatics() {
            return this.routerStatics;
        }

        @JsonProperty(value="static_type")
        public void setStaticType(Integer staticType) {
            this.staticType = staticType;
        }

        @JsonProperty(value="static_type")
        public Integer getStaticType() {
            return this.staticType;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getRouter())) {
                throw new QCException("Router is required");
            }
            String[] staticTypeValidValues = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
            boolean staticTypeIsValid = false;
            for (String v : staticTypeValidValues) {
                Boolean staticTypeIsRequired;
                if (v.equals(this.getStaticType() + "")) {
                    staticTypeIsValid = true;
                }
                if (!(staticTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStaticType() != null) continue;
                staticTypeIsValid = true;
            }
            if (!staticTypeIsValid) {
                throw new QCException("StaticType value " + this.getStaticType() + "is invalid");
            }
            String[] verboseValidValues = new String[]{"0", "1"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeRouterStaticEntriesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.RouterStaticEntryModel> routerStaticEntrySet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_static_entry_set")
        public void setRouterStaticEntrySet(List<Types.RouterStaticEntryModel> routerStaticEntrySet) {
            this.routerStaticEntrySet = routerStaticEntrySet;
        }

        @JsonProperty(value="router_static_entry_set")
        public List<Types.RouterStaticEntryModel> getRouterStaticEntrySet() {
            return this.routerStaticEntrySet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeRouterStaticEntriesInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String owner;
        private String routerStatic;
        private String routerStaticEntries;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="router_static")
        public void setRouterStatic(String routerStatic) {
            this.routerStatic = routerStatic;
        }

        @JsonProperty(value="router_static")
        public String getRouterStatic() {
            return this.routerStatic;
        }

        @JsonProperty(value="router_static_entries")
        public void setRouterStaticEntries(String routerStaticEntries) {
            this.routerStaticEntries = routerStaticEntries;
        }

        @JsonProperty(value="router_static_entries")
        public String getRouterStaticEntries() {
            return this.routerStaticEntries;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteRoutersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;
        private List<String> routers;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="routers")
        public void setRouters(List<String> routers) {
            this.routers = routers;
        }

        @JsonProperty(value="routers")
        public List<String> getRouters() {
            return this.routers;
        }
    }

    public static class DeleteRoutersInput
    extends IaasParamBody {
        private List<String> routers;

        @JsonProperty(value="routers")
        public void setRouters(List<String> routers) {
            this.routers = routers;
        }

        @JsonProperty(value="routers")
        public List<String> getRouters() {
            return this.routers;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteRouterStaticsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> routerStatics;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_statics")
        public void setRouterStatics(List<String> routerStatics) {
            this.routerStatics = routerStatics;
        }

        @JsonProperty(value="router_statics")
        public List<String> getRouterStatics() {
            return this.routerStatics;
        }
    }

    public static class DeleteRouterStaticsInput
    extends IaasParamBody {
        private List<String> routerStatics;

        @JsonProperty(value="router_statics")
        public void setRouterStatics(List<String> routerStatics) {
            this.routerStatics = routerStatics;
        }

        @JsonProperty(value="router_statics")
        public List<String> getRouterStatics() {
            return this.routerStatics;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteRouterStaticEntriesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> routerStaticEntries;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_static_entries")
        public void setRouterStaticEntries(List<String> routerStaticEntries) {
            this.routerStaticEntries = routerStaticEntries;
        }

        @JsonProperty(value="router_static_entries")
        public List<String> getRouterStaticEntries() {
            return this.routerStaticEntries;
        }
    }

    public static class DeleteRouterStaticEntriesInput
    extends IaasParamBody {
        private List<String> routerStaticEntries;

        @JsonProperty(value="router_static_entries")
        public void setRouterStaticEntries(List<String> routerStaticEntries) {
            this.routerStaticEntries = routerStaticEntries;
        }

        @JsonProperty(value="router_static_entries")
        public List<String> getRouterStaticEntries() {
            return this.routerStaticEntries;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateRoutersOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;
        private List<String> routers;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="routers")
        public void setRouters(List<String> routers) {
            this.routers = routers;
        }

        @JsonProperty(value="routers")
        public List<String> getRouters() {
            return this.routers;
        }
    }

    public static class CreateRoutersInput
    extends IaasParamBody {
        private Integer count;
        private String routerName;
        private Integer routerType;
        private String securityGroup;
        private String vpcNetwork;

        @JsonProperty(value="count")
        public void setCount(Integer count) {
            this.count = count;
        }

        @JsonProperty(value="count")
        public Integer getCount() {
            return this.count;
        }

        @JsonProperty(value="router_name")
        public void setRouterName(String routerName) {
            this.routerName = routerName;
        }

        @JsonProperty(value="router_name")
        public String getRouterName() {
            return this.routerName;
        }

        @JsonProperty(value="router_type")
        public void setRouterType(Integer routerType) {
            this.routerType = routerType;
        }

        @JsonProperty(value="router_type")
        public Integer getRouterType() {
            return this.routerType;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="vpc_network")
        public void setVpcNetwork(String vpcNetwork) {
            this.vpcNetwork = vpcNetwork;
        }

        @JsonProperty(value="vpc_network")
        public String getVpcNetwork() {
            return this.vpcNetwork;
        }

        @Override
        public String validateParam() throws QCException {
            String[] routerTypeValidValues = new String[]{"0", "1", "2", "3"};
            boolean routerTypeIsValid = false;
            for (String v : routerTypeValidValues) {
                Boolean routerTypeIsRequired;
                if (v.equals(this.getRouterType() + "")) {
                    routerTypeIsValid = true;
                }
                if (!(routerTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getRouterType() != null) continue;
                routerTypeIsValid = true;
            }
            if (!routerTypeIsValid) {
                throw new QCException("RouterType value " + this.getRouterType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddRouterStaticsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> routerStatics;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_statics")
        public void setRouterStatics(List<String> routerStatics) {
            this.routerStatics = routerStatics;
        }

        @JsonProperty(value="router_statics")
        public List<String> getRouterStatics() {
            return this.routerStatics;
        }
    }

    public static class AddRouterStaticsInput
    extends IaasParamBody {
        private String router;
        private List<Types.RouterStaticModel> statics;
        private String vxNet;

        @JsonProperty(value="router")
        public void setRouter(String router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public String getRouter() {
            return this.router;
        }

        @JsonProperty(value="statics")
        public void setStatics(List<Types.RouterStaticModel> statics) {
            this.statics = statics;
        }

        @JsonProperty(value="statics")
        public List<Types.RouterStaticModel> getStatics() {
            return this.statics;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (QCStringUtil.isEmpty(this.getRouter())) {
                throw new QCException("Router is required");
            }
            if (this.getStatics() != null && this.getStatics().size() > 0 && (i = 0) < this.getStatics().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddRouterStaticEntriesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> routerStaticEntries;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="router_static_entries")
        public void setRouterStaticEntries(List<String> routerStaticEntries) {
            this.routerStaticEntries = routerStaticEntries;
        }

        @JsonProperty(value="router_static_entries")
        public List<String> getRouterStaticEntries() {
            return this.routerStaticEntries;
        }
    }

    public static class AddRouterStaticEntriesInput
    extends IaasParamBody {
        private List<Types.RouterStaticEntryModel> entries;
        private String routerStatic;

        @JsonProperty(value="entries")
        public void setEntries(List<Types.RouterStaticEntryModel> entries) {
            this.entries = entries;
        }

        @JsonProperty(value="entries")
        public List<Types.RouterStaticEntryModel> getEntries() {
            return this.entries;
        }

        @JsonProperty(value="router_static")
        public void setRouterStatic(String routerStatic) {
            this.routerStatic = routerStatic;
        }

        @JsonProperty(value="router_static")
        public String getRouterStatic() {
            return this.routerStatic;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getEntries() != null && this.getEntries().size() > 0 && (i = 0) < this.getEntries().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getRouterStatic())) {
                throw new QCException("RouterStatic is required");
            }
            return null;
        }
    }
}

