/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class SnapshotService {
    private EnvContext envContext;
    private String zone;

    public SnapshotService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public SnapshotService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public ApplySnapshotsOutput applySnapshots(ApplySnapshotsInput input) throws QCException {
        if (input == null) {
            input = new ApplySnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplySnapshots");
        context.put("APIName", "ApplySnapshots");
        context.put("ServiceName", "ApplySnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplySnapshots");
        input.setAction("ApplySnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ApplySnapshotsOutput.class);
        if (backModel != null) {
            return (ApplySnapshotsOutput)backModel;
        }
        return null;
    }

    public void applySnapshots(ApplySnapshotsInput input, ResponseCallBack<ApplySnapshotsOutput> callback) throws QCException {
        if (input == null) {
            input = new ApplySnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplySnapshots");
        context.put("APIName", "ApplySnapshots");
        context.put("ServiceName", "ApplySnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplySnapshots");
        input.setAction("ApplySnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CaptureInstanceFromSnapshotOutput captureInstanceFromSnapshot(CaptureInstanceFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CaptureInstanceFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CaptureInstanceFromSnapshot");
        context.put("APIName", "CaptureInstanceFromSnapshot");
        context.put("ServiceName", "CaptureInstanceFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CaptureInstanceFromSnapshot");
        input.setAction("CaptureInstanceFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CaptureInstanceFromSnapshotOutput.class);
        if (backModel != null) {
            return (CaptureInstanceFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void captureInstanceFromSnapshot(CaptureInstanceFromSnapshotInput input, ResponseCallBack<CaptureInstanceFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CaptureInstanceFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CaptureInstanceFromSnapshot");
        context.put("APIName", "CaptureInstanceFromSnapshot");
        context.put("ServiceName", "CaptureInstanceFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CaptureInstanceFromSnapshot");
        input.setAction("CaptureInstanceFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateSnapshotsOutput createSnapshots(CreateSnapshotsInput input) throws QCException {
        if (input == null) {
            input = new CreateSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSnapshots");
        context.put("APIName", "CreateSnapshots");
        context.put("ServiceName", "CreateSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSnapshots");
        input.setAction("CreateSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateSnapshotsOutput.class);
        if (backModel != null) {
            return (CreateSnapshotsOutput)backModel;
        }
        return null;
    }

    public void createSnapshots(CreateSnapshotsInput input, ResponseCallBack<CreateSnapshotsOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSnapshots");
        context.put("APIName", "CreateSnapshots");
        context.put("ServiceName", "CreateSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSnapshots");
        input.setAction("CreateSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateVolumeFromSnapshotOutput createVolumeFromSnapshot(CreateVolumeFromSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CreateVolumeFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateVolumeFromSnapshot");
        context.put("APIName", "CreateVolumeFromSnapshot");
        context.put("ServiceName", "CreateVolumeFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateVolumeFromSnapshot");
        input.setAction("CreateVolumeFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateVolumeFromSnapshotOutput.class);
        if (backModel != null) {
            return (CreateVolumeFromSnapshotOutput)backModel;
        }
        return null;
    }

    public void createVolumeFromSnapshot(CreateVolumeFromSnapshotInput input, ResponseCallBack<CreateVolumeFromSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateVolumeFromSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateVolumeFromSnapshot");
        context.put("APIName", "CreateVolumeFromSnapshot");
        context.put("ServiceName", "CreateVolumeFromSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateVolumeFromSnapshot");
        input.setAction("CreateVolumeFromSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteSnapshotsOutput deleteSnapshots(DeleteSnapshotsInput input) throws QCException {
        if (input == null) {
            input = new DeleteSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSnapshots");
        context.put("APIName", "DeleteSnapshots");
        context.put("ServiceName", "DeleteSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSnapshots");
        input.setAction("DeleteSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteSnapshotsOutput.class);
        if (backModel != null) {
            return (DeleteSnapshotsOutput)backModel;
        }
        return null;
    }

    public void deleteSnapshots(DeleteSnapshotsInput input, ResponseCallBack<DeleteSnapshotsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSnapshots");
        context.put("APIName", "DeleteSnapshots");
        context.put("ServiceName", "DeleteSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSnapshots");
        input.setAction("DeleteSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeSnapshotsOutput describeSnapshots(DescribeSnapshotsInput input) throws QCException {
        if (input == null) {
            input = new DescribeSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSnapshots");
        context.put("APIName", "DescribeSnapshots");
        context.put("ServiceName", "DescribeSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSnapshots");
        input.setAction("DescribeSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeSnapshotsOutput.class);
        if (backModel != null) {
            return (DescribeSnapshotsOutput)backModel;
        }
        return null;
    }

    public void describeSnapshots(DescribeSnapshotsInput input, ResponseCallBack<DescribeSnapshotsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSnapshots");
        context.put("APIName", "DescribeSnapshots");
        context.put("ServiceName", "DescribeSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSnapshots");
        input.setAction("DescribeSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifySnapshotAttributesOutput modifySnapshotAttributes(ModifySnapshotAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifySnapshotAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySnapshotAttributes");
        context.put("APIName", "ModifySnapshotAttributes");
        context.put("ServiceName", "ModifySnapshotAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySnapshotAttributes");
        input.setAction("ModifySnapshotAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifySnapshotAttributesOutput.class);
        if (backModel != null) {
            return (ModifySnapshotAttributesOutput)backModel;
        }
        return null;
    }

    public void modifySnapshotAttributes(ModifySnapshotAttributesInput input, ResponseCallBack<ModifySnapshotAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifySnapshotAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySnapshotAttributes");
        context.put("APIName", "ModifySnapshotAttributes");
        context.put("ServiceName", "ModifySnapshotAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySnapshotAttributes");
        input.setAction("ModifySnapshotAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifySnapshotAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifySnapshotAttributesInput
    extends IaasParamBody {
        private String description;
        private String snapshot;
        private String snapshotName;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @JsonProperty(value="snapshot_name")
        public void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @JsonProperty(value="snapshot_name")
        public String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSnapshot())) {
                throw new QCException("Snapshot is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeSnapshotsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.SnapshotModel> snapshotSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="snapshot_set")
        public void setSnapshotSet(List<Types.SnapshotModel> snapshotSet) {
            this.snapshotSet = snapshotSet;
        }

        @JsonProperty(value="snapshot_set")
        public List<Types.SnapshotModel> getSnapshotSet() {
            return this.snapshotSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeSnapshotsInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String owner;
        private String resourceID;
        private String searchWord;
        private String snapshotTime;
        private Integer snapshotType;
        private List<String> snapshots;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="snapshot_time")
        public void setSnapshotTime(String snapshotTime) {
            this.snapshotTime = snapshotTime;
        }

        @JsonProperty(value="snapshot_time")
        public String getSnapshotTime() {
            return this.snapshotTime;
        }

        @JsonProperty(value="snapshot_type")
        public void setSnapshotType(Integer snapshotType) {
            this.snapshotType = snapshotType;
        }

        @JsonProperty(value="snapshot_type")
        public Integer getSnapshotType() {
            return this.snapshotType;
        }

        @JsonProperty(value="snapshots")
        public void setSnapshots(List<String> snapshots) {
            this.snapshots = snapshots;
        }

        @JsonProperty(value="snapshots")
        public List<String> getSnapshots() {
            return this.snapshots;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            String[] snapshotTypeValidValues = new String[]{"0", "1"};
            boolean snapshotTypeIsValid = false;
            for (String v : snapshotTypeValidValues) {
                Boolean snapshotTypeIsRequired;
                if (v.equals(this.getSnapshotType() + "")) {
                    snapshotTypeIsValid = true;
                }
                if (!(snapshotTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getSnapshotType() != null) continue;
                snapshotTypeIsValid = true;
            }
            if (!snapshotTypeIsValid) {
                throw new QCException("SnapshotType value " + this.getSnapshotType() + "is invalid");
            }
            String[] verboseValidValues = new String[]{"0", "1"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteSnapshotsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteSnapshotsInput
    extends IaasParamBody {
        private List<String> snapshots;

        @JsonProperty(value="snapshots")
        public void setSnapshots(List<String> snapshots) {
            this.snapshots = snapshots;
        }

        @JsonProperty(value="snapshots")
        public List<String> getSnapshots() {
            return this.snapshots;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateVolumeFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;
        private String volumeID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="volume_id")
        public void setVolumeID(String volumeID) {
            this.volumeID = volumeID;
        }

        @JsonProperty(value="volume_id")
        public String getVolumeID() {
            return this.volumeID;
        }
    }

    public static class CreateVolumeFromSnapshotInput
    extends IaasParamBody {
        private String snapshot;
        private String volumeName;

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @JsonProperty(value="volume_name")
        public void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @JsonProperty(value="volume_name")
        public String getVolumeName() {
            return this.volumeName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSnapshot())) {
                throw new QCException("Snapshot is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateSnapshotsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;
        private List<String> snapshots;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="snapshots")
        public void setSnapshots(List<String> snapshots) {
            this.snapshots = snapshots;
        }

        @JsonProperty(value="snapshots")
        public List<String> getSnapshots() {
            return this.snapshots;
        }
    }

    public static class CreateSnapshotsInput
    extends IaasParamBody {
        private Integer isFull;
        private List<String> resources;
        private String serviceParams;
        private String snapshotName;

        @JsonProperty(value="is_full")
        public void setIsFull(Integer isFull) {
            this.isFull = isFull;
        }

        @JsonProperty(value="is_full")
        public Integer getIsFull() {
            return this.isFull;
        }

        @JsonProperty(value="resources")
        public void setResources(List<String> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="resources")
        public List<String> getResources() {
            return this.resources;
        }

        @JsonProperty(value="service_params")
        public void setServiceParams(String serviceParams) {
            this.serviceParams = serviceParams;
        }

        @JsonProperty(value="service_params")
        public String getServiceParams() {
            return this.serviceParams;
        }

        @JsonProperty(value="snapshot_name")
        public void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @JsonProperty(value="snapshot_name")
        public String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public String validateParam() throws QCException {
            String[] isFullValidValues = new String[]{"0", "1"};
            boolean isFullIsValid = false;
            for (String v : isFullValidValues) {
                Boolean isFullIsRequired;
                if (v.equals(this.getIsFull() + "")) {
                    isFullIsValid = true;
                }
                if (!(isFullIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsFull() != null) continue;
                isFullIsValid = true;
            }
            if (!isFullIsValid) {
                throw new QCException("IsFull value " + this.getIsFull() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CaptureInstanceFromSnapshotOutput
    extends OutputModel {
        private String action;
        private String imageID;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CaptureInstanceFromSnapshotInput
    extends IaasParamBody {
        private String imageName;
        private String snapshot;

        @JsonProperty(value="image_name")
        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @JsonProperty(value="image_name")
        public String getImageName() {
            return this.imageName;
        }

        @JsonProperty(value="snapshot")
        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        @JsonProperty(value="snapshot")
        public String getSnapshot() {
            return this.snapshot;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSnapshot())) {
                throw new QCException("Snapshot is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplySnapshotsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ApplySnapshotsInput
    extends IaasParamBody {
        private List<String> snapshots;

        @JsonProperty(value="snapshots")
        public void setSnapshots(List<String> snapshots) {
            this.snapshots = snapshots;
        }

        @JsonProperty(value="snapshots")
        public List<String> getSnapshots() {
            return this.snapshots;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }
}

