/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class TagService {
    private EnvContext envContext;
    private String zone;

    public TagService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public TagService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AttachTagsOutput attachTags(AttachTagsInput input) throws QCException {
        if (input == null) {
            input = new AttachTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AttachTags");
        context.put("APIName", "AttachTags");
        context.put("ServiceName", "AttachTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AttachTags");
        input.setAction("AttachTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AttachTagsOutput.class);
        if (backModel != null) {
            return (AttachTagsOutput)backModel;
        }
        return null;
    }

    public void attachTags(AttachTagsInput input, ResponseCallBack<AttachTagsOutput> callback) throws QCException {
        if (input == null) {
            input = new AttachTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AttachTags");
        context.put("APIName", "AttachTags");
        context.put("ServiceName", "AttachTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AttachTags");
        input.setAction("AttachTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateTagOutput createTag(CreateTagInput input) throws QCException {
        if (input == null) {
            input = new CreateTagInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateTag");
        context.put("APIName", "CreateTag");
        context.put("ServiceName", "CreateTag");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateTag");
        input.setAction("CreateTag");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateTagOutput.class);
        if (backModel != null) {
            return (CreateTagOutput)backModel;
        }
        return null;
    }

    public void createTag(CreateTagInput input, ResponseCallBack<CreateTagOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateTagInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateTag");
        context.put("APIName", "CreateTag");
        context.put("ServiceName", "CreateTag");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateTag");
        input.setAction("CreateTag");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteTagsOutput deleteTags(DeleteTagsInput input) throws QCException {
        if (input == null) {
            input = new DeleteTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteTags");
        context.put("APIName", "DeleteTags");
        context.put("ServiceName", "DeleteTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteTags");
        input.setAction("DeleteTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteTagsOutput.class);
        if (backModel != null) {
            return (DeleteTagsOutput)backModel;
        }
        return null;
    }

    public void deleteTags(DeleteTagsInput input, ResponseCallBack<DeleteTagsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteTags");
        context.put("APIName", "DeleteTags");
        context.put("ServiceName", "DeleteTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteTags");
        input.setAction("DeleteTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeTagsOutput describeTags(DescribeTagsInput input) throws QCException {
        if (input == null) {
            input = new DescribeTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeTags");
        context.put("APIName", "DescribeTags");
        context.put("ServiceName", "DescribeTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeTags");
        input.setAction("DescribeTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeTagsOutput.class);
        if (backModel != null) {
            return (DescribeTagsOutput)backModel;
        }
        return null;
    }

    public void describeTags(DescribeTagsInput input, ResponseCallBack<DescribeTagsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeTags");
        context.put("APIName", "DescribeTags");
        context.put("ServiceName", "DescribeTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeTags");
        input.setAction("DescribeTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DetachTagsOutput detachTags(DetachTagsInput input) throws QCException {
        if (input == null) {
            input = new DetachTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DetachTags");
        context.put("APIName", "DetachTags");
        context.put("ServiceName", "DetachTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DetachTags");
        input.setAction("DetachTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DetachTagsOutput.class);
        if (backModel != null) {
            return (DetachTagsOutput)backModel;
        }
        return null;
    }

    public void detachTags(DetachTagsInput input, ResponseCallBack<DetachTagsOutput> callback) throws QCException {
        if (input == null) {
            input = new DetachTagsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DetachTags");
        context.put("APIName", "DetachTags");
        context.put("ServiceName", "DetachTags");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DetachTags");
        input.setAction("DetachTags");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyTagAttributesOutput modifyTagAttributes(ModifyTagAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyTagAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyTagAttributes");
        context.put("APIName", "ModifyTagAttributes");
        context.put("ServiceName", "ModifyTagAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyTagAttributes");
        input.setAction("ModifyTagAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyTagAttributesOutput.class);
        if (backModel != null) {
            return (ModifyTagAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyTagAttributes(ModifyTagAttributesInput input, ResponseCallBack<ModifyTagAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyTagAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyTagAttributes");
        context.put("APIName", "ModifyTagAttributes");
        context.put("ServiceName", "ModifyTagAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyTagAttributes");
        input.setAction("ModifyTagAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyTagAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyTagAttributesInput
    extends IaasParamBody {
        private String color;
        private String description;
        private String tag;
        private String tagName;

        @JsonProperty(value="color")
        public void setColor(String color) {
            this.color = color;
        }

        @JsonProperty(value="color")
        public String getColor() {
            return this.color;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="tag")
        public void setTag(String tag) {
            this.tag = tag;
        }

        @JsonProperty(value="tag")
        public String getTag() {
            return this.tag;
        }

        @JsonProperty(value="tag_name")
        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        @JsonProperty(value="tag_name")
        public String getTagName() {
            return this.tagName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getTag())) {
                throw new QCException("Tag is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DetachTagsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DetachTagsInput
    extends IaasParamBody {
        private List<Types.ResourceTagPairModel> resourceTagPairs;

        @JsonProperty(value="resource_tag_pairs")
        public void setResourceTagPairs(List<Types.ResourceTagPairModel> resourceTagPairs) {
            this.resourceTagPairs = resourceTagPairs;
        }

        @JsonProperty(value="resource_tag_pairs")
        public List<Types.ResourceTagPairModel> getResourceTagPairs() {
            return this.resourceTagPairs;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getResourceTagPairs() != null && this.getResourceTagPairs().size() > 0 && (i = 0) < this.getResourceTagPairs().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeTagsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.TagModel> tagSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="tag_set")
        public void setTagSet(List<Types.TagModel> tagSet) {
            this.tagSet = tagSet;
        }

        @JsonProperty(value="tag_set")
        public List<Types.TagModel> getTagSet() {
            return this.tagSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeTagsInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String searchWord;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            String[] verboseValidValues = new String[]{"0", "1"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteTagsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> tags;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }
    }

    public static class DeleteTagsInput
    extends IaasParamBody {
        private List<String> tags;

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateTagOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String tagID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="tag_id")
        public void setTagID(String tagID) {
            this.tagID = tagID;
        }

        @JsonProperty(value="tag_id")
        public String getTagID() {
            return this.tagID;
        }
    }

    public static class CreateTagInput
    extends IaasParamBody {
        private String color;
        private String tagName;

        @JsonProperty(value="color")
        public void setColor(String color) {
            this.color = color;
        }

        @JsonProperty(value="color")
        public String getColor() {
            return this.color;
        }

        @JsonProperty(value="tag_name")
        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        @JsonProperty(value="tag_name")
        public String getTagName() {
            return this.tagName;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AttachTagsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class AttachTagsInput
    extends IaasParamBody {
        private List<Types.ResourceTagPairModel> resourceTagPairs;

        @JsonProperty(value="resource_tag_pairs")
        public void setResourceTagPairs(List<Types.ResourceTagPairModel> resourceTagPairs) {
            this.resourceTagPairs = resourceTagPairs;
        }

        @JsonProperty(value="resource_tag_pairs")
        public List<Types.ResourceTagPairModel> getResourceTagPairs() {
            return this.resourceTagPairs;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getResourceTagPairs() != null && this.getResourceTagPairs().size() > 0 && (i = 0) < this.getResourceTagPairs().size()) {
                return null;
            }
            return null;
        }
    }
}

