/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.request;

import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.model.RequestInputModel;
import com.qingcloud.sdk.request.QCOkHttpRequestClient;
import com.qingcloud.sdk.request.ResourceRequest;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.utils.QCJSONUtil;
import com.qingcloud.sdk.utils.QCParamInvokeUtil;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.Map;
import okhttp3.Request;

public class QCRequest
implements ResourceRequest {
    private Request buildRequest(Map context, RequestInputModel inputModel) throws QCException {
        String method = (String)context.get("RequestMethod");
        EnvContext envContext = (EnvContext)context.get("envContext");
        String requestUrl = envContext.getRequestUrl();
        String uri = QCJSONUtil.parseRequestParams(inputModel, envContext, method);
        if ("POST".equalsIgnoreCase(method)) {
            return QCOkHttpRequestClient.getInstance().buildPostRequest(requestUrl, uri);
        }
        return QCOkHttpRequestClient.getInstance().buildGetRequest(requestUrl, uri);
    }

    @Override
    public void sendApiRequestAsync(Map context, RequestInputModel inputModel, ResponseCallBack callback) throws QCException {
        String validate = inputModel.validateParam();
        EnvContext envContext = (EnvContext)context.get("envContext");
        String evnValidate = envContext.validateParam();
        if (!QCStringUtil.isEmpty(validate) || !QCStringUtil.isEmpty(evnValidate)) {
            if (QCStringUtil.isEmpty(validate)) {
                validate = evnValidate;
            }
            OutputModel out = QCParamInvokeUtil.getOutputModel(callback);
            QCOkHttpRequestClient.fillErrorModel(10000, validate, out);
            callback.onAPIResponse(out);
        } else {
            Request request = this.buildRequest(context, inputModel);
            QCOkHttpRequestClient.getInstance().requestActionAsync(request, envContext.isSafeOkHttp(), callback);
        }
    }

    @Override
    public OutputModel sendApiRequest(Map context, RequestInputModel inputModel, Class<? extends OutputModel> outputClass) throws QCException {
        String validate = inputModel.validateParam();
        EnvContext envContext = (EnvContext)context.get("envContext");
        String envValidate = envContext.validateParam();
        if (QCStringUtil.isEmpty(validate) && QCStringUtil.isEmpty(envValidate)) {
            Request request = this.buildRequest(context, inputModel);
            return QCOkHttpRequestClient.getInstance().requestAction(request, envContext.isSafeOkHttp(), outputClass);
        }
        return this.invalidParam(validate, envValidate, outputClass);
    }

    private OutputModel invalidParam(String validate, String envValidate, Class outputClass) {
        if (QCStringUtil.isEmpty(validate)) {
            validate = envValidate;
        }
        OutputModel model = null;
        try {
            model = (OutputModel)outputClass.newInstance();
            QCOkHttpRequestClient.fillErrorModel(10000, validate, model);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return model;
    }
}

