/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class AccesskeyService {
    private EnvContext envContext;
    private String zone;

    public AccesskeyService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public AccesskeyService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public DeleteAccessKeysOutput deleteAccessKeys(DeleteAccessKeysInput input) throws QCException {
        if (input == null) {
            input = new DeleteAccessKeysInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteAccessKeys");
        context.put("APIName", "DeleteAccessKeys");
        context.put("ServiceName", "DeleteAccessKeys");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteAccessKeys");
        input.setAction("DeleteAccessKeys");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteAccessKeysOutput.class);
        if (backModel != null) {
            return (DeleteAccessKeysOutput)backModel;
        }
        return null;
    }

    public void deleteAccessKeys(DeleteAccessKeysInput input, ResponseCallBack<DeleteAccessKeysOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteAccessKeysInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteAccessKeys");
        context.put("APIName", "DeleteAccessKeys");
        context.put("ServiceName", "DeleteAccessKeys");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteAccessKeys");
        input.setAction("DeleteAccessKeys");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeAccessKeysOutput describeAccessKeys(DescribeAccessKeysInput input) throws QCException {
        if (input == null) {
            input = new DescribeAccessKeysInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeAccessKeys");
        context.put("APIName", "DescribeAccessKeys");
        context.put("ServiceName", "DescribeAccessKeys");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeAccessKeys");
        input.setAction("DescribeAccessKeys");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeAccessKeysOutput.class);
        if (backModel != null) {
            return (DescribeAccessKeysOutput)backModel;
        }
        return null;
    }

    public void describeAccessKeys(DescribeAccessKeysInput input, ResponseCallBack<DescribeAccessKeysOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeAccessKeysInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeAccessKeys");
        context.put("APIName", "DescribeAccessKeys");
        context.put("ServiceName", "DescribeAccessKeys");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeAccessKeys");
        input.setAction("DescribeAccessKeys");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class DeleteAccessKeysInput
    extends IaasParamBody {
        private List<String> accessKeys;

        @JsonProperty(value="access_keys")
        public void setAccessKeys(List<String> accessKeys) {
            this.accessKeys = accessKeys;
        }

        @JsonProperty(value="access_keys")
        public List<String> getAccessKeys() {
            return this.accessKeys;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteAccessKeysOutput
    extends OutputModel {
        private List<String> accessKeys;
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="access_keys")
        public void setAccessKeys(List<String> accessKeys) {
            this.accessKeys = accessKeys;
        }

        @JsonProperty(value="access_keys")
        public List<String> getAccessKeys() {
            return this.accessKeys;
        }

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeAccessKeysInput
    extends IaasParamBody {
        private List<String> accessKeys;
        private Integer limit;
        private Integer offset;
        private String owner;
        private String searchWord;
        private List<String> status;
        private Integer verbose;

        @JsonProperty(value="access_keys")
        public void setAccessKeys(List<String> accessKeys) {
            this.accessKeys = accessKeys;
        }

        @JsonProperty(value="access_keys")
        public List<String> getAccessKeys() {
            return this.accessKeys;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeAccessKeysOutput
    extends OutputModel {
        private List<Types.AccessKeyModel> accessKeySet;
        private String action;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="access_key_set")
        public void setAccessKeySet(List<Types.AccessKeyModel> accessKeySet) {
            this.accessKeySet = accessKeySet;
        }

        @JsonProperty(value="access_key_set")
        public List<Types.AccessKeyModel> getAccessKeySet() {
            return this.accessKeySet;
        }

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }
}

