/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class DNSAliasService {
    private EnvContext envContext;
    private String zone;

    public DNSAliasService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public DNSAliasService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AssociateDNSAliasOutput associateDNSAlias(AssociateDNSAliasInput input) throws QCException {
        if (input == null) {
            input = new AssociateDNSAliasInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AssociateDNSAlias");
        context.put("APIName", "AssociateDNSAlias");
        context.put("ServiceName", "AssociateDNSAlias");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AssociateDNSAlias");
        input.setAction("AssociateDNSAlias");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AssociateDNSAliasOutput.class);
        if (backModel != null) {
            return (AssociateDNSAliasOutput)backModel;
        }
        return null;
    }

    public void associateDNSAlias(AssociateDNSAliasInput input, ResponseCallBack<AssociateDNSAliasOutput> callback) throws QCException {
        if (input == null) {
            input = new AssociateDNSAliasInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AssociateDNSAlias");
        context.put("APIName", "AssociateDNSAlias");
        context.put("ServiceName", "AssociateDNSAlias");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AssociateDNSAlias");
        input.setAction("AssociateDNSAlias");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeDNSAliasesOutput describeDNSAliases(DescribeDNSAliasesInput input) throws QCException {
        if (input == null) {
            input = new DescribeDNSAliasesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeDNSAliases");
        context.put("APIName", "DescribeDNSAliases");
        context.put("ServiceName", "DescribeDNSAliases");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeDNSAliases");
        input.setAction("DescribeDNSAliases");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeDNSAliasesOutput.class);
        if (backModel != null) {
            return (DescribeDNSAliasesOutput)backModel;
        }
        return null;
    }

    public void describeDNSAliases(DescribeDNSAliasesInput input, ResponseCallBack<DescribeDNSAliasesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeDNSAliasesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeDNSAliases");
        context.put("APIName", "DescribeDNSAliases");
        context.put("ServiceName", "DescribeDNSAliases");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeDNSAliases");
        input.setAction("DescribeDNSAliases");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DissociateDNSAliasesOutput dissociateDNSAliases(DissociateDNSAliasesInput input) throws QCException {
        if (input == null) {
            input = new DissociateDNSAliasesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DissociateDNSAliases");
        context.put("APIName", "DissociateDNSAliases");
        context.put("ServiceName", "DissociateDNSAliases");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DissociateDNSAliases");
        input.setAction("DissociateDNSAliases");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DissociateDNSAliasesOutput.class);
        if (backModel != null) {
            return (DissociateDNSAliasesOutput)backModel;
        }
        return null;
    }

    public void dissociateDNSAliases(DissociateDNSAliasesInput input, ResponseCallBack<DissociateDNSAliasesOutput> callback) throws QCException {
        if (input == null) {
            input = new DissociateDNSAliasesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DissociateDNSAliases");
        context.put("APIName", "DissociateDNSAliases");
        context.put("ServiceName", "DissociateDNSAliases");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DissociateDNSAliases");
        input.setAction("DissociateDNSAliases");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetDNSLabelOutput getDNSLabel() throws QCException {
        IaasParamBody input = new IaasParamBody();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetDNSLabel");
        context.put("APIName", "GetDNSLabel");
        context.put("ServiceName", "GetDNSLabel");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetDNSLabel");
        input.setAction("GetDNSLabel");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetDNSLabelOutput.class);
        if (backModel != null) {
            return (GetDNSLabelOutput)backModel;
        }
        return null;
    }

    public void getDNSLabel(ResponseCallBack<GetDNSLabelOutput> callback) throws QCException {
        IaasParamBody input = new IaasParamBody();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetDNSLabel");
        context.put("APIName", "GetDNSLabel");
        context.put("ServiceName", "GetDNSLabel");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetDNSLabel");
        input.setAction("GetDNSLabel");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class AssociateDNSAliasInput
    extends IaasParamBody {
        private String prefix;
        private String resource;

        @JsonProperty(value="prefix")
        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @JsonProperty(value="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public String getResource() {
            return this.resource;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getPrefix())) {
                throw new QCException("Prefix is required");
            }
            if (QCStringUtil.isEmpty(this.getResource())) {
                throw new QCException("Resource is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AssociateDNSAliasOutput
    extends OutputModel {
        private String action;
        private String dNSAliasID;
        private String domainName;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="dns_alias_id")
        public void setDNSAliasID(String dNSAliasID) {
            this.dNSAliasID = dNSAliasID;
        }

        @JsonProperty(value="dns_alias_id")
        public String getDNSAliasID() {
            return this.dNSAliasID;
        }

        @JsonProperty(value="domain_name")
        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @JsonProperty(value="domain_name")
        public String getDomainName() {
            return this.domainName;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeDNSAliasesInput
    extends IaasParamBody {
        private List<String> dNSAliases;
        private Integer limit;
        private Integer offset;
        private String resourceID;
        private String searchWord;

        @JsonProperty(value="dns_aliases")
        public void setDNSAliases(List<String> dNSAliases) {
            this.dNSAliases = dNSAliases;
        }

        @JsonProperty(value="dns_aliases")
        public List<String> getDNSAliases() {
            return this.dNSAliases;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeDNSAliasesOutput
    extends OutputModel {
        private String action;
        private List<Types.DNSAliasModel> dNSAliasSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="dns_alias_set")
        public void setDNSAliasSet(List<Types.DNSAliasModel> dNSAliasSet) {
            this.dNSAliasSet = dNSAliasSet;
        }

        @JsonProperty(value="dns_alias_set")
        public List<Types.DNSAliasModel> getDNSAliasSet() {
            return this.dNSAliasSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DissociateDNSAliasesInput
    extends IaasParamBody {
        private List<String> dNSAliases;

        @JsonProperty(value="dns_aliases")
        public void setDNSAliases(List<String> dNSAliases) {
            this.dNSAliases = dNSAliases;
        }

        @JsonProperty(value="dns_aliases")
        public List<String> getDNSAliases() {
            return this.dNSAliases;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DissociateDNSAliasesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetDNSLabelOutput
    extends OutputModel {
        private String action;
        private String dNSLabel;
        private String domainName;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="dns_label")
        public void setDNSLabel(String dNSLabel) {
            this.dNSLabel = dNSLabel;
        }

        @JsonProperty(value="dns_label")
        public String getDNSLabel() {
            return this.dNSLabel;
        }

        @JsonProperty(value="domain_name")
        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @JsonProperty(value="domain_name")
        public String getDomainName() {
            return this.domainName;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }
}

