/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class ImageService {
    private EnvContext envContext;
    private String zone;

    public ImageService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public ImageService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public CaptureInstanceOutput captureInstance(CaptureInstanceInput input) throws QCException {
        if (input == null) {
            input = new CaptureInstanceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CaptureInstance");
        context.put("APIName", "CaptureInstance");
        context.put("ServiceName", "CaptureInstance");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CaptureInstance");
        input.setAction("CaptureInstance");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CaptureInstanceOutput.class);
        if (backModel != null) {
            return (CaptureInstanceOutput)backModel;
        }
        return null;
    }

    public void captureInstance(CaptureInstanceInput input, ResponseCallBack<CaptureInstanceOutput> callback) throws QCException {
        if (input == null) {
            input = new CaptureInstanceInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CaptureInstance");
        context.put("APIName", "CaptureInstance");
        context.put("ServiceName", "CaptureInstance");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CaptureInstance");
        input.setAction("CaptureInstance");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteImagesOutput deleteImages(DeleteImagesInput input) throws QCException {
        if (input == null) {
            input = new DeleteImagesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteImages");
        context.put("APIName", "DeleteImages");
        context.put("ServiceName", "DeleteImages");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteImages");
        input.setAction("DeleteImages");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteImagesOutput.class);
        if (backModel != null) {
            return (DeleteImagesOutput)backModel;
        }
        return null;
    }

    public void deleteImages(DeleteImagesInput input, ResponseCallBack<DeleteImagesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteImagesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteImages");
        context.put("APIName", "DeleteImages");
        context.put("ServiceName", "DeleteImages");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteImages");
        input.setAction("DeleteImages");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeImageUsersOutput describeImageUsers(DescribeImageUsersInput input) throws QCException {
        if (input == null) {
            input = new DescribeImageUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeImageUsers");
        context.put("APIName", "DescribeImageUsers");
        context.put("ServiceName", "DescribeImageUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeImageUsers");
        input.setAction("DescribeImageUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeImageUsersOutput.class);
        if (backModel != null) {
            return (DescribeImageUsersOutput)backModel;
        }
        return null;
    }

    public void describeImageUsers(DescribeImageUsersInput input, ResponseCallBack<DescribeImageUsersOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeImageUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeImageUsers");
        context.put("APIName", "DescribeImageUsers");
        context.put("ServiceName", "DescribeImageUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeImageUsers");
        input.setAction("DescribeImageUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeImagesOutput describeImages(DescribeImagesInput input) throws QCException {
        if (input == null) {
            input = new DescribeImagesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeImages");
        context.put("APIName", "DescribeImages");
        context.put("ServiceName", "DescribeImages");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeImages");
        input.setAction("DescribeImages");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeImagesOutput.class);
        if (backModel != null) {
            return (DescribeImagesOutput)backModel;
        }
        return null;
    }

    public void describeImages(DescribeImagesInput input, ResponseCallBack<DescribeImagesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeImagesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeImages");
        context.put("APIName", "DescribeImages");
        context.put("ServiceName", "DescribeImages");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeImages");
        input.setAction("DescribeImages");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GrantImageToUsersOutput grantImageToUsers(GrantImageToUsersInput input) throws QCException {
        if (input == null) {
            input = new GrantImageToUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GrantImageToUsers");
        context.put("APIName", "GrantImageToUsers");
        context.put("ServiceName", "GrantImageToUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GrantImageToUsers");
        input.setAction("GrantImageToUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GrantImageToUsersOutput.class);
        if (backModel != null) {
            return (GrantImageToUsersOutput)backModel;
        }
        return null;
    }

    public void grantImageToUsers(GrantImageToUsersInput input, ResponseCallBack<GrantImageToUsersOutput> callback) throws QCException {
        if (input == null) {
            input = new GrantImageToUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GrantImageToUsers");
        context.put("APIName", "GrantImageToUsers");
        context.put("ServiceName", "GrantImageToUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GrantImageToUsers");
        input.setAction("GrantImageToUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyImageAttributesOutput modifyImageAttributes(ModifyImageAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyImageAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyImageAttributes");
        context.put("APIName", "ModifyImageAttributes");
        context.put("ServiceName", "ModifyImageAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyImageAttributes");
        input.setAction("ModifyImageAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyImageAttributesOutput.class);
        if (backModel != null) {
            return (ModifyImageAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyImageAttributes(ModifyImageAttributesInput input, ResponseCallBack<ModifyImageAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyImageAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyImageAttributes");
        context.put("APIName", "ModifyImageAttributes");
        context.put("ServiceName", "ModifyImageAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyImageAttributes");
        input.setAction("ModifyImageAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RevokeImageFromUsersOutput revokeImageFromUsers(RevokeImageFromUsersInput input) throws QCException {
        if (input == null) {
            input = new RevokeImageFromUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RevokeImageFromUsers");
        context.put("APIName", "RevokeImageFromUsers");
        context.put("ServiceName", "RevokeImageFromUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RevokeImageFromUsers");
        input.setAction("RevokeImageFromUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RevokeImageFromUsersOutput.class);
        if (backModel != null) {
            return (RevokeImageFromUsersOutput)backModel;
        }
        return null;
    }

    public void revokeImageFromUsers(RevokeImageFromUsersInput input, ResponseCallBack<RevokeImageFromUsersOutput> callback) throws QCException {
        if (input == null) {
            input = new RevokeImageFromUsersInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RevokeImageFromUsers");
        context.put("APIName", "RevokeImageFromUsers");
        context.put("ServiceName", "RevokeImageFromUsers");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RevokeImageFromUsers");
        input.setAction("RevokeImageFromUsers");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class CaptureInstanceInput
    extends IaasParamBody {
        private String imageName;
        private String instance;

        @JsonProperty(value="image_name")
        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @JsonProperty(value="image_name")
        public String getImageName() {
            return this.imageName;
        }

        @JsonProperty(value="instance")
        public void setInstance(String instance) {
            this.instance = instance;
        }

        @JsonProperty(value="instance")
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getInstance())) {
                throw new QCException("Instance is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CaptureInstanceOutput
    extends OutputModel {
        private String action;
        private String imageID;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteImagesInput
    extends IaasParamBody {
        private List<String> images;

        @JsonProperty(value="images")
        public void setImages(List<String> images) {
            this.images = images;
        }

        @JsonProperty(value="images")
        public List<String> getImages() {
            return this.images;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteImagesOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeImageUsersInput
    extends IaasParamBody {
        private String imageID;
        private Integer limit;
        private Integer offset;

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getImageID())) {
                throw new QCException("ImageID is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeImageUsersOutput
    extends OutputModel {
        private String action;
        private List<Types.ImageUserModel> imageUserSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="image_user_set")
        public void setImageUserSet(List<Types.ImageUserModel> imageUserSet) {
            this.imageUserSet = imageUserSet;
        }

        @JsonProperty(value="image_user_set")
        public List<Types.ImageUserModel> getImageUserSet() {
            return this.imageUserSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeImagesInput
    extends IaasParamBody {
        private List<String> images;
        private Integer limit;
        private Integer offset;
        private String oSFamily;
        private String owner;
        private String processorType;
        private String projectID;
        private String provider;
        private String searchWord;
        private List<String> status;
        private List<String> tags;
        private Integer verbose;
        private String visibility;

        @JsonProperty(value="images")
        public void setImages(List<String> images) {
            this.images = images;
        }

        @JsonProperty(value="images")
        public List<String> getImages() {
            return this.images;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="os_family")
        public void setOSFamily(String oSFamily) {
            this.oSFamily = oSFamily;
        }

        @JsonProperty(value="os_family")
        public String getOSFamily() {
            return this.oSFamily;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="processor_type")
        public void setProcessorType(String processorType) {
            this.processorType = processorType;
        }

        @JsonProperty(value="processor_type")
        public String getProcessorType() {
            return this.processorType;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="provider")
        public void setProvider(String provider) {
            this.provider = provider;
        }

        @JsonProperty(value="provider")
        public String getProvider() {
            return this.provider;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="status")
        public void setStatus(List<String> status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public List<String> getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @JsonProperty(value="visibility")
        public String getVisibility() {
            return this.visibility;
        }

        @Override
        public String validateParam() throws QCException {
            String[] processorTypeValidValues = new String[]{"64bit", "32bit"};
            boolean processorTypeIsValid = false;
            for (String v : processorTypeValidValues) {
                Boolean processorTypeIsRequired;
                if (v.equals(this.getProcessorType())) {
                    processorTypeIsValid = true;
                }
                if (!(processorTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getProcessorType() != null) continue;
                processorTypeIsValid = true;
            }
            if (!processorTypeIsValid) {
                throw new QCException("ProcessorType value " + this.getProcessorType() + "is invalid");
            }
            String[] providerValidValues = new String[]{"system", "self"};
            boolean providerIsValid = false;
            for (String v : providerValidValues) {
                Boolean providerIsRequired;
                if (v.equals(this.getProvider())) {
                    providerIsValid = true;
                }
                if (!(providerIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getProvider() != null) continue;
                providerIsValid = true;
            }
            if (!providerIsValid) {
                throw new QCException("Provider value " + this.getProvider() + "is invalid");
            }
            String[] verboseValidValues = new String[]{"0"};
            boolean verboseIsValid = false;
            for (String v : verboseValidValues) {
                Boolean verboseIsRequired;
                if (v.equals(this.getVerbose() + "")) {
                    verboseIsValid = true;
                }
                if (!(verboseIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVerbose() != null) continue;
                verboseIsValid = true;
            }
            if (!verboseIsValid) {
                throw new QCException("Verbose value " + this.getVerbose() + "is invalid");
            }
            String[] visibilityValidValues = new String[]{"public", "private"};
            boolean visibilityIsValid = false;
            for (String v : visibilityValidValues) {
                Boolean visibilityIsRequired;
                if (v.equals(this.getVisibility())) {
                    visibilityIsValid = true;
                }
                if (!(visibilityIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVisibility() != null) continue;
                visibilityIsValid = true;
            }
            if (!visibilityIsValid) {
                throw new QCException("Visibility value " + this.getVisibility() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeImagesOutput
    extends OutputModel {
        private String action;
        private List<Types.ImageModel> imageSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="image_set")
        public void setImageSet(List<Types.ImageModel> imageSet) {
            this.imageSet = imageSet;
        }

        @JsonProperty(value="image_set")
        public List<Types.ImageModel> getImageSet() {
            return this.imageSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class GrantImageToUsersInput
    extends IaasParamBody {
        private String image;
        private List<String> users;

        @JsonProperty(value="image")
        public void setImage(String image) {
            this.image = image;
        }

        @JsonProperty(value="image")
        public String getImage() {
            return this.image;
        }

        @JsonProperty(value="users")
        public void setUsers(List<String> users) {
            this.users = users;
        }

        @JsonProperty(value="users")
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getImage())) {
                throw new QCException("Image is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GrantImageToUsersOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyImageAttributesInput
    extends IaasParamBody {
        private String description;
        private String image;
        private String imageName;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="image")
        public void setImage(String image) {
            this.image = image;
        }

        @JsonProperty(value="image")
        public String getImage() {
            return this.image;
        }

        @JsonProperty(value="image_name")
        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @JsonProperty(value="image_name")
        public String getImageName() {
            return this.imageName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getImage())) {
                throw new QCException("Image is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyImageAttributesOutput
    extends OutputModel {
        private String action;
        private String imageID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class RevokeImageFromUsersInput
    extends IaasParamBody {
        private String image;
        private List<String> users;

        @JsonProperty(value="image")
        public void setImage(String image) {
            this.image = image;
        }

        @JsonProperty(value="image")
        public String getImage() {
            return this.image;
        }

        @JsonProperty(value="users")
        public void setUsers(List<String> users) {
            this.users = users;
        }

        @JsonProperty(value="users")
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getImage())) {
                throw new QCException("Image is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RevokeImageFromUsersOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }
}

