/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class KeyPairService {
    private EnvContext envContext;
    private String zone;

    public KeyPairService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public KeyPairService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AttachKeyPairsOutput attachKeyPairs(AttachKeyPairsInput input) throws QCException {
        if (input == null) {
            input = new AttachKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AttachKeyPairs");
        context.put("APIName", "AttachKeyPairs");
        context.put("ServiceName", "AttachKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AttachKeyPairs");
        input.setAction("AttachKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AttachKeyPairsOutput.class);
        if (backModel != null) {
            return (AttachKeyPairsOutput)backModel;
        }
        return null;
    }

    public void attachKeyPairs(AttachKeyPairsInput input, ResponseCallBack<AttachKeyPairsOutput> callback) throws QCException {
        if (input == null) {
            input = new AttachKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AttachKeyPairs");
        context.put("APIName", "AttachKeyPairs");
        context.put("ServiceName", "AttachKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AttachKeyPairs");
        input.setAction("AttachKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateKeyPairOutput createKeyPair(CreateKeyPairInput input) throws QCException {
        if (input == null) {
            input = new CreateKeyPairInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateKeyPair");
        context.put("APIName", "CreateKeyPair");
        context.put("ServiceName", "CreateKeyPair");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateKeyPair");
        input.setAction("CreateKeyPair");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateKeyPairOutput.class);
        if (backModel != null) {
            return (CreateKeyPairOutput)backModel;
        }
        return null;
    }

    public void createKeyPair(CreateKeyPairInput input, ResponseCallBack<CreateKeyPairOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateKeyPairInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateKeyPair");
        context.put("APIName", "CreateKeyPair");
        context.put("ServiceName", "CreateKeyPair");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateKeyPair");
        input.setAction("CreateKeyPair");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteKeyPairsOutput deleteKeyPairs(DeleteKeyPairsInput input) throws QCException {
        if (input == null) {
            input = new DeleteKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteKeyPairs");
        context.put("APIName", "DeleteKeyPairs");
        context.put("ServiceName", "DeleteKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteKeyPairs");
        input.setAction("DeleteKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteKeyPairsOutput.class);
        if (backModel != null) {
            return (DeleteKeyPairsOutput)backModel;
        }
        return null;
    }

    public void deleteKeyPairs(DeleteKeyPairsInput input, ResponseCallBack<DeleteKeyPairsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteKeyPairs");
        context.put("APIName", "DeleteKeyPairs");
        context.put("ServiceName", "DeleteKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteKeyPairs");
        input.setAction("DeleteKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeKeyPairsOutput describeKeyPairs(DescribeKeyPairsInput input) throws QCException {
        if (input == null) {
            input = new DescribeKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeKeyPairs");
        context.put("APIName", "DescribeKeyPairs");
        context.put("ServiceName", "DescribeKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeKeyPairs");
        input.setAction("DescribeKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeKeyPairsOutput.class);
        if (backModel != null) {
            return (DescribeKeyPairsOutput)backModel;
        }
        return null;
    }

    public void describeKeyPairs(DescribeKeyPairsInput input, ResponseCallBack<DescribeKeyPairsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeKeyPairs");
        context.put("APIName", "DescribeKeyPairs");
        context.put("ServiceName", "DescribeKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeKeyPairs");
        input.setAction("DescribeKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DetachKeyPairsOutput detachKeyPairs(DetachKeyPairsInput input) throws QCException {
        if (input == null) {
            input = new DetachKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DetachKeyPairs");
        context.put("APIName", "DetachKeyPairs");
        context.put("ServiceName", "DetachKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DetachKeyPairs");
        input.setAction("DetachKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DetachKeyPairsOutput.class);
        if (backModel != null) {
            return (DetachKeyPairsOutput)backModel;
        }
        return null;
    }

    public void detachKeyPairs(DetachKeyPairsInput input, ResponseCallBack<DetachKeyPairsOutput> callback) throws QCException {
        if (input == null) {
            input = new DetachKeyPairsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DetachKeyPairs");
        context.put("APIName", "DetachKeyPairs");
        context.put("ServiceName", "DetachKeyPairs");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DetachKeyPairs");
        input.setAction("DetachKeyPairs");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyKeyPairAttributesOutput modifyKeyPairAttributes(ModifyKeyPairAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyKeyPairAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyKeyPairAttributes");
        context.put("APIName", "ModifyKeyPairAttributes");
        context.put("ServiceName", "ModifyKeyPairAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyKeyPairAttributes");
        input.setAction("ModifyKeyPairAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyKeyPairAttributesOutput.class);
        if (backModel != null) {
            return (ModifyKeyPairAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyKeyPairAttributes(ModifyKeyPairAttributesInput input, ResponseCallBack<ModifyKeyPairAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyKeyPairAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyKeyPairAttributes");
        context.put("APIName", "ModifyKeyPairAttributes");
        context.put("ServiceName", "ModifyKeyPairAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyKeyPairAttributes");
        input.setAction("ModifyKeyPairAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class AttachKeyPairsInput
    extends IaasParamBody {
        private List<String> instances;
        private List<String> keyPairs;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="keypairs")
        public void setKeyPairs(List<String> keyPairs) {
            this.keyPairs = keyPairs;
        }

        @JsonProperty(value="keypairs")
        public List<String> getKeyPairs() {
            return this.keyPairs;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AttachKeyPairsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateKeyPairInput
    extends IaasParamBody {
        private String encryptMethod;
        private String keyPairName;
        private String mode;
        private String publicKey;

        @JsonProperty(value="encrypt_method")
        public void setEncryptMethod(String encryptMethod) {
            this.encryptMethod = encryptMethod;
        }

        @JsonProperty(value="encrypt_method")
        public String getEncryptMethod() {
            return this.encryptMethod;
        }

        @JsonProperty(value="keypair_name")
        public void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @JsonProperty(value="keypair_name")
        public String getKeyPairName() {
            return this.keyPairName;
        }

        @JsonProperty(value="mode")
        public void setMode(String mode) {
            this.mode = mode;
        }

        @JsonProperty(value="mode")
        public String getMode() {
            return this.mode;
        }

        @JsonProperty(value="public_key")
        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="public_key")
        public String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public String validateParam() throws QCException {
            String[] encryptMethodValidValues = new String[]{"ssh-rsa", "ssh-dss"};
            boolean encryptMethodIsValid = false;
            for (String v : encryptMethodValidValues) {
                Boolean encryptMethodIsRequired;
                if (v.equals(this.getEncryptMethod())) {
                    encryptMethodIsValid = true;
                }
                if (!(encryptMethodIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getEncryptMethod() != null) continue;
                encryptMethodIsValid = true;
            }
            if (!encryptMethodIsValid) {
                throw new QCException("EncryptMethod value " + this.getEncryptMethod() + "is invalid");
            }
            String[] modeValidValues = new String[]{"system", "user"};
            boolean modeIsValid = false;
            for (String v : modeValidValues) {
                Boolean modeIsRequired;
                if (v.equals(this.getMode())) {
                    modeIsValid = true;
                }
                if (!(modeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getMode() != null) continue;
                modeIsValid = true;
            }
            if (!modeIsValid) {
                throw new QCException("Mode value " + this.getMode() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateKeyPairOutput
    extends OutputModel {
        private String action;
        private String keyPairID;
        private String privateKey;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="keypair_id")
        public void setKeyPairID(String keyPairID) {
            this.keyPairID = keyPairID;
        }

        @JsonProperty(value="keypair_id")
        public String getKeyPairID() {
            return this.keyPairID;
        }

        @JsonProperty(value="private_key")
        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @JsonProperty(value="private_key")
        public String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteKeyPairsInput
    extends IaasParamBody {
        private List<String> keyPairs;

        @JsonProperty(value="keypairs")
        public void setKeyPairs(List<String> keyPairs) {
            this.keyPairs = keyPairs;
        }

        @JsonProperty(value="keypairs")
        public List<String> getKeyPairs() {
            return this.keyPairs;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteKeyPairsOutput
    extends OutputModel {
        private String action;
        private List<String> keyPairs;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="keypairs")
        public void setKeyPairs(List<String> keyPairs) {
            this.keyPairs = keyPairs;
        }

        @JsonProperty(value="keypairs")
        public List<String> getKeyPairs() {
            return this.keyPairs;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeKeyPairsInput
    extends IaasParamBody {
        private String encryptMethod;
        private String instanceID;
        private List<String> keyPairs;
        private Integer limit;
        private Integer offset;
        private String owner;
        private String projectID;
        private String searchWord;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="encrypt_method")
        public void setEncryptMethod(String encryptMethod) {
            this.encryptMethod = encryptMethod;
        }

        @JsonProperty(value="encrypt_method")
        public String getEncryptMethod() {
            return this.encryptMethod;
        }

        @JsonProperty(value="instance_id")
        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        @JsonProperty(value="instance_id")
        public String getInstanceID() {
            return this.instanceID;
        }

        @JsonProperty(value="keypairs")
        public void setKeyPairs(List<String> keyPairs) {
            this.keyPairs = keyPairs;
        }

        @JsonProperty(value="keypairs")
        public List<String> getKeyPairs() {
            return this.keyPairs;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            String[] encryptMethodValidValues = new String[]{"ssh-rsa", "ssh-dss"};
            boolean encryptMethodIsValid = false;
            for (String v : encryptMethodValidValues) {
                Boolean encryptMethodIsRequired;
                if (v.equals(this.getEncryptMethod())) {
                    encryptMethodIsValid = true;
                }
                if (!(encryptMethodIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getEncryptMethod() != null) continue;
                encryptMethodIsValid = true;
            }
            if (!encryptMethodIsValid) {
                throw new QCException("EncryptMethod value " + this.getEncryptMethod() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeKeyPairsOutput
    extends OutputModel {
        private String action;
        private List<Types.KeyPairModel> keyPairSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="keypair_set")
        public void setKeyPairSet(List<Types.KeyPairModel> keyPairSet) {
            this.keyPairSet = keyPairSet;
        }

        @JsonProperty(value="keypair_set")
        public List<Types.KeyPairModel> getKeyPairSet() {
            return this.keyPairSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DetachKeyPairsInput
    extends IaasParamBody {
        private List<String> instances;
        private List<String> keyPairs;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="keypairs")
        public void setKeyPairs(List<String> keyPairs) {
            this.keyPairs = keyPairs;
        }

        @JsonProperty(value="keypairs")
        public List<String> getKeyPairs() {
            return this.keyPairs;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DetachKeyPairsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyKeyPairAttributesInput
    extends IaasParamBody {
        private String description;
        private String keyPair;
        private String keyPairName;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="keypair")
        public void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        @JsonProperty(value="keypair")
        public String getKeyPair() {
            return this.keyPair;
        }

        @JsonProperty(value="keypair_name")
        public void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @JsonProperty(value="keypair_name")
        public String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getKeyPair())) {
                throw new QCException("KeyPair is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyKeyPairAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }
}

