/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class MiscService {
    private EnvContext envContext;
    private String zone;

    public MiscService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public MiscService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public GetQuotaLeftOutput getQuotaLeft(GetQuotaLeftInput input) throws QCException {
        if (input == null) {
            input = new GetQuotaLeftInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetQuotaLeft");
        context.put("APIName", "GetQuotaLeft");
        context.put("ServiceName", "GetQuotaLeft");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetQuotaLeft");
        input.setAction("GetQuotaLeft");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetQuotaLeftOutput.class);
        if (backModel != null) {
            return (GetQuotaLeftOutput)backModel;
        }
        return null;
    }

    public void getQuotaLeft(GetQuotaLeftInput input, ResponseCallBack<GetQuotaLeftOutput> callback) throws QCException {
        if (input == null) {
            input = new GetQuotaLeftInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetQuotaLeft");
        context.put("APIName", "GetQuotaLeft");
        context.put("ServiceName", "GetQuotaLeft");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetQuotaLeft");
        input.setAction("GetQuotaLeft");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public GetResourceLimitOutput getResourceLimit(GetResourceLimitInput input) throws QCException {
        if (input == null) {
            input = new GetResourceLimitInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetResourceLimit");
        context.put("APIName", "GetResourceLimit");
        context.put("ServiceName", "GetResourceLimit");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetResourceLimit");
        input.setAction("GetResourceLimit");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, GetResourceLimitOutput.class);
        if (backModel != null) {
            return (GetResourceLimitOutput)backModel;
        }
        return null;
    }

    public void getResourceLimit(GetResourceLimitInput input, ResponseCallBack<GetResourceLimitOutput> callback) throws QCException {
        if (input == null) {
            input = new GetResourceLimitInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "GetResourceLimit");
        context.put("APIName", "GetResourceLimit");
        context.put("ServiceName", "GetResourceLimit");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/GetResourceLimit");
        input.setAction("GetResourceLimit");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class GetQuotaLeftInput
    extends IaasParamBody {
        private List<String> resourceTypes;
        private String zone;

        @JsonProperty(value="resource_types")
        public void setResourceTypes(List<String> resourceTypes) {
            this.resourceTypes = resourceTypes;
        }

        @JsonProperty(value="resource_types")
        public List<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        @JsonProperty(value="zone")
        public void setZone(String zone) {
            this.zone = zone;
        }

        @Override
        @JsonProperty(value="zone")
        public String getZone() {
            return this.zone;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getZone())) {
                throw new QCException("Zone is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetQuotaLeftOutput
    extends OutputModel {
        private String action;
        private List<Types.QuotaLeftModel> quotaLeftSet;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="quota_left_set")
        public void setQuotaLeftSet(List<Types.QuotaLeftModel> quotaLeftSet) {
            this.quotaLeftSet = quotaLeftSet;
        }

        @JsonProperty(value="quota_left_set")
        public List<Types.QuotaLeftModel> getQuotaLeftSet() {
            return this.quotaLeftSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class GetResourceLimitInput
    extends IaasParamBody {
        private Integer volumeType;
        private String zone;

        @JsonProperty(value="volume_type")
        public void setVolumeType(Integer volumeType) {
            this.volumeType = volumeType;
        }

        @JsonProperty(value="volume_type")
        public Integer getVolumeType() {
            return this.volumeType;
        }

        @Override
        @JsonProperty(value="zone")
        public void setZone(String zone) {
            this.zone = zone;
        }

        @Override
        @JsonProperty(value="zone")
        public String getZone() {
            return this.zone;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getZone())) {
                throw new QCException("Zone is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetResourceLimitOutput
    extends OutputModel {
        private String action;
        private Integer maxSize;
        private Integer minSize;
        private Types.ResourceLimitsModel resourceLimits;
        private Integer retCode;
        private Integer step;
        private List<String> vxNetSubnets;
        private Integer vxNetVersion;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="max-size")
        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @JsonProperty(value="max-size")
        public Integer getMaxSize() {
            return this.maxSize;
        }

        @JsonProperty(value="min-size")
        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @JsonProperty(value="min-size")
        public Integer getMinSize() {
            return this.minSize;
        }

        @JsonProperty(value="resource_limits")
        public void setResourceLimits(Types.ResourceLimitsModel resourceLimits) {
            this.resourceLimits = resourceLimits;
        }

        @JsonProperty(value="resource_limits")
        public Types.ResourceLimitsModel getResourceLimits() {
            return this.resourceLimits;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="step")
        public void setStep(Integer step) {
            this.step = step;
        }

        @JsonProperty(value="step")
        public Integer getStep() {
            return this.step;
        }

        @JsonProperty(value="vxnet_subnets")
        public void setVxNetSubnets(List<String> vxNetSubnets) {
            this.vxNetSubnets = vxNetSubnets;
        }

        @JsonProperty(value="vxnet_subnets")
        public List<String> getVxNetSubnets() {
            return this.vxNetSubnets;
        }

        @JsonProperty(value="vxnet_version")
        public void setVxNetVersion(Integer vxNetVersion) {
            this.vxNetVersion = vxNetVersion;
        }

        @JsonProperty(value="vxnet_version")
        public Integer getVxNetVersion() {
            return this.vxNetVersion;
        }
    }
}

