/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class NicService {
    private EnvContext envContext;
    private String zone;

    public NicService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public NicService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AttachNicsOutput attachNics(AttachNicsInput input) throws QCException {
        if (input == null) {
            input = new AttachNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AttachNics");
        context.put("APIName", "AttachNics");
        context.put("ServiceName", "AttachNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AttachNics");
        input.setAction("AttachNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AttachNicsOutput.class);
        if (backModel != null) {
            return (AttachNicsOutput)backModel;
        }
        return null;
    }

    public void attachNics(AttachNicsInput input, ResponseCallBack<AttachNicsOutput> callback) throws QCException {
        if (input == null) {
            input = new AttachNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AttachNics");
        context.put("APIName", "AttachNics");
        context.put("ServiceName", "AttachNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AttachNics");
        input.setAction("AttachNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateNicsOutput createNics(CreateNicsInput input) throws QCException {
        if (input == null) {
            input = new CreateNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateNics");
        context.put("APIName", "CreateNics");
        context.put("ServiceName", "CreateNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateNics");
        input.setAction("CreateNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateNicsOutput.class);
        if (backModel != null) {
            return (CreateNicsOutput)backModel;
        }
        return null;
    }

    public void createNics(CreateNicsInput input, ResponseCallBack<CreateNicsOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateNics");
        context.put("APIName", "CreateNics");
        context.put("ServiceName", "CreateNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateNics");
        input.setAction("CreateNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteNicsOutput deleteNics(DeleteNicsInput input) throws QCException {
        if (input == null) {
            input = new DeleteNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteNics");
        context.put("APIName", "DeleteNics");
        context.put("ServiceName", "DeleteNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteNics");
        input.setAction("DeleteNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteNicsOutput.class);
        if (backModel != null) {
            return (DeleteNicsOutput)backModel;
        }
        return null;
    }

    public void deleteNics(DeleteNicsInput input, ResponseCallBack<DeleteNicsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteNics");
        context.put("APIName", "DeleteNics");
        context.put("ServiceName", "DeleteNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteNics");
        input.setAction("DeleteNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeNicsOutput describeNics(DescribeNicsInput input) throws QCException {
        if (input == null) {
            input = new DescribeNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeNics");
        context.put("APIName", "DescribeNics");
        context.put("ServiceName", "DescribeNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeNics");
        input.setAction("DescribeNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeNicsOutput.class);
        if (backModel != null) {
            return (DescribeNicsOutput)backModel;
        }
        return null;
    }

    public void describeNics(DescribeNicsInput input, ResponseCallBack<DescribeNicsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeNics");
        context.put("APIName", "DescribeNics");
        context.put("ServiceName", "DescribeNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeNics");
        input.setAction("DescribeNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DetachNicsOutput detachNics(DetachNicsInput input) throws QCException {
        if (input == null) {
            input = new DetachNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DetachNics");
        context.put("APIName", "DetachNics");
        context.put("ServiceName", "DetachNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DetachNics");
        input.setAction("DetachNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DetachNicsOutput.class);
        if (backModel != null) {
            return (DetachNicsOutput)backModel;
        }
        return null;
    }

    public void detachNics(DetachNicsInput input, ResponseCallBack<DetachNicsOutput> callback) throws QCException {
        if (input == null) {
            input = new DetachNicsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DetachNics");
        context.put("APIName", "DetachNics");
        context.put("ServiceName", "DetachNics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DetachNics");
        input.setAction("DetachNics");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifyNicAttributesOutput modifyNicAttributes(ModifyNicAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifyNicAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyNicAttributes");
        context.put("APIName", "ModifyNicAttributes");
        context.put("ServiceName", "ModifyNicAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyNicAttributes");
        input.setAction("ModifyNicAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifyNicAttributesOutput.class);
        if (backModel != null) {
            return (ModifyNicAttributesOutput)backModel;
        }
        return null;
    }

    public void modifyNicAttributes(ModifyNicAttributesInput input, ResponseCallBack<ModifyNicAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifyNicAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifyNicAttributes");
        context.put("APIName", "ModifyNicAttributes");
        context.put("ServiceName", "ModifyNicAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifyNicAttributes");
        input.setAction("ModifyNicAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class AttachNicsInput
    extends IaasParamBody {
        private String instance;
        private List<String> nics;

        @JsonProperty(value="instance")
        public void setInstance(String instance) {
            this.instance = instance;
        }

        @JsonProperty(value="instance")
        public String getInstance() {
            return this.instance;
        }

        @JsonProperty(value="nics")
        public void setNics(List<String> nics) {
            this.nics = nics;
        }

        @JsonProperty(value="nics")
        public List<String> getNics() {
            return this.nics;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getInstance())) {
                throw new QCException("Instance is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AttachNicsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateNicsInput
    extends IaasParamBody {
        private Integer count;
        private String nICName;
        private List<String> privateIPs;
        private String vxNet;

        @JsonProperty(value="count")
        public void setCount(Integer count) {
            this.count = count;
        }

        @JsonProperty(value="count")
        public Integer getCount() {
            return this.count;
        }

        @JsonProperty(value="nic_name")
        public void setNICName(String nICName) {
            this.nICName = nICName;
        }

        @JsonProperty(value="nic_name")
        public String getNICName() {
            return this.nICName;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<String> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<String> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getVxNet())) {
                throw new QCException("VxNet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateNicsOutput
    extends OutputModel {
        private String action;
        private List<Types.NICIPModel> nics;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="nics")
        public void setNics(List<Types.NICIPModel> nics) {
            this.nics = nics;
        }

        @JsonProperty(value="nics")
        public List<Types.NICIPModel> getNics() {
            return this.nics;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DeleteNicsInput
    extends IaasParamBody {
        private List<String> nics;

        @JsonProperty(value="nics")
        public void setNics(List<String> nics) {
            this.nics = nics;
        }

        @JsonProperty(value="nics")
        public List<String> getNics() {
            return this.nics;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteNicsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class DescribeNicsInput
    extends IaasParamBody {
        private List<String> instances;
        private Integer limit;
        private String nICName;
        private List<String> nics;
        private Integer offset;
        private String owner;
        private String projectID;
        private String status;
        private List<Integer> vxNetType;
        private List<String> vxNets;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="nic_name")
        public void setNICName(String nICName) {
            this.nICName = nICName;
        }

        @JsonProperty(value="nic_name")
        public String getNICName() {
            return this.nICName;
        }

        @JsonProperty(value="nics")
        public void setNics(List<String> nics) {
            this.nics = nics;
        }

        @JsonProperty(value="nics")
        public List<String> getNics() {
            return this.nics;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="vxnet_type")
        public void setVxNetType(List<Integer> vxNetType) {
            this.vxNetType = vxNetType;
        }

        @JsonProperty(value="vxnet_type")
        public List<Integer> getVxNetType() {
            return this.vxNetType;
        }

        @JsonProperty(value="vxnets")
        public void setVxNets(List<String> vxNets) {
            this.vxNets = vxNets;
        }

        @JsonProperty(value="vxnets")
        public List<String> getVxNets() {
            return this.vxNets;
        }

        @Override
        public String validateParam() throws QCException {
            String[] statusValidValues = new String[]{"available", "in-use"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeNicsOutput
    extends OutputModel {
        private String action;
        private List<Types.NICModel> nICSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="nic_set")
        public void setNICSet(List<Types.NICModel> nICSet) {
            this.nICSet = nICSet;
        }

        @JsonProperty(value="nic_set")
        public List<Types.NICModel> getNICSet() {
            return this.nICSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DetachNicsInput
    extends IaasParamBody {
        private List<String> nics;

        @JsonProperty(value="nics")
        public void setNics(List<String> nics) {
            this.nics = nics;
        }

        @JsonProperty(value="nics")
        public List<String> getNics() {
            return this.nics;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DetachNicsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ModifyNicAttributesInput
    extends IaasParamBody {
        private String nIC;
        private String nICName;
        private String privateIP;
        private String vxNet;

        @JsonProperty(value="nic")
        public void setNIC(String nIC) {
            this.nIC = nIC;
        }

        @JsonProperty(value="nic")
        public String getNIC() {
            return this.nIC;
        }

        @JsonProperty(value="nic_name")
        public void setNICName(String nICName) {
            this.nICName = nICName;
        }

        @JsonProperty(value="nic_name")
        public String getNICName() {
            return this.nICName;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(String vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public String getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getNIC())) {
                throw new QCException("NIC is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifyNicAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }
}

