/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class NotificationService {
    private EnvContext envContext;
    private String zone;

    public NotificationService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public NotificationService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public DescribeNotificationListsOutput describeNotificationLists(DescribeNotificationListsInput input) throws QCException {
        if (input == null) {
            input = new DescribeNotificationListsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeNotificationLists");
        context.put("APIName", "DescribeNotificationLists");
        context.put("ServiceName", "DescribeNotificationLists");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeNotificationLists");
        input.setAction("DescribeNotificationLists");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeNotificationListsOutput.class);
        if (backModel != null) {
            return (DescribeNotificationListsOutput)backModel;
        }
        return null;
    }

    public void describeNotificationLists(DescribeNotificationListsInput input, ResponseCallBack<DescribeNotificationListsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeNotificationListsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeNotificationLists");
        context.put("APIName", "DescribeNotificationLists");
        context.put("ServiceName", "DescribeNotificationLists");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeNotificationLists");
        input.setAction("DescribeNotificationLists");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public SendAlarmNotificationOutput sendAlarmNotification(SendAlarmNotificationInput input) throws QCException {
        if (input == null) {
            input = new SendAlarmNotificationInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "SendAlarmNotification");
        context.put("APIName", "SendAlarmNotification");
        context.put("ServiceName", "SendAlarmNotification");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/SendAlarmNotification");
        input.setAction("SendAlarmNotification");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, SendAlarmNotificationOutput.class);
        if (backModel != null) {
            return (SendAlarmNotificationOutput)backModel;
        }
        return null;
    }

    public void sendAlarmNotification(SendAlarmNotificationInput input, ResponseCallBack<SendAlarmNotificationOutput> callback) throws QCException {
        if (input == null) {
            input = new SendAlarmNotificationInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "SendAlarmNotification");
        context.put("APIName", "SendAlarmNotification");
        context.put("ServiceName", "SendAlarmNotification");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/SendAlarmNotification");
        input.setAction("SendAlarmNotification");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class DescribeNotificationListsInput
    extends IaasParamBody {
        private Integer limit;
        private List<String> notificationLists;
        private Integer offset;
        private String owner;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="notification_lists")
        public void setNotificationLists(List<String> notificationLists) {
            this.notificationLists = notificationLists;
        }

        @JsonProperty(value="notification_lists")
        public List<String> getNotificationLists() {
            return this.notificationLists;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeNotificationListsOutput
    extends OutputModel {
        private String action;
        private List<Types.NotificationListModel> notificationListSet;
        private Integer retCode;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="notification_list_set")
        public void setNotificationListSet(List<Types.NotificationListModel> notificationListSet) {
            this.notificationListSet = notificationListSet;
        }

        @JsonProperty(value="notification_list_set")
        public List<Types.NotificationListModel> getNotificationListSet() {
            return this.notificationListSet;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class SendAlarmNotificationInput
    extends IaasParamBody {
        private List<Types.NotificationDataModel> notificationData;
        private String notificationListID;
        private String resourceID;
        private String resourceName;
        private String resourceType;
        private String userID;

        @JsonProperty(value="notification_data")
        public void setNotificationData(List<Types.NotificationDataModel> notificationData) {
            this.notificationData = notificationData;
        }

        @JsonProperty(value="notification_data")
        public List<Types.NotificationDataModel> getNotificationData() {
            return this.notificationData;
        }

        @JsonProperty(value="notification_list_id")
        public void setNotificationListID(String notificationListID) {
            this.notificationListID = notificationListID;
        }

        @JsonProperty(value="notification_list_id")
        public String getNotificationListID() {
            return this.notificationListID;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="resource_name")
        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @JsonProperty(value="resource_name")
        public String getResourceName() {
            return this.resourceName;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @JsonProperty(value="user_id")
        public void setUserID(String userID) {
            this.userID = userID;
        }

        @JsonProperty(value="user_id")
        public String getUserID() {
            return this.userID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getNotificationData() != null && this.getNotificationData().size() > 0 && (i = 0) < this.getNotificationData().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getNotificationListID())) {
                throw new QCException("NotificationListID is required");
            }
            if (QCStringUtil.isEmpty(this.getUserID())) {
                throw new QCException("UserID is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SendAlarmNotificationOutput
    extends OutputModel {
        private String action;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }
}

