/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.service.Types;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;
import java.util.List;

public class SecurityGroupService {
    private EnvContext envContext;
    private String zone;

    public SecurityGroupService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public SecurityGroupService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public AddSecurityGroupRulesOutput addSecurityGroupRules(AddSecurityGroupRulesInput input) throws QCException {
        if (input == null) {
            input = new AddSecurityGroupRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddSecurityGroupRules");
        context.put("APIName", "AddSecurityGroupRules");
        context.put("ServiceName", "AddSecurityGroupRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddSecurityGroupRules");
        input.setAction("AddSecurityGroupRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, AddSecurityGroupRulesOutput.class);
        if (backModel != null) {
            return (AddSecurityGroupRulesOutput)backModel;
        }
        return null;
    }

    public void addSecurityGroupRules(AddSecurityGroupRulesInput input, ResponseCallBack<AddSecurityGroupRulesOutput> callback) throws QCException {
        if (input == null) {
            input = new AddSecurityGroupRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "AddSecurityGroupRules");
        context.put("APIName", "AddSecurityGroupRules");
        context.put("ServiceName", "AddSecurityGroupRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/AddSecurityGroupRules");
        input.setAction("AddSecurityGroupRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ApplySecurityGroupOutput applySecurityGroup(ApplySecurityGroupInput input) throws QCException {
        if (input == null) {
            input = new ApplySecurityGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplySecurityGroup");
        context.put("APIName", "ApplySecurityGroup");
        context.put("ServiceName", "ApplySecurityGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplySecurityGroup");
        input.setAction("ApplySecurityGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ApplySecurityGroupOutput.class);
        if (backModel != null) {
            return (ApplySecurityGroupOutput)backModel;
        }
        return null;
    }

    public void applySecurityGroup(ApplySecurityGroupInput input, ResponseCallBack<ApplySecurityGroupOutput> callback) throws QCException {
        if (input == null) {
            input = new ApplySecurityGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplySecurityGroup");
        context.put("APIName", "ApplySecurityGroup");
        context.put("ServiceName", "ApplySecurityGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplySecurityGroup");
        input.setAction("ApplySecurityGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ApplySecurityGroupIPSetsOutput applySecurityGroupIPSets(ApplySecurityGroupIPSetsInput input) throws QCException {
        if (input == null) {
            input = new ApplySecurityGroupIPSetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplySecurityGroupIPSets");
        context.put("APIName", "ApplySecurityGroupIPSets");
        context.put("ServiceName", "ApplySecurityGroupIPSets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplySecurityGroupIPSets");
        input.setAction("ApplySecurityGroupIPSets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ApplySecurityGroupIPSetsOutput.class);
        if (backModel != null) {
            return (ApplySecurityGroupIPSetsOutput)backModel;
        }
        return null;
    }

    public void applySecurityGroupIPSets(ApplySecurityGroupIPSetsInput input, ResponseCallBack<ApplySecurityGroupIPSetsOutput> callback) throws QCException {
        if (input == null) {
            input = new ApplySecurityGroupIPSetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ApplySecurityGroupIPSets");
        context.put("APIName", "ApplySecurityGroupIPSets");
        context.put("ServiceName", "ApplySecurityGroupIPSets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ApplySecurityGroupIPSets");
        input.setAction("ApplySecurityGroupIPSets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateSecurityGroupOutput createSecurityGroup(CreateSecurityGroupInput input) throws QCException {
        if (input == null) {
            input = new CreateSecurityGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSecurityGroup");
        context.put("APIName", "CreateSecurityGroup");
        context.put("ServiceName", "CreateSecurityGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSecurityGroup");
        input.setAction("CreateSecurityGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateSecurityGroupOutput.class);
        if (backModel != null) {
            return (CreateSecurityGroupOutput)backModel;
        }
        return null;
    }

    public void createSecurityGroup(CreateSecurityGroupInput input, ResponseCallBack<CreateSecurityGroupOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateSecurityGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSecurityGroup");
        context.put("APIName", "CreateSecurityGroup");
        context.put("ServiceName", "CreateSecurityGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSecurityGroup");
        input.setAction("CreateSecurityGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateSecurityGroupIPSetOutput createSecurityGroupIPSet(CreateSecurityGroupIPSetInput input) throws QCException {
        if (input == null) {
            input = new CreateSecurityGroupIPSetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSecurityGroupIPSet");
        context.put("APIName", "CreateSecurityGroupIPSet");
        context.put("ServiceName", "CreateSecurityGroupIPSet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSecurityGroupIPSet");
        input.setAction("CreateSecurityGroupIPSet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateSecurityGroupIPSetOutput.class);
        if (backModel != null) {
            return (CreateSecurityGroupIPSetOutput)backModel;
        }
        return null;
    }

    public void createSecurityGroupIPSet(CreateSecurityGroupIPSetInput input, ResponseCallBack<CreateSecurityGroupIPSetOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateSecurityGroupIPSetInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSecurityGroupIPSet");
        context.put("APIName", "CreateSecurityGroupIPSet");
        context.put("ServiceName", "CreateSecurityGroupIPSet");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSecurityGroupIPSet");
        input.setAction("CreateSecurityGroupIPSet");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public CreateSecurityGroupSnapshotOutput createSecurityGroupSnapshot(CreateSecurityGroupSnapshotInput input) throws QCException {
        if (input == null) {
            input = new CreateSecurityGroupSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSecurityGroupSnapshot");
        context.put("APIName", "CreateSecurityGroupSnapshot");
        context.put("ServiceName", "CreateSecurityGroupSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSecurityGroupSnapshot");
        input.setAction("CreateSecurityGroupSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, CreateSecurityGroupSnapshotOutput.class);
        if (backModel != null) {
            return (CreateSecurityGroupSnapshotOutput)backModel;
        }
        return null;
    }

    public void createSecurityGroupSnapshot(CreateSecurityGroupSnapshotInput input, ResponseCallBack<CreateSecurityGroupSnapshotOutput> callback) throws QCException {
        if (input == null) {
            input = new CreateSecurityGroupSnapshotInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "CreateSecurityGroupSnapshot");
        context.put("APIName", "CreateSecurityGroupSnapshot");
        context.put("ServiceName", "CreateSecurityGroupSnapshot");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/CreateSecurityGroupSnapshot");
        input.setAction("CreateSecurityGroupSnapshot");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteSecurityGroupIPSetsOutput deleteSecurityGroupIPSets(DeleteSecurityGroupIPSetsInput input) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupIPSetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroupIPSets");
        context.put("APIName", "DeleteSecurityGroupIPSets");
        context.put("ServiceName", "DeleteSecurityGroupIPSets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroupIPSets");
        input.setAction("DeleteSecurityGroupIPSets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteSecurityGroupIPSetsOutput.class);
        if (backModel != null) {
            return (DeleteSecurityGroupIPSetsOutput)backModel;
        }
        return null;
    }

    public void deleteSecurityGroupIPSets(DeleteSecurityGroupIPSetsInput input, ResponseCallBack<DeleteSecurityGroupIPSetsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupIPSetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroupIPSets");
        context.put("APIName", "DeleteSecurityGroupIPSets");
        context.put("ServiceName", "DeleteSecurityGroupIPSets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroupIPSets");
        input.setAction("DeleteSecurityGroupIPSets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteSecurityGroupRulesOutput deleteSecurityGroupRules(DeleteSecurityGroupRulesInput input) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroupRules");
        context.put("APIName", "DeleteSecurityGroupRules");
        context.put("ServiceName", "DeleteSecurityGroupRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroupRules");
        input.setAction("DeleteSecurityGroupRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteSecurityGroupRulesOutput.class);
        if (backModel != null) {
            return (DeleteSecurityGroupRulesOutput)backModel;
        }
        return null;
    }

    public void deleteSecurityGroupRules(DeleteSecurityGroupRulesInput input, ResponseCallBack<DeleteSecurityGroupRulesOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroupRules");
        context.put("APIName", "DeleteSecurityGroupRules");
        context.put("ServiceName", "DeleteSecurityGroupRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroupRules");
        input.setAction("DeleteSecurityGroupRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteSecurityGroupSnapshotsOutput deleteSecurityGroupSnapshots(DeleteSecurityGroupSnapshotsInput input) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroupSnapshots");
        context.put("APIName", "DeleteSecurityGroupSnapshots");
        context.put("ServiceName", "DeleteSecurityGroupSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroupSnapshots");
        input.setAction("DeleteSecurityGroupSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteSecurityGroupSnapshotsOutput.class);
        if (backModel != null) {
            return (DeleteSecurityGroupSnapshotsOutput)backModel;
        }
        return null;
    }

    public void deleteSecurityGroupSnapshots(DeleteSecurityGroupSnapshotsInput input, ResponseCallBack<DeleteSecurityGroupSnapshotsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroupSnapshots");
        context.put("APIName", "DeleteSecurityGroupSnapshots");
        context.put("ServiceName", "DeleteSecurityGroupSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroupSnapshots");
        input.setAction("DeleteSecurityGroupSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DeleteSecurityGroupsOutput deleteSecurityGroups(DeleteSecurityGroupsInput input) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroups");
        context.put("APIName", "DeleteSecurityGroups");
        context.put("ServiceName", "DeleteSecurityGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroups");
        input.setAction("DeleteSecurityGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DeleteSecurityGroupsOutput.class);
        if (backModel != null) {
            return (DeleteSecurityGroupsOutput)backModel;
        }
        return null;
    }

    public void deleteSecurityGroups(DeleteSecurityGroupsInput input, ResponseCallBack<DeleteSecurityGroupsOutput> callback) throws QCException {
        if (input == null) {
            input = new DeleteSecurityGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DeleteSecurityGroups");
        context.put("APIName", "DeleteSecurityGroups");
        context.put("ServiceName", "DeleteSecurityGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DeleteSecurityGroups");
        input.setAction("DeleteSecurityGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeSecurityGroupIPSetsOutput describeSecurityGroupIPSets(DescribeSecurityGroupIPSetsInput input) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupIPSetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroupIPSets");
        context.put("APIName", "DescribeSecurityGroupIPSets");
        context.put("ServiceName", "DescribeSecurityGroupIPSets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroupIPSets");
        input.setAction("DescribeSecurityGroupIPSets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeSecurityGroupIPSetsOutput.class);
        if (backModel != null) {
            return (DescribeSecurityGroupIPSetsOutput)backModel;
        }
        return null;
    }

    public void describeSecurityGroupIPSets(DescribeSecurityGroupIPSetsInput input, ResponseCallBack<DescribeSecurityGroupIPSetsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupIPSetsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroupIPSets");
        context.put("APIName", "DescribeSecurityGroupIPSets");
        context.put("ServiceName", "DescribeSecurityGroupIPSets");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroupIPSets");
        input.setAction("DescribeSecurityGroupIPSets");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeSecurityGroupRulesOutput describeSecurityGroupRules(DescribeSecurityGroupRulesInput input) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroupRules");
        context.put("APIName", "DescribeSecurityGroupRules");
        context.put("ServiceName", "DescribeSecurityGroupRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroupRules");
        input.setAction("DescribeSecurityGroupRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeSecurityGroupRulesOutput.class);
        if (backModel != null) {
            return (DescribeSecurityGroupRulesOutput)backModel;
        }
        return null;
    }

    public void describeSecurityGroupRules(DescribeSecurityGroupRulesInput input, ResponseCallBack<DescribeSecurityGroupRulesOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupRulesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroupRules");
        context.put("APIName", "DescribeSecurityGroupRules");
        context.put("ServiceName", "DescribeSecurityGroupRules");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroupRules");
        input.setAction("DescribeSecurityGroupRules");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeSecurityGroupSnapshotsOutput describeSecurityGroupSnapshots(DescribeSecurityGroupSnapshotsInput input) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroupSnapshots");
        context.put("APIName", "DescribeSecurityGroupSnapshots");
        context.put("ServiceName", "DescribeSecurityGroupSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroupSnapshots");
        input.setAction("DescribeSecurityGroupSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeSecurityGroupSnapshotsOutput.class);
        if (backModel != null) {
            return (DescribeSecurityGroupSnapshotsOutput)backModel;
        }
        return null;
    }

    public void describeSecurityGroupSnapshots(DescribeSecurityGroupSnapshotsInput input, ResponseCallBack<DescribeSecurityGroupSnapshotsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupSnapshotsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroupSnapshots");
        context.put("APIName", "DescribeSecurityGroupSnapshots");
        context.put("ServiceName", "DescribeSecurityGroupSnapshots");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroupSnapshots");
        input.setAction("DescribeSecurityGroupSnapshots");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public DescribeSecurityGroupsOutput describeSecurityGroups(DescribeSecurityGroupsInput input) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroups");
        context.put("APIName", "DescribeSecurityGroups");
        context.put("ServiceName", "DescribeSecurityGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroups");
        input.setAction("DescribeSecurityGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, DescribeSecurityGroupsOutput.class);
        if (backModel != null) {
            return (DescribeSecurityGroupsOutput)backModel;
        }
        return null;
    }

    public void describeSecurityGroups(DescribeSecurityGroupsInput input, ResponseCallBack<DescribeSecurityGroupsOutput> callback) throws QCException {
        if (input == null) {
            input = new DescribeSecurityGroupsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "DescribeSecurityGroups");
        context.put("APIName", "DescribeSecurityGroups");
        context.put("ServiceName", "DescribeSecurityGroups");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/DescribeSecurityGroups");
        input.setAction("DescribeSecurityGroups");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifySecurityGroupAttributesOutput modifySecurityGroupAttributes(ModifySecurityGroupAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifySecurityGroupAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySecurityGroupAttributes");
        context.put("APIName", "ModifySecurityGroupAttributes");
        context.put("ServiceName", "ModifySecurityGroupAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySecurityGroupAttributes");
        input.setAction("ModifySecurityGroupAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifySecurityGroupAttributesOutput.class);
        if (backModel != null) {
            return (ModifySecurityGroupAttributesOutput)backModel;
        }
        return null;
    }

    public void modifySecurityGroupAttributes(ModifySecurityGroupAttributesInput input, ResponseCallBack<ModifySecurityGroupAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifySecurityGroupAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySecurityGroupAttributes");
        context.put("APIName", "ModifySecurityGroupAttributes");
        context.put("ServiceName", "ModifySecurityGroupAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySecurityGroupAttributes");
        input.setAction("ModifySecurityGroupAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifySecurityGroupIPSetAttributesOutput modifySecurityGroupIPSetAttributes(ModifySecurityGroupIPSetAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifySecurityGroupIPSetAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySecurityGroupIPSetAttributes");
        context.put("APIName", "ModifySecurityGroupIPSetAttributes");
        context.put("ServiceName", "ModifySecurityGroupIPSetAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySecurityGroupIPSetAttributes");
        input.setAction("ModifySecurityGroupIPSetAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifySecurityGroupIPSetAttributesOutput.class);
        if (backModel != null) {
            return (ModifySecurityGroupIPSetAttributesOutput)backModel;
        }
        return null;
    }

    public void modifySecurityGroupIPSetAttributes(ModifySecurityGroupIPSetAttributesInput input, ResponseCallBack<ModifySecurityGroupIPSetAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifySecurityGroupIPSetAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySecurityGroupIPSetAttributes");
        context.put("APIName", "ModifySecurityGroupIPSetAttributes");
        context.put("ServiceName", "ModifySecurityGroupIPSetAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySecurityGroupIPSetAttributes");
        input.setAction("ModifySecurityGroupIPSetAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public ModifySecurityGroupRuleAttributesOutput modifySecurityGroupRuleAttributes(ModifySecurityGroupRuleAttributesInput input) throws QCException {
        if (input == null) {
            input = new ModifySecurityGroupRuleAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySecurityGroupRuleAttributes");
        context.put("APIName", "ModifySecurityGroupRuleAttributes");
        context.put("ServiceName", "ModifySecurityGroupRuleAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySecurityGroupRuleAttributes");
        input.setAction("ModifySecurityGroupRuleAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, ModifySecurityGroupRuleAttributesOutput.class);
        if (backModel != null) {
            return (ModifySecurityGroupRuleAttributesOutput)backModel;
        }
        return null;
    }

    public void modifySecurityGroupRuleAttributes(ModifySecurityGroupRuleAttributesInput input, ResponseCallBack<ModifySecurityGroupRuleAttributesOutput> callback) throws QCException {
        if (input == null) {
            input = new ModifySecurityGroupRuleAttributesInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "ModifySecurityGroupRuleAttributes");
        context.put("APIName", "ModifySecurityGroupRuleAttributes");
        context.put("ServiceName", "ModifySecurityGroupRuleAttributes");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/ModifySecurityGroupRuleAttributes");
        input.setAction("ModifySecurityGroupRuleAttributes");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public RollbackSecurityGroupOutput rollbackSecurityGroup(RollbackSecurityGroupInput input) throws QCException {
        if (input == null) {
            input = new RollbackSecurityGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RollbackSecurityGroup");
        context.put("APIName", "RollbackSecurityGroup");
        context.put("ServiceName", "RollbackSecurityGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RollbackSecurityGroup");
        input.setAction("RollbackSecurityGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, RollbackSecurityGroupOutput.class);
        if (backModel != null) {
            return (RollbackSecurityGroupOutput)backModel;
        }
        return null;
    }

    public void rollbackSecurityGroup(RollbackSecurityGroupInput input, ResponseCallBack<RollbackSecurityGroupOutput> callback) throws QCException {
        if (input == null) {
            input = new RollbackSecurityGroupInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "RollbackSecurityGroup");
        context.put("APIName", "RollbackSecurityGroup");
        context.put("ServiceName", "RollbackSecurityGroup");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/iaas/RollbackSecurityGroup");
        input.setAction("RollbackSecurityGroup");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class AddSecurityGroupRulesInput
    extends IaasParamBody {
        private List<Types.SecurityGroupRuleModel> rules;
        private String securityGroup;

        @JsonProperty(value="rules")
        public void setRules(List<Types.SecurityGroupRuleModel> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="rules")
        public List<Types.SecurityGroupRuleModel> getRules() {
            return this.rules;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getRules() != null && this.getRules().size() > 0 && (i = 0) < this.getRules().size()) {
                return null;
            }
            if (QCStringUtil.isEmpty(this.getSecurityGroup())) {
                throw new QCException("SecurityGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AddSecurityGroupRulesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> securityGroupRules;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_rules")
        public void setSecurityGroupRules(List<String> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
        }

        @JsonProperty(value="security_group_rules")
        public List<String> getSecurityGroupRules() {
            return this.securityGroupRules;
        }
    }

    public static class ApplySecurityGroupInput
    extends IaasParamBody {
        private List<String> instances;
        private String securityGroup;

        @JsonProperty(value="instances")
        public void setInstances(List<String> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<String> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSecurityGroup())) {
                throw new QCException("SecurityGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplySecurityGroupOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class ApplySecurityGroupIPSetsInput
    extends IaasParamBody {
        private List<String> securityGroupIPSets;

        @JsonProperty(value="security_group_ipsets")
        public void setSecurityGroupIPSets(List<String> securityGroupIPSets) {
            this.securityGroupIPSets = securityGroupIPSets;
        }

        @JsonProperty(value="security_group_ipsets")
        public List<String> getSecurityGroupIPSets() {
            return this.securityGroupIPSets;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplySecurityGroupIPSetsOutput
    extends OutputModel {
        private String action;
        private String jobID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }

    public static class CreateSecurityGroupInput
    extends IaasParamBody {
        private String securityGroupName;

        @JsonProperty(value="security_group_name")
        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }

        @JsonProperty(value="security_group_name")
        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateSecurityGroupOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String securityGroupID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }
    }

    public static class CreateSecurityGroupIPSetInput
    extends IaasParamBody {
        private Integer iPSetType;
        private String securityGroupIPSetName;
        private String val;

        @JsonProperty(value="ipset_type")
        public void setIPSetType(Integer iPSetType) {
            this.iPSetType = iPSetType;
        }

        @JsonProperty(value="ipset_type")
        public Integer getIPSetType() {
            return this.iPSetType;
        }

        @JsonProperty(value="security_group_ipset_name")
        public void setSecurityGroupIPSetName(String securityGroupIPSetName) {
            this.securityGroupIPSetName = securityGroupIPSetName;
        }

        @JsonProperty(value="security_group_ipset_name")
        public String getSecurityGroupIPSetName() {
            return this.securityGroupIPSetName;
        }

        @JsonProperty(value="val")
        public void setVal(String val) {
            this.val = val;
        }

        @JsonProperty(value="val")
        public String getVal() {
            return this.val;
        }

        @Override
        public String validateParam() throws QCException {
            if (this.getIPSetType() < 0) {
                throw new QCException("IPSetType is required");
            }
            String[] iPSetTypeValidValues = new String[]{"0", "1"};
            boolean iPSetTypeIsValid = false;
            for (String v : iPSetTypeValidValues) {
                Boolean iPSetTypeIsRequired;
                if (v.equals(this.getIPSetType() + "")) {
                    iPSetTypeIsValid = true;
                }
                if (!(iPSetTypeIsRequired = Boolean.TRUE).equals(Boolean.FALSE) || this.getIPSetType() != null) continue;
                iPSetTypeIsValid = true;
            }
            if (!iPSetTypeIsValid) {
                throw new QCException("IPSetType value " + this.getIPSetType() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getVal())) {
                throw new QCException("Val is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateSecurityGroupIPSetOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String securityGroupIPSetID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_ipset_id")
        public void setSecurityGroupIPSetID(String securityGroupIPSetID) {
            this.securityGroupIPSetID = securityGroupIPSetID;
        }

        @JsonProperty(value="security_group_ipset_id")
        public String getSecurityGroupIPSetID() {
            return this.securityGroupIPSetID;
        }
    }

    public static class CreateSecurityGroupSnapshotInput
    extends IaasParamBody {
        private String name;
        private String securityGroup;

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSecurityGroup())) {
                throw new QCException("SecurityGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateSecurityGroupSnapshotOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String securityGroupID;
        private String securityGroupSnapshotID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="security_group_snapshot_id")
        public void setSecurityGroupSnapshotID(String securityGroupSnapshotID) {
            this.securityGroupSnapshotID = securityGroupSnapshotID;
        }

        @JsonProperty(value="security_group_snapshot_id")
        public String getSecurityGroupSnapshotID() {
            return this.securityGroupSnapshotID;
        }
    }

    public static class DeleteSecurityGroupIPSetsInput
    extends IaasParamBody {
        private List<String> securityGroupIPSets;

        @JsonProperty(value="security_group_ipsets")
        public void setSecurityGroupIPSets(List<String> securityGroupIPSets) {
            this.securityGroupIPSets = securityGroupIPSets;
        }

        @JsonProperty(value="security_group_ipsets")
        public List<String> getSecurityGroupIPSets() {
            return this.securityGroupIPSets;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteSecurityGroupIPSetsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> securityGroupIPSets;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_ipsets")
        public void setSecurityGroupIPSets(List<String> securityGroupIPSets) {
            this.securityGroupIPSets = securityGroupIPSets;
        }

        @JsonProperty(value="security_group_ipsets")
        public List<String> getSecurityGroupIPSets() {
            return this.securityGroupIPSets;
        }
    }

    public static class DeleteSecurityGroupRulesInput
    extends IaasParamBody {
        private List<String> securityGroupRules;

        @JsonProperty(value="security_group_rules")
        public void setSecurityGroupRules(List<String> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
        }

        @JsonProperty(value="security_group_rules")
        public List<String> getSecurityGroupRules() {
            return this.securityGroupRules;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteSecurityGroupRulesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> securityGroupRules;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_rules")
        public void setSecurityGroupRules(List<String> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
        }

        @JsonProperty(value="security_group_rules")
        public List<String> getSecurityGroupRules() {
            return this.securityGroupRules;
        }
    }

    public static class DeleteSecurityGroupSnapshotsInput
    extends IaasParamBody {
        private List<String> securityGroupSnapshots;

        @JsonProperty(value="security_group_snapshots")
        public void setSecurityGroupSnapshots(List<String> securityGroupSnapshots) {
            this.securityGroupSnapshots = securityGroupSnapshots;
        }

        @JsonProperty(value="security_group_snapshots")
        public List<String> getSecurityGroupSnapshots() {
            return this.securityGroupSnapshots;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteSecurityGroupSnapshotsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> securityGroupSnapshots;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_snapshots")
        public void setSecurityGroupSnapshots(List<String> securityGroupSnapshots) {
            this.securityGroupSnapshots = securityGroupSnapshots;
        }

        @JsonProperty(value="security_group_snapshots")
        public List<String> getSecurityGroupSnapshots() {
            return this.securityGroupSnapshots;
        }
    }

    public static class DeleteSecurityGroupsInput
    extends IaasParamBody {
        private List<String> securityGroups;

        @JsonProperty(value="security_groups")
        public void setSecurityGroups(List<String> securityGroups) {
            this.securityGroups = securityGroups;
        }

        @JsonProperty(value="security_groups")
        public List<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DeleteSecurityGroupsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<String> securityGroups;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_groups")
        public void setSecurityGroups(List<String> securityGroups) {
            this.securityGroups = securityGroups;
        }

        @JsonProperty(value="security_groups")
        public List<String> getSecurityGroups() {
            return this.securityGroups;
        }
    }

    public static class DescribeSecurityGroupIPSetsInput
    extends IaasParamBody {
        private Integer iPSetType;
        private Integer limit;
        private Integer offset;
        private String owner;
        private String projectID;
        private String securityGroupIPSetName;
        private List<String> securityGroupIPSets;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="ipset_type")
        public void setIPSetType(Integer iPSetType) {
            this.iPSetType = iPSetType;
        }

        @JsonProperty(value="ipset_type")
        public Integer getIPSetType() {
            return this.iPSetType;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="security_group_ipset_name")
        public void setSecurityGroupIPSetName(String securityGroupIPSetName) {
            this.securityGroupIPSetName = securityGroupIPSetName;
        }

        @JsonProperty(value="security_group_ipset_name")
        public String getSecurityGroupIPSetName() {
            return this.securityGroupIPSetName;
        }

        @JsonProperty(value="security_group_ipsets")
        public void setSecurityGroupIPSets(List<String> securityGroupIPSets) {
            this.securityGroupIPSets = securityGroupIPSets;
        }

        @JsonProperty(value="security_group_ipsets")
        public List<String> getSecurityGroupIPSets() {
            return this.securityGroupIPSets;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            String[] iPSetTypeValidValues = new String[]{"0", "1"};
            boolean iPSetTypeIsValid = false;
            for (String v : iPSetTypeValidValues) {
                Boolean iPSetTypeIsRequired;
                if (v.equals(this.getIPSetType() + "")) {
                    iPSetTypeIsValid = true;
                }
                if (!(iPSetTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIPSetType() != null) continue;
                iPSetTypeIsValid = true;
            }
            if (!iPSetTypeIsValid) {
                throw new QCException("IPSetType value " + this.getIPSetType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeSecurityGroupIPSetsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.SecurityGroupIPSetModel> securityGroupIPSetSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_ipset_set")
        public void setSecurityGroupIPSetSet(List<Types.SecurityGroupIPSetModel> securityGroupIPSetSet) {
            this.securityGroupIPSetSet = securityGroupIPSetSet;
        }

        @JsonProperty(value="security_group_ipset_set")
        public List<Types.SecurityGroupIPSetModel> getSecurityGroupIPSetSet() {
            return this.securityGroupIPSetSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeSecurityGroupRulesInput
    extends IaasParamBody {
        private Integer direction;
        private Integer limit;
        private Integer offset;
        private String owner;
        private String securityGroup;
        private List<String> securityGroupRules;

        @JsonProperty(value="direction")
        public void setDirection(Integer direction) {
            this.direction = direction;
        }

        @JsonProperty(value="direction")
        public Integer getDirection() {
            return this.direction;
        }

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="security_group_rules")
        public void setSecurityGroupRules(List<String> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
        }

        @JsonProperty(value="security_group_rules")
        public List<String> getSecurityGroupRules() {
            return this.securityGroupRules;
        }

        @Override
        public String validateParam() throws QCException {
            String[] directionValidValues = new String[]{"0", "1"};
            boolean directionIsValid = false;
            for (String v : directionValidValues) {
                Boolean directionIsRequired;
                if (v.equals(this.getDirection() + "")) {
                    directionIsValid = true;
                }
                if (!(directionIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getDirection() != null) continue;
                directionIsValid = true;
            }
            if (!directionIsValid) {
                throw new QCException("Direction value " + this.getDirection() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeSecurityGroupRulesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.SecurityGroupRuleModel> securityGroupRuleSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_rule_set")
        public void setSecurityGroupRuleSet(List<Types.SecurityGroupRuleModel> securityGroupRuleSet) {
            this.securityGroupRuleSet = securityGroupRuleSet;
        }

        @JsonProperty(value="security_group_rule_set")
        public List<Types.SecurityGroupRuleModel> getSecurityGroupRuleSet() {
            return this.securityGroupRuleSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeSecurityGroupSnapshotsInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String projectID;
        private Integer reverse;
        private String securityGroup;
        private List<String> securityGroupSnapshots;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="reverse")
        public void setReverse(Integer reverse) {
            this.reverse = reverse;
        }

        @JsonProperty(value="reverse")
        public Integer getReverse() {
            return this.reverse;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="security_group_snapshots")
        public void setSecurityGroupSnapshots(List<String> securityGroupSnapshots) {
            this.securityGroupSnapshots = securityGroupSnapshots;
        }

        @JsonProperty(value="security_group_snapshots")
        public List<String> getSecurityGroupSnapshots() {
            return this.securityGroupSnapshots;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSecurityGroup())) {
                throw new QCException("SecurityGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeSecurityGroupSnapshotsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.SecurityGroupSnapshotModel> securityGroupSnapshotSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_snapshot_set")
        public void setSecurityGroupSnapshotSet(List<Types.SecurityGroupSnapshotModel> securityGroupSnapshotSet) {
            this.securityGroupSnapshotSet = securityGroupSnapshotSet;
        }

        @JsonProperty(value="security_group_snapshot_set")
        public List<Types.SecurityGroupSnapshotModel> getSecurityGroupSnapshotSet() {
            return this.securityGroupSnapshotSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class DescribeSecurityGroupsInput
    extends IaasParamBody {
        private Integer limit;
        private Integer offset;
        private String owner;
        private String projectID;
        private String searchWord;
        private List<String> securityGroups;
        private List<String> tags;
        private Integer verbose;

        @JsonProperty(value="limit")
        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit")
        public Integer getLimit() {
            return this.limit;
        }

        @JsonProperty(value="offset")
        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        @JsonProperty(value="offset")
        public Integer getOffset() {
            return this.offset;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="search_word")
        public void setSearchWord(String searchWord) {
            this.searchWord = searchWord;
        }

        @JsonProperty(value="search_word")
        public String getSearchWord() {
            return this.searchWord;
        }

        @JsonProperty(value="security_groups")
        public void setSecurityGroups(List<String> securityGroups) {
            this.securityGroups = securityGroups;
        }

        @JsonProperty(value="security_groups")
        public List<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="verbose")
        public void setVerbose(Integer verbose) {
            this.verbose = verbose;
        }

        @JsonProperty(value="verbose")
        public Integer getVerbose() {
            return this.verbose;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DescribeSecurityGroupsOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private List<Types.SecurityGroupModel> securityGroupSet;
        private Integer totalCount;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_set")
        public void setSecurityGroupSet(List<Types.SecurityGroupModel> securityGroupSet) {
            this.securityGroupSet = securityGroupSet;
        }

        @JsonProperty(value="security_group_set")
        public List<Types.SecurityGroupModel> getSecurityGroupSet() {
            return this.securityGroupSet;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }
    }

    public static class ModifySecurityGroupAttributesInput
    extends IaasParamBody {
        private String description;
        private String securityGroup;
        private String securityGroupName;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="security_group_name")
        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }

        @JsonProperty(value="security_group_name")
        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSecurityGroup())) {
                throw new QCException("SecurityGroup is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifySecurityGroupAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String securityGroupID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }
    }

    public static class ModifySecurityGroupIPSetAttributesInput
    extends IaasParamBody {
        private String description;
        private String securityGroupIPSet;
        private String securityGroupIPSetName;
        private String val;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="security_group_ipset")
        public void setSecurityGroupIPSet(String securityGroupIPSet) {
            this.securityGroupIPSet = securityGroupIPSet;
        }

        @JsonProperty(value="security_group_ipset")
        public String getSecurityGroupIPSet() {
            return this.securityGroupIPSet;
        }

        @JsonProperty(value="security_group_ipset_name")
        public void setSecurityGroupIPSetName(String securityGroupIPSetName) {
            this.securityGroupIPSetName = securityGroupIPSetName;
        }

        @JsonProperty(value="security_group_ipset_name")
        public String getSecurityGroupIPSetName() {
            return this.securityGroupIPSetName;
        }

        @JsonProperty(value="val")
        public void setVal(String val) {
            this.val = val;
        }

        @JsonProperty(value="val")
        public String getVal() {
            return this.val;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSecurityGroupIPSet())) {
                throw new QCException("SecurityGroupIPSet is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifySecurityGroupIPSetAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String securityGroupIPSetID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_ipset_id")
        public void setSecurityGroupIPSetID(String securityGroupIPSetID) {
            this.securityGroupIPSetID = securityGroupIPSetID;
        }

        @JsonProperty(value="security_group_ipset_id")
        public String getSecurityGroupIPSetID() {
            return this.securityGroupIPSetID;
        }
    }

    public static class ModifySecurityGroupRuleAttributesInput
    extends IaasParamBody {
        private Integer direction;
        private Integer priority;
        private String protocol;
        private String ruleAction;
        private String securityGroup;
        private String securityGroupRule;
        private String securityGroupRuleName;
        private String val1;
        private String val2;
        private String val3;

        @JsonProperty(value="direction")
        public void setDirection(Integer direction) {
            this.direction = direction;
        }

        @JsonProperty(value="direction")
        public Integer getDirection() {
            return this.direction;
        }

        @JsonProperty(value="priority")
        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        @JsonProperty(value="priority")
        public Integer getPriority() {
            return this.priority;
        }

        @JsonProperty(value="protocol")
        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @JsonProperty(value="protocol")
        public String getProtocol() {
            return this.protocol;
        }

        @JsonProperty(value="rule_action")
        public void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @JsonProperty(value="rule_action")
        public String getRuleAction() {
            return this.ruleAction;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="security_group_rule")
        public void setSecurityGroupRule(String securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
        }

        @JsonProperty(value="security_group_rule")
        public String getSecurityGroupRule() {
            return this.securityGroupRule;
        }

        @JsonProperty(value="security_group_rule_name")
        public void setSecurityGroupRuleName(String securityGroupRuleName) {
            this.securityGroupRuleName = securityGroupRuleName;
        }

        @JsonProperty(value="security_group_rule_name")
        public String getSecurityGroupRuleName() {
            return this.securityGroupRuleName;
        }

        @JsonProperty(value="val1")
        public void setVal1(String val1) {
            this.val1 = val1;
        }

        @JsonProperty(value="val1")
        public String getVal1() {
            return this.val1;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @JsonProperty(value="val3")
        public void setVal3(String val3) {
            this.val3 = val3;
        }

        @JsonProperty(value="val3")
        public String getVal3() {
            return this.val3;
        }

        @Override
        public String validateParam() throws QCException {
            String[] directionValidValues = new String[]{"0", "1"};
            boolean directionIsValid = false;
            for (String v : directionValidValues) {
                Boolean directionIsRequired;
                if (v.equals(this.getDirection() + "")) {
                    directionIsValid = true;
                }
                if (!(directionIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getDirection() != null) continue;
                directionIsValid = true;
            }
            if (!directionIsValid) {
                throw new QCException("Direction value " + this.getDirection() + "is invalid");
            }
            String[] ruleActionValidValues = new String[]{"accept", "drop"};
            boolean ruleActionIsValid = false;
            for (String v : ruleActionValidValues) {
                Boolean ruleActionIsRequired;
                if (v.equals(this.getRuleAction())) {
                    ruleActionIsValid = true;
                }
                if (!(ruleActionIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getRuleAction() != null) continue;
                ruleActionIsValid = true;
            }
            if (!ruleActionIsValid) {
                throw new QCException("RuleAction value " + this.getRuleAction() + "is invalid");
            }
            if (QCStringUtil.isEmpty(this.getSecurityGroupRule())) {
                throw new QCException("SecurityGroupRule is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModifySecurityGroupRuleAttributesOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String securityGroupRuleID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_rule_id")
        public void setSecurityGroupRuleID(String securityGroupRuleID) {
            this.securityGroupRuleID = securityGroupRuleID;
        }

        @JsonProperty(value="security_group_rule_id")
        public String getSecurityGroupRuleID() {
            return this.securityGroupRuleID;
        }
    }

    public static class RollbackSecurityGroupInput
    extends IaasParamBody {
        private String securityGroup;
        private String securityGroupSnapshot;

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="security_group_snapshot")
        public void setSecurityGroupSnapshot(String securityGroupSnapshot) {
            this.securityGroupSnapshot = securityGroupSnapshot;
        }

        @JsonProperty(value="security_group_snapshot")
        public String getSecurityGroupSnapshot() {
            return this.securityGroupSnapshot;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getSecurityGroup())) {
                throw new QCException("SecurityGroup is required");
            }
            if (QCStringUtil.isEmpty(this.getSecurityGroupSnapshot())) {
                throw new QCException("SecurityGroupSnapshot is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RollbackSecurityGroupOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String securityGroupID;
        private String securityGroupSnapshotID;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="security_group_snapshot_id")
        public void setSecurityGroupSnapshotID(String securityGroupSnapshotID) {
            this.securityGroupSnapshotID = securityGroupSnapshotID;
        }

        @JsonProperty(value="security_group_snapshot_id")
        public String getSecurityGroupSnapshotID() {
            return this.securityGroupSnapshotID;
        }
    }
}

