/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.QCOkHttpRequestClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private static final String CREDENTIAL_PROXY_HOST = "169.254.169.254";
    private static final String CREDENTIAL_PROXY_PORT = "80";
    private static final String CREDENTIAL_PROXY_PROTOCOL = "http";
    private static final String CREDENTIAL_PROXY_URI = "/latest/meta-data/security-credentials";
    private EnvContext envContext;

    public TokenService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public GetTokenOutput getToken() {
        OutputModel model;
        Request request = QCOkHttpRequestClient.getInstance().buildGetRequest(this.getCredentialProxyUrl(), "");
        try {
            model = QCOkHttpRequestClient.getInstance().requestAction(request, true, GetTokenOutput.class);
        }
        catch (QCException e) {
            logger.error("Failed to get credentials, error: {}", (Object)e.getMessage());
            return null;
        }
        if (model != null) {
            return (GetTokenOutput)model;
        }
        return null;
    }

    private String getCredentialProxyUrl() {
        String credentialProxyProtocol = this.envContext.getCredentialProxyProtocol() != null && !this.envContext.getCredentialProxyProtocol().isEmpty() ? this.envContext.getCredentialProxyProtocol() : CREDENTIAL_PROXY_PROTOCOL;
        String credentialProxyHost = this.envContext.getCredentialProxyHost() != null && !this.envContext.getCredentialProxyHost().isEmpty() ? this.envContext.getCredentialProxyHost() : CREDENTIAL_PROXY_HOST;
        String credentialProxyPort = this.envContext.getCredentialProxyPort() != null && !this.envContext.getCredentialProxyPort().isEmpty() ? this.envContext.getCredentialProxyPort() : CREDENTIAL_PROXY_PORT;
        String credentialProxyUri = this.envContext.getCredentialProxyUri() != null && !this.envContext.getCredentialProxyUri().isEmpty() ? this.envContext.getCredentialProxyUri() : CREDENTIAL_PROXY_URI;
        return String.format("%s://%s:%s%s", credentialProxyProtocol, credentialProxyHost, credentialProxyPort, credentialProxyUri);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetTokenOutput
    extends OutputModel {
        private String action;
        private Integer retCode;
        private String jti;
        private String token;
        private String accessKey;
        private String accessSecret;
        private String expiration;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }

        @JsonProperty(value="jti")
        public String getJti() {
            return this.jti;
        }

        @JsonProperty(value="jti")
        public void setJti(String jti) {
            this.jti = jti;
        }

        @JsonProperty(value="id_token")
        public String getToken() {
            return this.token;
        }

        @JsonProperty(value="id_token")
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(value="access_key")
        public String getAccessKey() {
            return this.accessKey;
        }

        @JsonProperty(value="access_key")
        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        @JsonProperty(value="secret_key")
        public String getAccessSecret() {
            return this.accessSecret;
        }

        @JsonProperty(value="secret_key")
        public void setAccessSecret(String accessSecret) {
            this.accessSecret = accessSecret;
        }

        @JsonProperty(value="expiration")
        public String getExpiration() {
            return this.expiration;
        }

        @JsonProperty(value="expiration")
        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }
    }
}

