/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.request.ParamValidate;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.List;
import java.util.Map;

public class Types {

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ZoneModel
    implements ParamValidate {
        private String regionID;
        private String status;
        private String zoneID;

        @JsonProperty(value="region_id")
        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        @JsonProperty(value="region_id")
        public String getRegionID() {
            return this.regionID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="zone_id")
        public void setZoneID(String zoneID) {
            this.zoneID = zoneID;
        }

        @JsonProperty(value="zone_id")
        public String getZoneID() {
            return this.zoneID;
        }

        @Override
        public String validateParam() throws QCException {
            String[] statusValidValues = new String[]{"active", "faulty", "defunct"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class VxNetModel
    implements ParamValidate {
        private Integer availableIPCount;
        private String createTime;
        private String description;
        private List<String> instanceIDs;
        private String owner;
        private RouterModel router;
        private List<TagModel> tags;
        private String vpcRouterID;
        private String vxNetID;
        private String vxNetName;
        private Integer vxNetType;
        private String zoneID;

        @JsonProperty(value="available_ip_count")
        public void setAvailableIPCount(Integer availableIPCount) {
            this.availableIPCount = availableIPCount;
        }

        @JsonProperty(value="available_ip_count")
        public Integer getAvailableIPCount() {
            return this.availableIPCount;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="instance_ids")
        public void setInstanceIDs(List<String> instanceIDs) {
            this.instanceIDs = instanceIDs;
        }

        @JsonProperty(value="instance_ids")
        public List<String> getInstanceIDs() {
            return this.instanceIDs;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="router")
        public void setRouter(RouterModel router) {
            this.router = router;
        }

        @JsonProperty(value="router")
        public RouterModel getRouter() {
            return this.router;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="vpc_router_id")
        public void setVpcRouterID(String vpcRouterID) {
            this.vpcRouterID = vpcRouterID;
        }

        @JsonProperty(value="vpc_router_id")
        public String getVpcRouterID() {
            return this.vpcRouterID;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @JsonProperty(value="vxnet_name")
        public void setVxNetName(String vxNetName) {
            this.vxNetName = vxNetName;
        }

        @JsonProperty(value="vxnet_name")
        public String getVxNetName() {
            return this.vxNetName;
        }

        @JsonProperty(value="vxnet_type")
        public void setVxNetType(Integer vxNetType) {
            this.vxNetType = vxNetType;
        }

        @JsonProperty(value="vxnet_type")
        public Integer getVxNetType() {
            return this.vxNetType;
        }

        @JsonProperty(value="zone_id")
        public void setZoneID(String zoneID) {
            this.zoneID = zoneID;
        }

        @JsonProperty(value="zone_id")
        public String getZoneID() {
            return this.zoneID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] vxNetTypeValidValues = new String[]{"0", "1", "2"};
            boolean vxNetTypeIsValid = false;
            for (String v : vxNetTypeValidValues) {
                Boolean vxNetTypeIsRequired;
                if (v.equals(this.getVxNetType() + "")) {
                    vxNetTypeIsValid = true;
                }
                if (!(vxNetTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVxNetType() != null) continue;
                vxNetTypeIsValid = true;
            }
            if (!vxNetTypeIsValid) {
                throw new QCException("VxNetType value " + this.getVxNetType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class VolumeModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private String device;
        private InstanceModel instance;
        private List<InstanceModel> instances;
        private String latestSnapshotTime;
        private String owner;
        private String placeGroupID;
        private String repl;
        private Integer size;
        private String status;
        private String statusTime;
        private Integer subCode;
        private List<TagModel> tags;
        private String transitionStatus;
        private String volumeID;
        private String volumeName;
        private Integer volumeType;
        private String zoneID;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="device")
        public void setDevice(String device) {
            this.device = device;
        }

        @JsonProperty(value="device")
        public String getDevice() {
            return this.device;
        }

        @JsonProperty(value="instance")
        public void setInstance(InstanceModel instance) {
            this.instance = instance;
        }

        @JsonProperty(value="instance")
        public InstanceModel getInstance() {
            return this.instance;
        }

        @JsonProperty(value="instances")
        public void setInstances(List<InstanceModel> instances) {
            this.instances = instances;
        }

        @JsonProperty(value="instances")
        public List<InstanceModel> getInstances() {
            return this.instances;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public void setLatestSnapshotTime(String latestSnapshotTime) {
            this.latestSnapshotTime = latestSnapshotTime;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public String getLatestSnapshotTime() {
            return this.latestSnapshotTime;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="place_group_id")
        public void setPlaceGroupID(String placeGroupID) {
            this.placeGroupID = placeGroupID;
        }

        @JsonProperty(value="place_group_id")
        public String getPlaceGroupID() {
            return this.placeGroupID;
        }

        @JsonProperty(value="repl")
        public void setRepl(String repl) {
            this.repl = repl;
        }

        @JsonProperty(value="repl")
        public String getRepl() {
            return this.repl;
        }

        @JsonProperty(value="size")
        public void setSize(Integer size) {
            this.size = size;
        }

        @JsonProperty(value="size")
        public Integer getSize() {
            return this.size;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_code")
        public void setSubCode(Integer subCode) {
            this.subCode = subCode;
        }

        @JsonProperty(value="sub_code")
        public Integer getSubCode() {
            return this.subCode;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="volume_id")
        public void setVolumeID(String volumeID) {
            this.volumeID = volumeID;
        }

        @JsonProperty(value="volume_id")
        public String getVolumeID() {
            return this.volumeID;
        }

        @JsonProperty(value="volume_name")
        public void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @JsonProperty(value="volume_name")
        public String getVolumeName() {
            return this.volumeName;
        }

        @JsonProperty(value="volume_type")
        public void setVolumeType(Integer volumeType) {
            this.volumeType = volumeType;
        }

        @JsonProperty(value="volume_type")
        public Integer getVolumeType() {
            return this.volumeType;
        }

        @JsonProperty(value="zone_id")
        public void setZoneID(String zoneID) {
            this.zoneID = zoneID;
        }

        @JsonProperty(value="zone_id")
        public String getZoneID() {
            return this.zoneID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            int i2;
            if (this.getInstances() != null && this.getInstances().size() > 0 && (i2 = 0) < this.getInstances().size()) {
                return null;
            }
            String[] statusValidValues = new String[]{"pending", "available", "in-use", "suspended", "deleted", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "attaching", "detaching", "suspending", "resuming", "deleting", "recovering"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            String[] volumeTypeValidValues = new String[]{"0", "1", "2", "3"};
            boolean volumeTypeIsValid = false;
            for (String v : volumeTypeValidValues) {
                Boolean volumeTypeIsRequired;
                if (v.equals(this.getVolumeType() + "")) {
                    volumeTypeIsValid = true;
                }
                if (!(volumeTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVolumeType() != null) continue;
                volumeTypeIsValid = true;
            }
            if (!volumeTypeIsValid) {
                throw new QCException("VolumeType value " + this.getVolumeType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UserModel
    implements ParamValidate {
        private String email;
        private String userID;

        @JsonProperty(value="email")
        public void setEmail(String email) {
            this.email = email;
        }

        @JsonProperty(value="email")
        public String getEmail() {
            return this.email;
        }

        @JsonProperty(value="user_id")
        public void setUserID(String userID) {
            this.userID = userID;
        }

        @JsonProperty(value="user_id")
        public String getUserID() {
            return this.userID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TagModel
    implements ParamValidate {
        private String color;
        private String createTime;
        private String description;
        private String owner;
        private Integer resourceCount;
        private List<ResourceTagPairModel> resourceTagPairs;
        private List<ResourceTypeCountModel> resourceTypeCount;
        private String tagID;
        private String tagKey;
        private String tagName;

        @JsonProperty(value="color")
        public void setColor(String color) {
            this.color = color;
        }

        @JsonProperty(value="color")
        public String getColor() {
            return this.color;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="resource_count")
        public void setResourceCount(Integer resourceCount) {
            this.resourceCount = resourceCount;
        }

        @JsonProperty(value="resource_count")
        public Integer getResourceCount() {
            return this.resourceCount;
        }

        @JsonProperty(value="resource_tag_pairs")
        public void setResourceTagPairs(List<ResourceTagPairModel> resourceTagPairs) {
            this.resourceTagPairs = resourceTagPairs;
        }

        @JsonProperty(value="resource_tag_pairs")
        public List<ResourceTagPairModel> getResourceTagPairs() {
            return this.resourceTagPairs;
        }

        @JsonProperty(value="resource_type_count")
        public void setResourceTypeCount(List<ResourceTypeCountModel> resourceTypeCount) {
            this.resourceTypeCount = resourceTypeCount;
        }

        @JsonProperty(value="resource_type_count")
        public List<ResourceTypeCountModel> getResourceTypeCount() {
            return this.resourceTypeCount;
        }

        @JsonProperty(value="tag_id")
        public void setTagID(String tagID) {
            this.tagID = tagID;
        }

        @JsonProperty(value="tag_id")
        public String getTagID() {
            return this.tagID;
        }

        @JsonProperty(value="tag_key")
        public void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @JsonProperty(value="tag_key")
        public String getTagKey() {
            return this.tagKey;
        }

        @JsonProperty(value="tag_name")
        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        @JsonProperty(value="tag_name")
        public String getTagName() {
            return this.tagName;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getResourceTagPairs() != null && this.getResourceTagPairs().size() > 0 && (i = 0) < this.getResourceTagPairs().size()) {
                return null;
            }
            if (this.getResourceTypeCount() != null && this.getResourceTypeCount().size() > 0 && (i = 0) < this.getResourceTypeCount().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SnapshotResourceModel
    implements ParamValidate {
        private String architecture;
        private String filesystem;
        private String mountOptions;
        private String mountPoint;
        private Integer size;
        private String volumeID;
        private Integer volumeType;

        @JsonProperty(value="architecture")
        public void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @JsonProperty(value="architecture")
        public String getArchitecture() {
            return this.architecture;
        }

        @JsonProperty(value="filesystem")
        public void setFilesystem(String filesystem) {
            this.filesystem = filesystem;
        }

        @JsonProperty(value="filesystem")
        public String getFilesystem() {
            return this.filesystem;
        }

        @JsonProperty(value="mount_options")
        public void setMountOptions(String mountOptions) {
            this.mountOptions = mountOptions;
        }

        @JsonProperty(value="mount_options")
        public String getMountOptions() {
            return this.mountOptions;
        }

        @JsonProperty(value="mount_point")
        public void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        @JsonProperty(value="mount_point")
        public String getMountPoint() {
            return this.mountPoint;
        }

        @JsonProperty(value="size")
        public void setSize(Integer size) {
            this.size = size;
        }

        @JsonProperty(value="size")
        public Integer getSize() {
            return this.size;
        }

        @JsonProperty(value="volume_id")
        public void setVolumeID(String volumeID) {
            this.volumeID = volumeID;
        }

        @JsonProperty(value="volume_id")
        public String getVolumeID() {
            return this.volumeID;
        }

        @JsonProperty(value="volume_type")
        public void setVolumeType(Integer volumeType) {
            this.volumeType = volumeType;
        }

        @JsonProperty(value="volume_type")
        public Integer getVolumeType() {
            return this.volumeType;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SnapshotModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private Integer headChain;
        private Integer isHead;
        private Integer isTaken;
        private String latestSnapshotTime;
        private String parentID;
        private String provider;
        private ResourceModel resource;
        private String rootID;
        private Integer size;
        private String snapshotID;
        private String snapshotName;
        private SnapshotResourceModel snapshotResource;
        private String snapshotTime;
        private Integer snapshotType;
        private String status;
        private String statusTime;
        private Integer subCode;
        private List<TagModel> tags;
        private Integer totalCount;
        private Integer totalSize;
        private String transitionStatus;
        private Integer virtualSize;
        private String visibility;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="head_chain")
        public void setHeadChain(Integer headChain) {
            this.headChain = headChain;
        }

        @JsonProperty(value="head_chain")
        public Integer getHeadChain() {
            return this.headChain;
        }

        @JsonProperty(value="is_head")
        public void setIsHead(Integer isHead) {
            this.isHead = isHead;
        }

        @JsonProperty(value="is_head")
        public Integer getIsHead() {
            return this.isHead;
        }

        @JsonProperty(value="is_taken")
        public void setIsTaken(Integer isTaken) {
            this.isTaken = isTaken;
        }

        @JsonProperty(value="is_taken")
        public Integer getIsTaken() {
            return this.isTaken;
        }

        @JsonProperty(value="latest_snapshot_time")
        public void setLatestSnapshotTime(String latestSnapshotTime) {
            this.latestSnapshotTime = latestSnapshotTime;
        }

        @JsonProperty(value="latest_snapshot_time")
        public String getLatestSnapshotTime() {
            return this.latestSnapshotTime;
        }

        @JsonProperty(value="parent_id")
        public void setParentID(String parentID) {
            this.parentID = parentID;
        }

        @JsonProperty(value="parent_id")
        public String getParentID() {
            return this.parentID;
        }

        @JsonProperty(value="provider")
        public void setProvider(String provider) {
            this.provider = provider;
        }

        @JsonProperty(value="provider")
        public String getProvider() {
            return this.provider;
        }

        @JsonProperty(value="resource")
        public void setResource(ResourceModel resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public ResourceModel getResource() {
            return this.resource;
        }

        @JsonProperty(value="root_id")
        public void setRootID(String rootID) {
            this.rootID = rootID;
        }

        @JsonProperty(value="root_id")
        public String getRootID() {
            return this.rootID;
        }

        @JsonProperty(value="size")
        public void setSize(Integer size) {
            this.size = size;
        }

        @JsonProperty(value="size")
        public Integer getSize() {
            return this.size;
        }

        @JsonProperty(value="snapshot_id")
        public void setSnapshotID(String snapshotID) {
            this.snapshotID = snapshotID;
        }

        @JsonProperty(value="snapshot_id")
        public String getSnapshotID() {
            return this.snapshotID;
        }

        @JsonProperty(value="snapshot_name")
        public void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @JsonProperty(value="snapshot_name")
        public String getSnapshotName() {
            return this.snapshotName;
        }

        @JsonProperty(value="snapshot_resource")
        public void setSnapshotResource(SnapshotResourceModel snapshotResource) {
            this.snapshotResource = snapshotResource;
        }

        @JsonProperty(value="snapshot_resource")
        public SnapshotResourceModel getSnapshotResource() {
            return this.snapshotResource;
        }

        @JsonProperty(value="snapshot_time")
        public void setSnapshotTime(String snapshotTime) {
            this.snapshotTime = snapshotTime;
        }

        @JsonProperty(value="snapshot_time")
        public String getSnapshotTime() {
            return this.snapshotTime;
        }

        @JsonProperty(value="snapshot_type")
        public void setSnapshotType(Integer snapshotType) {
            this.snapshotType = snapshotType;
        }

        @JsonProperty(value="snapshot_type")
        public Integer getSnapshotType() {
            return this.snapshotType;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_code")
        public void setSubCode(Integer subCode) {
            this.subCode = subCode;
        }

        @JsonProperty(value="sub_code")
        public Integer getSubCode() {
            return this.subCode;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="total_count")
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty(value="total_count")
        public Integer getTotalCount() {
            return this.totalCount;
        }

        @JsonProperty(value="total_size")
        public void setTotalSize(Integer totalSize) {
            this.totalSize = totalSize;
        }

        @JsonProperty(value="total_size")
        public Integer getTotalSize() {
            return this.totalSize;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="virtual_size")
        public void setVirtualSize(Integer virtualSize) {
            this.virtualSize = virtualSize;
        }

        @JsonProperty(value="virtual_size")
        public Integer getVirtualSize() {
            return this.virtualSize;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @JsonProperty(value="visibility")
        public String getVisibility() {
            return this.visibility;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] isHeadValidValues = new String[]{"0", "1"};
            boolean isHeadIsValid = false;
            for (String v : isHeadValidValues) {
                Boolean isHeadIsRequired;
                if (v.equals(this.getIsHead() + "")) {
                    isHeadIsValid = true;
                }
                if (!(isHeadIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsHead() != null) continue;
                isHeadIsValid = true;
            }
            if (!isHeadIsValid) {
                throw new QCException("IsHead value " + this.getIsHead() + "is invalid");
            }
            String[] isTakenValidValues = new String[]{"0", "1"};
            boolean isTakenIsValid = false;
            for (String v : isTakenValidValues) {
                Boolean isTakenIsRequired;
                if (v.equals(this.getIsTaken() + "")) {
                    isTakenIsValid = true;
                }
                if (!(isTakenIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsTaken() != null) continue;
                isTakenIsValid = true;
            }
            if (!isTakenIsValid) {
                throw new QCException("IsTaken value " + this.getIsTaken() + "is invalid");
            }
            String[] snapshotTypeValidValues = new String[]{"0", "1"};
            boolean snapshotTypeIsValid = false;
            for (String v : snapshotTypeValidValues) {
                Boolean snapshotTypeIsRequired;
                if (v.equals(this.getSnapshotType() + "")) {
                    snapshotTypeIsValid = true;
                }
                if (!(snapshotTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getSnapshotType() != null) continue;
                snapshotTypeIsValid = true;
            }
            if (!snapshotTypeIsValid) {
                throw new QCException("SnapshotType value " + this.getSnapshotType() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "available", "suspended", "deleted", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "suspending", "resuming", "deleting", "recovering"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServerCertificateModel
    implements ParamValidate {
        private String certificateContent;
        private String createTime;
        private String description;
        private String privateKey;
        private String serverCertificateID;
        private String serverCertificateName;

        @JsonProperty(value="certificate_content")
        public void setCertificateContent(String certificateContent) {
            this.certificateContent = certificateContent;
        }

        @JsonProperty(value="certificate_content")
        public String getCertificateContent() {
            return this.certificateContent;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="private_key")
        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @JsonProperty(value="private_key")
        public String getPrivateKey() {
            return this.privateKey;
        }

        @JsonProperty(value="server_certificate_id")
        public void setServerCertificateID(String serverCertificateID) {
            this.serverCertificateID = serverCertificateID;
        }

        @JsonProperty(value="server_certificate_id")
        public String getServerCertificateID() {
            return this.serverCertificateID;
        }

        @JsonProperty(value="server_certificate_name")
        public void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        @JsonProperty(value="server_certificate_name")
        public String getServerCertificateName() {
            return this.serverCertificateName;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SecurityGroupSnapshotModel
    implements ParamValidate {
        private String groupID;
        private List<SecurityGroupRuleModel> rules;
        private String securityGroupSnapshotID;

        @JsonProperty(value="group_id")
        public void setGroupID(String groupID) {
            this.groupID = groupID;
        }

        @JsonProperty(value="group_id")
        public String getGroupID() {
            return this.groupID;
        }

        @JsonProperty(value="rules")
        public void setRules(List<SecurityGroupRuleModel> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="rules")
        public List<SecurityGroupRuleModel> getRules() {
            return this.rules;
        }

        @JsonProperty(value="security_group_snapshot_id")
        public void setSecurityGroupSnapshotID(String securityGroupSnapshotID) {
            this.securityGroupSnapshotID = securityGroupSnapshotID;
        }

        @JsonProperty(value="security_group_snapshot_id")
        public String getSecurityGroupSnapshotID() {
            return this.securityGroupSnapshotID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getRules() != null && this.getRules().size() > 0 && (i = 0) < this.getRules().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SecurityGroupRuleModel
    implements ParamValidate {
        private String action;
        private Integer direction;
        private Integer priority;
        private String protocol;
        private String securityGroupID;
        private String securityGroupRuleID;
        private String securityGroupRuleName;
        private String val1;
        private String val2;
        private String val3;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="direction")
        public void setDirection(Integer direction) {
            this.direction = direction;
        }

        @JsonProperty(value="direction")
        public Integer getDirection() {
            return this.direction;
        }

        @JsonProperty(value="priority")
        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        @JsonProperty(value="priority")
        public Integer getPriority() {
            return this.priority;
        }

        @JsonProperty(value="protocol")
        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @JsonProperty(value="protocol")
        public String getProtocol() {
            return this.protocol;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="security_group_rule_id")
        public void setSecurityGroupRuleID(String securityGroupRuleID) {
            this.securityGroupRuleID = securityGroupRuleID;
        }

        @JsonProperty(value="security_group_rule_id")
        public String getSecurityGroupRuleID() {
            return this.securityGroupRuleID;
        }

        @JsonProperty(value="security_group_rule_name")
        public void setSecurityGroupRuleName(String securityGroupRuleName) {
            this.securityGroupRuleName = securityGroupRuleName;
        }

        @JsonProperty(value="security_group_rule_name")
        public String getSecurityGroupRuleName() {
            return this.securityGroupRuleName;
        }

        @JsonProperty(value="val1")
        public void setVal1(String val1) {
            this.val1 = val1;
        }

        @JsonProperty(value="val1")
        public String getVal1() {
            return this.val1;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @JsonProperty(value="val3")
        public void setVal3(String val3) {
            this.val3 = val3;
        }

        @JsonProperty(value="val3")
        public String getVal3() {
            return this.val3;
        }

        @Override
        public String validateParam() throws QCException {
            String[] actionValidValues = new String[]{"accept", "drop"};
            boolean actionIsValid = false;
            for (String v : actionValidValues) {
                Boolean actionIsRequired;
                if (v.equals(this.getAction())) {
                    actionIsValid = true;
                }
                if (!(actionIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getAction() != null) continue;
                actionIsValid = true;
            }
            if (!actionIsValid) {
                throw new QCException("Action value " + this.getAction() + "is invalid");
            }
            String[] directionValidValues = new String[]{"0", "1"};
            boolean directionIsValid = false;
            for (String v : directionValidValues) {
                Boolean directionIsRequired;
                if (v.equals(this.getDirection() + "")) {
                    directionIsValid = true;
                }
                if (!(directionIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getDirection() != null) continue;
                directionIsValid = true;
            }
            if (!directionIsValid) {
                throw new QCException("Direction value " + this.getDirection() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SecurityGroupIPSetModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private Integer iPSetType;
        private String securityGroupIPSetID;
        private String securityGroupIPSetName;
        private String val;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="ipset_type")
        public void setIPSetType(Integer iPSetType) {
            this.iPSetType = iPSetType;
        }

        @JsonProperty(value="ipset_type")
        public Integer getIPSetType() {
            return this.iPSetType;
        }

        @JsonProperty(value="security_group_ipset_id")
        public void setSecurityGroupIPSetID(String securityGroupIPSetID) {
            this.securityGroupIPSetID = securityGroupIPSetID;
        }

        @JsonProperty(value="security_group_ipset_id")
        public String getSecurityGroupIPSetID() {
            return this.securityGroupIPSetID;
        }

        @JsonProperty(value="security_group_ipset_name")
        public void setSecurityGroupIPSetName(String securityGroupIPSetName) {
            this.securityGroupIPSetName = securityGroupIPSetName;
        }

        @JsonProperty(value="security_group_ipset_name")
        public String getSecurityGroupIPSetName() {
            return this.securityGroupIPSetName;
        }

        @JsonProperty(value="val")
        public void setVal(String val) {
            this.val = val;
        }

        @JsonProperty(value="val")
        public String getVal() {
            return this.val;
        }

        @Override
        public String validateParam() throws QCException {
            String[] iPSetTypeValidValues = new String[]{"0", "1"};
            boolean iPSetTypeIsValid = false;
            for (String v : iPSetTypeValidValues) {
                Boolean iPSetTypeIsRequired;
                if (v.equals(this.getIPSetType() + "")) {
                    iPSetTypeIsValid = true;
                }
                if (!(iPSetTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIPSetType() != null) continue;
                iPSetTypeIsValid = true;
            }
            if (!iPSetTypeIsValid) {
                throw new QCException("IPSetType value " + this.getIPSetType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SecurityGroupModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private Integer isApplied;
        private Integer isDefault;
        private List<ResourceModel> resources;
        private String securityGroupID;
        private String securityGroupName;
        private List<TagModel> tags;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="is_applied")
        public void setIsApplied(Integer isApplied) {
            this.isApplied = isApplied;
        }

        @JsonProperty(value="is_applied")
        public Integer getIsApplied() {
            return this.isApplied;
        }

        @JsonProperty(value="is_default")
        public void setIsDefault(Integer isDefault) {
            this.isDefault = isDefault;
        }

        @JsonProperty(value="is_default")
        public Integer getIsDefault() {
            return this.isDefault;
        }

        @JsonProperty(value="resources")
        public void setResources(List<ResourceModel> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="resources")
        public List<ResourceModel> getResources() {
            return this.resources;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="security_group_name")
        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }

        @JsonProperty(value="security_group_name")
        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getResources() != null && this.getResources().size() > 0 && (i = 0) < this.getResources().size()) {
                return null;
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class S2SharedTargetModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private String exportName;
        private String s2ServerID;
        private String s2SharedTargetID;
        private String statusTime;
        private String targetType;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="export_name")
        public void setExportName(String exportName) {
            this.exportName = exportName;
        }

        @JsonProperty(value="export_name")
        public String getExportName() {
            return this.exportName;
        }

        @JsonProperty(value="s2_server_id")
        public void setS2ServerID(String s2ServerID) {
            this.s2ServerID = s2ServerID;
        }

        @JsonProperty(value="s2_server_id")
        public String getS2ServerID() {
            return this.s2ServerID;
        }

        @JsonProperty(value="s2_shared_target_id")
        public void setS2SharedTargetID(String s2SharedTargetID) {
            this.s2SharedTargetID = s2SharedTargetID;
        }

        @JsonProperty(value="s2_shared_target_id")
        public String getS2SharedTargetID() {
            return this.s2SharedTargetID;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="target_type")
        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @JsonProperty(value="target_type")
        public String getTargetType() {
            return this.targetType;
        }

        @Override
        public String validateParam() throws QCException {
            String[] targetTypeValidValues = new String[]{"ISCSI", "NFS"};
            boolean targetTypeIsValid = false;
            for (String v : targetTypeValidValues) {
                Boolean targetTypeIsRequired;
                if (v.equals(this.getTargetType())) {
                    targetTypeIsValid = true;
                }
                if (!(targetTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTargetType() != null) continue;
                targetTypeIsValid = true;
            }
            if (!targetTypeIsValid) {
                throw new QCException("TargetType value " + this.getTargetType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class S2ServerModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private Integer isApplied;
        private String name;
        private String privateIP;
        private String s2ServerID;
        private Integer s2ServerType;
        private String serviceType;
        private String status;
        private String statusTime;
        private List<TagModel> tags;
        private String transitionStatus;
        private VxNetModel vxNet;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="is_applied")
        public void setIsApplied(Integer isApplied) {
            this.isApplied = isApplied;
        }

        @JsonProperty(value="is_applied")
        public Integer getIsApplied() {
            return this.isApplied;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="s2_server_id")
        public void setS2ServerID(String s2ServerID) {
            this.s2ServerID = s2ServerID;
        }

        @JsonProperty(value="s2_server_id")
        public String getS2ServerID() {
            return this.s2ServerID;
        }

        @JsonProperty(value="s2_server_type")
        public void setS2ServerType(Integer s2ServerType) {
            this.s2ServerType = s2ServerType;
        }

        @JsonProperty(value="s2_server_type")
        public Integer getS2ServerType() {
            return this.s2ServerType;
        }

        @JsonProperty(value="service_type")
        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @JsonProperty(value="service_type")
        public String getServiceType() {
            return this.serviceType;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(VxNetModel vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public VxNetModel getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] isAppliedValidValues = new String[]{"0", "1"};
            boolean isAppliedIsValid = false;
            for (String v : isAppliedValidValues) {
                Boolean isAppliedIsRequired;
                if (v.equals(this.getIsApplied() + "")) {
                    isAppliedIsValid = true;
                }
                if (!(isAppliedIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsApplied() != null) continue;
                isAppliedIsValid = true;
            }
            if (!isAppliedIsValid) {
                throw new QCException("IsApplied value " + this.getIsApplied() + "is invalid");
            }
            String[] s2ServerTypeValidValues = new String[]{"0", "1", "2", "3"};
            boolean s2ServerTypeIsValid = false;
            for (String v : s2ServerTypeValidValues) {
                Boolean s2ServerTypeIsRequired;
                if (v.equals(this.getS2ServerType() + "")) {
                    s2ServerTypeIsValid = true;
                }
                if (!(s2ServerTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getS2ServerType() != null) continue;
                s2ServerTypeIsValid = true;
            }
            if (!s2ServerTypeIsValid) {
                throw new QCException("S2ServerType value " + this.getS2ServerType() + "is invalid");
            }
            String[] serviceTypeValidValues = new String[]{"vsan"};
            boolean serviceTypeIsValid = false;
            for (String v : serviceTypeValidValues) {
                Boolean serviceTypeIsRequired;
                if (v.equals(this.getServiceType())) {
                    serviceTypeIsValid = true;
                }
                if (!(serviceTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getServiceType() != null) continue;
                serviceTypeIsValid = true;
            }
            if (!serviceTypeIsValid) {
                throw new QCException("ServiceType value " + this.getServiceType() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "active", "poweroffed", "suspended", "deleted", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "updating", "suspending", "resuming", "poweroffing"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class S2DefaultParametersModel
    implements ParamValidate {
        private String defaultValue;
        private String description;
        private String paramName;
        private String serviceType;
        private String targetType;

        @JsonProperty(value="default_value")
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @JsonProperty(value="default_value")
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="param_name")
        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        @JsonProperty(value="param_name")
        public String getParamName() {
            return this.paramName;
        }

        @JsonProperty(value="service_type")
        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @JsonProperty(value="service_type")
        public String getServiceType() {
            return this.serviceType;
        }

        @JsonProperty(value="target_type")
        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @JsonProperty(value="target_type")
        public String getTargetType() {
            return this.targetType;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RouterVxNetModel
    implements ParamValidate {
        private String createTime;
        private String dYNIPEnd;
        private String dYNIPStart;
        private Integer features;
        private String iPNetwork;
        private String managerIP;
        private String routerID;
        private String vxNetID;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="dyn_ip_end")
        public void setDYNIPEnd(String dYNIPEnd) {
            this.dYNIPEnd = dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_end")
        public String getDYNIPEnd() {
            return this.dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_start")
        public void setDYNIPStart(String dYNIPStart) {
            this.dYNIPStart = dYNIPStart;
        }

        @JsonProperty(value="dyn_ip_start")
        public String getDYNIPStart() {
            return this.dYNIPStart;
        }

        @JsonProperty(value="features")
        public void setFeatures(Integer features) {
            this.features = features;
        }

        @JsonProperty(value="features")
        public Integer getFeatures() {
            return this.features;
        }

        @JsonProperty(value="ip_network")
        public void setIPNetwork(String iPNetwork) {
            this.iPNetwork = iPNetwork;
        }

        @JsonProperty(value="ip_network")
        public String getIPNetwork() {
            return this.iPNetwork;
        }

        @JsonProperty(value="manager_ip")
        public void setManagerIP(String managerIP) {
            this.managerIP = managerIP;
        }

        @JsonProperty(value="manager_ip")
        public String getManagerIP() {
            return this.managerIP;
        }

        @JsonProperty(value="router_id")
        public void setRouterID(String routerID) {
            this.routerID = routerID;
        }

        @JsonProperty(value="router_id")
        public String getRouterID() {
            return this.routerID;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RouterStaticEntrySimpleModel
    implements ParamValidate {
        private String routerStaticEntryID;
        private String val1;
        private String val2;

        @JsonProperty(value="router_static_entry_id")
        public void setRouterStaticEntryID(String routerStaticEntryID) {
            this.routerStaticEntryID = routerStaticEntryID;
        }

        @JsonProperty(value="router_static_entry_id")
        public String getRouterStaticEntryID() {
            return this.routerStaticEntryID;
        }

        @JsonProperty(value="val1")
        public void setVal1(String val1) {
            this.val1 = val1;
        }

        @JsonProperty(value="val1")
        public String getVal1() {
            return this.val1;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RouterStaticEntryModel
    implements ParamValidate {
        private String routerID;
        private String routerStaticEntryID;
        private String routerStaticEntryName;
        private String routerStaticID;
        private String val1;
        private String val2;

        @JsonProperty(value="router_id")
        public void setRouterID(String routerID) {
            this.routerID = routerID;
        }

        @JsonProperty(value="router_id")
        public String getRouterID() {
            return this.routerID;
        }

        @JsonProperty(value="router_static_entry_id")
        public void setRouterStaticEntryID(String routerStaticEntryID) {
            this.routerStaticEntryID = routerStaticEntryID;
        }

        @JsonProperty(value="router_static_entry_id")
        public String getRouterStaticEntryID() {
            return this.routerStaticEntryID;
        }

        @JsonProperty(value="router_static_entry_name")
        public void setRouterStaticEntryName(String routerStaticEntryName) {
            this.routerStaticEntryName = routerStaticEntryName;
        }

        @JsonProperty(value="router_static_entry_name")
        public String getRouterStaticEntryName() {
            return this.routerStaticEntryName;
        }

        @JsonProperty(value="router_static_id")
        public void setRouterStaticID(String routerStaticID) {
            this.routerStaticID = routerStaticID;
        }

        @JsonProperty(value="router_static_id")
        public String getRouterStaticID() {
            return this.routerStaticID;
        }

        @JsonProperty(value="val1")
        public void setVal1(String val1) {
            this.val1 = val1;
        }

        @JsonProperty(value="val1")
        public String getVal1() {
            return this.val1;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RouterStaticModel
    implements ParamValidate {
        private String createTime;
        private List<RouterStaticEntrySimpleModel> entrySet;
        private String routerID;
        private String routerStaticID;
        private String routerStaticName;
        private Integer staticType;
        private String val1;
        private String val2;
        private String val3;
        private String val4;
        private String val5;
        private String val6;
        private String val7;
        private String val8;
        private String val9;
        private String vxNetID;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="entry_set")
        public void setEntrySet(List<RouterStaticEntrySimpleModel> entrySet) {
            this.entrySet = entrySet;
        }

        @JsonProperty(value="entry_set")
        public List<RouterStaticEntrySimpleModel> getEntrySet() {
            return this.entrySet;
        }

        @JsonProperty(value="router_id")
        public void setRouterID(String routerID) {
            this.routerID = routerID;
        }

        @JsonProperty(value="router_id")
        public String getRouterID() {
            return this.routerID;
        }

        @JsonProperty(value="router_static_id")
        public void setRouterStaticID(String routerStaticID) {
            this.routerStaticID = routerStaticID;
        }

        @JsonProperty(value="router_static_id")
        public String getRouterStaticID() {
            return this.routerStaticID;
        }

        @JsonProperty(value="router_static_name")
        public void setRouterStaticName(String routerStaticName) {
            this.routerStaticName = routerStaticName;
        }

        @JsonProperty(value="router_static_name")
        public String getRouterStaticName() {
            return this.routerStaticName;
        }

        @JsonProperty(value="static_type")
        public void setStaticType(Integer staticType) {
            this.staticType = staticType;
        }

        @JsonProperty(value="static_type")
        public Integer getStaticType() {
            return this.staticType;
        }

        @JsonProperty(value="val1")
        public void setVal1(String val1) {
            this.val1 = val1;
        }

        @JsonProperty(value="val1")
        public String getVal1() {
            return this.val1;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @JsonProperty(value="val3")
        public void setVal3(String val3) {
            this.val3 = val3;
        }

        @JsonProperty(value="val3")
        public String getVal3() {
            return this.val3;
        }

        @JsonProperty(value="val4")
        public void setVal4(String val4) {
            this.val4 = val4;
        }

        @JsonProperty(value="val4")
        public String getVal4() {
            return this.val4;
        }

        @JsonProperty(value="val5")
        public void setVal5(String val5) {
            this.val5 = val5;
        }

        @JsonProperty(value="val5")
        public String getVal5() {
            return this.val5;
        }

        @JsonProperty(value="val6")
        public void setVal6(String val6) {
            this.val6 = val6;
        }

        @JsonProperty(value="val6")
        public String getVal6() {
            return this.val6;
        }

        @JsonProperty(value="val7")
        public void setVal7(String val7) {
            this.val7 = val7;
        }

        @JsonProperty(value="val7")
        public String getVal7() {
            return this.val7;
        }

        @JsonProperty(value="val8")
        public void setVal8(String val8) {
            this.val8 = val8;
        }

        @JsonProperty(value="val8")
        public String getVal8() {
            return this.val8;
        }

        @JsonProperty(value="val9")
        public void setVal9(String val9) {
            this.val9 = val9;
        }

        @JsonProperty(value="val9")
        public String getVal9() {
            return this.val9;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getEntrySet() != null && this.getEntrySet().size() > 0 && (i = 0) < this.getEntrySet().size()) {
                return null;
            }
            String[] staticTypeValidValues = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
            boolean staticTypeIsValid = false;
            for (String v : staticTypeValidValues) {
                Boolean staticTypeIsRequired;
                if (v.equals(this.getStaticType() + "")) {
                    staticTypeIsValid = true;
                }
                if (!(staticTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStaticType() != null) continue;
                staticTypeIsValid = true;
            }
            if (!staticTypeIsValid) {
                throw new QCException("StaticType value " + this.getStaticType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RouterModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private String dYNIPEnd;
        private String dYNIPStart;
        private EIPModel eIP;
        private String iPNetwork;
        private Integer isApplied;
        private String managerIP;
        private Integer mode;
        private String privateIP;
        private String routerID;
        private String routerName;
        private Integer routerType;
        private String securityGroupID;
        private String status;
        private String statusTime;
        private List<TagModel> tags;
        private String transitionStatus;
        private String vpcNetwork;
        private List<VxNetModel> vxNets;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="dyn_ip_end")
        public void setDYNIPEnd(String dYNIPEnd) {
            this.dYNIPEnd = dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_end")
        public String getDYNIPEnd() {
            return this.dYNIPEnd;
        }

        @JsonProperty(value="dyn_ip_start")
        public void setDYNIPStart(String dYNIPStart) {
            this.dYNIPStart = dYNIPStart;
        }

        @JsonProperty(value="dyn_ip_start")
        public String getDYNIPStart() {
            return this.dYNIPStart;
        }

        @JsonProperty(value="eip")
        public void setEIP(EIPModel eIP) {
            this.eIP = eIP;
        }

        @JsonProperty(value="eip")
        public EIPModel getEIP() {
            return this.eIP;
        }

        @JsonProperty(value="ip_network")
        public void setIPNetwork(String iPNetwork) {
            this.iPNetwork = iPNetwork;
        }

        @JsonProperty(value="ip_network")
        public String getIPNetwork() {
            return this.iPNetwork;
        }

        @JsonProperty(value="is_applied")
        public void setIsApplied(Integer isApplied) {
            this.isApplied = isApplied;
        }

        @JsonProperty(value="is_applied")
        public Integer getIsApplied() {
            return this.isApplied;
        }

        @JsonProperty(value="manager_ip")
        public void setManagerIP(String managerIP) {
            this.managerIP = managerIP;
        }

        @JsonProperty(value="manager_ip")
        public String getManagerIP() {
            return this.managerIP;
        }

        @JsonProperty(value="mode")
        public void setMode(Integer mode) {
            this.mode = mode;
        }

        @JsonProperty(value="mode")
        public Integer getMode() {
            return this.mode;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="router_id")
        public void setRouterID(String routerID) {
            this.routerID = routerID;
        }

        @JsonProperty(value="router_id")
        public String getRouterID() {
            return this.routerID;
        }

        @JsonProperty(value="router_name")
        public void setRouterName(String routerName) {
            this.routerName = routerName;
        }

        @JsonProperty(value="router_name")
        public String getRouterName() {
            return this.routerName;
        }

        @JsonProperty(value="router_type")
        public void setRouterType(Integer routerType) {
            this.routerType = routerType;
        }

        @JsonProperty(value="router_type")
        public Integer getRouterType() {
            return this.routerType;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="vpc_network")
        public void setVpcNetwork(String vpcNetwork) {
            this.vpcNetwork = vpcNetwork;
        }

        @JsonProperty(value="vpc_network")
        public String getVpcNetwork() {
            return this.vpcNetwork;
        }

        @JsonProperty(value="vxnets")
        public void setVxNets(List<VxNetModel> vxNets) {
            this.vxNets = vxNets;
        }

        @JsonProperty(value="vxnets")
        public List<VxNetModel> getVxNets() {
            return this.vxNets;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            int i2;
            String[] isAppliedValidValues = new String[]{"0", "1"};
            boolean isAppliedIsValid = false;
            for (String v : isAppliedValidValues) {
                Boolean isAppliedIsRequired;
                if (v.equals(this.getIsApplied() + "")) {
                    isAppliedIsValid = true;
                }
                if (!(isAppliedIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsApplied() != null) continue;
                isAppliedIsValid = true;
            }
            if (!isAppliedIsValid) {
                throw new QCException("IsApplied value " + this.getIsApplied() + "is invalid");
            }
            String[] routerTypeValidValues = new String[]{"1"};
            boolean routerTypeIsValid = false;
            for (String v : routerTypeValidValues) {
                Boolean routerTypeIsRequired;
                if (v.equals(this.getRouterType() + "")) {
                    routerTypeIsValid = true;
                }
                if (!(routerTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getRouterType() != null) continue;
                routerTypeIsValid = true;
            }
            if (!routerTypeIsValid) {
                throw new QCException("RouterType value " + this.getRouterType() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "active", "poweroffed", "suspended", "deleted", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i2 = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "updating", "suspending", "resuming", "poweroffing", "poweroning", "deleting"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            if (this.getVxNets() != null && this.getVxNets().size() > 0 && (i = 0) < this.getVxNets().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceTypeCountModel
    implements ParamValidate {
        private Integer count;
        private String resourceType;

        @JsonProperty(value="count")
        public void setCount(Integer count) {
            this.count = count;
        }

        @JsonProperty(value="count")
        public Integer getCount() {
            return this.count;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceTagPairModel
    implements ParamValidate {
        private String resourceID;
        private String resourceType;
        private String status;
        private String tagID;

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="tag_id")
        public void setTagID(String tagID) {
            this.tagID = tagID;
        }

        @JsonProperty(value="tag_id")
        public String getTagID() {
            return this.tagID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceLimitsModel
    implements ParamValidate {
        private String comments;
        private Integer banMmVxNets;
        private List<String> bmZones;
        private String bucketCreateWhitelist;
        private List<String> disabledActions;
        private List<String> disabledFeatures;
        private Integer enableNICBandwidth;
        private List<String> gpuZones;
        private Model hadoopTypes;
        private Model hbaseTypes;
        private Integer hcVolumeStep;
        private Integer hcsVolumeStep;
        private Integer hdfsDisksPerNode;
        private Integer hpsVolumeStep;
        private String ignoreMmVxNetUsers;
        private Integer maxAbuseEIPCnt;
        private Integer maxAlarmPolicyActions;
        private Integer maxAlarmPolicyResources;
        private Integer maxAlarmPolicyRules;
        private Integer maxChangeEIPBillingModeCnt;
        private Integer maxEIPBandwidth;
        private Integer maxEIPCount;
        private Integer maxGpuCount;
        private Integer maxHcVolumeSize;
        private Integer maxHcsVolumeSize;
        private Integer maxHpsVolumeSize;
        private Integer maxImageSharedUsers;
        private Integer maxInstanceCount;
        private Integer maxItemInResourceGroup;
        private Integer maxListenerBackends;
        private Integer maxLoadBalancerListeners;
        private Integer maxLoadBalancerPolicyRewriteRules;
        private Integer maxLoadBalancerPolicyRules;
        private Integer maxMemberInUserGroup;
        private Integer maxNICPerInstance;
        private Integer maxResourceSharedUsers;
        private Integer maxRgCntItemCanJoin;
        private Integer maxRouterCount;
        private Integer maxRouterEntries;
        private Integer maxRouterStatics;
        private Integer maxRouterVxNets;
        private Integer maxRuleInGroupRole;
        private Integer maxSecurityGroupRules;
        private Integer maxSecurityGroupRulesets;
        private Integer maxSecurityGroupSnapshots;
        private Integer maxUsersInOneDepartment;
        private Integer maxVolumeCount;
        private Integer maxVolumePerInst;
        private Integer maxVolumeSize;
        private Integer maxVosReplicaCount;
        private Integer maxVxNetCount;
        private Integer minAbuseEIPSec;
        private Integer minHcVolumeSize;
        private Integer minHcsVolumeSize;
        private Integer minHostsPerDedicatedGroup;
        private Integer minHpsVolumeSize;
        private Integer minReservedHostsInPool;
        private Integer minVolumeSize;
        private Integer privilegeOfLxc;
        private Model sparkTypes;
        private Model stormTypes;
        private List<Integer> validCacheSize;
        private List<Integer> validCPUCores;
        private Model validCPUMemoryPairs;
        private List<Integer> validDedicatedHostGroupClasses;
        private List<Integer> validInstanceClasses;
        private List<Integer> validLoadBalancerTypes;
        private List<Integer> validMemorySize;
        private List<Integer> validResourceClasses;
        private List<Integer> validVolumeTypes;
        private Integer volumeStep;
        private Integer vpcIpv6Prefixlen;
        private Integer vxNetIpv6Prefixlen;
        private String vxNetKsWhiteList;

        @JsonProperty(value="__comments")
        public void setComments(String comments) {
            this.comments = comments;
        }

        @JsonProperty(value="__comments")
        public String getComments() {
            return this.comments;
        }

        @JsonProperty(value="ban_mm_vxnets")
        public void setBanMmVxNets(Integer banMmVxNets) {
            this.banMmVxNets = banMmVxNets;
        }

        @JsonProperty(value="ban_mm_vxnets")
        public Integer getBanMmVxNets() {
            return this.banMmVxNets;
        }

        @JsonProperty(value="bm_zones")
        public void setBmZones(List<String> bmZones) {
            this.bmZones = bmZones;
        }

        @JsonProperty(value="bm_zones")
        public List<String> getBmZones() {
            return this.bmZones;
        }

        @JsonProperty(value="bucket_create_whitelist")
        public void setBucketCreateWhitelist(String bucketCreateWhitelist) {
            this.bucketCreateWhitelist = bucketCreateWhitelist;
        }

        @JsonProperty(value="bucket_create_whitelist")
        public String getBucketCreateWhitelist() {
            return this.bucketCreateWhitelist;
        }

        @JsonProperty(value="disabled_actions")
        public void setDisabledActions(List<String> disabledActions) {
            this.disabledActions = disabledActions;
        }

        @JsonProperty(value="disabled_actions")
        public List<String> getDisabledActions() {
            return this.disabledActions;
        }

        @JsonProperty(value="disabled_features")
        public void setDisabledFeatures(List<String> disabledFeatures) {
            this.disabledFeatures = disabledFeatures;
        }

        @JsonProperty(value="disabled_features")
        public List<String> getDisabledFeatures() {
            return this.disabledFeatures;
        }

        @JsonProperty(value="enable_nic_bandwidth")
        public void setEnableNICBandwidth(Integer enableNICBandwidth) {
            this.enableNICBandwidth = enableNICBandwidth;
        }

        @JsonProperty(value="enable_nic_bandwidth")
        public Integer getEnableNICBandwidth() {
            return this.enableNICBandwidth;
        }

        @JsonProperty(value="gpu_zones")
        public void setGpuZones(List<String> gpuZones) {
            this.gpuZones = gpuZones;
        }

        @JsonProperty(value="gpu_zones")
        public List<String> getGpuZones() {
            return this.gpuZones;
        }

        @JsonProperty(value="hadoop_types")
        public void setHadoopTypes(Model hadoopTypes) {
            this.hadoopTypes = hadoopTypes;
        }

        @JsonProperty(value="hadoop_types")
        public Model getHadoopTypes() {
            return this.hadoopTypes;
        }

        @JsonProperty(value="hbase_types")
        public void setHbaseTypes(Model hbaseTypes) {
            this.hbaseTypes = hbaseTypes;
        }

        @JsonProperty(value="hbase_types")
        public Model getHbaseTypes() {
            return this.hbaseTypes;
        }

        @JsonProperty(value="hc_volume_step")
        public void setHcVolumeStep(Integer hcVolumeStep) {
            this.hcVolumeStep = hcVolumeStep;
        }

        @JsonProperty(value="hc_volume_step")
        public Integer getHcVolumeStep() {
            return this.hcVolumeStep;
        }

        @JsonProperty(value="hcs_volume_step")
        public void setHcsVolumeStep(Integer hcsVolumeStep) {
            this.hcsVolumeStep = hcsVolumeStep;
        }

        @JsonProperty(value="hcs_volume_step")
        public Integer getHcsVolumeStep() {
            return this.hcsVolumeStep;
        }

        @JsonProperty(value="hdfs_disks_per_node")
        public void setHdfsDisksPerNode(Integer hdfsDisksPerNode) {
            this.hdfsDisksPerNode = hdfsDisksPerNode;
        }

        @JsonProperty(value="hdfs_disks_per_node")
        public Integer getHdfsDisksPerNode() {
            return this.hdfsDisksPerNode;
        }

        @JsonProperty(value="hps_volume_step")
        public void setHpsVolumeStep(Integer hpsVolumeStep) {
            this.hpsVolumeStep = hpsVolumeStep;
        }

        @JsonProperty(value="hps_volume_step")
        public Integer getHpsVolumeStep() {
            return this.hpsVolumeStep;
        }

        @JsonProperty(value="ignore_mm_vxnet_users")
        public void setIgnoreMmVxNetUsers(String ignoreMmVxNetUsers) {
            this.ignoreMmVxNetUsers = ignoreMmVxNetUsers;
        }

        @JsonProperty(value="ignore_mm_vxnet_users")
        public String getIgnoreMmVxNetUsers() {
            return this.ignoreMmVxNetUsers;
        }

        @JsonProperty(value="max_abuse_eip_cnt")
        public void setMaxAbuseEIPCnt(Integer maxAbuseEIPCnt) {
            this.maxAbuseEIPCnt = maxAbuseEIPCnt;
        }

        @JsonProperty(value="max_abuse_eip_cnt")
        public Integer getMaxAbuseEIPCnt() {
            return this.maxAbuseEIPCnt;
        }

        @JsonProperty(value="max_alarm_policy_actions")
        public void setMaxAlarmPolicyActions(Integer maxAlarmPolicyActions) {
            this.maxAlarmPolicyActions = maxAlarmPolicyActions;
        }

        @JsonProperty(value="max_alarm_policy_actions")
        public Integer getMaxAlarmPolicyActions() {
            return this.maxAlarmPolicyActions;
        }

        @JsonProperty(value="max_alarm_policy_resources")
        public void setMaxAlarmPolicyResources(Integer maxAlarmPolicyResources) {
            this.maxAlarmPolicyResources = maxAlarmPolicyResources;
        }

        @JsonProperty(value="max_alarm_policy_resources")
        public Integer getMaxAlarmPolicyResources() {
            return this.maxAlarmPolicyResources;
        }

        @JsonProperty(value="max_alarm_policy_rules")
        public void setMaxAlarmPolicyRules(Integer maxAlarmPolicyRules) {
            this.maxAlarmPolicyRules = maxAlarmPolicyRules;
        }

        @JsonProperty(value="max_alarm_policy_rules")
        public Integer getMaxAlarmPolicyRules() {
            return this.maxAlarmPolicyRules;
        }

        @JsonProperty(value="max_change_eip_billing_mode_cnt")
        public void setMaxChangeEIPBillingModeCnt(Integer maxChangeEIPBillingModeCnt) {
            this.maxChangeEIPBillingModeCnt = maxChangeEIPBillingModeCnt;
        }

        @JsonProperty(value="max_change_eip_billing_mode_cnt")
        public Integer getMaxChangeEIPBillingModeCnt() {
            return this.maxChangeEIPBillingModeCnt;
        }

        @JsonProperty(value="max_eip_bandwidth")
        public void setMaxEIPBandwidth(Integer maxEIPBandwidth) {
            this.maxEIPBandwidth = maxEIPBandwidth;
        }

        @JsonProperty(value="max_eip_bandwidth")
        public Integer getMaxEIPBandwidth() {
            return this.maxEIPBandwidth;
        }

        @JsonProperty(value="max_eip_count")
        public void setMaxEIPCount(Integer maxEIPCount) {
            this.maxEIPCount = maxEIPCount;
        }

        @JsonProperty(value="max_eip_count")
        public Integer getMaxEIPCount() {
            return this.maxEIPCount;
        }

        @JsonProperty(value="max_gpu_count")
        public void setMaxGpuCount(Integer maxGpuCount) {
            this.maxGpuCount = maxGpuCount;
        }

        @JsonProperty(value="max_gpu_count")
        public Integer getMaxGpuCount() {
            return this.maxGpuCount;
        }

        @JsonProperty(value="max_hc_volume_size")
        public void setMaxHcVolumeSize(Integer maxHcVolumeSize) {
            this.maxHcVolumeSize = maxHcVolumeSize;
        }

        @JsonProperty(value="max_hc_volume_size")
        public Integer getMaxHcVolumeSize() {
            return this.maxHcVolumeSize;
        }

        @JsonProperty(value="max_hcs_volume_size")
        public void setMaxHcsVolumeSize(Integer maxHcsVolumeSize) {
            this.maxHcsVolumeSize = maxHcsVolumeSize;
        }

        @JsonProperty(value="max_hcs_volume_size")
        public Integer getMaxHcsVolumeSize() {
            return this.maxHcsVolumeSize;
        }

        @JsonProperty(value="max_hps_volume_size")
        public void setMaxHpsVolumeSize(Integer maxHpsVolumeSize) {
            this.maxHpsVolumeSize = maxHpsVolumeSize;
        }

        @JsonProperty(value="max_hps_volume_size")
        public Integer getMaxHpsVolumeSize() {
            return this.maxHpsVolumeSize;
        }

        @JsonProperty(value="max_image_shared_users")
        public void setMaxImageSharedUsers(Integer maxImageSharedUsers) {
            this.maxImageSharedUsers = maxImageSharedUsers;
        }

        @JsonProperty(value="max_image_shared_users")
        public Integer getMaxImageSharedUsers() {
            return this.maxImageSharedUsers;
        }

        @JsonProperty(value="max_instance_count")
        public void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        @JsonProperty(value="max_instance_count")
        public Integer getMaxInstanceCount() {
            return this.maxInstanceCount;
        }

        @JsonProperty(value="max_item_in_resource_group")
        public void setMaxItemInResourceGroup(Integer maxItemInResourceGroup) {
            this.maxItemInResourceGroup = maxItemInResourceGroup;
        }

        @JsonProperty(value="max_item_in_resource_group")
        public Integer getMaxItemInResourceGroup() {
            return this.maxItemInResourceGroup;
        }

        @JsonProperty(value="max_listener_backends")
        public void setMaxListenerBackends(Integer maxListenerBackends) {
            this.maxListenerBackends = maxListenerBackends;
        }

        @JsonProperty(value="max_listener_backends")
        public Integer getMaxListenerBackends() {
            return this.maxListenerBackends;
        }

        @JsonProperty(value="max_loadbalancer_listeners")
        public void setMaxLoadBalancerListeners(Integer maxLoadBalancerListeners) {
            this.maxLoadBalancerListeners = maxLoadBalancerListeners;
        }

        @JsonProperty(value="max_loadbalancer_listeners")
        public Integer getMaxLoadBalancerListeners() {
            return this.maxLoadBalancerListeners;
        }

        @JsonProperty(value="max_loadbalancer_policy_rewrite_rules")
        public void setMaxLoadBalancerPolicyRewriteRules(Integer maxLoadBalancerPolicyRewriteRules) {
            this.maxLoadBalancerPolicyRewriteRules = maxLoadBalancerPolicyRewriteRules;
        }

        @JsonProperty(value="max_loadbalancer_policy_rewrite_rules")
        public Integer getMaxLoadBalancerPolicyRewriteRules() {
            return this.maxLoadBalancerPolicyRewriteRules;
        }

        @JsonProperty(value="max_loadbalancer_policy_rules")
        public void setMaxLoadBalancerPolicyRules(Integer maxLoadBalancerPolicyRules) {
            this.maxLoadBalancerPolicyRules = maxLoadBalancerPolicyRules;
        }

        @JsonProperty(value="max_loadbalancer_policy_rules")
        public Integer getMaxLoadBalancerPolicyRules() {
            return this.maxLoadBalancerPolicyRules;
        }

        @JsonProperty(value="max_member_in_user_group")
        public void setMaxMemberInUserGroup(Integer maxMemberInUserGroup) {
            this.maxMemberInUserGroup = maxMemberInUserGroup;
        }

        @JsonProperty(value="max_member_in_user_group")
        public Integer getMaxMemberInUserGroup() {
            return this.maxMemberInUserGroup;
        }

        @JsonProperty(value="max_nic_per_instance")
        public void setMaxNICPerInstance(Integer maxNICPerInstance) {
            this.maxNICPerInstance = maxNICPerInstance;
        }

        @JsonProperty(value="max_nic_per_instance")
        public Integer getMaxNICPerInstance() {
            return this.maxNICPerInstance;
        }

        @JsonProperty(value="max_resource_shared_users")
        public void setMaxResourceSharedUsers(Integer maxResourceSharedUsers) {
            this.maxResourceSharedUsers = maxResourceSharedUsers;
        }

        @JsonProperty(value="max_resource_shared_users")
        public Integer getMaxResourceSharedUsers() {
            return this.maxResourceSharedUsers;
        }

        @JsonProperty(value="max_rg_cnt_item_can_join")
        public void setMaxRgCntItemCanJoin(Integer maxRgCntItemCanJoin) {
            this.maxRgCntItemCanJoin = maxRgCntItemCanJoin;
        }

        @JsonProperty(value="max_rg_cnt_item_can_join")
        public Integer getMaxRgCntItemCanJoin() {
            return this.maxRgCntItemCanJoin;
        }

        @JsonProperty(value="max_router_count")
        public void setMaxRouterCount(Integer maxRouterCount) {
            this.maxRouterCount = maxRouterCount;
        }

        @JsonProperty(value="max_router_count")
        public Integer getMaxRouterCount() {
            return this.maxRouterCount;
        }

        @JsonProperty(value="max_router_entries")
        public void setMaxRouterEntries(Integer maxRouterEntries) {
            this.maxRouterEntries = maxRouterEntries;
        }

        @JsonProperty(value="max_router_entries")
        public Integer getMaxRouterEntries() {
            return this.maxRouterEntries;
        }

        @JsonProperty(value="max_router_statics")
        public void setMaxRouterStatics(Integer maxRouterStatics) {
            this.maxRouterStatics = maxRouterStatics;
        }

        @JsonProperty(value="max_router_statics")
        public Integer getMaxRouterStatics() {
            return this.maxRouterStatics;
        }

        @JsonProperty(value="max_router_vxnets")
        public void setMaxRouterVxNets(Integer maxRouterVxNets) {
            this.maxRouterVxNets = maxRouterVxNets;
        }

        @JsonProperty(value="max_router_vxnets")
        public Integer getMaxRouterVxNets() {
            return this.maxRouterVxNets;
        }

        @JsonProperty(value="max_rule_in_group_role")
        public void setMaxRuleInGroupRole(Integer maxRuleInGroupRole) {
            this.maxRuleInGroupRole = maxRuleInGroupRole;
        }

        @JsonProperty(value="max_rule_in_group_role")
        public Integer getMaxRuleInGroupRole() {
            return this.maxRuleInGroupRole;
        }

        @JsonProperty(value="max_security_group_rules")
        public void setMaxSecurityGroupRules(Integer maxSecurityGroupRules) {
            this.maxSecurityGroupRules = maxSecurityGroupRules;
        }

        @JsonProperty(value="max_security_group_rules")
        public Integer getMaxSecurityGroupRules() {
            return this.maxSecurityGroupRules;
        }

        @JsonProperty(value="max_security_group_rulesets")
        public void setMaxSecurityGroupRulesets(Integer maxSecurityGroupRulesets) {
            this.maxSecurityGroupRulesets = maxSecurityGroupRulesets;
        }

        @JsonProperty(value="max_security_group_rulesets")
        public Integer getMaxSecurityGroupRulesets() {
            return this.maxSecurityGroupRulesets;
        }

        @JsonProperty(value="max_security_group_snapshots")
        public void setMaxSecurityGroupSnapshots(Integer maxSecurityGroupSnapshots) {
            this.maxSecurityGroupSnapshots = maxSecurityGroupSnapshots;
        }

        @JsonProperty(value="max_security_group_snapshots")
        public Integer getMaxSecurityGroupSnapshots() {
            return this.maxSecurityGroupSnapshots;
        }

        @JsonProperty(value="max_users_in_one_department")
        public void setMaxUsersInOneDepartment(Integer maxUsersInOneDepartment) {
            this.maxUsersInOneDepartment = maxUsersInOneDepartment;
        }

        @JsonProperty(value="max_users_in_one_department")
        public Integer getMaxUsersInOneDepartment() {
            return this.maxUsersInOneDepartment;
        }

        @JsonProperty(value="max_volume_count")
        public void setMaxVolumeCount(Integer maxVolumeCount) {
            this.maxVolumeCount = maxVolumeCount;
        }

        @JsonProperty(value="max_volume_count")
        public Integer getMaxVolumeCount() {
            return this.maxVolumeCount;
        }

        @JsonProperty(value="max_volume_per_inst")
        public void setMaxVolumePerInst(Integer maxVolumePerInst) {
            this.maxVolumePerInst = maxVolumePerInst;
        }

        @JsonProperty(value="max_volume_per_inst")
        public Integer getMaxVolumePerInst() {
            return this.maxVolumePerInst;
        }

        @JsonProperty(value="max_volume_size")
        public void setMaxVolumeSize(Integer maxVolumeSize) {
            this.maxVolumeSize = maxVolumeSize;
        }

        @JsonProperty(value="max_volume_size")
        public Integer getMaxVolumeSize() {
            return this.maxVolumeSize;
        }

        @JsonProperty(value="max_vos_replica_count")
        public void setMaxVosReplicaCount(Integer maxVosReplicaCount) {
            this.maxVosReplicaCount = maxVosReplicaCount;
        }

        @JsonProperty(value="max_vos_replica_count")
        public Integer getMaxVosReplicaCount() {
            return this.maxVosReplicaCount;
        }

        @JsonProperty(value="max_vxnet_count")
        public void setMaxVxNetCount(Integer maxVxNetCount) {
            this.maxVxNetCount = maxVxNetCount;
        }

        @JsonProperty(value="max_vxnet_count")
        public Integer getMaxVxNetCount() {
            return this.maxVxNetCount;
        }

        @JsonProperty(value="min_abuse_eip_sec")
        public void setMinAbuseEIPSec(Integer minAbuseEIPSec) {
            this.minAbuseEIPSec = minAbuseEIPSec;
        }

        @JsonProperty(value="min_abuse_eip_sec")
        public Integer getMinAbuseEIPSec() {
            return this.minAbuseEIPSec;
        }

        @JsonProperty(value="min_hc_volume_size")
        public void setMinHcVolumeSize(Integer minHcVolumeSize) {
            this.minHcVolumeSize = minHcVolumeSize;
        }

        @JsonProperty(value="min_hc_volume_size")
        public Integer getMinHcVolumeSize() {
            return this.minHcVolumeSize;
        }

        @JsonProperty(value="min_hcs_volume_size")
        public void setMinHcsVolumeSize(Integer minHcsVolumeSize) {
            this.minHcsVolumeSize = minHcsVolumeSize;
        }

        @JsonProperty(value="min_hcs_volume_size")
        public Integer getMinHcsVolumeSize() {
            return this.minHcsVolumeSize;
        }

        @JsonProperty(value="min_hosts_per_dedicated_group")
        public void setMinHostsPerDedicatedGroup(Integer minHostsPerDedicatedGroup) {
            this.minHostsPerDedicatedGroup = minHostsPerDedicatedGroup;
        }

        @JsonProperty(value="min_hosts_per_dedicated_group")
        public Integer getMinHostsPerDedicatedGroup() {
            return this.minHostsPerDedicatedGroup;
        }

        @JsonProperty(value="min_hps_volume_size")
        public void setMinHpsVolumeSize(Integer minHpsVolumeSize) {
            this.minHpsVolumeSize = minHpsVolumeSize;
        }

        @JsonProperty(value="min_hps_volume_size")
        public Integer getMinHpsVolumeSize() {
            return this.minHpsVolumeSize;
        }

        @JsonProperty(value="min_reserved_hosts_in_pool")
        public void setMinReservedHostsInPool(Integer minReservedHostsInPool) {
            this.minReservedHostsInPool = minReservedHostsInPool;
        }

        @JsonProperty(value="min_reserved_hosts_in_pool")
        public Integer getMinReservedHostsInPool() {
            return this.minReservedHostsInPool;
        }

        @JsonProperty(value="min_volume_size")
        public void setMinVolumeSize(Integer minVolumeSize) {
            this.minVolumeSize = minVolumeSize;
        }

        @JsonProperty(value="min_volume_size")
        public Integer getMinVolumeSize() {
            return this.minVolumeSize;
        }

        @JsonProperty(value="privilege_of_lxc")
        public void setPrivilegeOfLxc(Integer privilegeOfLxc) {
            this.privilegeOfLxc = privilegeOfLxc;
        }

        @JsonProperty(value="privilege_of_lxc")
        public Integer getPrivilegeOfLxc() {
            return this.privilegeOfLxc;
        }

        @JsonProperty(value="spark_types")
        public void setSparkTypes(Model sparkTypes) {
            this.sparkTypes = sparkTypes;
        }

        @JsonProperty(value="spark_types")
        public Model getSparkTypes() {
            return this.sparkTypes;
        }

        @JsonProperty(value="storm_types")
        public void setStormTypes(Model stormTypes) {
            this.stormTypes = stormTypes;
        }

        @JsonProperty(value="storm_types")
        public Model getStormTypes() {
            return this.stormTypes;
        }

        @JsonProperty(value="valid_cache_size")
        public void setValidCacheSize(List<Integer> validCacheSize) {
            this.validCacheSize = validCacheSize;
        }

        @JsonProperty(value="valid_cache_size")
        public List<Integer> getValidCacheSize() {
            return this.validCacheSize;
        }

        @JsonProperty(value="valid_cpu_cores")
        public void setValidCPUCores(List<Integer> validCPUCores) {
            this.validCPUCores = validCPUCores;
        }

        @JsonProperty(value="valid_cpu_cores")
        public List<Integer> getValidCPUCores() {
            return this.validCPUCores;
        }

        @JsonProperty(value="valid_cpu_memory_pairs")
        public void setValidCPUMemoryPairs(Model validCPUMemoryPairs) {
            this.validCPUMemoryPairs = validCPUMemoryPairs;
        }

        @JsonProperty(value="valid_cpu_memory_pairs")
        public Model getValidCPUMemoryPairs() {
            return this.validCPUMemoryPairs;
        }

        @JsonProperty(value="valid_dedicated_host_group_classes")
        public void setValidDedicatedHostGroupClasses(List<Integer> validDedicatedHostGroupClasses) {
            this.validDedicatedHostGroupClasses = validDedicatedHostGroupClasses;
        }

        @JsonProperty(value="valid_dedicated_host_group_classes")
        public List<Integer> getValidDedicatedHostGroupClasses() {
            return this.validDedicatedHostGroupClasses;
        }

        @JsonProperty(value="valid_instance_classes")
        public void setValidInstanceClasses(List<Integer> validInstanceClasses) {
            this.validInstanceClasses = validInstanceClasses;
        }

        @JsonProperty(value="valid_instance_classes")
        public List<Integer> getValidInstanceClasses() {
            return this.validInstanceClasses;
        }

        @JsonProperty(value="valid_loadbalancer_types")
        public void setValidLoadBalancerTypes(List<Integer> validLoadBalancerTypes) {
            this.validLoadBalancerTypes = validLoadBalancerTypes;
        }

        @JsonProperty(value="valid_loadbalancer_types")
        public List<Integer> getValidLoadBalancerTypes() {
            return this.validLoadBalancerTypes;
        }

        @JsonProperty(value="valid_memory_size")
        public void setValidMemorySize(List<Integer> validMemorySize) {
            this.validMemorySize = validMemorySize;
        }

        @JsonProperty(value="valid_memory_size")
        public List<Integer> getValidMemorySize() {
            return this.validMemorySize;
        }

        @JsonProperty(value="valid_resource_classes")
        public void setValidResourceClasses(List<Integer> validResourceClasses) {
            this.validResourceClasses = validResourceClasses;
        }

        @JsonProperty(value="valid_resource_classes")
        public List<Integer> getValidResourceClasses() {
            return this.validResourceClasses;
        }

        @JsonProperty(value="valid_volume_types")
        public void setValidVolumeTypes(List<Integer> validVolumeTypes) {
            this.validVolumeTypes = validVolumeTypes;
        }

        @JsonProperty(value="valid_volume_types")
        public List<Integer> getValidVolumeTypes() {
            return this.validVolumeTypes;
        }

        @JsonProperty(value="volume_step")
        public void setVolumeStep(Integer volumeStep) {
            this.volumeStep = volumeStep;
        }

        @JsonProperty(value="volume_step")
        public Integer getVolumeStep() {
            return this.volumeStep;
        }

        @JsonProperty(value="vpc_ipv6_prefixlen")
        public void setVpcIpv6Prefixlen(Integer vpcIpv6Prefixlen) {
            this.vpcIpv6Prefixlen = vpcIpv6Prefixlen;
        }

        @JsonProperty(value="vpc_ipv6_prefixlen")
        public Integer getVpcIpv6Prefixlen() {
            return this.vpcIpv6Prefixlen;
        }

        @JsonProperty(value="vxnet_ipv6_prefixlen")
        public void setVxNetIpv6Prefixlen(Integer vxNetIpv6Prefixlen) {
            this.vxNetIpv6Prefixlen = vxNetIpv6Prefixlen;
        }

        @JsonProperty(value="vxnet_ipv6_prefixlen")
        public Integer getVxNetIpv6Prefixlen() {
            return this.vxNetIpv6Prefixlen;
        }

        @JsonProperty(value="vxnet_ks_white_list")
        public void setVxNetKsWhiteList(String vxNetKsWhiteList) {
            this.vxNetKsWhiteList = vxNetKsWhiteList;
        }

        @JsonProperty(value="vxnet_ks_white_list")
        public String getVxNetKsWhiteList() {
            return this.vxNetKsWhiteList;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceModel
    implements ParamValidate {
        private String resourceID;
        private String resourceName;
        private String resourceType;

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="resource_name")
        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @JsonProperty(value="resource_name")
        public String getResourceName() {
            return this.resourceName;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RDBPrivateIPModel
    implements ParamValidate {
        private String master;
        private String topSlave;

        @JsonProperty(value="master")
        public void setMaster(String master) {
            this.master = master;
        }

        @JsonProperty(value="master")
        public String getMaster() {
            return this.master;
        }

        @JsonProperty(value="topslave")
        public void setTopSlave(String topSlave) {
            this.topSlave = topSlave;
        }

        @JsonProperty(value="topslave")
        public String getTopSlave() {
            return this.topSlave;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RDBParametersModel
    implements ParamValidate {
        private String bindAddress;
        private String binlogFormat;
        private String characterSetServer;
        private String dataDir;
        private String defaultStorageEngine;
        private Integer expireLogsDays;
        private String innoDB;
        private Integer innoDBBufferPoolInstances;
        private String innoDBBufferPoolSize;
        private Integer innoDBFilePerTable;
        private Integer innoDBFlushLogAtTRXCommit;
        private String innoDBFlushMethod;
        private Integer innoDBIOCapacity;
        private String innoDBLogBufferSize;
        private String innoDBLogFileSize;
        private Integer innoDBLogFilesInGroup;
        private Integer innoDBMaxDirtyPagesPct;
        private Integer innoDBReadIOThreads;
        private Integer innoDBWriteIOThreads;
        private Integer interactiveTimeout;
        private String keyBufferSize;
        private String logBinIndex;
        private String logBin;
        private String logError;
        private String logQueriesNotUsingIndexes;
        private Integer logSlaveUpdates;
        private Integer longQueryTime;
        private Integer lowerCaseTableNames;
        private String maxAllowedPacket;
        private Integer maxConnectErrors;
        private Integer maxConnections;
        private String maxHeapTableSize;
        private Integer openFilesLimit;
        private Integer port;
        private Integer queryCacheSize;
        private Integer queryCacheType;
        private String relayLog;
        private String relayLogIndex;
        private Integer skipSlaveStart;
        private Integer skipNameResolve;
        private String slaveExecMode;
        private Integer slaveNetTimeout;
        private Integer slowQueryLog;
        private String slowQueryLogFile;
        private String sQLMode;
        private Integer syncBinlog;
        private Integer syncMasterInfo;
        private Integer syncRelayLog;
        private Integer syncRelayLogInfo;
        private Integer tableOpenCache;
        private Integer threadCacheSize;
        private String tMPTableSize;
        private String tMPDir;
        private String user;
        private Integer waitTimeout;

        @JsonProperty(value="bind_address")
        public void setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
        }

        @JsonProperty(value="bind_address")
        public String getBindAddress() {
            return this.bindAddress;
        }

        @JsonProperty(value="binlog_format")
        public void setBinlogFormat(String binlogFormat) {
            this.binlogFormat = binlogFormat;
        }

        @JsonProperty(value="binlog_format")
        public String getBinlogFormat() {
            return this.binlogFormat;
        }

        @JsonProperty(value="character_set_server")
        public void setCharacterSetServer(String characterSetServer) {
            this.characterSetServer = characterSetServer;
        }

        @JsonProperty(value="character_set_server")
        public String getCharacterSetServer() {
            return this.characterSetServer;
        }

        @JsonProperty(value="datadir")
        public void setDataDir(String dataDir) {
            this.dataDir = dataDir;
        }

        @JsonProperty(value="datadir")
        public String getDataDir() {
            return this.dataDir;
        }

        @JsonProperty(value="default_storage_engine")
        public void setDefaultStorageEngine(String defaultStorageEngine) {
            this.defaultStorageEngine = defaultStorageEngine;
        }

        @JsonProperty(value="default_storage_engine")
        public String getDefaultStorageEngine() {
            return this.defaultStorageEngine;
        }

        @JsonProperty(value="expire_logs_days")
        public void setExpireLogsDays(Integer expireLogsDays) {
            this.expireLogsDays = expireLogsDays;
        }

        @JsonProperty(value="expire_logs_days")
        public Integer getExpireLogsDays() {
            return this.expireLogsDays;
        }

        @JsonProperty(value="innodb")
        public void setInnoDB(String innoDB) {
            this.innoDB = innoDB;
        }

        @JsonProperty(value="innodb")
        public String getInnoDB() {
            return this.innoDB;
        }

        @JsonProperty(value="innodb_buffer_pool_instances")
        public void setInnoDBBufferPoolInstances(Integer innoDBBufferPoolInstances) {
            this.innoDBBufferPoolInstances = innoDBBufferPoolInstances;
        }

        @JsonProperty(value="innodb_buffer_pool_instances")
        public Integer getInnoDBBufferPoolInstances() {
            return this.innoDBBufferPoolInstances;
        }

        @JsonProperty(value="innodb_buffer_pool_size")
        public void setInnoDBBufferPoolSize(String innoDBBufferPoolSize) {
            this.innoDBBufferPoolSize = innoDBBufferPoolSize;
        }

        @JsonProperty(value="innodb_buffer_pool_size")
        public String getInnoDBBufferPoolSize() {
            return this.innoDBBufferPoolSize;
        }

        @JsonProperty(value="innodb_file_per_table")
        public void setInnoDBFilePerTable(Integer innoDBFilePerTable) {
            this.innoDBFilePerTable = innoDBFilePerTable;
        }

        @JsonProperty(value="innodb_file_per_table")
        public Integer getInnoDBFilePerTable() {
            return this.innoDBFilePerTable;
        }

        @JsonProperty(value="innodb_flush_log_at_trx_commit")
        public void setInnoDBFlushLogAtTRXCommit(Integer innoDBFlushLogAtTRXCommit) {
            this.innoDBFlushLogAtTRXCommit = innoDBFlushLogAtTRXCommit;
        }

        @JsonProperty(value="innodb_flush_log_at_trx_commit")
        public Integer getInnoDBFlushLogAtTRXCommit() {
            return this.innoDBFlushLogAtTRXCommit;
        }

        @JsonProperty(value="innodb_flush_method")
        public void setInnoDBFlushMethod(String innoDBFlushMethod) {
            this.innoDBFlushMethod = innoDBFlushMethod;
        }

        @JsonProperty(value="innodb_flush_method")
        public String getInnoDBFlushMethod() {
            return this.innoDBFlushMethod;
        }

        @JsonProperty(value="innodb_io_capacity")
        public void setInnoDBIOCapacity(Integer innoDBIOCapacity) {
            this.innoDBIOCapacity = innoDBIOCapacity;
        }

        @JsonProperty(value="innodb_io_capacity")
        public Integer getInnoDBIOCapacity() {
            return this.innoDBIOCapacity;
        }

        @JsonProperty(value="innodb_log_buffer_size")
        public void setInnoDBLogBufferSize(String innoDBLogBufferSize) {
            this.innoDBLogBufferSize = innoDBLogBufferSize;
        }

        @JsonProperty(value="innodb_log_buffer_size")
        public String getInnoDBLogBufferSize() {
            return this.innoDBLogBufferSize;
        }

        @JsonProperty(value="innodb_log_file_size")
        public void setInnoDBLogFileSize(String innoDBLogFileSize) {
            this.innoDBLogFileSize = innoDBLogFileSize;
        }

        @JsonProperty(value="innodb_log_file_size")
        public String getInnoDBLogFileSize() {
            return this.innoDBLogFileSize;
        }

        @JsonProperty(value="innodb_log_files_in_group")
        public void setInnoDBLogFilesInGroup(Integer innoDBLogFilesInGroup) {
            this.innoDBLogFilesInGroup = innoDBLogFilesInGroup;
        }

        @JsonProperty(value="innodb_log_files_in_group")
        public Integer getInnoDBLogFilesInGroup() {
            return this.innoDBLogFilesInGroup;
        }

        @JsonProperty(value="innodb_max_dirty_pages_pct")
        public void setInnoDBMaxDirtyPagesPct(Integer innoDBMaxDirtyPagesPct) {
            this.innoDBMaxDirtyPagesPct = innoDBMaxDirtyPagesPct;
        }

        @JsonProperty(value="innodb_max_dirty_pages_pct")
        public Integer getInnoDBMaxDirtyPagesPct() {
            return this.innoDBMaxDirtyPagesPct;
        }

        @JsonProperty(value="innodb_read_io_threads")
        public void setInnoDBReadIOThreads(Integer innoDBReadIOThreads) {
            this.innoDBReadIOThreads = innoDBReadIOThreads;
        }

        @JsonProperty(value="innodb_read_io_threads")
        public Integer getInnoDBReadIOThreads() {
            return this.innoDBReadIOThreads;
        }

        @JsonProperty(value="innodb_write_io_threads")
        public void setInnoDBWriteIOThreads(Integer innoDBWriteIOThreads) {
            this.innoDBWriteIOThreads = innoDBWriteIOThreads;
        }

        @JsonProperty(value="innodb_write_io_threads")
        public Integer getInnoDBWriteIOThreads() {
            return this.innoDBWriteIOThreads;
        }

        @JsonProperty(value="interactive_timeout")
        public void setInteractiveTimeout(Integer interactiveTimeout) {
            this.interactiveTimeout = interactiveTimeout;
        }

        @JsonProperty(value="interactive_timeout")
        public Integer getInteractiveTimeout() {
            return this.interactiveTimeout;
        }

        @JsonProperty(value="key_buffer_size")
        public void setKeyBufferSize(String keyBufferSize) {
            this.keyBufferSize = keyBufferSize;
        }

        @JsonProperty(value="key_buffer_size")
        public String getKeyBufferSize() {
            return this.keyBufferSize;
        }

        @JsonProperty(value="log-bin-index")
        public void setLogBinIndex(String logBinIndex) {
            this.logBinIndex = logBinIndex;
        }

        @JsonProperty(value="log-bin-index")
        public String getLogBinIndex() {
            return this.logBinIndex;
        }

        @JsonProperty(value="log_bin")
        public void setLogBin(String logBin) {
            this.logBin = logBin;
        }

        @JsonProperty(value="log_bin")
        public String getLogBin() {
            return this.logBin;
        }

        @JsonProperty(value="log_error")
        public void setLogError(String logError) {
            this.logError = logError;
        }

        @JsonProperty(value="log_error")
        public String getLogError() {
            return this.logError;
        }

        @JsonProperty(value="log_queries_not_using_indexes")
        public void setLogQueriesNotUsingIndexes(String logQueriesNotUsingIndexes) {
            this.logQueriesNotUsingIndexes = logQueriesNotUsingIndexes;
        }

        @JsonProperty(value="log_queries_not_using_indexes")
        public String getLogQueriesNotUsingIndexes() {
            return this.logQueriesNotUsingIndexes;
        }

        @JsonProperty(value="log_slave_updates")
        public void setLogSlaveUpdates(Integer logSlaveUpdates) {
            this.logSlaveUpdates = logSlaveUpdates;
        }

        @JsonProperty(value="log_slave_updates")
        public Integer getLogSlaveUpdates() {
            return this.logSlaveUpdates;
        }

        @JsonProperty(value="long_query_time")
        public void setLongQueryTime(Integer longQueryTime) {
            this.longQueryTime = longQueryTime;
        }

        @JsonProperty(value="long_query_time")
        public Integer getLongQueryTime() {
            return this.longQueryTime;
        }

        @JsonProperty(value="lower_case_table_names")
        public void setLowerCaseTableNames(Integer lowerCaseTableNames) {
            this.lowerCaseTableNames = lowerCaseTableNames;
        }

        @JsonProperty(value="lower_case_table_names")
        public Integer getLowerCaseTableNames() {
            return this.lowerCaseTableNames;
        }

        @JsonProperty(value="max_allowed_packet")
        public void setMaxAllowedPacket(String maxAllowedPacket) {
            this.maxAllowedPacket = maxAllowedPacket;
        }

        @JsonProperty(value="max_allowed_packet")
        public String getMaxAllowedPacket() {
            return this.maxAllowedPacket;
        }

        @JsonProperty(value="max_connect_errors")
        public void setMaxConnectErrors(Integer maxConnectErrors) {
            this.maxConnectErrors = maxConnectErrors;
        }

        @JsonProperty(value="max_connect_errors")
        public Integer getMaxConnectErrors() {
            return this.maxConnectErrors;
        }

        @JsonProperty(value="max_connections")
        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        @JsonProperty(value="max_connections")
        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        @JsonProperty(value="max_heap_table_size")
        public void setMaxHeapTableSize(String maxHeapTableSize) {
            this.maxHeapTableSize = maxHeapTableSize;
        }

        @JsonProperty(value="max_heap_table_size")
        public String getMaxHeapTableSize() {
            return this.maxHeapTableSize;
        }

        @JsonProperty(value="open_files_limit")
        public void setOpenFilesLimit(Integer openFilesLimit) {
            this.openFilesLimit = openFilesLimit;
        }

        @JsonProperty(value="open_files_limit")
        public Integer getOpenFilesLimit() {
            return this.openFilesLimit;
        }

        @JsonProperty(value="port")
        public void setPort(Integer port) {
            this.port = port;
        }

        @JsonProperty(value="port")
        public Integer getPort() {
            return this.port;
        }

        @JsonProperty(value="query_cache_size")
        public void setQueryCacheSize(Integer queryCacheSize) {
            this.queryCacheSize = queryCacheSize;
        }

        @JsonProperty(value="query_cache_size")
        public Integer getQueryCacheSize() {
            return this.queryCacheSize;
        }

        @JsonProperty(value="query_cache_type")
        public void setQueryCacheType(Integer queryCacheType) {
            this.queryCacheType = queryCacheType;
        }

        @JsonProperty(value="query_cache_type")
        public Integer getQueryCacheType() {
            return this.queryCacheType;
        }

        @JsonProperty(value="relay_log")
        public void setRelayLog(String relayLog) {
            this.relayLog = relayLog;
        }

        @JsonProperty(value="relay_log")
        public String getRelayLog() {
            return this.relayLog;
        }

        @JsonProperty(value="relay_log_index")
        public void setRelayLogIndex(String relayLogIndex) {
            this.relayLogIndex = relayLogIndex;
        }

        @JsonProperty(value="relay_log_index")
        public String getRelayLogIndex() {
            return this.relayLogIndex;
        }

        @JsonProperty(value="skip-slave-start")
        public void setSkipSlaveStart(Integer skipSlaveStart) {
            this.skipSlaveStart = skipSlaveStart;
        }

        @JsonProperty(value="skip-slave-start")
        public Integer getSkipSlaveStart() {
            return this.skipSlaveStart;
        }

        @JsonProperty(value="skip_name_resolve")
        public void setSkipNameResolve(Integer skipNameResolve) {
            this.skipNameResolve = skipNameResolve;
        }

        @JsonProperty(value="skip_name_resolve")
        public Integer getSkipNameResolve() {
            return this.skipNameResolve;
        }

        @JsonProperty(value="slave_exec_mode")
        public void setSlaveExecMode(String slaveExecMode) {
            this.slaveExecMode = slaveExecMode;
        }

        @JsonProperty(value="slave_exec_mode")
        public String getSlaveExecMode() {
            return this.slaveExecMode;
        }

        @JsonProperty(value="slave_net_timeout")
        public void setSlaveNetTimeout(Integer slaveNetTimeout) {
            this.slaveNetTimeout = slaveNetTimeout;
        }

        @JsonProperty(value="slave_net_timeout")
        public Integer getSlaveNetTimeout() {
            return this.slaveNetTimeout;
        }

        @JsonProperty(value="slow_query_log")
        public void setSlowQueryLog(Integer slowQueryLog) {
            this.slowQueryLog = slowQueryLog;
        }

        @JsonProperty(value="slow_query_log")
        public Integer getSlowQueryLog() {
            return this.slowQueryLog;
        }

        @JsonProperty(value="slow_query_log_file")
        public void setSlowQueryLogFile(String slowQueryLogFile) {
            this.slowQueryLogFile = slowQueryLogFile;
        }

        @JsonProperty(value="slow_query_log_file")
        public String getSlowQueryLogFile() {
            return this.slowQueryLogFile;
        }

        @JsonProperty(value="sql_mode")
        public void setSQLMode(String sQLMode) {
            this.sQLMode = sQLMode;
        }

        @JsonProperty(value="sql_mode")
        public String getSQLMode() {
            return this.sQLMode;
        }

        @JsonProperty(value="sync_binlog")
        public void setSyncBinlog(Integer syncBinlog) {
            this.syncBinlog = syncBinlog;
        }

        @JsonProperty(value="sync_binlog")
        public Integer getSyncBinlog() {
            return this.syncBinlog;
        }

        @JsonProperty(value="sync_master_info")
        public void setSyncMasterInfo(Integer syncMasterInfo) {
            this.syncMasterInfo = syncMasterInfo;
        }

        @JsonProperty(value="sync_master_info")
        public Integer getSyncMasterInfo() {
            return this.syncMasterInfo;
        }

        @JsonProperty(value="sync_relay_log")
        public void setSyncRelayLog(Integer syncRelayLog) {
            this.syncRelayLog = syncRelayLog;
        }

        @JsonProperty(value="sync_relay_log")
        public Integer getSyncRelayLog() {
            return this.syncRelayLog;
        }

        @JsonProperty(value="sync_relay_log_info")
        public void setSyncRelayLogInfo(Integer syncRelayLogInfo) {
            this.syncRelayLogInfo = syncRelayLogInfo;
        }

        @JsonProperty(value="sync_relay_log_info")
        public Integer getSyncRelayLogInfo() {
            return this.syncRelayLogInfo;
        }

        @JsonProperty(value="table_open_cache")
        public void setTableOpenCache(Integer tableOpenCache) {
            this.tableOpenCache = tableOpenCache;
        }

        @JsonProperty(value="table_open_cache")
        public Integer getTableOpenCache() {
            return this.tableOpenCache;
        }

        @JsonProperty(value="thread_cache_size")
        public void setThreadCacheSize(Integer threadCacheSize) {
            this.threadCacheSize = threadCacheSize;
        }

        @JsonProperty(value="thread_cache_size")
        public Integer getThreadCacheSize() {
            return this.threadCacheSize;
        }

        @JsonProperty(value="tmp_table_size")
        public void setTMPTableSize(String tMPTableSize) {
            this.tMPTableSize = tMPTableSize;
        }

        @JsonProperty(value="tmp_table_size")
        public String getTMPTableSize() {
            return this.tMPTableSize;
        }

        @JsonProperty(value="tmpdir")
        public void setTMPDir(String tMPDir) {
            this.tMPDir = tMPDir;
        }

        @JsonProperty(value="tmpdir")
        public String getTMPDir() {
            return this.tMPDir;
        }

        @JsonProperty(value="user")
        public void setUser(String user) {
            this.user = user;
        }

        @JsonProperty(value="user")
        public String getUser() {
            return this.user;
        }

        @JsonProperty(value="wait_timeout")
        public void setWaitTimeout(Integer waitTimeout) {
            this.waitTimeout = waitTimeout;
        }

        @JsonProperty(value="wait_timeout")
        public Integer getWaitTimeout() {
            return this.waitTimeout;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RDBParameterModel
    implements ParamValidate {
        private String family;
        private Integer isReadonly;
        private Integer isStatic;
        private Integer maxValue;
        private Integer minValue;
        private String oPTName;
        private String sectionName;
        private String varName;
        private String varType;
        private String varValue;

        @JsonProperty(value="family")
        public void setFamily(String family) {
            this.family = family;
        }

        @JsonProperty(value="family")
        public String getFamily() {
            return this.family;
        }

        @JsonProperty(value="is_readonly")
        public void setIsReadonly(Integer isReadonly) {
            this.isReadonly = isReadonly;
        }

        @JsonProperty(value="is_readonly")
        public Integer getIsReadonly() {
            return this.isReadonly;
        }

        @JsonProperty(value="is_static")
        public void setIsStatic(Integer isStatic) {
            this.isStatic = isStatic;
        }

        @JsonProperty(value="is_static")
        public Integer getIsStatic() {
            return this.isStatic;
        }

        @JsonProperty(value="max_value")
        public void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @JsonProperty(value="max_value")
        public Integer getMaxValue() {
            return this.maxValue;
        }

        @JsonProperty(value="min_value")
        public void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @JsonProperty(value="min_value")
        public Integer getMinValue() {
            return this.minValue;
        }

        @JsonProperty(value="opt_name")
        public void setOPTName(String oPTName) {
            this.oPTName = oPTName;
        }

        @JsonProperty(value="opt_name")
        public String getOPTName() {
            return this.oPTName;
        }

        @JsonProperty(value="section_name")
        public void setSectionName(String sectionName) {
            this.sectionName = sectionName;
        }

        @JsonProperty(value="section_name")
        public String getSectionName() {
            return this.sectionName;
        }

        @JsonProperty(value="var_name")
        public void setVarName(String varName) {
            this.varName = varName;
        }

        @JsonProperty(value="var_name")
        public String getVarName() {
            return this.varName;
        }

        @JsonProperty(value="var_type")
        public void setVarType(String varType) {
            this.varType = varType;
        }

        @JsonProperty(value="var_type")
        public String getVarType() {
            return this.varType;
        }

        @JsonProperty(value="var_value")
        public void setVarValue(String varValue) {
            this.varValue = varValue;
        }

        @JsonProperty(value="var_value")
        public String getVarValue() {
            return this.varValue;
        }

        @Override
        public String validateParam() throws QCException {
            String[] isReadonlyValidValues = new String[]{"0", "1"};
            boolean isReadonlyIsValid = false;
            for (String v : isReadonlyValidValues) {
                Boolean isReadonlyIsRequired;
                if (v.equals(this.getIsReadonly() + "")) {
                    isReadonlyIsValid = true;
                }
                if (!(isReadonlyIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsReadonly() != null) continue;
                isReadonlyIsValid = true;
            }
            if (!isReadonlyIsValid) {
                throw new QCException("IsReadonly value " + this.getIsReadonly() + "is invalid");
            }
            String[] isStaticValidValues = new String[]{"0", "1"};
            boolean isStaticIsValid = false;
            for (String v : isStaticValidValues) {
                Boolean isStaticIsRequired;
                if (v.equals(this.getIsStatic() + "")) {
                    isStaticIsValid = true;
                }
                if (!(isStaticIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsStatic() != null) continue;
                isStaticIsValid = true;
            }
            if (!isStaticIsValid) {
                throw new QCException("IsStatic value " + this.getIsStatic() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RDBFileModel
    implements ParamValidate {
        private List<FileModel> binaryLog;
        private List<FileModel> errorLog;
        private List<FileModel> slowLog;

        @JsonProperty(value="binary_log")
        public void setBinaryLog(List<FileModel> binaryLog) {
            this.binaryLog = binaryLog;
        }

        @JsonProperty(value="binary_log")
        public List<FileModel> getBinaryLog() {
            return this.binaryLog;
        }

        @JsonProperty(value="error_log")
        public void setErrorLog(List<FileModel> errorLog) {
            this.errorLog = errorLog;
        }

        @JsonProperty(value="error_log")
        public List<FileModel> getErrorLog() {
            return this.errorLog;
        }

        @JsonProperty(value="slow_log")
        public void setSlowLog(List<FileModel> slowLog) {
            this.slowLog = slowLog;
        }

        @JsonProperty(value="slow_log")
        public List<FileModel> getSlowLog() {
            return this.slowLog;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getBinaryLog() != null && this.getBinaryLog().size() > 0 && (i = 0) < this.getBinaryLog().size()) {
                return null;
            }
            if (this.getErrorLog() != null && this.getErrorLog().size() > 0 && (i = 0) < this.getErrorLog().size()) {
                return null;
            }
            if (this.getSlowLog() != null && this.getSlowLog().size() > 0 && (i = 0) < this.getSlowLog().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RDBModel
    implements ParamValidate {
        private String alarmStatus;
        private Integer autoBackupTime;
        private Integer autoMinorVerUpgrade;
        private String createTime;
        private String description;
        private String engineVersion;
        private String latestSnapshotTime;
        private String masterIP;
        private String rDBEngine;
        private String rDBID;
        private String rDBName;
        private Integer rDBType;
        private String status;
        private String statusTime;
        private Integer storageSize;
        private List<TagModel> tags;
        private String transitionStatus;
        private VxNetModel vxNet;

        @JsonProperty(value="alarm_status")
        public void setAlarmStatus(String alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        @JsonProperty(value="alarm_status")
        public String getAlarmStatus() {
            return this.alarmStatus;
        }

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="auto_minor_ver_upgrade")
        public void setAutoMinorVerUpgrade(Integer autoMinorVerUpgrade) {
            this.autoMinorVerUpgrade = autoMinorVerUpgrade;
        }

        @JsonProperty(value="auto_minor_ver_upgrade")
        public Integer getAutoMinorVerUpgrade() {
            return this.autoMinorVerUpgrade;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="engine_version")
        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @JsonProperty(value="engine_version")
        public String getEngineVersion() {
            return this.engineVersion;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public void setLatestSnapshotTime(String latestSnapshotTime) {
            this.latestSnapshotTime = latestSnapshotTime;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public String getLatestSnapshotTime() {
            return this.latestSnapshotTime;
        }

        @JsonProperty(value="master_ip")
        public void setMasterIP(String masterIP) {
            this.masterIP = masterIP;
        }

        @JsonProperty(value="master_ip")
        public String getMasterIP() {
            return this.masterIP;
        }

        @JsonProperty(value="rdb_engine")
        public void setRDBEngine(String rDBEngine) {
            this.rDBEngine = rDBEngine;
        }

        @JsonProperty(value="rdb_engine")
        public String getRDBEngine() {
            return this.rDBEngine;
        }

        @JsonProperty(value="rdb_id")
        public void setRDBID(String rDBID) {
            this.rDBID = rDBID;
        }

        @JsonProperty(value="rdb_id")
        public String getRDBID() {
            return this.rDBID;
        }

        @JsonProperty(value="rdb_name")
        public void setRDBName(String rDBName) {
            this.rDBName = rDBName;
        }

        @JsonProperty(value="rdb_name")
        public String getRDBName() {
            return this.rDBName;
        }

        @JsonProperty(value="rdb_type")
        public void setRDBType(Integer rDBType) {
            this.rDBType = rDBType;
        }

        @JsonProperty(value="rdb_type")
        public Integer getRDBType() {
            return this.rDBType;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(VxNetModel vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public VxNetModel getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] alarmStatusValidValues = new String[]{"ok", "alarm", "insufficient"};
            boolean alarmStatusIsValid = false;
            for (String v : alarmStatusValidValues) {
                Boolean alarmStatusIsRequired;
                if (v.equals(this.getAlarmStatus())) {
                    alarmStatusIsValid = true;
                }
                if (!(alarmStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getAlarmStatus() != null) continue;
                alarmStatusIsValid = true;
            }
            if (!alarmStatusIsValid) {
                throw new QCException("AlarmStatus value " + this.getAlarmStatus() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "active", "stopped", "deleted", "suspended", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "stopping", "starting", "deleting", "backup-creating", "temp-creating", "configuring", "switching", "invalid-tackling", "resizing", "suspending", "ceasing", "instance-ceasing", "vxnet-leaving", "vxnet-joining"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class QuotaLeftModel
    implements ParamValidate {
        private Integer left;
        private String resourceType;

        @JsonProperty(value="left")
        public void setLeft(Integer left) {
            this.left = left;
        }

        @JsonProperty(value="left")
        public Integer getLeft() {
            return this.left;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProjectResourceItemModel
    implements ParamValidate {
        private String createTime;
        private String meta;
        private String owner;
        private String projectID;
        private String projectName;
        private String resourceGroupID;
        private String resourceID;
        private String resourceType;
        private String rootUserID;
        private String zoneID;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="meta")
        public void setMeta(String meta) {
            this.meta = meta;
        }

        @JsonProperty(value="meta")
        public String getMeta() {
            return this.meta;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="project_name")
        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @JsonProperty(value="project_name")
        public String getProjectName() {
            return this.projectName;
        }

        @JsonProperty(value="resource_group_id")
        public void setResourceGroupID(String resourceGroupID) {
            this.resourceGroupID = resourceGroupID;
        }

        @JsonProperty(value="resource_group_id")
        public String getResourceGroupID() {
            return this.resourceGroupID;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="zone_id")
        public void setZoneID(String zoneID) {
            this.zoneID = zoneID;
        }

        @JsonProperty(value="zone_id")
        public String getZoneID() {
            return this.zoneID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProjectModel
    implements ParamValidate {
        private String consoleID;
        private String createTime;
        private String description;
        private Integer enabled;
        private String meta;
        private String owner;
        private String ownerName;
        private String projectID;
        private String projectName;
        private String resourceGroupID;
        private String rootUserID;
        private String status;

        @JsonProperty(value="console_id")
        public void setConsoleID(String consoleID) {
            this.consoleID = consoleID;
        }

        @JsonProperty(value="console_id")
        public String getConsoleID() {
            return this.consoleID;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(Integer enabled) {
            this.enabled = enabled;
        }

        @JsonProperty(value="enabled")
        public Integer getEnabled() {
            return this.enabled;
        }

        @JsonProperty(value="meta")
        public void setMeta(String meta) {
            this.meta = meta;
        }

        @JsonProperty(value="meta")
        public String getMeta() {
            return this.meta;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="owner_name")
        public void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        @JsonProperty(value="owner_name")
        public String getOwnerName() {
            return this.ownerName;
        }

        @JsonProperty(value="project_id")
        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        @JsonProperty(value="project_id")
        public String getProjectID() {
            return this.projectID;
        }

        @JsonProperty(value="project_name")
        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @JsonProperty(value="project_name")
        public String getProjectName() {
            return this.projectName;
        }

        @JsonProperty(value="resource_group_id")
        public void setResourceGroupID(String resourceGroupID) {
            this.resourceGroupID = resourceGroupID;
        }

        @JsonProperty(value="resource_group_id")
        public String getResourceGroupID() {
            return this.resourceGroupID;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NotificationListItemModel
    implements ParamValidate {
        private String consoleID;
        private String content;
        private String createTime;
        private String notificationItemID;
        private String notificationItemType;
        private String owner;
        private String remarks;
        private String rootUserID;
        private Integer validStatus;
        private String verificationCode;
        private Integer verified;
        private String verifyTime;

        @JsonProperty(value="console_id")
        public void setConsoleID(String consoleID) {
            this.consoleID = consoleID;
        }

        @JsonProperty(value="console_id")
        public String getConsoleID() {
            return this.consoleID;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="content")
        public String getContent() {
            return this.content;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="notification_item_id")
        public void setNotificationItemID(String notificationItemID) {
            this.notificationItemID = notificationItemID;
        }

        @JsonProperty(value="notification_item_id")
        public String getNotificationItemID() {
            return this.notificationItemID;
        }

        @JsonProperty(value="notification_item_type")
        public void setNotificationItemType(String notificationItemType) {
            this.notificationItemType = notificationItemType;
        }

        @JsonProperty(value="notification_item_type")
        public String getNotificationItemType() {
            return this.notificationItemType;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="remarks")
        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        @JsonProperty(value="remarks")
        public String getRemarks() {
            return this.remarks;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="valid_status")
        public void setValidStatus(Integer validStatus) {
            this.validStatus = validStatus;
        }

        @JsonProperty(value="valid_status")
        public Integer getValidStatus() {
            return this.validStatus;
        }

        @JsonProperty(value="verification_code")
        public void setVerificationCode(String verificationCode) {
            this.verificationCode = verificationCode;
        }

        @JsonProperty(value="verification_code")
        public String getVerificationCode() {
            return this.verificationCode;
        }

        @JsonProperty(value="verified")
        public void setVerified(Integer verified) {
            this.verified = verified;
        }

        @JsonProperty(value="verified")
        public Integer getVerified() {
            return this.verified;
        }

        @JsonProperty(value="verify_time")
        public void setVerifyTime(String verifyTime) {
            this.verifyTime = verifyTime;
        }

        @JsonProperty(value="verify_time")
        public String getVerifyTime() {
            return this.verifyTime;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NotificationListModel
    implements ParamValidate {
        private String consoleID;
        private String createTime;
        private String isMine;
        private List<NotificationListItemModel> items;
        private String notificationListID;
        private String notificationListName;
        private String owner;
        private String rootUserID;
        private String shared;
        private String visibility;

        @JsonProperty(value="console_id")
        public void setConsoleID(String consoleID) {
            this.consoleID = consoleID;
        }

        @JsonProperty(value="console_id")
        public String getConsoleID() {
            return this.consoleID;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="is_mine")
        public void setIsMine(String isMine) {
            this.isMine = isMine;
        }

        @JsonProperty(value="is_mine")
        public String getIsMine() {
            return this.isMine;
        }

        @JsonProperty(value="items")
        public void setItems(List<NotificationListItemModel> items) {
            this.items = items;
        }

        @JsonProperty(value="items")
        public List<NotificationListItemModel> getItems() {
            return this.items;
        }

        @JsonProperty(value="notification_list_id")
        public void setNotificationListID(String notificationListID) {
            this.notificationListID = notificationListID;
        }

        @JsonProperty(value="notification_list_id")
        public String getNotificationListID() {
            return this.notificationListID;
        }

        @JsonProperty(value="notification_list_name")
        public void setNotificationListName(String notificationListName) {
            this.notificationListName = notificationListName;
        }

        @JsonProperty(value="notification_list_name")
        public String getNotificationListName() {
            return this.notificationListName;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="shared")
        public void setShared(String shared) {
            this.shared = shared;
        }

        @JsonProperty(value="shared")
        public String getShared() {
            return this.shared;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @JsonProperty(value="visibility")
        public String getVisibility() {
            return this.visibility;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getItems() != null && this.getItems().size() > 0 && (i = 0) < this.getItems().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NotificationDataModel
    implements ParamValidate {
        private String alarmPolicy;
        private String prevStatus;
        private String rules;
        private String triggerStatus;
        private String userID;

        @JsonProperty(value="alarm_policy")
        public void setAlarmPolicy(String alarmPolicy) {
            this.alarmPolicy = alarmPolicy;
        }

        @JsonProperty(value="alarm_policy")
        public String getAlarmPolicy() {
            return this.alarmPolicy;
        }

        @JsonProperty(value="prev_status")
        public void setPrevStatus(String prevStatus) {
            this.prevStatus = prevStatus;
        }

        @JsonProperty(value="prev_status")
        public String getPrevStatus() {
            return this.prevStatus;
        }

        @JsonProperty(value="rules")
        public void setRules(String rules) {
            this.rules = rules;
        }

        @JsonProperty(value="rules")
        public String getRules() {
            return this.rules;
        }

        @JsonProperty(value="trigger_status")
        public void setTriggerStatus(String triggerStatus) {
            this.triggerStatus = triggerStatus;
        }

        @JsonProperty(value="trigger_status")
        public String getTriggerStatus() {
            return this.triggerStatus;
        }

        @JsonProperty(value="user_id")
        public void setUserID(String userID) {
            this.userID = userID;
        }

        @JsonProperty(value="user_id")
        public String getUserID() {
            return this.userID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NICVxNetModel
    implements ParamValidate {
        private String nICID;
        private String privateIP;
        private Integer role;
        private String vxNetID;
        private String vxNetName;
        private Integer vxNetType;

        @JsonProperty(value="nic_id")
        public void setNICID(String nICID) {
            this.nICID = nICID;
        }

        @JsonProperty(value="nic_id")
        public String getNICID() {
            return this.nICID;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="role")
        public void setRole(Integer role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public Integer getRole() {
            return this.role;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @JsonProperty(value="vxnet_name")
        public void setVxNetName(String vxNetName) {
            this.vxNetName = vxNetName;
        }

        @JsonProperty(value="vxnet_name")
        public String getVxNetName() {
            return this.vxNetName;
        }

        @JsonProperty(value="vxnet_type")
        public void setVxNetType(Integer vxNetType) {
            this.vxNetType = vxNetType;
        }

        @JsonProperty(value="vxnet_type")
        public Integer getVxNetType() {
            return this.vxNetType;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NICIPModel
    implements ParamValidate {
        private String nICID;
        private String privateIP;

        @JsonProperty(value="nic_id")
        public void setNICID(String nICID) {
            this.nICID = nICID;
        }

        @JsonProperty(value="nic_id")
        public String getNICID() {
            return this.nICID;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NICEIPModel
    implements ParamValidate {
        private Integer bandwidth;
        private String eIPAddr;
        private String eIPID;

        @JsonProperty(value="bandwidth")
        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        @JsonProperty(value="bandwidth")
        public Integer getBandwidth() {
            return this.bandwidth;
        }

        @JsonProperty(value="eip_addr")
        public void setEIPAddr(String eIPAddr) {
            this.eIPAddr = eIPAddr;
        }

        @JsonProperty(value="eip_addr")
        public String getEIPAddr() {
            return this.eIPAddr;
        }

        @JsonProperty(value="eip_id")
        public void setEIPID(String eIPID) {
            this.eIPID = eIPID;
        }

        @JsonProperty(value="eip_id")
        public String getEIPID() {
            return this.eIPID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NICModel
    implements ParamValidate {
        private String createTime;
        private NICEIPModel eIP;
        private String instanceID;
        private String nICID;
        private String nICName;
        private String owner;
        private String privateIP;
        private Integer role;
        private String rootUserID;
        private String securityGroup;
        private Integer sequence;
        private String status;
        private String statusTime;
        private List<TagModel> tags;
        private String vxNetID;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="eip")
        public void setEIP(NICEIPModel eIP) {
            this.eIP = eIP;
        }

        @JsonProperty(value="eip")
        public NICEIPModel getEIP() {
            return this.eIP;
        }

        @JsonProperty(value="instance_id")
        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        @JsonProperty(value="instance_id")
        public String getInstanceID() {
            return this.instanceID;
        }

        @JsonProperty(value="nic_id")
        public void setNICID(String nICID) {
            this.nICID = nICID;
        }

        @JsonProperty(value="nic_id")
        public String getNICID() {
            return this.nICID;
        }

        @JsonProperty(value="nic_name")
        public void setNICName(String nICName) {
            this.nICName = nICName;
        }

        @JsonProperty(value="nic_name")
        public String getNICName() {
            return this.nICName;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="role")
        public void setRole(Integer role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public Integer getRole() {
            return this.role;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="sequence")
        public void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="sequence")
        public Integer getSequence() {
            return this.sequence;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] statusValidValues = new String[]{"available", "in-use"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MongoPrivateIPModel
    implements ParamValidate {
        private String priority0;
        private String replica;

        @JsonProperty(value="priority0")
        public void setPriority0(String priority0) {
            this.priority0 = priority0;
        }

        @JsonProperty(value="priority0")
        public String getPriority0() {
            return this.priority0;
        }

        @JsonProperty(value="replica")
        public void setReplica(String replica) {
            this.replica = replica;
        }

        @JsonProperty(value="replica")
        public String getReplica() {
            return this.replica;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MongoParameterModel
    implements ParamValidate {
        private Integer isReadonly;
        private Integer isStatic;
        private String oPTName;
        private String parameterName;
        private String parameterType;
        private String parameterValue;
        private String resourceType;

        @JsonProperty(value="is_readonly")
        public void setIsReadonly(Integer isReadonly) {
            this.isReadonly = isReadonly;
        }

        @JsonProperty(value="is_readonly")
        public Integer getIsReadonly() {
            return this.isReadonly;
        }

        @JsonProperty(value="is_static")
        public void setIsStatic(Integer isStatic) {
            this.isStatic = isStatic;
        }

        @JsonProperty(value="is_static")
        public Integer getIsStatic() {
            return this.isStatic;
        }

        @JsonProperty(value="opt_name")
        public void setOPTName(String oPTName) {
            this.oPTName = oPTName;
        }

        @JsonProperty(value="opt_name")
        public String getOPTName() {
            return this.oPTName;
        }

        @JsonProperty(value="parameter_name")
        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @JsonProperty(value="parameter_name")
        public String getParameterName() {
            return this.parameterName;
        }

        @JsonProperty(value="parameter_type")
        public void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        @JsonProperty(value="parameter_type")
        public String getParameterType() {
            return this.parameterType;
        }

        @JsonProperty(value="parameter_value")
        public void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @JsonProperty(value="parameter_value")
        public String getParameterValue() {
            return this.parameterValue;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String validateParam() throws QCException {
            String[] isReadonlyValidValues = new String[]{"0", "1"};
            boolean isReadonlyIsValid = false;
            for (String v : isReadonlyValidValues) {
                Boolean isReadonlyIsRequired;
                if (v.equals(this.getIsReadonly() + "")) {
                    isReadonlyIsValid = true;
                }
                if (!(isReadonlyIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsReadonly() != null) continue;
                isReadonlyIsValid = true;
            }
            if (!isReadonlyIsValid) {
                throw new QCException("IsReadonly value " + this.getIsReadonly() + "is invalid");
            }
            String[] isStaticValidValues = new String[]{"0", "1"};
            boolean isStaticIsValid = false;
            for (String v : isStaticValidValues) {
                Boolean isStaticIsRequired;
                if (v.equals(this.getIsStatic() + "")) {
                    isStaticIsValid = true;
                }
                if (!(isStaticIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsStatic() != null) continue;
                isStaticIsValid = true;
            }
            if (!isStaticIsValid) {
                throw new QCException("IsStatic value " + this.getIsStatic() + "is invalid");
            }
            String[] parameterTypeValidValues = new String[]{"string", "int", "bool"};
            boolean parameterTypeIsValid = false;
            for (String v : parameterTypeValidValues) {
                Boolean parameterTypeIsRequired;
                if (v.equals(this.getParameterType())) {
                    parameterTypeIsValid = true;
                }
                if (!(parameterTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getParameterType() != null) continue;
                parameterTypeIsValid = true;
            }
            if (!parameterTypeIsValid) {
                throw new QCException("ParameterType value " + this.getParameterType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MongoNodeModel
    implements ParamValidate {
        private String iP;
        private String mongoID;
        private String mongoNodeID;
        private Integer primary;
        private String status;
        private String vxNetID;

        @JsonProperty(value="ip")
        public void setIP(String iP) {
            this.iP = iP;
        }

        @JsonProperty(value="ip")
        public String getIP() {
            return this.iP;
        }

        @JsonProperty(value="mongo_id")
        public void setMongoID(String mongoID) {
            this.mongoID = mongoID;
        }

        @JsonProperty(value="mongo_id")
        public String getMongoID() {
            return this.mongoID;
        }

        @JsonProperty(value="mongo_node_id")
        public void setMongoNodeID(String mongoNodeID) {
            this.mongoNodeID = mongoNodeID;
        }

        @JsonProperty(value="mongo_node_id")
        public String getMongoNodeID() {
            return this.mongoNodeID;
        }

        @JsonProperty(value="primary")
        public void setPrimary(Integer primary) {
            this.primary = primary;
        }

        @JsonProperty(value="primary")
        public Integer getPrimary() {
            return this.primary;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MongoModel
    implements ParamValidate {
        private String alarmStatus;
        private Integer autoBackupTime;
        private Integer autoMinorVerUpgrade;
        private String createTime;
        private String description;
        private String latestSnapshotTime;
        private String mongoID;
        private String mongoName;
        private Integer mongoType;
        private String mongoVersion;
        private String status;
        private String statusTime;
        private Integer storageSize;
        private List<TagModel> tags;
        private String transitionStatus;
        private VxNetModel vxNet;

        @JsonProperty(value="alarm_status")
        public void setAlarmStatus(String alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        @JsonProperty(value="alarm_status")
        public String getAlarmStatus() {
            return this.alarmStatus;
        }

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="auto_minor_ver_upgrade")
        public void setAutoMinorVerUpgrade(Integer autoMinorVerUpgrade) {
            this.autoMinorVerUpgrade = autoMinorVerUpgrade;
        }

        @JsonProperty(value="auto_minor_ver_upgrade")
        public Integer getAutoMinorVerUpgrade() {
            return this.autoMinorVerUpgrade;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public void setLatestSnapshotTime(String latestSnapshotTime) {
            this.latestSnapshotTime = latestSnapshotTime;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public String getLatestSnapshotTime() {
            return this.latestSnapshotTime;
        }

        @JsonProperty(value="mongo_id")
        public void setMongoID(String mongoID) {
            this.mongoID = mongoID;
        }

        @JsonProperty(value="mongo_id")
        public String getMongoID() {
            return this.mongoID;
        }

        @JsonProperty(value="mongo_name")
        public void setMongoName(String mongoName) {
            this.mongoName = mongoName;
        }

        @JsonProperty(value="mongo_name")
        public String getMongoName() {
            return this.mongoName;
        }

        @JsonProperty(value="mongo_type")
        public void setMongoType(Integer mongoType) {
            this.mongoType = mongoType;
        }

        @JsonProperty(value="mongo_type")
        public Integer getMongoType() {
            return this.mongoType;
        }

        @JsonProperty(value="mongo_version")
        public void setMongoVersion(String mongoVersion) {
            this.mongoVersion = mongoVersion;
        }

        @JsonProperty(value="mongo_version")
        public String getMongoVersion() {
            return this.mongoVersion;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(VxNetModel vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public VxNetModel getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] alarmStatusValidValues = new String[]{"ok", "alarm", "insufficient"};
            boolean alarmStatusIsValid = false;
            for (String v : alarmStatusValidValues) {
                Boolean alarmStatusIsRequired;
                if (v.equals(this.getAlarmStatus())) {
                    alarmStatusIsValid = true;
                }
                if (!(alarmStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getAlarmStatus() != null) continue;
                alarmStatusIsValid = true;
            }
            if (!alarmStatusIsValid) {
                throw new QCException("AlarmStatus value " + this.getAlarmStatus() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "active", "stopped", "deleted", "suspended", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "stopping", "starting", "deleting", "resizing", "suspending", "vxnet-changing", "snapshot-creating", "instances-adding", "instances-removing", "pg-applying"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MeterModel
    implements ParamValidate {
        private List<Object> data;
        private String meterID;
        private Integer sequence;
        private String vxNetID;

        @JsonProperty(value="data")
        public void setData(List<Object> data) {
            this.data = data;
        }

        @JsonProperty(value="data")
        public List<Object> getData() {
            return this.data;
        }

        @JsonProperty(value="meter_id")
        public void setMeterID(String meterID) {
            this.meterID = meterID;
        }

        @JsonProperty(value="meter_id")
        public String getMeterID() {
            return this.meterID;
        }

        @JsonProperty(value="sequence")
        public void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="sequence")
        public Integer getSequence() {
            return this.sequence;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @Override
        public String validateParam() throws QCException {
            if (this.getData() != null && this.getData().size() > 0) {
                for (int i = 0; i < this.getData().size(); ++i) {
                    String string = (String)this.getData().get(i);
                }
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoadBalancerPolicyRuleModel
    implements ParamValidate {
        private String loadBalancerPolicyRuleID;
        private String loadBalancerPolicyRuleName;
        private String ruleType;
        private String val;

        @JsonProperty(value="loadbalancer_policy_rule_id")
        public void setLoadBalancerPolicyRuleID(String loadBalancerPolicyRuleID) {
            this.loadBalancerPolicyRuleID = loadBalancerPolicyRuleID;
        }

        @JsonProperty(value="loadbalancer_policy_rule_id")
        public String getLoadBalancerPolicyRuleID() {
            return this.loadBalancerPolicyRuleID;
        }

        @JsonProperty(value="loadbalancer_policy_rule_name")
        public void setLoadBalancerPolicyRuleName(String loadBalancerPolicyRuleName) {
            this.loadBalancerPolicyRuleName = loadBalancerPolicyRuleName;
        }

        @JsonProperty(value="loadbalancer_policy_rule_name")
        public String getLoadBalancerPolicyRuleName() {
            return this.loadBalancerPolicyRuleName;
        }

        @JsonProperty(value="rule_type")
        public void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @JsonProperty(value="rule_type")
        public String getRuleType() {
            return this.ruleType;
        }

        @JsonProperty(value="val")
        public void setVal(String val) {
            this.val = val;
        }

        @JsonProperty(value="val")
        public String getVal() {
            return this.val;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoadBalancerPolicyModel
    implements ParamValidate {
        private String createTime;
        private Integer isApplied;
        private List<String> loadBalancerIDs;
        private String loadBalancerPolicyID;
        private String loadBalancerPolicyName;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="is_applied")
        public void setIsApplied(Integer isApplied) {
            this.isApplied = isApplied;
        }

        @JsonProperty(value="is_applied")
        public Integer getIsApplied() {
            return this.isApplied;
        }

        @JsonProperty(value="loadbalancer_ids")
        public void setLoadBalancerIDs(List<String> loadBalancerIDs) {
            this.loadBalancerIDs = loadBalancerIDs;
        }

        @JsonProperty(value="loadbalancer_ids")
        public List<String> getLoadBalancerIDs() {
            return this.loadBalancerIDs;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public void setLoadBalancerPolicyID(String loadBalancerPolicyID) {
            this.loadBalancerPolicyID = loadBalancerPolicyID;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public String getLoadBalancerPolicyID() {
            return this.loadBalancerPolicyID;
        }

        @JsonProperty(value="loadbalancer_policy_name")
        public void setLoadBalancerPolicyName(String loadBalancerPolicyName) {
            this.loadBalancerPolicyName = loadBalancerPolicyName;
        }

        @JsonProperty(value="loadbalancer_policy_name")
        public String getLoadBalancerPolicyName() {
            return this.loadBalancerPolicyName;
        }

        @Override
        public String validateParam() throws QCException {
            String[] isAppliedValidValues = new String[]{"0", "1"};
            boolean isAppliedIsValid = false;
            for (String v : isAppliedValidValues) {
                Boolean isAppliedIsRequired;
                if (v.equals(this.getIsApplied() + "")) {
                    isAppliedIsValid = true;
                }
                if (!(isAppliedIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsApplied() != null) continue;
                isAppliedIsValid = true;
            }
            if (!isAppliedIsValid) {
                throw new QCException("IsApplied value " + this.getIsApplied() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoadBalancerListenerModel
    implements ParamValidate {
        private String backendProtocol;
        private List<LoadBalancerBackendModel> backends;
        private String balanceMode;
        private String createTime;
        private Integer forwardfor;
        private String healthyCheckMethod;
        private String healthyCheckOption;
        private Integer listenerOption;
        private Integer listenerPort;
        private String listenerProtocol;
        private String loadBalancerID;
        private String loadBalancerListenerID;
        private String loadBalancerListenerName;
        private List<String> serverCertificateID;
        private String sessionSticky;
        private Integer timeout;

        @JsonProperty(value="backend_protocol")
        public void setBackendProtocol(String backendProtocol) {
            this.backendProtocol = backendProtocol;
        }

        @JsonProperty(value="backend_protocol")
        public String getBackendProtocol() {
            return this.backendProtocol;
        }

        @JsonProperty(value="backends")
        public void setBackends(List<LoadBalancerBackendModel> backends) {
            this.backends = backends;
        }

        @JsonProperty(value="backends")
        public List<LoadBalancerBackendModel> getBackends() {
            return this.backends;
        }

        @JsonProperty(value="balance_mode")
        public void setBalanceMode(String balanceMode) {
            this.balanceMode = balanceMode;
        }

        @JsonProperty(value="balance_mode")
        public String getBalanceMode() {
            return this.balanceMode;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="forwardfor")
        public void setForwardfor(Integer forwardfor) {
            this.forwardfor = forwardfor;
        }

        @JsonProperty(value="forwardfor")
        public Integer getForwardfor() {
            return this.forwardfor;
        }

        @JsonProperty(value="healthy_check_method")
        public void setHealthyCheckMethod(String healthyCheckMethod) {
            this.healthyCheckMethod = healthyCheckMethod;
        }

        @JsonProperty(value="healthy_check_method")
        public String getHealthyCheckMethod() {
            return this.healthyCheckMethod;
        }

        @JsonProperty(value="healthy_check_option")
        public void setHealthyCheckOption(String healthyCheckOption) {
            this.healthyCheckOption = healthyCheckOption;
        }

        @JsonProperty(value="healthy_check_option")
        public String getHealthyCheckOption() {
            return this.healthyCheckOption;
        }

        @JsonProperty(value="listener_option")
        public void setListenerOption(Integer listenerOption) {
            this.listenerOption = listenerOption;
        }

        @JsonProperty(value="listener_option")
        public Integer getListenerOption() {
            return this.listenerOption;
        }

        @JsonProperty(value="listener_port")
        public void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @JsonProperty(value="listener_port")
        public Integer getListenerPort() {
            return this.listenerPort;
        }

        @JsonProperty(value="listener_protocol")
        public void setListenerProtocol(String listenerProtocol) {
            this.listenerProtocol = listenerProtocol;
        }

        @JsonProperty(value="listener_protocol")
        public String getListenerProtocol() {
            return this.listenerProtocol;
        }

        @JsonProperty(value="loadbalancer_id")
        public void setLoadBalancerID(String loadBalancerID) {
            this.loadBalancerID = loadBalancerID;
        }

        @JsonProperty(value="loadbalancer_id")
        public String getLoadBalancerID() {
            return this.loadBalancerID;
        }

        @JsonProperty(value="loadbalancer_listener_id")
        public void setLoadBalancerListenerID(String loadBalancerListenerID) {
            this.loadBalancerListenerID = loadBalancerListenerID;
        }

        @JsonProperty(value="loadbalancer_listener_id")
        public String getLoadBalancerListenerID() {
            return this.loadBalancerListenerID;
        }

        @JsonProperty(value="loadbalancer_listener_name")
        public void setLoadBalancerListenerName(String loadBalancerListenerName) {
            this.loadBalancerListenerName = loadBalancerListenerName;
        }

        @JsonProperty(value="loadbalancer_listener_name")
        public String getLoadBalancerListenerName() {
            return this.loadBalancerListenerName;
        }

        @JsonProperty(value="server_certificate_id")
        public void setServerCertificateID(List<String> serverCertificateID) {
            this.serverCertificateID = serverCertificateID;
        }

        @JsonProperty(value="server_certificate_id")
        public List<String> getServerCertificateID() {
            return this.serverCertificateID;
        }

        @JsonProperty(value="session_sticky")
        public void setSessionSticky(String sessionSticky) {
            this.sessionSticky = sessionSticky;
        }

        @JsonProperty(value="session_sticky")
        public String getSessionSticky() {
            return this.sessionSticky;
        }

        @JsonProperty(value="timeout")
        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @JsonProperty(value="timeout")
        public Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getBackends() != null && this.getBackends().size() > 0 && (i = 0) < this.getBackends().size()) {
                return null;
            }
            String[] balanceModeValidValues = new String[]{"roundrobin", "leastconn", "source"};
            boolean balanceModeIsValid = false;
            for (String v : balanceModeValidValues) {
                Boolean balanceModeIsRequired;
                if (v.equals(this.getBalanceMode())) {
                    balanceModeIsValid = true;
                }
                if (!(balanceModeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getBalanceMode() != null) continue;
                balanceModeIsValid = true;
            }
            if (!balanceModeIsValid) {
                throw new QCException("BalanceMode value " + this.getBalanceMode() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoadBalancerBackendModel
    implements ParamValidate {
        private String createTime;
        private String loadBalancerBackendID;
        private String loadBalancerBackendName;
        private String loadBalancerID;
        private String loadBalancerListenerID;
        private String loadBalancerPolicyID;
        private Integer port;
        private String resourceID;
        private String status;
        private Integer weight;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="loadbalancer_backend_id")
        public void setLoadBalancerBackendID(String loadBalancerBackendID) {
            this.loadBalancerBackendID = loadBalancerBackendID;
        }

        @JsonProperty(value="loadbalancer_backend_id")
        public String getLoadBalancerBackendID() {
            return this.loadBalancerBackendID;
        }

        @JsonProperty(value="loadbalancer_backend_name")
        public void setLoadBalancerBackendName(String loadBalancerBackendName) {
            this.loadBalancerBackendName = loadBalancerBackendName;
        }

        @JsonProperty(value="loadbalancer_backend_name")
        public String getLoadBalancerBackendName() {
            return this.loadBalancerBackendName;
        }

        @JsonProperty(value="loadbalancer_id")
        public void setLoadBalancerID(String loadBalancerID) {
            this.loadBalancerID = loadBalancerID;
        }

        @JsonProperty(value="loadbalancer_id")
        public String getLoadBalancerID() {
            return this.loadBalancerID;
        }

        @JsonProperty(value="loadbalancer_listener_id")
        public void setLoadBalancerListenerID(String loadBalancerListenerID) {
            this.loadBalancerListenerID = loadBalancerListenerID;
        }

        @JsonProperty(value="loadbalancer_listener_id")
        public String getLoadBalancerListenerID() {
            return this.loadBalancerListenerID;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public void setLoadBalancerPolicyID(String loadBalancerPolicyID) {
            this.loadBalancerPolicyID = loadBalancerPolicyID;
        }

        @JsonProperty(value="loadbalancer_policy_id")
        public String getLoadBalancerPolicyID() {
            return this.loadBalancerPolicyID;
        }

        @JsonProperty(value="port")
        public void setPort(Integer port) {
            this.port = port;
        }

        @JsonProperty(value="port")
        public Integer getPort() {
            return this.port;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="weight")
        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        @JsonProperty(value="weight")
        public Integer getWeight() {
            return this.weight;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoadBalancerModel
    implements ParamValidate {
        private List<EIPModel> cluster;
        private String createTime;
        private String description;
        private List<EIPModel> eIPs;
        private Integer isApplied;
        private List<LoadBalancerListenerModel> listeners;
        private String loadBalancerID;
        private String loadBalancerName;
        private Integer loadBalancerType;
        private Integer nodeCount;
        private List<String> privateIPs;
        private String securityGroupID;
        private String status;
        private String statusTime;
        private List<TagModel> tags;
        private String transitionStatus;
        private String vxNetID;

        @JsonProperty(value="cluster")
        public void setCluster(List<EIPModel> cluster) {
            this.cluster = cluster;
        }

        @JsonProperty(value="cluster")
        public List<EIPModel> getCluster() {
            return this.cluster;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="eips")
        public void setEIPs(List<EIPModel> eIPs) {
            this.eIPs = eIPs;
        }

        @JsonProperty(value="eips")
        public List<EIPModel> getEIPs() {
            return this.eIPs;
        }

        @JsonProperty(value="is_applied")
        public void setIsApplied(Integer isApplied) {
            this.isApplied = isApplied;
        }

        @JsonProperty(value="is_applied")
        public Integer getIsApplied() {
            return this.isApplied;
        }

        @JsonProperty(value="listeners")
        public void setListeners(List<LoadBalancerListenerModel> listeners) {
            this.listeners = listeners;
        }

        @JsonProperty(value="listeners")
        public List<LoadBalancerListenerModel> getListeners() {
            return this.listeners;
        }

        @JsonProperty(value="loadbalancer_id")
        public void setLoadBalancerID(String loadBalancerID) {
            this.loadBalancerID = loadBalancerID;
        }

        @JsonProperty(value="loadbalancer_id")
        public String getLoadBalancerID() {
            return this.loadBalancerID;
        }

        @JsonProperty(value="loadbalancer_name")
        public void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @JsonProperty(value="loadbalancer_name")
        public String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @JsonProperty(value="loadbalancer_type")
        public void setLoadBalancerType(Integer loadBalancerType) {
            this.loadBalancerType = loadBalancerType;
        }

        @JsonProperty(value="loadbalancer_type")
        public Integer getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(List<String> privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public List<String> getPrivateIPs() {
            return this.privateIPs;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            int i2;
            int i3;
            if (this.getCluster() != null && this.getCluster().size() > 0 && (i3 = 0) < this.getCluster().size()) {
                return null;
            }
            if (this.getEIPs() != null && this.getEIPs().size() > 0 && (i3 = 0) < this.getEIPs().size()) {
                return null;
            }
            String[] isAppliedValidValues = new String[]{"0", "1"};
            boolean isAppliedIsValid = false;
            for (String v : isAppliedValidValues) {
                Boolean isAppliedIsRequired;
                if (v.equals(this.getIsApplied() + "")) {
                    isAppliedIsValid = true;
                }
                if (!(isAppliedIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsApplied() != null) continue;
                isAppliedIsValid = true;
            }
            if (!isAppliedIsValid) {
                throw new QCException("IsApplied value " + this.getIsApplied() + "is invalid");
            }
            if (this.getListeners() != null && this.getListeners().size() > 0 && (i2 = 0) < this.getListeners().size()) {
                return null;
            }
            String[] loadBalancerTypeValidValues = new String[]{"0", "1", "2", "3", "4", "5"};
            boolean loadBalancerTypeIsValid = false;
            for (String v : loadBalancerTypeValidValues) {
                Boolean loadBalancerTypeIsRequired;
                if (v.equals(this.getLoadBalancerType() + "")) {
                    loadBalancerTypeIsValid = true;
                }
                if (!(loadBalancerTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getLoadBalancerType() != null) continue;
                loadBalancerTypeIsValid = true;
            }
            if (!loadBalancerTypeIsValid) {
                throw new QCException("LoadBalancerType value " + this.getLoadBalancerType() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "active", "stopped", "suspended", "deleted", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "starting", "stopping", "updating", "suspending", "resuming", "deleting"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KeyPairModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private String encryptMethod;
        private List<String> instanceIDs;
        private String keyPairID;
        private String keyPairName;
        private String owner;
        private String privKey;
        private String pubKey;
        private List<String> resourceIDs;
        private List<TagModel> tags;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="encrypt_method")
        public void setEncryptMethod(String encryptMethod) {
            this.encryptMethod = encryptMethod;
        }

        @JsonProperty(value="encrypt_method")
        public String getEncryptMethod() {
            return this.encryptMethod;
        }

        @JsonProperty(value="instance_ids")
        public void setInstanceIDs(List<String> instanceIDs) {
            this.instanceIDs = instanceIDs;
        }

        @JsonProperty(value="instance_ids")
        public List<String> getInstanceIDs() {
            return this.instanceIDs;
        }

        @JsonProperty(value="keypair_id")
        public void setKeyPairID(String keyPairID) {
            this.keyPairID = keyPairID;
        }

        @JsonProperty(value="keypair_id")
        public String getKeyPairID() {
            return this.keyPairID;
        }

        @JsonProperty(value="keypair_name")
        public void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @JsonProperty(value="keypair_name")
        public String getKeyPairName() {
            return this.keyPairName;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="priv_key")
        public void setPrivKey(String privKey) {
            this.privKey = privKey;
        }

        @JsonProperty(value="priv_key")
        public String getPrivKey() {
            return this.privKey;
        }

        @JsonProperty(value="pub_key")
        public void setPubKey(String pubKey) {
            this.pubKey = pubKey;
        }

        @JsonProperty(value="pub_key")
        public String getPubKey() {
            return this.pubKey;
        }

        @JsonProperty(value="resource_ids")
        public void setResourceIDs(List<String> resourceIDs) {
            this.resourceIDs = resourceIDs;
        }

        @JsonProperty(value="resource_ids")
        public List<String> getResourceIDs() {
            return this.resourceIDs;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] encryptMethodValidValues = new String[]{"ssh-rsa", "ssh-dss"};
            boolean encryptMethodIsValid = false;
            for (String v : encryptMethodValidValues) {
                Boolean encryptMethodIsRequired;
                if (v.equals(this.getEncryptMethod())) {
                    encryptMethodIsValid = true;
                }
                if (!(encryptMethodIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getEncryptMethod() != null) continue;
                encryptMethodIsValid = true;
            }
            if (!encryptMethodIsValid) {
                throw new QCException("EncryptMethod value " + this.getEncryptMethod() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JobModel
    implements ParamValidate {
        private String createTime;
        private String directive;
        private String jobAction;
        private String jobID;
        private String owner;
        private String resourceIDs;
        private String status;
        private String statusTime;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="directive")
        public void setDirective(String directive) {
            this.directive = directive;
        }

        @JsonProperty(value="directive")
        public String getDirective() {
            return this.directive;
        }

        @JsonProperty(value="job_action")
        public void setJobAction(String jobAction) {
            this.jobAction = jobAction;
        }

        @JsonProperty(value="job_action")
        public String getJobAction() {
            return this.jobAction;
        }

        @JsonProperty(value="job_id")
        public void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @JsonProperty(value="job_id")
        public String getJobID() {
            return this.jobID;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="resource_ids")
        public void setResourceIDs(String resourceIDs) {
            this.resourceIDs = resourceIDs;
        }

        @JsonProperty(value="resource_ids")
        public String getResourceIDs() {
            return this.resourceIDs;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @Override
        public String validateParam() throws QCException {
            String[] statusValidValues = new String[]{"pending", "working", "failed", "successful", "done with failure"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InstanceVxNetModel
    implements ParamValidate {
        private String nICID;
        private String privateIP;
        private Integer role;
        private String vxNetID;
        private String vxNetName;
        private Integer vxNetType;

        @JsonProperty(value="nic_id")
        public void setNICID(String nICID) {
            this.nICID = nICID;
        }

        @JsonProperty(value="nic_id")
        public String getNICID() {
            return this.nICID;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="role")
        public void setRole(Integer role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public Integer getRole() {
            return this.role;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @JsonProperty(value="vxnet_name")
        public void setVxNetName(String vxNetName) {
            this.vxNetName = vxNetName;
        }

        @JsonProperty(value="vxnet_name")
        public String getVxNetName() {
            return this.vxNetName;
        }

        @JsonProperty(value="vxnet_type")
        public void setVxNetType(Integer vxNetType) {
            this.vxNetType = vxNetType;
        }

        @JsonProperty(value="vxnet_type")
        public Integer getVxNetType() {
            return this.vxNetType;
        }

        @Override
        public String validateParam() throws QCException {
            String[] vxNetTypeValidValues = new String[]{"0", "1"};
            boolean vxNetTypeIsValid = false;
            for (String v : vxNetTypeValidValues) {
                Boolean vxNetTypeIsRequired;
                if (v.equals(this.getVxNetType() + "")) {
                    vxNetTypeIsValid = true;
                }
                if (!(vxNetTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVxNetType() != null) continue;
                vxNetTypeIsValid = true;
            }
            if (!vxNetTypeIsValid) {
                throw new QCException("VxNetType value " + this.getVxNetType() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InstanceTypeModel
    implements ParamValidate {
        private String description;
        private String instanceTypeID;
        private String instanceTypeName;
        private Integer memoryCurrent;
        private String status;
        private Integer vCPUsCurrent;
        private String zoneID;

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="instance_type_id")
        public void setInstanceTypeID(String instanceTypeID) {
            this.instanceTypeID = instanceTypeID;
        }

        @JsonProperty(value="instance_type_id")
        public String getInstanceTypeID() {
            return this.instanceTypeID;
        }

        @JsonProperty(value="instance_type_name")
        public void setInstanceTypeName(String instanceTypeName) {
            this.instanceTypeName = instanceTypeName;
        }

        @JsonProperty(value="instance_type_name")
        public String getInstanceTypeName() {
            return this.instanceTypeName;
        }

        @JsonProperty(value="memory_current")
        public void setMemoryCurrent(Integer memoryCurrent) {
            this.memoryCurrent = memoryCurrent;
        }

        @JsonProperty(value="memory_current")
        public Integer getMemoryCurrent() {
            return this.memoryCurrent;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="vcpus_current")
        public void setVCPUsCurrent(Integer vCPUsCurrent) {
            this.vCPUsCurrent = vCPUsCurrent;
        }

        @JsonProperty(value="vcpus_current")
        public Integer getVCPUsCurrent() {
            return this.vCPUsCurrent;
        }

        @JsonProperty(value="zone_id")
        public void setZoneID(String zoneID) {
            this.zoneID = zoneID;
        }

        @JsonProperty(value="zone_id")
        public String getZoneID() {
            return this.zoneID;
        }

        @Override
        public String validateParam() throws QCException {
            String[] statusValidValues = new String[]{"available", "deprecated"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InstanceModel
    implements ParamValidate {
        private String alarmStatus;
        private String cPUTopology;
        private String createTime;
        private String description;
        private String device;
        private List<DNSAliasModel> dNSAliases;
        private EIPModel eIP;
        private ExtraModel extra;
        private String graphicsPasswd;
        private String graphicsProtocol;
        private ImageModel image;
        private Integer instanceClass;
        private String instanceID;
        private String instanceName;
        private String instanceType;
        private List<String> keyPairIDs;
        private Integer memoryCurrent;
        private String repl;
        private SecurityGroupModel securityGroup;
        private String status;
        private String statusTime;
        private Integer subCode;
        private List<TagModel> tags;
        private String transitionStatus;
        private Integer vCPUsCurrent;
        private List<String> volumeIDs;
        private List<VolumeModel> volumes;
        private List<NICVxNetModel> vxNets;
        private String zoneID;

        @JsonProperty(value="alarm_status")
        public void setAlarmStatus(String alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        @JsonProperty(value="alarm_status")
        public String getAlarmStatus() {
            return this.alarmStatus;
        }

        @JsonProperty(value="cpu_topology")
        public void setCPUTopology(String cPUTopology) {
            this.cPUTopology = cPUTopology;
        }

        @JsonProperty(value="cpu_topology")
        public String getCPUTopology() {
            return this.cPUTopology;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="device")
        public void setDevice(String device) {
            this.device = device;
        }

        @JsonProperty(value="device")
        public String getDevice() {
            return this.device;
        }

        @JsonProperty(value="dns_aliases")
        public void setDNSAliases(List<DNSAliasModel> dNSAliases) {
            this.dNSAliases = dNSAliases;
        }

        @JsonProperty(value="dns_aliases")
        public List<DNSAliasModel> getDNSAliases() {
            return this.dNSAliases;
        }

        @JsonProperty(value="eip")
        public void setEIP(EIPModel eIP) {
            this.eIP = eIP;
        }

        @JsonProperty(value="eip")
        public EIPModel getEIP() {
            return this.eIP;
        }

        @JsonProperty(value="extra")
        public void setExtra(ExtraModel extra) {
            this.extra = extra;
        }

        @JsonProperty(value="extra")
        public ExtraModel getExtra() {
            return this.extra;
        }

        @JsonProperty(value="graphics_passwd")
        public void setGraphicsPasswd(String graphicsPasswd) {
            this.graphicsPasswd = graphicsPasswd;
        }

        @JsonProperty(value="graphics_passwd")
        public String getGraphicsPasswd() {
            return this.graphicsPasswd;
        }

        @JsonProperty(value="graphics_protocol")
        public void setGraphicsProtocol(String graphicsProtocol) {
            this.graphicsProtocol = graphicsProtocol;
        }

        @JsonProperty(value="graphics_protocol")
        public String getGraphicsProtocol() {
            return this.graphicsProtocol;
        }

        @JsonProperty(value="image")
        public void setImage(ImageModel image) {
            this.image = image;
        }

        @JsonProperty(value="image")
        public ImageModel getImage() {
            return this.image;
        }

        @JsonProperty(value="instance_class")
        public void setInstanceClass(Integer instanceClass) {
            this.instanceClass = instanceClass;
        }

        @JsonProperty(value="instance_class")
        public Integer getInstanceClass() {
            return this.instanceClass;
        }

        @JsonProperty(value="instance_id")
        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        @JsonProperty(value="instance_id")
        public String getInstanceID() {
            return this.instanceID;
        }

        @JsonProperty(value="instance_name")
        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @JsonProperty(value="instance_name")
        public String getInstanceName() {
            return this.instanceName;
        }

        @JsonProperty(value="instance_type")
        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @JsonProperty(value="instance_type")
        public String getInstanceType() {
            return this.instanceType;
        }

        @JsonProperty(value="keypair_ids")
        public void setKeyPairIDs(List<String> keyPairIDs) {
            this.keyPairIDs = keyPairIDs;
        }

        @JsonProperty(value="keypair_ids")
        public List<String> getKeyPairIDs() {
            return this.keyPairIDs;
        }

        @JsonProperty(value="memory_current")
        public void setMemoryCurrent(Integer memoryCurrent) {
            this.memoryCurrent = memoryCurrent;
        }

        @JsonProperty(value="memory_current")
        public Integer getMemoryCurrent() {
            return this.memoryCurrent;
        }

        @JsonProperty(value="repl")
        public void setRepl(String repl) {
            this.repl = repl;
        }

        @JsonProperty(value="repl")
        public String getRepl() {
            return this.repl;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(SecurityGroupModel securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public SecurityGroupModel getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_code")
        public void setSubCode(Integer subCode) {
            this.subCode = subCode;
        }

        @JsonProperty(value="sub_code")
        public Integer getSubCode() {
            return this.subCode;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="vcpus_current")
        public void setVCPUsCurrent(Integer vCPUsCurrent) {
            this.vCPUsCurrent = vCPUsCurrent;
        }

        @JsonProperty(value="vcpus_current")
        public Integer getVCPUsCurrent() {
            return this.vCPUsCurrent;
        }

        @JsonProperty(value="volume_ids")
        public void setVolumeIDs(List<String> volumeIDs) {
            this.volumeIDs = volumeIDs;
        }

        @JsonProperty(value="volume_ids")
        public List<String> getVolumeIDs() {
            return this.volumeIDs;
        }

        @JsonProperty(value="volumes")
        public void setVolumes(List<VolumeModel> volumes) {
            this.volumes = volumes;
        }

        @JsonProperty(value="volumes")
        public List<VolumeModel> getVolumes() {
            return this.volumes;
        }

        @JsonProperty(value="vxnets")
        public void setVxNets(List<NICVxNetModel> vxNets) {
            this.vxNets = vxNets;
        }

        @JsonProperty(value="vxnets")
        public List<NICVxNetModel> getVxNets() {
            return this.vxNets;
        }

        @JsonProperty(value="zone_id")
        public void setZoneID(String zoneID) {
            this.zoneID = zoneID;
        }

        @JsonProperty(value="zone_id")
        public String getZoneID() {
            return this.zoneID;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            int i2;
            int i3;
            if (this.getDNSAliases() != null && this.getDNSAliases().size() > 0 && (i3 = 0) < this.getDNSAliases().size()) {
                return null;
            }
            String[] statusValidValues = new String[]{"pending", "running", "stopped", "suspended", "terminated", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i2 = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "starting", "stopping", "restarting", "suspending", "resuming", "terminating", "recovering", "resetting"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            if (this.getVolumes() != null && this.getVolumes().size() > 0 && (i = 0) < this.getVolumes().size()) {
                return null;
            }
            if (this.getVxNets() != null && this.getVxNets().size() > 0 && (i = 0) < this.getVxNets().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImageUserModel
    implements ParamValidate {
        private String createTime;
        private String imageID;
        private UserModel user;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="user")
        public void setUser(UserModel user) {
            this.user = user;
        }

        @JsonProperty(value="user")
        public UserModel getUser() {
            return this.user;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImageModel
    implements ParamValidate {
        private String appBillingID;
        private String architecture;
        private String billingID;
        private String createTime;
        private String defaultPasswd;
        private String defaultUser;
        private String description;
        private Integer fResetpwd;
        private Integer feature;
        private Integer features;
        private String hypervisor;
        private String imageID;
        private String imageName;
        private List<String> instanceIDs;
        private String oSFamily;
        private String owner;
        private String platform;
        private String processorType;
        private String provider;
        private String recommendedType;
        private String rootID;
        private Integer size;
        private String status;
        private String statusTime;
        private Integer subCode;
        private String transitionStatus;
        private String uIType;
        private String visibility;

        @JsonProperty(value="app_billing_id")
        public void setAppBillingID(String appBillingID) {
            this.appBillingID = appBillingID;
        }

        @JsonProperty(value="app_billing_id")
        public String getAppBillingID() {
            return this.appBillingID;
        }

        @JsonProperty(value="architecture")
        public void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @JsonProperty(value="architecture")
        public String getArchitecture() {
            return this.architecture;
        }

        @JsonProperty(value="billing_id")
        public void setBillingID(String billingID) {
            this.billingID = billingID;
        }

        @JsonProperty(value="billing_id")
        public String getBillingID() {
            return this.billingID;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="default_passwd")
        public void setDefaultPasswd(String defaultPasswd) {
            this.defaultPasswd = defaultPasswd;
        }

        @JsonProperty(value="default_passwd")
        public String getDefaultPasswd() {
            return this.defaultPasswd;
        }

        @JsonProperty(value="default_user")
        public void setDefaultUser(String defaultUser) {
            this.defaultUser = defaultUser;
        }

        @JsonProperty(value="default_user")
        public String getDefaultUser() {
            return this.defaultUser;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="f_resetpwd")
        public void setFResetpwd(Integer fResetpwd) {
            this.fResetpwd = fResetpwd;
        }

        @JsonProperty(value="f_resetpwd")
        public Integer getFResetpwd() {
            return this.fResetpwd;
        }

        @JsonProperty(value="feature")
        public void setFeature(Integer feature) {
            this.feature = feature;
        }

        @JsonProperty(value="feature")
        public Integer getFeature() {
            return this.feature;
        }

        @JsonProperty(value="features")
        public void setFeatures(Integer features) {
            this.features = features;
        }

        @JsonProperty(value="features")
        public Integer getFeatures() {
            return this.features;
        }

        @JsonProperty(value="hypervisor")
        public void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @JsonProperty(value="hypervisor")
        public String getHypervisor() {
            return this.hypervisor;
        }

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="image_name")
        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @JsonProperty(value="image_name")
        public String getImageName() {
            return this.imageName;
        }

        @JsonProperty(value="instance_ids")
        public void setInstanceIDs(List<String> instanceIDs) {
            this.instanceIDs = instanceIDs;
        }

        @JsonProperty(value="instance_ids")
        public List<String> getInstanceIDs() {
            return this.instanceIDs;
        }

        @JsonProperty(value="os_family")
        public void setOSFamily(String oSFamily) {
            this.oSFamily = oSFamily;
        }

        @JsonProperty(value="os_family")
        public String getOSFamily() {
            return this.oSFamily;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="platform")
        public void setPlatform(String platform) {
            this.platform = platform;
        }

        @JsonProperty(value="platform")
        public String getPlatform() {
            return this.platform;
        }

        @JsonProperty(value="processor_type")
        public void setProcessorType(String processorType) {
            this.processorType = processorType;
        }

        @JsonProperty(value="processor_type")
        public String getProcessorType() {
            return this.processorType;
        }

        @JsonProperty(value="provider")
        public void setProvider(String provider) {
            this.provider = provider;
        }

        @JsonProperty(value="provider")
        public String getProvider() {
            return this.provider;
        }

        @JsonProperty(value="recommended_type")
        public void setRecommendedType(String recommendedType) {
            this.recommendedType = recommendedType;
        }

        @JsonProperty(value="recommended_type")
        public String getRecommendedType() {
            return this.recommendedType;
        }

        @JsonProperty(value="root_id")
        public void setRootID(String rootID) {
            this.rootID = rootID;
        }

        @JsonProperty(value="root_id")
        public String getRootID() {
            return this.rootID;
        }

        @JsonProperty(value="size")
        public void setSize(Integer size) {
            this.size = size;
        }

        @JsonProperty(value="size")
        public Integer getSize() {
            return this.size;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_code")
        public void setSubCode(Integer subCode) {
            this.subCode = subCode;
        }

        @JsonProperty(value="sub_code")
        public Integer getSubCode() {
            return this.subCode;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="ui_type")
        public void setUIType(String uIType) {
            this.uIType = uIType;
        }

        @JsonProperty(value="ui_type")
        public String getUIType() {
            return this.uIType;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @JsonProperty(value="visibility")
        public String getVisibility() {
            return this.visibility;
        }

        @Override
        public String validateParam() throws QCException {
            String[] platformValidValues = new String[]{"linux", "windows"};
            boolean platformIsValid = false;
            for (String v : platformValidValues) {
                Boolean platformIsRequired;
                if (v.equals(this.getPlatform())) {
                    platformIsValid = true;
                }
                if (!(platformIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getPlatform() != null) continue;
                platformIsValid = true;
            }
            if (!platformIsValid) {
                throw new QCException("Platform value " + this.getPlatform() + "is invalid");
            }
            String[] processorTypeValidValues = new String[]{"64bit", "32bit"};
            boolean processorTypeIsValid = false;
            for (String v : processorTypeValidValues) {
                Boolean processorTypeIsRequired;
                if (v.equals(this.getProcessorType())) {
                    processorTypeIsValid = true;
                }
                if (!(processorTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getProcessorType() != null) continue;
                processorTypeIsValid = true;
            }
            if (!processorTypeIsValid) {
                throw new QCException("ProcessorType value " + this.getProcessorType() + "is invalid");
            }
            String[] providerValidValues = new String[]{"system", "self"};
            boolean providerIsValid = false;
            for (String v : providerValidValues) {
                Boolean providerIsRequired;
                if (v.equals(this.getProvider())) {
                    providerIsValid = true;
                }
                if (!(providerIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getProvider() != null) continue;
                providerIsValid = true;
            }
            if (!providerIsValid) {
                throw new QCException("Provider value " + this.getProvider() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "available", "deprecated", "suspended", "deleted", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            String[] transitionStatusValidValues = new String[]{"creating", "suspending", "resuming", "deleting", "recovering"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            String[] visibilityValidValues = new String[]{"public", "private"};
            boolean visibilityIsValid = false;
            for (String v : visibilityValidValues) {
                Boolean visibilityIsRequired;
                if (v.equals(this.getVisibility())) {
                    visibilityIsValid = true;
                }
                if (!(visibilityIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getVisibility() != null) continue;
                visibilityIsValid = true;
            }
            if (!visibilityIsValid) {
                throw new QCException("Visibility value " + this.getVisibility() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FileModel
    implements ParamValidate {
        private String file;
        private String lastModify;
        private Integer size;

        @JsonProperty(value="file")
        public void setFile(String file) {
            this.file = file;
        }

        @JsonProperty(value="file")
        public String getFile() {
            return this.file;
        }

        @JsonProperty(value="last_modify")
        public void setLastModify(String lastModify) {
            this.lastModify = lastModify;
        }

        @JsonProperty(value="last_modify")
        public String getLastModify() {
            return this.lastModify;
        }

        @JsonProperty(value="size")
        public void setSize(Integer size) {
            this.size = size;
        }

        @JsonProperty(value="size")
        public Integer getSize() {
            return this.size;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ExtraModel
    implements ParamValidate {
        private String blockBus;
        private String bootDev;
        private Integer cPUMax;
        private String cPUModel;
        private Integer features;
        private String hypervisor;
        private Integer memMax;
        private Integer nICMqueue;
        private Integer noLimit;
        private Integer noRestrict;
        private Integer oSDiskSize;
        private Integer uSB;

        @JsonProperty(value="block_bus")
        public void setBlockBus(String blockBus) {
            this.blockBus = blockBus;
        }

        @JsonProperty(value="block_bus")
        public String getBlockBus() {
            return this.blockBus;
        }

        @JsonProperty(value="boot_dev")
        public void setBootDev(String bootDev) {
            this.bootDev = bootDev;
        }

        @JsonProperty(value="boot_dev")
        public String getBootDev() {
            return this.bootDev;
        }

        @JsonProperty(value="cpu_max")
        public void setCPUMax(Integer cPUMax) {
            this.cPUMax = cPUMax;
        }

        @JsonProperty(value="cpu_max")
        public Integer getCPUMax() {
            return this.cPUMax;
        }

        @JsonProperty(value="cpu_model")
        public void setCPUModel(String cPUModel) {
            this.cPUModel = cPUModel;
        }

        @JsonProperty(value="cpu_model")
        public String getCPUModel() {
            return this.cPUModel;
        }

        @JsonProperty(value="features")
        public void setFeatures(Integer features) {
            this.features = features;
        }

        @JsonProperty(value="features")
        public Integer getFeatures() {
            return this.features;
        }

        @JsonProperty(value="hypervisor")
        public void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @JsonProperty(value="hypervisor")
        public String getHypervisor() {
            return this.hypervisor;
        }

        @JsonProperty(value="mem_max")
        public void setMemMax(Integer memMax) {
            this.memMax = memMax;
        }

        @JsonProperty(value="mem_max")
        public Integer getMemMax() {
            return this.memMax;
        }

        @JsonProperty(value="nic_mqueue")
        public void setNICMqueue(Integer nICMqueue) {
            this.nICMqueue = nICMqueue;
        }

        @JsonProperty(value="nic_mqueue")
        public Integer getNICMqueue() {
            return this.nICMqueue;
        }

        @JsonProperty(value="no_limit")
        public void setNoLimit(Integer noLimit) {
            this.noLimit = noLimit;
        }

        @JsonProperty(value="no_limit")
        public Integer getNoLimit() {
            return this.noLimit;
        }

        @JsonProperty(value="no_restrict")
        public void setNoRestrict(Integer noRestrict) {
            this.noRestrict = noRestrict;
        }

        @JsonProperty(value="no_restrict")
        public Integer getNoRestrict() {
            return this.noRestrict;
        }

        @JsonProperty(value="os_disk_size")
        public void setOSDiskSize(Integer oSDiskSize) {
            this.oSDiskSize = oSDiskSize;
        }

        @JsonProperty(value="os_disk_size")
        public Integer getOSDiskSize() {
            return this.oSDiskSize;
        }

        @JsonProperty(value="usb")
        public void setUSB(Integer uSB) {
            this.uSB = uSB;
        }

        @JsonProperty(value="usb")
        public Integer getUSB() {
            return this.uSB;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EIPResourceModel
    implements ParamValidate {
        private String resourceID;
        private String resourceName;
        private String resourceType;

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="resource_name")
        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @JsonProperty(value="resource_name")
        public String getResourceName() {
            return this.resourceName;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EIPGroupModel
    implements ParamValidate {
        private String eIPGroupID;
        private String eIPGroupName;

        @JsonProperty(value="eip_group_id")
        public void setEIPGroupID(String eIPGroupID) {
            this.eIPGroupID = eIPGroupID;
        }

        @JsonProperty(value="eip_group_id")
        public String getEIPGroupID() {
            return this.eIPGroupID;
        }

        @JsonProperty(value="eip_group_name")
        public void setEIPGroupName(String eIPGroupName) {
            this.eIPGroupName = eIPGroupName;
        }

        @JsonProperty(value="eip_group_name")
        public String getEIPGroupName() {
            return this.eIPGroupName;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EIPModel
    implements ParamValidate {
        private String alarmStatus;
        private Integer associateMode;
        private Integer bandwidth;
        private String billingMode;
        private String createTime;
        private String description;
        private String eIPAddr;
        private EIPGroupModel eIPGroup;
        private String eIPID;
        private String eIPName;
        private String iCPCodes;
        private Integer needICP;
        private EIPResourceModel resource;
        private String status;
        private String statusTime;
        private Integer subCode;
        private List<TagModel> tags;
        private String transitionStatus;

        @JsonProperty(value="alarm_status")
        public void setAlarmStatus(String alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        @JsonProperty(value="alarm_status")
        public String getAlarmStatus() {
            return this.alarmStatus;
        }

        @JsonProperty(value="associate_mode")
        public void setAssociateMode(Integer associateMode) {
            this.associateMode = associateMode;
        }

        @JsonProperty(value="associate_mode")
        public Integer getAssociateMode() {
            return this.associateMode;
        }

        @JsonProperty(value="bandwidth")
        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        @JsonProperty(value="bandwidth")
        public Integer getBandwidth() {
            return this.bandwidth;
        }

        @JsonProperty(value="billing_mode")
        public void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @JsonProperty(value="billing_mode")
        public String getBillingMode() {
            return this.billingMode;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="eip_addr")
        public void setEIPAddr(String eIPAddr) {
            this.eIPAddr = eIPAddr;
        }

        @JsonProperty(value="eip_addr")
        public String getEIPAddr() {
            return this.eIPAddr;
        }

        @JsonProperty(value="eip_group")
        public void setEIPGroup(EIPGroupModel eIPGroup) {
            this.eIPGroup = eIPGroup;
        }

        @JsonProperty(value="eip_group")
        public EIPGroupModel getEIPGroup() {
            return this.eIPGroup;
        }

        @JsonProperty(value="eip_id")
        public void setEIPID(String eIPID) {
            this.eIPID = eIPID;
        }

        @JsonProperty(value="eip_id")
        public String getEIPID() {
            return this.eIPID;
        }

        @JsonProperty(value="eip_name")
        public void setEIPName(String eIPName) {
            this.eIPName = eIPName;
        }

        @JsonProperty(value="eip_name")
        public String getEIPName() {
            return this.eIPName;
        }

        @JsonProperty(value="icp_codes")
        public void setICPCodes(String iCPCodes) {
            this.iCPCodes = iCPCodes;
        }

        @JsonProperty(value="icp_codes")
        public String getICPCodes() {
            return this.iCPCodes;
        }

        @JsonProperty(value="need_icp")
        public void setNeedICP(Integer needICP) {
            this.needICP = needICP;
        }

        @JsonProperty(value="need_icp")
        public Integer getNeedICP() {
            return this.needICP;
        }

        @JsonProperty(value="resource")
        public void setResource(EIPResourceModel resource) {
            this.resource = resource;
        }

        @JsonProperty(value="resource")
        public EIPResourceModel getResource() {
            return this.resource;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_code")
        public void setSubCode(Integer subCode) {
            this.subCode = subCode;
        }

        @JsonProperty(value="sub_code")
        public Integer getSubCode() {
            return this.subCode;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] billingModeValidValues = new String[]{"bandwidth", "traffic"};
            boolean billingModeIsValid = false;
            for (String v : billingModeValidValues) {
                Boolean billingModeIsRequired;
                if (v.equals(this.getBillingMode())) {
                    billingModeIsValid = true;
                }
                if (!(billingModeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getBillingMode() != null) continue;
                billingModeIsValid = true;
            }
            if (!billingModeIsValid) {
                throw new QCException("BillingMode value " + this.getBillingMode() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "available", "associated", "suspended", "released", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"associating", "dissociating", "suspending", "resuming", "releasing"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DNSAliasModel
    implements ParamValidate {
        private String createTime;
        private String description;
        private String dNSAliasID;
        private String dNSAliasName;
        private String domainName;
        private String resourceID;
        private String status;

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="dns_alias_id")
        public void setDNSAliasID(String dNSAliasID) {
            this.dNSAliasID = dNSAliasID;
        }

        @JsonProperty(value="dns_alias_id")
        public String getDNSAliasID() {
            return this.dNSAliasID;
        }

        @JsonProperty(value="dns_alias_name")
        public void setDNSAliasName(String dNSAliasName) {
            this.dNSAliasName = dNSAliasName;
        }

        @JsonProperty(value="dns_alias_name")
        public String getDNSAliasName() {
            return this.dNSAliasName;
        }

        @JsonProperty(value="domain_name")
        public void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @JsonProperty(value="domain_name")
        public String getDomainName() {
            return this.domainName;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DHCPOptionModel
    implements ParamValidate {
        private String routerStaticID;
        private String val2;

        @JsonProperty(value="router_static_id")
        public void setRouterStaticID(String routerStaticID) {
            this.routerStaticID = routerStaticID;
        }

        @JsonProperty(value="router_static_id")
        public String getRouterStaticID() {
            return this.routerStaticID;
        }

        @JsonProperty(value="val2")
        public void setVal2(String val2) {
            this.val2 = val2;
        }

        @JsonProperty(value="val2")
        public String getVal2() {
            return this.val2;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DataModel
    implements ParamValidate {
        private String data;
        private String eIPID;

        @JsonProperty(value="data")
        public void setData(String data) {
            this.data = data;
        }

        @JsonProperty(value="data")
        public String getData() {
            return this.data;
        }

        @JsonProperty(value="eip_id")
        public void setEIPID(String eIPID) {
            this.eIPID = eIPID;
        }

        @JsonProperty(value="eip_id")
        public String getEIPID() {
            return this.eIPID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClusterNodeModel
    implements ParamValidate {
        private String advancedActions;
        private Boolean agentInstalled;
        private String alarmStatus;
        private String appID;
        private String appVersion;
        private Integer autoBackup;
        private String backupPolicy;
        private Model backupService;
        private String clusterID;
        private String consoleID;
        private String controller;
        private Integer cPU;
        private String createTime;
        private Model customMetadataScript;
        private Model customService;
        private Boolean debug;
        private Model destroyService;
        private Model displayTabs;
        private String eIP;
        private String env;
        private Integer globalServerID;
        private Integer gpu;
        private Integer gpuClass;
        private Integer groupID;
        private Model healthCheck;
        private String healthStatus;
        private String hypervisor;
        private String imageID;
        private Boolean incrementalBackupSupported;
        private Model initService;
        private String instanceID;
        private Integer isBackup;
        private Integer memory;
        private Model monitor;
        private String name;
        private String nodeID;
        private String owner;
        private String passphraseless;
        private String privateIP;
        private String repl;
        private Integer resourceClass;
        private Model restartService;
        private Model restoreService;
        private String role;
        private String rootUserID;
        private Model scaleInService;
        private Model scaleOutService;
        private String securityGroup;
        private Integer serverID;
        private Integer serverIDUpperBound;
        private String singleNodeRepl;
        private Model startService;
        private String status;
        private String statusTime;
        private Model stopService;
        private Integer storageSize;
        private String transitionStatus;
        private Integer userAccess;
        private String verticalScalingPolicy;
        private String volumeIDs;
        private Integer volumeType;
        private String vxNetID;

        @JsonProperty(value="advanced_actions")
        public void setAdvancedActions(String advancedActions) {
            this.advancedActions = advancedActions;
        }

        @JsonProperty(value="advanced_actions")
        public String getAdvancedActions() {
            return this.advancedActions;
        }

        @JsonProperty(value="agent_installed")
        public void setAgentInstalled(Boolean agentInstalled) {
            this.agentInstalled = agentInstalled;
        }

        @JsonProperty(value="agent_installed")
        public Boolean getAgentInstalled() {
            return this.agentInstalled;
        }

        @JsonProperty(value="alarm_status")
        public void setAlarmStatus(String alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        @JsonProperty(value="alarm_status")
        public String getAlarmStatus() {
            return this.alarmStatus;
        }

        @JsonProperty(value="app_id")
        public void setAppID(String appID) {
            this.appID = appID;
        }

        @JsonProperty(value="app_id")
        public String getAppID() {
            return this.appID;
        }

        @JsonProperty(value="app_version")
        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @JsonProperty(value="app_version")
        public String getAppVersion() {
            return this.appVersion;
        }

        @JsonProperty(value="auto_backup")
        public void setAutoBackup(Integer autoBackup) {
            this.autoBackup = autoBackup;
        }

        @JsonProperty(value="auto_backup")
        public Integer getAutoBackup() {
            return this.autoBackup;
        }

        @JsonProperty(value="backup_policy")
        public void setBackupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
        }

        @JsonProperty(value="backup_policy")
        public String getBackupPolicy() {
            return this.backupPolicy;
        }

        @JsonProperty(value="backup_service")
        public void setBackupService(Model backupService) {
            this.backupService = backupService;
        }

        @JsonProperty(value="backup_service")
        public Model getBackupService() {
            return this.backupService;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="console_id")
        public void setConsoleID(String consoleID) {
            this.consoleID = consoleID;
        }

        @JsonProperty(value="console_id")
        public String getConsoleID() {
            return this.consoleID;
        }

        @JsonProperty(value="controller")
        public void setController(String controller) {
            this.controller = controller;
        }

        @JsonProperty(value="controller")
        public String getController() {
            return this.controller;
        }

        @JsonProperty(value="cpu")
        public void setCPU(Integer cPU) {
            this.cPU = cPU;
        }

        @JsonProperty(value="cpu")
        public Integer getCPU() {
            return this.cPU;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="custom_metadata_script")
        public void setCustomMetadataScript(Model customMetadataScript) {
            this.customMetadataScript = customMetadataScript;
        }

        @JsonProperty(value="custom_metadata_script")
        public Model getCustomMetadataScript() {
            return this.customMetadataScript;
        }

        @JsonProperty(value="custom_service")
        public void setCustomService(Model customService) {
            this.customService = customService;
        }

        @JsonProperty(value="custom_service")
        public Model getCustomService() {
            return this.customService;
        }

        @JsonProperty(value="debug")
        public void setDebug(Boolean debug) {
            this.debug = debug;
        }

        @JsonProperty(value="debug")
        public Boolean getDebug() {
            return this.debug;
        }

        @JsonProperty(value="destroy_service")
        public void setDestroyService(Model destroyService) {
            this.destroyService = destroyService;
        }

        @JsonProperty(value="destroy_service")
        public Model getDestroyService() {
            return this.destroyService;
        }

        @JsonProperty(value="display_tabs")
        public void setDisplayTabs(Model displayTabs) {
            this.displayTabs = displayTabs;
        }

        @JsonProperty(value="display_tabs")
        public Model getDisplayTabs() {
            return this.displayTabs;
        }

        @JsonProperty(value="eip")
        public void setEIP(String eIP) {
            this.eIP = eIP;
        }

        @JsonProperty(value="eip")
        public String getEIP() {
            return this.eIP;
        }

        @JsonProperty(value="env")
        public void setEnv(String env) {
            this.env = env;
        }

        @JsonProperty(value="env")
        public String getEnv() {
            return this.env;
        }

        @JsonProperty(value="global_server_id")
        public void setGlobalServerID(Integer globalServerID) {
            this.globalServerID = globalServerID;
        }

        @JsonProperty(value="global_server_id")
        public Integer getGlobalServerID() {
            return this.globalServerID;
        }

        @JsonProperty(value="gpu")
        public void setGpu(Integer gpu) {
            this.gpu = gpu;
        }

        @JsonProperty(value="gpu")
        public Integer getGpu() {
            return this.gpu;
        }

        @JsonProperty(value="gpu_class")
        public void setGpuClass(Integer gpuClass) {
            this.gpuClass = gpuClass;
        }

        @JsonProperty(value="gpu_class")
        public Integer getGpuClass() {
            return this.gpuClass;
        }

        @JsonProperty(value="group_id")
        public void setGroupID(Integer groupID) {
            this.groupID = groupID;
        }

        @JsonProperty(value="group_id")
        public Integer getGroupID() {
            return this.groupID;
        }

        @JsonProperty(value="health_check")
        public void setHealthCheck(Model healthCheck) {
            this.healthCheck = healthCheck;
        }

        @JsonProperty(value="health_check")
        public Model getHealthCheck() {
            return this.healthCheck;
        }

        @JsonProperty(value="health_status")
        public void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @JsonProperty(value="health_status")
        public String getHealthStatus() {
            return this.healthStatus;
        }

        @JsonProperty(value="hypervisor")
        public void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @JsonProperty(value="hypervisor")
        public String getHypervisor() {
            return this.hypervisor;
        }

        @JsonProperty(value="image_id")
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        @JsonProperty(value="image_id")
        public String getImageID() {
            return this.imageID;
        }

        @JsonProperty(value="incremental_backup_supported")
        public void setIncrementalBackupSupported(Boolean incrementalBackupSupported) {
            this.incrementalBackupSupported = incrementalBackupSupported;
        }

        @JsonProperty(value="incremental_backup_supported")
        public Boolean getIncrementalBackupSupported() {
            return this.incrementalBackupSupported;
        }

        @JsonProperty(value="init_service")
        public void setInitService(Model initService) {
            this.initService = initService;
        }

        @JsonProperty(value="init_service")
        public Model getInitService() {
            return this.initService;
        }

        @JsonProperty(value="instance_id")
        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        @JsonProperty(value="instance_id")
        public String getInstanceID() {
            return this.instanceID;
        }

        @JsonProperty(value="is_backup")
        public void setIsBackup(Integer isBackup) {
            this.isBackup = isBackup;
        }

        @JsonProperty(value="is_backup")
        public Integer getIsBackup() {
            return this.isBackup;
        }

        @JsonProperty(value="memory")
        public void setMemory(Integer memory) {
            this.memory = memory;
        }

        @JsonProperty(value="memory")
        public Integer getMemory() {
            return this.memory;
        }

        @JsonProperty(value="monitor")
        public void setMonitor(Model monitor) {
            this.monitor = monitor;
        }

        @JsonProperty(value="monitor")
        public Model getMonitor() {
            return this.monitor;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="node_id")
        public void setNodeID(String nodeID) {
            this.nodeID = nodeID;
        }

        @JsonProperty(value="node_id")
        public String getNodeID() {
            return this.nodeID;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="passphraseless")
        public void setPassphraseless(String passphraseless) {
            this.passphraseless = passphraseless;
        }

        @JsonProperty(value="passphraseless")
        public String getPassphraseless() {
            return this.passphraseless;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="repl")
        public void setRepl(String repl) {
            this.repl = repl;
        }

        @JsonProperty(value="repl")
        public String getRepl() {
            return this.repl;
        }

        @JsonProperty(value="resource_class")
        public void setResourceClass(Integer resourceClass) {
            this.resourceClass = resourceClass;
        }

        @JsonProperty(value="resource_class")
        public Integer getResourceClass() {
            return this.resourceClass;
        }

        @JsonProperty(value="restart_service")
        public void setRestartService(Model restartService) {
            this.restartService = restartService;
        }

        @JsonProperty(value="restart_service")
        public Model getRestartService() {
            return this.restartService;
        }

        @JsonProperty(value="restore_service")
        public void setRestoreService(Model restoreService) {
            this.restoreService = restoreService;
        }

        @JsonProperty(value="restore_service")
        public Model getRestoreService() {
            return this.restoreService;
        }

        @JsonProperty(value="role")
        public void setRole(String role) {
            this.role = role;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="scale_in_service")
        public void setScaleInService(Model scaleInService) {
            this.scaleInService = scaleInService;
        }

        @JsonProperty(value="scale_in_service")
        public Model getScaleInService() {
            return this.scaleInService;
        }

        @JsonProperty(value="scale_out_service")
        public void setScaleOutService(Model scaleOutService) {
            this.scaleOutService = scaleOutService;
        }

        @JsonProperty(value="scale_out_service")
        public Model getScaleOutService() {
            return this.scaleOutService;
        }

        @JsonProperty(value="security_group")
        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @JsonProperty(value="security_group")
        public String getSecurityGroup() {
            return this.securityGroup;
        }

        @JsonProperty(value="server_id")
        public void setServerID(Integer serverID) {
            this.serverID = serverID;
        }

        @JsonProperty(value="server_id")
        public Integer getServerID() {
            return this.serverID;
        }

        @JsonProperty(value="server_id_upper_bound")
        public void setServerIDUpperBound(Integer serverIDUpperBound) {
            this.serverIDUpperBound = serverIDUpperBound;
        }

        @JsonProperty(value="server_id_upper_bound")
        public Integer getServerIDUpperBound() {
            return this.serverIDUpperBound;
        }

        @JsonProperty(value="single_node_repl")
        public void setSingleNodeRepl(String singleNodeRepl) {
            this.singleNodeRepl = singleNodeRepl;
        }

        @JsonProperty(value="single_node_repl")
        public String getSingleNodeRepl() {
            return this.singleNodeRepl;
        }

        @JsonProperty(value="start_service")
        public void setStartService(Model startService) {
            this.startService = startService;
        }

        @JsonProperty(value="start_service")
        public Model getStartService() {
            return this.startService;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="stop_service")
        public void setStopService(Model stopService) {
            this.stopService = stopService;
        }

        @JsonProperty(value="stop_service")
        public Model getStopService() {
            return this.stopService;
        }

        @JsonProperty(value="storage_size")
        public void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @JsonProperty(value="storage_size")
        public Integer getStorageSize() {
            return this.storageSize;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="user_access")
        public void setUserAccess(Integer userAccess) {
            this.userAccess = userAccess;
        }

        @JsonProperty(value="user_access")
        public Integer getUserAccess() {
            return this.userAccess;
        }

        @JsonProperty(value="vertical_scaling_policy")
        public void setVerticalScalingPolicy(String verticalScalingPolicy) {
            this.verticalScalingPolicy = verticalScalingPolicy;
        }

        @JsonProperty(value="vertical_scaling_policy")
        public String getVerticalScalingPolicy() {
            return this.verticalScalingPolicy;
        }

        @JsonProperty(value="volume_ids")
        public void setVolumeIDs(String volumeIDs) {
            this.volumeIDs = volumeIDs;
        }

        @JsonProperty(value="volume_ids")
        public String getVolumeIDs() {
            return this.volumeIDs;
        }

        @JsonProperty(value="volume_type")
        public void setVolumeType(Integer volumeType) {
            this.volumeType = volumeType;
        }

        @JsonProperty(value="volume_type")
        public Integer getVolumeType() {
            return this.volumeType;
        }

        @JsonProperty(value="vxnet_id")
        public void setVxNetID(String vxNetID) {
            this.vxNetID = vxNetID;
        }

        @JsonProperty(value="vxnet_id")
        public String getVxNetID() {
            return this.vxNetID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClusterModel
    implements ParamValidate {
        private Map advancedActions;
        private String appID;
        private Model appInfo;
        private String appVersion;
        private Model appVersionInfo;
        private Integer autoBackupTime;
        private Map backup;
        private String backupPolicy;
        private Model backupService;
        private String cfgmgmtID;
        private String clusterID;
        private Integer clusterType;
        private String consoleID;
        private String controller;
        private String createTime;
        private Model customService;
        private Boolean debug;
        private String description;
        private Model displayTabs;
        private Model endpoints;
        private String globalUUID;
        private Map healthCheckEnablement;
        private Boolean incrementalBackupSupported;
        private String latestSnapshotTime;
        private Map links;
        private Boolean metadataRootAccess;
        private String name;
        private Integer nodeCount;
        private List<ClusterNodeModel> nodes;
        private String owner;
        private Boolean partnerAccess;
        private Model restoreService;
        private Boolean reuseHyper;
        private Map roleCount;
        private List<String> roles;
        private String rootUserID;
        private String securityGroupID;
        private String status;
        private String statusTime;
        private Integer subCode;
        private String transitionStatus;
        private List<Object> upgradePolicy;
        private String upgradeStatus;
        private String upgradeTime;
        private VxNetModel vxNet;

        @JsonProperty(value="advanced_actions")
        public void setAdvancedActions(Map advancedActions) {
            this.advancedActions = advancedActions;
        }

        @JsonProperty(value="advanced_actions")
        public Map getAdvancedActions() {
            return this.advancedActions;
        }

        @JsonProperty(value="app_id")
        public void setAppID(String appID) {
            this.appID = appID;
        }

        @JsonProperty(value="app_id")
        public String getAppID() {
            return this.appID;
        }

        @JsonProperty(value="app_info")
        public void setAppInfo(Model appInfo) {
            this.appInfo = appInfo;
        }

        @JsonProperty(value="app_info")
        public Model getAppInfo() {
            return this.appInfo;
        }

        @JsonProperty(value="app_version")
        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @JsonProperty(value="app_version")
        public String getAppVersion() {
            return this.appVersion;
        }

        @JsonProperty(value="app_version_info")
        public void setAppVersionInfo(Model appVersionInfo) {
            this.appVersionInfo = appVersionInfo;
        }

        @JsonProperty(value="app_version_info")
        public Model getAppVersionInfo() {
            return this.appVersionInfo;
        }

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="backup")
        public void setBackup(Map backup) {
            this.backup = backup;
        }

        @JsonProperty(value="backup")
        public Map getBackup() {
            return this.backup;
        }

        @JsonProperty(value="backup_policy")
        public void setBackupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
        }

        @JsonProperty(value="backup_policy")
        public String getBackupPolicy() {
            return this.backupPolicy;
        }

        @JsonProperty(value="backup_service")
        public void setBackupService(Model backupService) {
            this.backupService = backupService;
        }

        @JsonProperty(value="backup_service")
        public Model getBackupService() {
            return this.backupService;
        }

        @JsonProperty(value="cfgmgmt_id")
        public void setCfgmgmtID(String cfgmgmtID) {
            this.cfgmgmtID = cfgmgmtID;
        }

        @JsonProperty(value="cfgmgmt_id")
        public String getCfgmgmtID() {
            return this.cfgmgmtID;
        }

        @JsonProperty(value="cluster_id")
        public void setClusterID(String clusterID) {
            this.clusterID = clusterID;
        }

        @JsonProperty(value="cluster_id")
        public String getClusterID() {
            return this.clusterID;
        }

        @JsonProperty(value="cluster_type")
        public void setClusterType(Integer clusterType) {
            this.clusterType = clusterType;
        }

        @JsonProperty(value="cluster_type")
        public Integer getClusterType() {
            return this.clusterType;
        }

        @JsonProperty(value="console_id")
        public void setConsoleID(String consoleID) {
            this.consoleID = consoleID;
        }

        @JsonProperty(value="console_id")
        public String getConsoleID() {
            return this.consoleID;
        }

        @JsonProperty(value="controller")
        public void setController(String controller) {
            this.controller = controller;
        }

        @JsonProperty(value="controller")
        public String getController() {
            return this.controller;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="custom_service")
        public void setCustomService(Model customService) {
            this.customService = customService;
        }

        @JsonProperty(value="custom_service")
        public Model getCustomService() {
            return this.customService;
        }

        @JsonProperty(value="debug")
        public void setDebug(Boolean debug) {
            this.debug = debug;
        }

        @JsonProperty(value="debug")
        public Boolean getDebug() {
            return this.debug;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="display_tabs")
        public void setDisplayTabs(Model displayTabs) {
            this.displayTabs = displayTabs;
        }

        @JsonProperty(value="display_tabs")
        public Model getDisplayTabs() {
            return this.displayTabs;
        }

        @JsonProperty(value="endpoints")
        public void setEndpoints(Model endpoints) {
            this.endpoints = endpoints;
        }

        @JsonProperty(value="endpoints")
        public Model getEndpoints() {
            return this.endpoints;
        }

        @JsonProperty(value="global_uuid")
        public void setGlobalUUID(String globalUUID) {
            this.globalUUID = globalUUID;
        }

        @JsonProperty(value="global_uuid")
        public String getGlobalUUID() {
            return this.globalUUID;
        }

        @JsonProperty(value="health_check_enablement")
        public void setHealthCheckEnablement(Map healthCheckEnablement) {
            this.healthCheckEnablement = healthCheckEnablement;
        }

        @JsonProperty(value="health_check_enablement")
        public Map getHealthCheckEnablement() {
            return this.healthCheckEnablement;
        }

        @JsonProperty(value="incremental_backup_supported")
        public void setIncrementalBackupSupported(Boolean incrementalBackupSupported) {
            this.incrementalBackupSupported = incrementalBackupSupported;
        }

        @JsonProperty(value="incremental_backup_supported")
        public Boolean getIncrementalBackupSupported() {
            return this.incrementalBackupSupported;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public void setLatestSnapshotTime(String latestSnapshotTime) {
            this.latestSnapshotTime = latestSnapshotTime;
        }

        @JsonProperty(value="lastest_snapshot_time")
        public String getLatestSnapshotTime() {
            return this.latestSnapshotTime;
        }

        @JsonProperty(value="links")
        public void setLinks(Map links) {
            this.links = links;
        }

        @JsonProperty(value="links")
        public Map getLinks() {
            return this.links;
        }

        @JsonProperty(value="metadata_root_access")
        public void setMetadataRootAccess(Boolean metadataRootAccess) {
            this.metadataRootAccess = metadataRootAccess;
        }

        @JsonProperty(value="metadata_root_access")
        public Boolean getMetadataRootAccess() {
            return this.metadataRootAccess;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="nodes")
        public void setNodes(List<ClusterNodeModel> nodes) {
            this.nodes = nodes;
        }

        @JsonProperty(value="nodes")
        public List<ClusterNodeModel> getNodes() {
            return this.nodes;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="partner_access")
        public void setPartnerAccess(Boolean partnerAccess) {
            this.partnerAccess = partnerAccess;
        }

        @JsonProperty(value="partner_access")
        public Boolean getPartnerAccess() {
            return this.partnerAccess;
        }

        @JsonProperty(value="restore_service")
        public void setRestoreService(Model restoreService) {
            this.restoreService = restoreService;
        }

        @JsonProperty(value="restore_service")
        public Model getRestoreService() {
            return this.restoreService;
        }

        @JsonProperty(value="reuse_hyper")
        public void setReuseHyper(Boolean reuseHyper) {
            this.reuseHyper = reuseHyper;
        }

        @JsonProperty(value="reuse_hyper")
        public Boolean getReuseHyper() {
            return this.reuseHyper;
        }

        @JsonProperty(value="role_count")
        public void setRoleCount(Map roleCount) {
            this.roleCount = roleCount;
        }

        @JsonProperty(value="role_count")
        public Map getRoleCount() {
            return this.roleCount;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="roles")
        public List<String> getRoles() {
            return this.roles;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_code")
        public void setSubCode(Integer subCode) {
            this.subCode = subCode;
        }

        @JsonProperty(value="sub_code")
        public Integer getSubCode() {
            return this.subCode;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="upgrade_policy")
        public void setUpgradePolicy(List<Object> upgradePolicy) {
            this.upgradePolicy = upgradePolicy;
        }

        @JsonProperty(value="upgrade_policy")
        public List<Object> getUpgradePolicy() {
            return this.upgradePolicy;
        }

        @JsonProperty(value="upgrade_status")
        public void setUpgradeStatus(String upgradeStatus) {
            this.upgradeStatus = upgradeStatus;
        }

        @JsonProperty(value="upgrade_status")
        public String getUpgradeStatus() {
            return this.upgradeStatus;
        }

        @JsonProperty(value="upgrade_time")
        public void setUpgradeTime(String upgradeTime) {
            this.upgradeTime = upgradeTime;
        }

        @JsonProperty(value="upgrade_time")
        public String getUpgradeTime() {
            return this.upgradeTime;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(VxNetModel vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public VxNetModel getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            if (this.getNodes() != null && this.getNodes().size() > 0 && (i = 0) < this.getNodes().size()) {
                return null;
            }
            if (this.getUpgradePolicy() != null && this.getUpgradePolicy().size() > 0) {
                for (i = 0; i < this.getUpgradePolicy().size(); ++i) {
                    String string = (String)this.getUpgradePolicy().get(i);
                }
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CachePrivateIPModel
    implements ParamValidate {
        private String cacheNodeID;
        private String cacheRole;
        private String privateIPs;

        @JsonProperty(value="cache_node_id")
        public void setCacheNodeID(String cacheNodeID) {
            this.cacheNodeID = cacheNodeID;
        }

        @JsonProperty(value="cache_node_id")
        public String getCacheNodeID() {
            return this.cacheNodeID;
        }

        @JsonProperty(value="cache_role")
        public void setCacheRole(String cacheRole) {
            this.cacheRole = cacheRole;
        }

        @JsonProperty(value="cache_role")
        public String getCacheRole() {
            return this.cacheRole;
        }

        @JsonProperty(value="private_ips")
        public void setPrivateIPs(String privateIPs) {
            this.privateIPs = privateIPs;
        }

        @JsonProperty(value="private_ips")
        public String getPrivateIPs() {
            return this.privateIPs;
        }

        @Override
        public String validateParam() throws QCException {
            String[] cacheRoleValidValues = new String[]{"master", "slave"};
            boolean cacheRoleIsValid = false;
            for (String v : cacheRoleValidValues) {
                Boolean cacheRoleIsRequired;
                if (v.equals(this.getCacheRole())) {
                    cacheRoleIsValid = true;
                }
                if (!(cacheRoleIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCacheRole() != null) continue;
                cacheRoleIsValid = true;
            }
            if (!cacheRoleIsValid) {
                throw new QCException("CacheRole value " + this.getCacheRole() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CacheParameterGroupModel
    implements ParamValidate {
        private String cacheParameterGroupID;
        private String cacheParameterGroupName;
        private String cacheType;
        private String createTime;
        private String description;
        private Integer isApplied;
        private Integer isDefault;
        private List<ResourceModel> resources;

        @JsonProperty(value="cache_parameter_group_id")
        public void setCacheParameterGroupID(String cacheParameterGroupID) {
            this.cacheParameterGroupID = cacheParameterGroupID;
        }

        @JsonProperty(value="cache_parameter_group_id")
        public String getCacheParameterGroupID() {
            return this.cacheParameterGroupID;
        }

        @JsonProperty(value="cache_parameter_group_name")
        public void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @JsonProperty(value="cache_parameter_group_name")
        public String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="is_applied")
        public void setIsApplied(Integer isApplied) {
            this.isApplied = isApplied;
        }

        @JsonProperty(value="is_applied")
        public Integer getIsApplied() {
            return this.isApplied;
        }

        @JsonProperty(value="is_default")
        public void setIsDefault(Integer isDefault) {
            this.isDefault = isDefault;
        }

        @JsonProperty(value="is_default")
        public Integer getIsDefault() {
            return this.isDefault;
        }

        @JsonProperty(value="resources")
        public void setResources(List<ResourceModel> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="resources")
        public List<ResourceModel> getResources() {
            return this.resources;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            String[] isAppliedValidValues = new String[]{"0", "1"};
            boolean isAppliedIsValid = false;
            for (String v : isAppliedValidValues) {
                Boolean isAppliedIsRequired;
                if (v.equals(this.getIsApplied() + "")) {
                    isAppliedIsValid = true;
                }
                if (!(isAppliedIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsApplied() != null) continue;
                isAppliedIsValid = true;
            }
            if (!isAppliedIsValid) {
                throw new QCException("IsApplied value " + this.getIsApplied() + "is invalid");
            }
            if (this.getResources() != null && this.getResources().size() > 0 && (i = 0) < this.getResources().size()) {
                return null;
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CacheParameterModel
    implements ParamValidate {
        private String cacheParameterName;
        private String cacheParameterType;
        private String cacheParameterValue;
        private String cacheType;
        private Integer isReadonly;
        private Integer isStatic;
        private String oPTName;
        private String parameterType;
        private String resourceVersion;
        private String valueRange;

        @JsonProperty(value="cache_parameter_name")
        public void setCacheParameterName(String cacheParameterName) {
            this.cacheParameterName = cacheParameterName;
        }

        @JsonProperty(value="cache_parameter_name")
        public String getCacheParameterName() {
            return this.cacheParameterName;
        }

        @JsonProperty(value="cache_parameter_type")
        public void setCacheParameterType(String cacheParameterType) {
            this.cacheParameterType = cacheParameterType;
        }

        @JsonProperty(value="cache_parameter_type")
        public String getCacheParameterType() {
            return this.cacheParameterType;
        }

        @JsonProperty(value="cache_parameter_value")
        public void setCacheParameterValue(String cacheParameterValue) {
            this.cacheParameterValue = cacheParameterValue;
        }

        @JsonProperty(value="cache_parameter_value")
        public String getCacheParameterValue() {
            return this.cacheParameterValue;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="is_readonly")
        public void setIsReadonly(Integer isReadonly) {
            this.isReadonly = isReadonly;
        }

        @JsonProperty(value="is_readonly")
        public Integer getIsReadonly() {
            return this.isReadonly;
        }

        @JsonProperty(value="is_static")
        public void setIsStatic(Integer isStatic) {
            this.isStatic = isStatic;
        }

        @JsonProperty(value="is_static")
        public Integer getIsStatic() {
            return this.isStatic;
        }

        @JsonProperty(value="opt_name")
        public void setOPTName(String oPTName) {
            this.oPTName = oPTName;
        }

        @JsonProperty(value="opt_name")
        public String getOPTName() {
            return this.oPTName;
        }

        @JsonProperty(value="parameter_type")
        public void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        @JsonProperty(value="parameter_type")
        public String getParameterType() {
            return this.parameterType;
        }

        @JsonProperty(value="resource_version")
        public void setResourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
        }

        @JsonProperty(value="resource_version")
        public String getResourceVersion() {
            return this.resourceVersion;
        }

        @JsonProperty(value="value_range")
        public void setValueRange(String valueRange) {
            this.valueRange = valueRange;
        }

        @JsonProperty(value="value_range")
        public String getValueRange() {
            return this.valueRange;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getCacheParameterName())) {
                throw new QCException("CacheParameterName is required");
            }
            if (QCStringUtil.isEmpty(this.getCacheParameterValue())) {
                throw new QCException("CacheParameterValue is required");
            }
            String[] isReadonlyValidValues = new String[]{"0", "1"};
            boolean isReadonlyIsValid = false;
            for (String v : isReadonlyValidValues) {
                Boolean isReadonlyIsRequired;
                if (v.equals(this.getIsReadonly() + "")) {
                    isReadonlyIsValid = true;
                }
                if (!(isReadonlyIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsReadonly() != null) continue;
                isReadonlyIsValid = true;
            }
            if (!isReadonlyIsValid) {
                throw new QCException("IsReadonly value " + this.getIsReadonly() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CacheNodeModel
    implements ParamValidate {
        private String alarmStatus;
        private String cacheID;
        private String cacheNodeID;
        private String cacheNodeName;
        private String cacheRole;
        private String cacheType;
        private String createTime;
        private String privateIP;
        private String slaveof;
        private String status;
        private String statusTime;
        private String transitionStatus;

        @JsonProperty(value="alarm_status")
        public void setAlarmStatus(String alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        @JsonProperty(value="alarm_status")
        public String getAlarmStatus() {
            return this.alarmStatus;
        }

        @JsonProperty(value="cache_id")
        public void setCacheID(String cacheID) {
            this.cacheID = cacheID;
        }

        @JsonProperty(value="cache_id")
        public String getCacheID() {
            return this.cacheID;
        }

        @JsonProperty(value="cache_node_id")
        public void setCacheNodeID(String cacheNodeID) {
            this.cacheNodeID = cacheNodeID;
        }

        @JsonProperty(value="cache_node_id")
        public String getCacheNodeID() {
            return this.cacheNodeID;
        }

        @JsonProperty(value="cache_node_name")
        public void setCacheNodeName(String cacheNodeName) {
            this.cacheNodeName = cacheNodeName;
        }

        @JsonProperty(value="cache_node_name")
        public String getCacheNodeName() {
            return this.cacheNodeName;
        }

        @JsonProperty(value="cache_role")
        public void setCacheRole(String cacheRole) {
            this.cacheRole = cacheRole;
        }

        @JsonProperty(value="cache_role")
        public String getCacheRole() {
            return this.cacheRole;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="private_ip")
        public void setPrivateIP(String privateIP) {
            this.privateIP = privateIP;
        }

        @JsonProperty(value="private_ip")
        public String getPrivateIP() {
            return this.privateIP;
        }

        @JsonProperty(value="slaveof")
        public void setSlaveof(String slaveof) {
            this.slaveof = slaveof;
        }

        @JsonProperty(value="slaveof")
        public String getSlaveof() {
            return this.slaveof;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @Override
        public String validateParam() throws QCException {
            String[] cacheRoleValidValues = new String[]{"master", "slave"};
            boolean cacheRoleIsValid = false;
            for (String v : cacheRoleValidValues) {
                Boolean cacheRoleIsRequired;
                if (v.equals(this.getCacheRole())) {
                    cacheRoleIsValid = true;
                }
                if (!(cacheRoleIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCacheRole() != null) continue;
                cacheRoleIsValid = true;
            }
            if (!cacheRoleIsValid) {
                throw new QCException("CacheRole value " + this.getCacheRole() + "is invalid");
            }
            String[] statusValidValues = new String[]{"pending", "active", "down", "suspended"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            String[] transitionStatusValidValues = new String[]{"creating", "starting", "stopping", "updating", "suspending", "resuming", "deleting"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CacheModel
    implements ParamValidate {
        private Integer autoBackupTime;
        private Integer cacheClass;
        private String cacheID;
        private String cacheName;
        private String cacheParameterGroupID;
        private Integer cachePort;
        private Integer cacheSize;
        private String cacheType;
        private String cacheVersion;
        private String createTime;
        private String description;
        private Integer isApplied;
        private Integer masterCount;
        private Integer maxMemory;
        private Integer nodeCount;
        private List<CacheNodeModel> nodes;
        private Integer replicateCount;
        private String securityGroupID;
        private String status;
        private String statusTime;
        private Integer subCode;
        private List<TagModel> tags;
        private String transitionStatus;
        private VxNetModel vxNet;

        @JsonProperty(value="auto_backup_time")
        public void setAutoBackupTime(Integer autoBackupTime) {
            this.autoBackupTime = autoBackupTime;
        }

        @JsonProperty(value="auto_backup_time")
        public Integer getAutoBackupTime() {
            return this.autoBackupTime;
        }

        @JsonProperty(value="cache_class")
        public void setCacheClass(Integer cacheClass) {
            this.cacheClass = cacheClass;
        }

        @JsonProperty(value="cache_class")
        public Integer getCacheClass() {
            return this.cacheClass;
        }

        @JsonProperty(value="cache_id")
        public void setCacheID(String cacheID) {
            this.cacheID = cacheID;
        }

        @JsonProperty(value="cache_id")
        public String getCacheID() {
            return this.cacheID;
        }

        @JsonProperty(value="cache_name")
        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        @JsonProperty(value="cache_name")
        public String getCacheName() {
            return this.cacheName;
        }

        @JsonProperty(value="cache_parameter_group_id")
        public void setCacheParameterGroupID(String cacheParameterGroupID) {
            this.cacheParameterGroupID = cacheParameterGroupID;
        }

        @JsonProperty(value="cache_parameter_group_id")
        public String getCacheParameterGroupID() {
            return this.cacheParameterGroupID;
        }

        @JsonProperty(value="cache_port")
        public void setCachePort(Integer cachePort) {
            this.cachePort = cachePort;
        }

        @JsonProperty(value="cache_port")
        public Integer getCachePort() {
            return this.cachePort;
        }

        @JsonProperty(value="cache_size")
        public void setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
        }

        @JsonProperty(value="cache_size")
        public Integer getCacheSize() {
            return this.cacheSize;
        }

        @JsonProperty(value="cache_type")
        public void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="cache_type")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="cache_version")
        public void setCacheVersion(String cacheVersion) {
            this.cacheVersion = cacheVersion;
        }

        @JsonProperty(value="cache_version")
        public String getCacheVersion() {
            return this.cacheVersion;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="is_applied")
        public void setIsApplied(Integer isApplied) {
            this.isApplied = isApplied;
        }

        @JsonProperty(value="is_applied")
        public Integer getIsApplied() {
            return this.isApplied;
        }

        @JsonProperty(value="master_count")
        public void setMasterCount(Integer masterCount) {
            this.masterCount = masterCount;
        }

        @JsonProperty(value="master_count")
        public Integer getMasterCount() {
            return this.masterCount;
        }

        @JsonProperty(value="max_memory")
        public void setMaxMemory(Integer maxMemory) {
            this.maxMemory = maxMemory;
        }

        @JsonProperty(value="max_memory")
        public Integer getMaxMemory() {
            return this.maxMemory;
        }

        @JsonProperty(value="node_count")
        public void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @JsonProperty(value="node_count")
        public Integer getNodeCount() {
            return this.nodeCount;
        }

        @JsonProperty(value="nodes")
        public void setNodes(List<CacheNodeModel> nodes) {
            this.nodes = nodes;
        }

        @JsonProperty(value="nodes")
        public List<CacheNodeModel> getNodes() {
            return this.nodes;
        }

        @JsonProperty(value="replicate_count")
        public void setReplicateCount(Integer replicateCount) {
            this.replicateCount = replicateCount;
        }

        @JsonProperty(value="replicate_count")
        public Integer getReplicateCount() {
            return this.replicateCount;
        }

        @JsonProperty(value="security_group_id")
        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        @JsonProperty(value="security_group_id")
        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_code")
        public void setSubCode(Integer subCode) {
            this.subCode = subCode;
        }

        @JsonProperty(value="sub_code")
        public Integer getSubCode() {
            return this.subCode;
        }

        @JsonProperty(value="tags")
        public void setTags(List<TagModel> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<TagModel> getTags() {
            return this.tags;
        }

        @JsonProperty(value="transition_status")
        public void setTransitionStatus(String transitionStatus) {
            this.transitionStatus = transitionStatus;
        }

        @JsonProperty(value="transition_status")
        public String getTransitionStatus() {
            return this.transitionStatus;
        }

        @JsonProperty(value="vxnet")
        public void setVxNet(VxNetModel vxNet) {
            this.vxNet = vxNet;
        }

        @JsonProperty(value="vxnet")
        public VxNetModel getVxNet() {
            return this.vxNet;
        }

        @Override
        public String validateParam() throws QCException {
            int i;
            int i2;
            String[] cacheClassValidValues = new String[]{"0", "1"};
            boolean cacheClassIsValid = false;
            for (String v : cacheClassValidValues) {
                Boolean cacheClassIsRequired;
                if (v.equals(this.getCacheClass() + "")) {
                    cacheClassIsValid = true;
                }
                if (!(cacheClassIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCacheClass() != null) continue;
                cacheClassIsValid = true;
            }
            if (!cacheClassIsValid) {
                throw new QCException("CacheClass value " + this.getCacheClass() + "is invalid");
            }
            String[] cacheTypeValidValues = new String[]{"Redis2.8.17", "Memcached1.4.13"};
            boolean cacheTypeIsValid = false;
            for (String v : cacheTypeValidValues) {
                Boolean cacheTypeIsRequired;
                if (v.equals(this.getCacheType())) {
                    cacheTypeIsValid = true;
                }
                if (!(cacheTypeIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getCacheType() != null) continue;
                cacheTypeIsValid = true;
            }
            if (!cacheTypeIsValid) {
                throw new QCException("CacheType value " + this.getCacheType() + "is invalid");
            }
            String[] isAppliedValidValues = new String[]{"0", "1"};
            boolean isAppliedIsValid = false;
            for (String v : isAppliedValidValues) {
                Boolean isAppliedIsRequired;
                if (v.equals(this.getIsApplied() + "")) {
                    isAppliedIsValid = true;
                }
                if (!(isAppliedIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getIsApplied() != null) continue;
                isAppliedIsValid = true;
            }
            if (!isAppliedIsValid) {
                throw new QCException("IsApplied value " + this.getIsApplied() + "is invalid");
            }
            if (this.getNodes() != null && this.getNodes().size() > 0 && (i2 = 0) < this.getNodes().size()) {
                return null;
            }
            String[] statusValidValues = new String[]{"pending", "active", "stopped", "suspended", "deleted", "ceased"};
            boolean statusIsValid = false;
            for (String v : statusValidValues) {
                Boolean statusIsRequired;
                if (v.equals(this.getStatus())) {
                    statusIsValid = true;
                }
                if (!(statusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getStatus() != null) continue;
                statusIsValid = true;
            }
            if (!statusIsValid) {
                throw new QCException("Status value " + this.getStatus() + "is invalid");
            }
            if (this.getTags() != null && this.getTags().size() > 0 && (i = 0) < this.getTags().size()) {
                return null;
            }
            String[] transitionStatusValidValues = new String[]{"creating", "starting", "stopping", "updating", "suspending", "resuming", "deleting"};
            boolean transitionStatusIsValid = false;
            for (String v : transitionStatusValidValues) {
                Boolean transitionStatusIsRequired;
                if (v.equals(this.getTransitionStatus())) {
                    transitionStatusIsValid = true;
                }
                if (!(transitionStatusIsRequired = Boolean.FALSE).equals(Boolean.FALSE) || this.getTransitionStatus() != null) continue;
                transitionStatusIsValid = true;
            }
            if (!transitionStatusIsValid) {
                throw new QCException("TransitionStatus value " + this.getTransitionStatus() + "is invalid");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AppVersionAttachmentModel
    implements ParamValidate {
        private String attachmentID;
        private String attachmentType;
        private String category;
        private String createTime;
        private String filename;
        private Integer filesize;
        private String name;
        private String owner;
        private String resourceID;
        private String resourceType;
        private String statusTime;
        private String subCategory;

        @JsonProperty(value="attachment_id")
        public void setAttachmentID(String attachmentID) {
            this.attachmentID = attachmentID;
        }

        @JsonProperty(value="attachment_id")
        public String getAttachmentID() {
            return this.attachmentID;
        }

        @JsonProperty(value="attachment_type")
        public void setAttachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
        }

        @JsonProperty(value="attachment_type")
        public String getAttachmentType() {
            return this.attachmentType;
        }

        @JsonProperty(value="category")
        public void setCategory(String category) {
            this.category = category;
        }

        @JsonProperty(value="category")
        public String getCategory() {
            return this.category;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="filename")
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @JsonProperty(value="filename")
        public String getFilename() {
            return this.filename;
        }

        @JsonProperty(value="filesize")
        public void setFilesize(Integer filesize) {
            this.filesize = filesize;
        }

        @JsonProperty(value="filesize")
        public Integer getFilesize() {
            return this.filesize;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="resource_id")
        public void setResourceID(String resourceID) {
            this.resourceID = resourceID;
        }

        @JsonProperty(value="resource_id")
        public String getResourceID() {
            return this.resourceID;
        }

        @JsonProperty(value="resource_type")
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @JsonProperty(value="resource_type")
        public String getResourceType() {
            return this.resourceType;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="sub_category")
        public void setSubCategory(String subCategory) {
            this.subCategory = subCategory;
        }

        @JsonProperty(value="sub_category")
        public String getSubCategory() {
            return this.subCategory;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AppVersionModel
    implements ParamValidate {
        private String appID;
        private String createTime;
        private String description;
        private String name;
        private String resourceKit;
        private String status;
        private String statusTime;
        private String versionID;

        @JsonProperty(value="app_id")
        public void setAppID(String appID) {
            this.appID = appID;
        }

        @JsonProperty(value="app_id")
        public String getAppID() {
            return this.appID;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="resource_kit")
        public void setResourceKit(String resourceKit) {
            this.resourceKit = resourceKit;
        }

        @JsonProperty(value="resource_kit")
        public String getResourceKit() {
            return this.resourceKit;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @JsonProperty(value="version_id")
        public void setVersionID(String versionID) {
            this.versionID = versionID;
        }

        @JsonProperty(value="version_id")
        public String getVersionID() {
            return this.versionID;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AppModel
    implements ParamValidate {
        private String abstraction;
        private String appContractStatus;
        private String appID;
        private String appInstanceID;
        private String appName;
        private String appType;
        private Integer authLevel;
        private String category;
        private String companyURL;
        private String contact;
        private String coverImg;
        private String description;
        private String icon;
        private List<String> screenshots;
        private String status;
        private List<String> tags;
        private String termsOfService;
        private String termsOfServiceLink;
        private String uRL;
        private String usageInstructions;
        private String usageInstructionsLink;
        private String visibility;
        private List<String> zones;

        @JsonProperty(value="abstraction")
        public void setAbstraction(String abstraction) {
            this.abstraction = abstraction;
        }

        @JsonProperty(value="abstraction")
        public String getAbstraction() {
            return this.abstraction;
        }

        @JsonProperty(value="app_contract_status")
        public void setAppContractStatus(String appContractStatus) {
            this.appContractStatus = appContractStatus;
        }

        @JsonProperty(value="app_contract_status")
        public String getAppContractStatus() {
            return this.appContractStatus;
        }

        @JsonProperty(value="app_id")
        public void setAppID(String appID) {
            this.appID = appID;
        }

        @JsonProperty(value="app_id")
        public String getAppID() {
            return this.appID;
        }

        @JsonProperty(value="app_instance_id")
        public void setAppInstanceID(String appInstanceID) {
            this.appInstanceID = appInstanceID;
        }

        @JsonProperty(value="app_instance_id")
        public String getAppInstanceID() {
            return this.appInstanceID;
        }

        @JsonProperty(value="app_name")
        public void setAppName(String appName) {
            this.appName = appName;
        }

        @JsonProperty(value="app_name")
        public String getAppName() {
            return this.appName;
        }

        @JsonProperty(value="app_type")
        public void setAppType(String appType) {
            this.appType = appType;
        }

        @JsonProperty(value="app_type")
        public String getAppType() {
            return this.appType;
        }

        @JsonProperty(value="auth_level")
        public void setAuthLevel(Integer authLevel) {
            this.authLevel = authLevel;
        }

        @JsonProperty(value="auth_level")
        public Integer getAuthLevel() {
            return this.authLevel;
        }

        @JsonProperty(value="category")
        public void setCategory(String category) {
            this.category = category;
        }

        @JsonProperty(value="category")
        public String getCategory() {
            return this.category;
        }

        @JsonProperty(value="company_url")
        public void setCompanyURL(String companyURL) {
            this.companyURL = companyURL;
        }

        @JsonProperty(value="company_url")
        public String getCompanyURL() {
            return this.companyURL;
        }

        @JsonProperty(value="contact")
        public void setContact(String contact) {
            this.contact = contact;
        }

        @JsonProperty(value="contact")
        public String getContact() {
            return this.contact;
        }

        @JsonProperty(value="cover_img")
        public void setCoverImg(String coverImg) {
            this.coverImg = coverImg;
        }

        @JsonProperty(value="cover_img")
        public String getCoverImg() {
            return this.coverImg;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="icon")
        public void setIcon(String icon) {
            this.icon = icon;
        }

        @JsonProperty(value="icon")
        public String getIcon() {
            return this.icon;
        }

        @JsonProperty(value="screenshots")
        public void setScreenshots(List<String> screenshots) {
            this.screenshots = screenshots;
        }

        @JsonProperty(value="screenshots")
        public List<String> getScreenshots() {
            return this.screenshots;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="tags")
        public List<String> getTags() {
            return this.tags;
        }

        @JsonProperty(value="terms_of_service")
        public void setTermsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
        }

        @JsonProperty(value="terms_of_service")
        public String getTermsOfService() {
            return this.termsOfService;
        }

        @JsonProperty(value="terms_of_service_link")
        public void setTermsOfServiceLink(String termsOfServiceLink) {
            this.termsOfServiceLink = termsOfServiceLink;
        }

        @JsonProperty(value="terms_of_service_link")
        public String getTermsOfServiceLink() {
            return this.termsOfServiceLink;
        }

        @JsonProperty(value="url")
        public void setURL(String uRL) {
            this.uRL = uRL;
        }

        @JsonProperty(value="url")
        public String getURL() {
            return this.uRL;
        }

        @JsonProperty(value="usage_instructions")
        public void setUsageInstructions(String usageInstructions) {
            this.usageInstructions = usageInstructions;
        }

        @JsonProperty(value="usage_instructions")
        public String getUsageInstructions() {
            return this.usageInstructions;
        }

        @JsonProperty(value="usage_instructions_link")
        public void setUsageInstructionsLink(String usageInstructionsLink) {
            this.usageInstructionsLink = usageInstructionsLink;
        }

        @JsonProperty(value="usage_instructions_link")
        public String getUsageInstructionsLink() {
            return this.usageInstructionsLink;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @JsonProperty(value="visibility")
        public String getVisibility() {
            return this.visibility;
        }

        @JsonProperty(value="zones")
        public void setZones(List<String> zones) {
            this.zones = zones;
        }

        @JsonProperty(value="zones")
        public List<String> getZones() {
            return this.zones;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AccessKeyModel
    implements ParamValidate {
        private String accessKeyID;
        private String accessKeyName;
        private String consoleID;
        private String controller;
        private String createTime;
        private String description;
        private String iPWhiteList;
        private String owner;
        private String rootUserID;
        private String secretAccessKey;
        private String status;
        private String statusTime;

        @JsonProperty(value="access_key_id")
        public void setAccessKeyID(String accessKeyID) {
            this.accessKeyID = accessKeyID;
        }

        @JsonProperty(value="access_key_id")
        public String getAccessKeyID() {
            return this.accessKeyID;
        }

        @JsonProperty(value="access_key_name")
        public void setAccessKeyName(String accessKeyName) {
            this.accessKeyName = accessKeyName;
        }

        @JsonProperty(value="access_key_name")
        public String getAccessKeyName() {
            return this.accessKeyName;
        }

        @JsonProperty(value="console_id")
        public void setConsoleID(String consoleID) {
            this.consoleID = consoleID;
        }

        @JsonProperty(value="console_id")
        public String getConsoleID() {
            return this.consoleID;
        }

        @JsonProperty(value="controller")
        public void setController(String controller) {
            this.controller = controller;
        }

        @JsonProperty(value="controller")
        public String getController() {
            return this.controller;
        }

        @JsonProperty(value="create_time")
        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @JsonProperty(value="create_time")
        public String getCreateTime() {
            return this.createTime;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="ip_white_list")
        public void setIPWhiteList(String iPWhiteList) {
            this.iPWhiteList = iPWhiteList;
        }

        @JsonProperty(value="ip_white_list")
        public String getIPWhiteList() {
            return this.iPWhiteList;
        }

        @JsonProperty(value="owner")
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @JsonProperty(value="owner")
        public String getOwner() {
            return this.owner;
        }

        @JsonProperty(value="root_user_id")
        public void setRootUserID(String rootUserID) {
            this.rootUserID = rootUserID;
        }

        @JsonProperty(value="root_user_id")
        public String getRootUserID() {
            return this.rootUserID;
        }

        @JsonProperty(value="secret_access_key")
        public void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @JsonProperty(value="secret_access_key")
        public String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @JsonProperty(value="status_time")
        public void setStatusTime(String statusTime) {
            this.statusTime = statusTime;
        }

        @JsonProperty(value="status_time")
        public String getStatusTime() {
            return this.statusTime;
        }

        @Override
        public String validateParam() throws QCException {
            return null;
        }
    }

    public class Model {
    }
}

