/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.IaasParamBody;
import com.qingcloud.sdk.model.OutputModel;
import com.qingcloud.sdk.request.ResourceRequestFactory;
import com.qingcloud.sdk.request.ResponseCallBack;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.util.HashMap;

public class UserDataService {
    private EnvContext envContext;
    private String zone;

    public UserDataService(EnvContext envContext) {
        this.envContext = envContext;
    }

    public UserDataService(EnvContext envContext, String zone) {
        this.envContext = envContext;
        this.zone = zone;
    }

    public UploadUserDataAttachmentOutput uploadUserDataAttachment(UploadUserDataAttachmentInput input) throws QCException {
        if (input == null) {
            input = new UploadUserDataAttachmentInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UploadUserDataAttachment");
        context.put("APIName", "UploadUserDataAttachment");
        context.put("ServiceName", "UploadUserDataAttachment");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/iaas/UploadUserDataAttachment");
        input.setAction("UploadUserDataAttachment");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(context, input, UploadUserDataAttachmentOutput.class);
        if (backModel != null) {
            return (UploadUserDataAttachmentOutput)backModel;
        }
        return null;
    }

    public void uploadUserDataAttachment(UploadUserDataAttachmentInput input, ResponseCallBack<UploadUserDataAttachmentOutput> callback) throws QCException {
        if (input == null) {
            input = new UploadUserDataAttachmentInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("envContext", this.envContext);
        context.put("OperationName", "UploadUserDataAttachment");
        context.put("APIName", "UploadUserDataAttachment");
        context.put("ServiceName", "UploadUserDataAttachment");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/iaas/UploadUserDataAttachment");
        input.setAction("UploadUserDataAttachment");
        if (QCStringUtil.isEmpty(this.zone)) {
            input.setZone(this.envContext.getZone());
        } else {
            input.setZone(this.zone);
        }
        if (callback == null) {
            throw new QCException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(context, input, callback);
    }

    public static class UploadUserDataAttachmentInput
    extends IaasParamBody {
        private String attachmentContent;
        private String attachmentName;

        @JsonProperty(value="attachment_content")
        public void setAttachmentContent(String attachmentContent) {
            this.attachmentContent = attachmentContent;
        }

        @JsonProperty(value="attachment_content")
        public String getAttachmentContent() {
            return this.attachmentContent;
        }

        @JsonProperty(value="attachment_name")
        public void setAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
        }

        @JsonProperty(value="attachment_name")
        public String getAttachmentName() {
            return this.attachmentName;
        }

        @Override
        public String validateParam() throws QCException {
            if (QCStringUtil.isEmpty(this.getAttachmentContent())) {
                throw new QCException("AttachmentContent is required");
            }
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UploadUserDataAttachmentOutput
    extends OutputModel {
        private String action;
        private String attachmentID;
        private Integer retCode;

        @JsonProperty(value="action")
        public void setAction(String action) {
            this.action = action;
        }

        @JsonProperty(value="action")
        public String getAction() {
            return this.action;
        }

        @JsonProperty(value="attachment_id")
        public void setAttachmentID(String attachmentID) {
            this.attachmentID = attachmentID;
        }

        @JsonProperty(value="attachment_id")
        public String getAttachmentID() {
            return this.attachmentID;
        }

        @Override
        @JsonProperty(value="ret_code")
        public void setRetCode(Integer retCode) {
            this.retCode = retCode;
        }

        @Override
        @JsonProperty(value="ret_code")
        public Integer getRetCode() {
            return this.retCode;
        }
    }
}

