/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qingcloud.sdk.config.EnvContext;
import com.qingcloud.sdk.exception.QCException;
import com.qingcloud.sdk.model.RequestInputModel;
import com.qingcloud.sdk.utils.QCSignatureUtil;
import com.qingcloud.sdk.utils.QCStringUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class QCJSONUtil {
    private static final List<Class> PRIMITIVE_TYPES = new ArrayList<Class>(Arrays.asList(Boolean.class, String.class, Integer.class, Double.class, Long.class, Float.class, null, BigDecimal.class));

    public static String parseRequestParams(RequestInputModel inputModel, EnvContext envContext, String httpMethod) throws QCException {
        ObjectMapper oMapper = new ObjectMapper();
        Map parameters = (Map)oMapper.convertValue((Object)inputModel, Map.class);
        parameters.put("version", "1");
        parameters.put("signature_version", "1");
        parameters.put("signature_method", "HmacSHA256");
        parameters.put("access_key_id", envContext.getAccessKey());
        parameters.put("api_lang", envContext.getApiLang());
        parameters.put("time_stamp", QCSignatureUtil.formatIso8601Date(new Date()));
        if (envContext.getUri().equals("iam")) {
            parameters.put("token", envContext.getToken());
        }
        String uri = null;
        StringBuilder sbUri = new StringBuilder();
        Object[] keys = parameters.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        try {
            for (Object key : keys) {
                String encodedVal;
                String encodedKey;
                Object value = parameters.get(key);
                if (value == null) continue;
                if (PRIMITIVE_TYPES.contains(value.getClass())) {
                    String valueStr = String.valueOf(value);
                    encodedKey = QCStringUtil.percentEncode((String)key, "UTF-8");
                    encodedVal = QCStringUtil.percentEncode(valueStr, "UTF-8");
                    sbUri.append(encodedKey).append("=").append(encodedVal).append("&");
                    continue;
                }
                if (value instanceof List) {
                    int i;
                    int count = ((List)value).size();
                    ArrayList<String> listKeys = new ArrayList<String>();
                    for (i = 0; i < count; ++i) {
                        encodedKey = QCStringUtil.percentEncode(String.format("%s.%d", key, i + 1), "UTF-8");
                        listKeys.add(encodedKey);
                    }
                    Collections.sort(listKeys);
                    for (i = 0; i < count; ++i) {
                        encodedKey = (String)listKeys.get(i);
                        Object item = ((List)value).get(i);
                        if (item instanceof String) {
                            String itemStr = (String)item;
                            encodedVal = QCStringUtil.percentEncode(itemStr, "UTF-8");
                            sbUri.append(encodedKey).append("=").append(encodedVal).append("&");
                            continue;
                        }
                        if (item instanceof Map) {
                            for (Object itemKey : ((Map)item).keySet()) {
                                String deepEncodedKey = String.format("%s.%s", encodedKey, QCStringUtil.percentEncode((String)itemKey, "UTF-8"));
                                Object deepItem = ((Map)item).get(itemKey);
                                String deepItemStr = deepItem instanceof String ? (String)deepItem : oMapper.writeValueAsString(deepItem);
                                encodedVal = QCStringUtil.percentEncode(deepItemStr, "UTF-8");
                                sbUri.append(deepEncodedKey).append("=").append(encodedVal).append("&");
                            }
                            continue;
                        }
                        throw new QCException(String.format("Failed to parse input model: %s!", oMapper.writeValueAsString((Object)inputModel)));
                    }
                    continue;
                }
                throw new QCException(String.format("Failed to parse input model: %s!", oMapper.writeValueAsString((Object)inputModel)));
            }
            String tmp = sbUri.toString();
            String uriNotSigned = tmp.substring(0, tmp.length() - 1);
            String signature = QCSignatureUtil.computeIaasSignature(httpMethod, envContext.getUri(), uriNotSigned, envContext.getAccessSecret());
            uri = String.format("%s&signature=%s", uriNotSigned, signature);
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return uri;
    }
}

