/*
 * Decompiled with CFR 0.152.
 */
package com.qingcloud.sdk.utils;

import com.qingcloud.sdk.exception.QCException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

class QCSignatureUtil {
    private static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    QCSignatureUtil() {
    }

    static String computeIaasSignature(String httpMethod, String endPoint, String uri, String accSecret) {
        String strToSign = String.format("%s\n/%s/\n%s", httpMethod, endPoint, uri);
        String signature = "";
        try {
            signature = QCSignatureUtil.calculateSignature(accSecret, strToSign);
        }
        catch (QCException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }

    static String formatIso8601Date(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date);
    }

    private static String calculateSignature(String secret, String stringToSign) throws UnsupportedEncodingException, QCException {
        String ALGORITHM = "HmacSHA256";
        byte[] signData = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256"));
            signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] base64Encoded = Base64.encodeBase64(signData);
        if (base64Encoded == null) {
            throw new QCException("no signature generated!");
        }
        return URLEncoder.encode(new String(base64Encoded, "UTF-8"), "UTF-8");
    }
}

