/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client;

import com.quantumdmn.client.ApiException;
import com.quantumdmn.client.DmnService;
import com.quantumdmn.client.api.DefaultApi;
import com.quantumdmn.client.model.EvaluateStoredRequest;
import com.quantumdmn.client.model.EvaluationResult;
import com.quantumdmn.client.model.FeelValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DmnEngine {
    private final DefaultApi api;
    private final UUID projectId;

    public DmnEngine(DmnService service, String projectId) {
        this.api = service.getApi();
        this.projectId = UUID.fromString(projectId);
    }

    public DmnEngine(String baseUrl, String token, String projectId) {
        this(new DmnService(baseUrl, () -> token), projectId);
    }

    public Map<String, EvaluationResult> evaluate(String xmlId, Map<String, Object> evaluationContext, EvaluateOption ... options) throws ApiException {
        EvaluateConfig config = new EvaluateConfig();
        for (EvaluateOption option : options) {
            option.apply(config);
        }
        EvaluateStoredRequest request = new EvaluateStoredRequest();
        HashMap<String, FeelValue> feelCtx = new HashMap<String, FeelValue>();
        if (evaluationContext != null) {
            for (Map.Entry<String, Object> entry : evaluationContext.entrySet()) {
                feelCtx.put(entry.getKey(), FeelValue.fromRaw(entry.getValue()));
            }
        }
        request.setContext(feelCtx);
        if (config.businessId != null) {
            request.setBusinessId(config.businessId);
        }
        return this.api.evaluateByXMLID(this.projectId, xmlId, request, config.version);
    }

    public static EvaluateOption withVersion(int version) {
        return config -> {
            config.version = version;
        };
    }

    public static EvaluateOption withBusinessId(String businessId) {
        return config -> {
            config.businessId = businessId;
        };
    }

    private static class EvaluateConfig {
        Integer version = null;
        String businessId = null;

        private EvaluateConfig() {
        }
    }

    @FunctionalInterface
    public static interface EvaluateOption {
        public void apply(EvaluateConfig var1);
    }
}

