/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client;

import com.quantumdmn.client.ApiClient;
import com.quantumdmn.client.api.DefaultApi;
import java.net.http.HttpRequest;
import java.util.function.Supplier;

public class DmnService {
    private final String baseUrl;
    private final Supplier<String> tokenProvider;
    private ApiClient apiClient;
    private DefaultApi api;

    public DmnService(String baseUrl, Supplier<String> tokenProvider) {
        this.baseUrl = baseUrl;
        this.tokenProvider = tokenProvider;
        this.initializeClient();
    }

    public DmnService(String baseUrl, String token) {
        this(baseUrl, () -> token);
    }

    private void initializeClient() {
        this.apiClient = new ApiClient();
        this.apiClient.updateBaseUri(this.baseUrl);
        this.apiClient.setRequestInterceptor(this::addAuthHeader);
        this.api = new DefaultApi(this.apiClient);
    }

    private HttpRequest.Builder addAuthHeader(HttpRequest.Builder builder) {
        String token = this.tokenProvider.get();
        return builder.header("Authorization", "Bearer " + token);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public DefaultApi getApi() {
        return this.api;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

