/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.quantumdmn.client.ApiClient;
import com.quantumdmn.client.ApiException;
import com.quantumdmn.client.ApiResponse;
import com.quantumdmn.client.Pair;
import com.quantumdmn.client.model.AddProjectMemberRequest;
import com.quantumdmn.client.model.BatchEvaluateDesignRequest;
import com.quantumdmn.client.model.BatchEvaluationResponse;
import com.quantumdmn.client.model.BatchGetUsersRequest;
import com.quantumdmn.client.model.CreateDefinitionRequest;
import com.quantumdmn.client.model.CreateProjectRequest;
import com.quantumdmn.client.model.CreateSubscriptionUpgradeTransaction200Response;
import com.quantumdmn.client.model.CreateSubscriptionUpgradeTransactionRequest;
import com.quantumdmn.client.model.Definition;
import com.quantumdmn.client.model.EvaluateDesignRequest;
import com.quantumdmn.client.model.EvaluateStoredRequest;
import com.quantumdmn.client.model.EvaluationResult;
import com.quantumdmn.client.model.Execution;
import com.quantumdmn.client.model.FrontendConfig;
import com.quantumdmn.client.model.GetCustomerPortalSession200Response;
import com.quantumdmn.client.model.GetHealth200Response;
import com.quantumdmn.client.model.GetVersion200Response;
import com.quantumdmn.client.model.OrganizationUser;
import com.quantumdmn.client.model.OverviewResponse;
import com.quantumdmn.client.model.PaginatedDefinitionsResponse;
import com.quantumdmn.client.model.PaginatedExecutionsResponse;
import com.quantumdmn.client.model.Project;
import com.quantumdmn.client.model.ProjectMember;
import com.quantumdmn.client.model.Quota;
import com.quantumdmn.client.model.SimulationRequest;
import com.quantumdmn.client.model.SimulationResponse;
import com.quantumdmn.client.model.Tier;
import com.quantumdmn.client.model.UpdateCustomerSettingsRequest;
import com.quantumdmn.client.model.UpdateDefinitionRequest;
import com.quantumdmn.client.model.UpdateProjectMemberRoleRequest;
import com.quantumdmn.client.model.UserPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;

public class DefaultApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public DefaultApi() {
        this(new ApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public ProjectMember addProjectMember(UUID projectID, AddProjectMemberRequest addProjectMemberRequest) throws ApiException {
        ApiResponse<ProjectMember> localVarResponse = this.addProjectMemberWithHttpInfo(projectID, addProjectMemberRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ProjectMember> addProjectMemberWithHttpInfo(UUID projectID, AddProjectMemberRequest addProjectMemberRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.addProjectMemberRequestBuilder(projectID, addProjectMemberRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("addProjectMember", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ProjectMember)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ProjectMember>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder addProjectMemberRequestBuilder(UUID projectID, AddProjectMemberRequest addProjectMemberRequest) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling addProjectMember");
        }
        if (addProjectMemberRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'addProjectMemberRequest' when calling addProjectMember");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/members".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)addProjectMemberRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<OrganizationUser> batchGetUsers(BatchGetUsersRequest batchGetUsersRequest) throws ApiException {
        ApiResponse<List<OrganizationUser>> localVarResponse = this.batchGetUsersWithHttpInfo(batchGetUsersRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<List<OrganizationUser>> batchGetUsersWithHttpInfo(BatchGetUsersRequest batchGetUsersRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.batchGetUsersRequestBuilder(batchGetUsersRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("batchGetUsers", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<OrganizationUser>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder batchGetUsersRequestBuilder(BatchGetUsersRequest batchGetUsersRequest) throws ApiException {
        if (batchGetUsersRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'batchGetUsersRequest' when calling batchGetUsers");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/users/batch";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)batchGetUsersRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Definition createDefinition(UUID projectID, CreateDefinitionRequest createDefinitionRequest) throws ApiException {
        ApiResponse<Definition> localVarResponse = this.createDefinitionWithHttpInfo(projectID, createDefinitionRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<Definition> createDefinitionWithHttpInfo(UUID projectID, CreateDefinitionRequest createDefinitionRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createDefinitionRequestBuilder(projectID, createDefinitionRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createDefinition", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Definition)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Definition>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createDefinitionRequestBuilder(UUID projectID, CreateDefinitionRequest createDefinitionRequest) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling createDefinition");
        }
        if (createDefinitionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createDefinitionRequest' when calling createDefinition");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createDefinitionRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Project createProject(CreateProjectRequest createProjectRequest) throws ApiException {
        ApiResponse<Project> localVarResponse = this.createProjectWithHttpInfo(createProjectRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<Project> createProjectWithHttpInfo(CreateProjectRequest createProjectRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createProjectRequestBuilder(createProjectRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createProject", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Project)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Project>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createProjectRequestBuilder(CreateProjectRequest createProjectRequest) throws ApiException {
        if (createProjectRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createProjectRequest' when calling createProject");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createProjectRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CreateSubscriptionUpgradeTransaction200Response createSubscriptionUpgradeTransaction(CreateSubscriptionUpgradeTransactionRequest createSubscriptionUpgradeTransactionRequest) throws ApiException {
        ApiResponse<CreateSubscriptionUpgradeTransaction200Response> localVarResponse = this.createSubscriptionUpgradeTransactionWithHttpInfo(createSubscriptionUpgradeTransactionRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<CreateSubscriptionUpgradeTransaction200Response> createSubscriptionUpgradeTransactionWithHttpInfo(CreateSubscriptionUpgradeTransactionRequest createSubscriptionUpgradeTransactionRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createSubscriptionUpgradeTransactionRequestBuilder(createSubscriptionUpgradeTransactionRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createSubscriptionUpgradeTransaction", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (CreateSubscriptionUpgradeTransaction200Response)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<CreateSubscriptionUpgradeTransaction200Response>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createSubscriptionUpgradeTransactionRequestBuilder(CreateSubscriptionUpgradeTransactionRequest createSubscriptionUpgradeTransactionRequest) throws ApiException {
        if (createSubscriptionUpgradeTransactionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createSubscriptionUpgradeTransactionRequest' when calling createSubscriptionUpgradeTransaction");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/billing/upgrade-transaction";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createSubscriptionUpgradeTransactionRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void deleteDefinition(UUID projectID, UUID definitionID) throws ApiException {
        this.deleteDefinitionWithHttpInfo(projectID, definitionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> deleteDefinitionWithHttpInfo(UUID projectID, UUID definitionID) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.deleteDefinitionRequestBuilder(projectID, definitionID);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteDefinition", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder deleteDefinitionRequestBuilder(UUID projectID, UUID definitionID) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling deleteDefinition");
        }
        if (definitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'definitionID' when calling deleteDefinition");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/{definitionID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{definitionID}", ApiClient.urlEncode(definitionID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void deleteProject(UUID projectID) throws ApiException {
        this.deleteProjectWithHttpInfo(projectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> deleteProjectWithHttpInfo(UUID projectID) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.deleteProjectRequestBuilder(projectID);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteProject", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder deleteProjectRequestBuilder(UUID projectID) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling deleteProject");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Map<String, EvaluationResult> evaluateByXMLID(UUID projectID, String xmlDefinitionID, EvaluateStoredRequest evaluateStoredRequest, Integer version) throws ApiException {
        ApiResponse<Map<String, EvaluationResult>> localVarResponse = this.evaluateByXMLIDWithHttpInfo(projectID, xmlDefinitionID, evaluateStoredRequest, version);
        return localVarResponse.getData();
    }

    public ApiResponse<Map<String, EvaluationResult>> evaluateByXMLIDWithHttpInfo(UUID projectID, String xmlDefinitionID, EvaluateStoredRequest evaluateStoredRequest, Integer version) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.evaluateByXMLIDRequestBuilder(projectID, xmlDefinitionID, evaluateStoredRequest, version);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("evaluateByXMLID", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Map)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Map<String, EvaluationResult>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder evaluateByXMLIDRequestBuilder(UUID projectID, String xmlDefinitionID, EvaluateStoredRequest evaluateStoredRequest, Integer version) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling evaluateByXMLID");
        }
        if (xmlDefinitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'xmlDefinitionID' when calling evaluateByXMLID");
        }
        if (evaluateStoredRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'evaluateStoredRequest' when calling evaluateByXMLID");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/by-xml-id/{xmlDefinitionID}/evaluate".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{xmlDefinitionID}", ApiClient.urlEncode(xmlDefinitionID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "version";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("version", version));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)evaluateStoredRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Map<String, EvaluationResult> evaluateDesign(EvaluateDesignRequest evaluateDesignRequest) throws ApiException {
        ApiResponse<Map<String, EvaluationResult>> localVarResponse = this.evaluateDesignWithHttpInfo(evaluateDesignRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<Map<String, EvaluationResult>> evaluateDesignWithHttpInfo(EvaluateDesignRequest evaluateDesignRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.evaluateDesignRequestBuilder(evaluateDesignRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("evaluateDesign", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Map)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Map<String, EvaluationResult>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder evaluateDesignRequestBuilder(EvaluateDesignRequest evaluateDesignRequest) throws ApiException {
        if (evaluateDesignRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'evaluateDesignRequest' when calling evaluateDesign");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/evaluate/design";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)evaluateDesignRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public BatchEvaluationResponse evaluateDesignBatch(BatchEvaluateDesignRequest batchEvaluateDesignRequest) throws ApiException {
        ApiResponse<BatchEvaluationResponse> localVarResponse = this.evaluateDesignBatchWithHttpInfo(batchEvaluateDesignRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<BatchEvaluationResponse> evaluateDesignBatchWithHttpInfo(BatchEvaluateDesignRequest batchEvaluateDesignRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.evaluateDesignBatchRequestBuilder(batchEvaluateDesignRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("evaluateDesignBatch", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (BatchEvaluationResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<BatchEvaluationResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder evaluateDesignBatchRequestBuilder(BatchEvaluateDesignRequest batchEvaluateDesignRequest) throws ApiException {
        if (batchEvaluateDesignRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'batchEvaluateDesignRequest' when calling evaluateDesignBatch");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/evaluate/design/batch";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)batchEvaluateDesignRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Map<String, EvaluationResult> evaluateStored(UUID projectID, UUID definitionID, EvaluateStoredRequest evaluateStoredRequest) throws ApiException {
        ApiResponse<Map<String, EvaluationResult>> localVarResponse = this.evaluateStoredWithHttpInfo(projectID, definitionID, evaluateStoredRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<Map<String, EvaluationResult>> evaluateStoredWithHttpInfo(UUID projectID, UUID definitionID, EvaluateStoredRequest evaluateStoredRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.evaluateStoredRequestBuilder(projectID, definitionID, evaluateStoredRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("evaluateStored", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Map)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Map<String, EvaluationResult>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder evaluateStoredRequestBuilder(UUID projectID, UUID definitionID, EvaluateStoredRequest evaluateStoredRequest) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling evaluateStored");
        }
        if (definitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'definitionID' when calling evaluateStored");
        }
        if (evaluateStoredRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'evaluateStoredRequest' when calling evaluateStored");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/{definitionID}/evaluate".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{definitionID}", ApiClient.urlEncode(definitionID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)evaluateStoredRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public GetCustomerPortalSession200Response getCustomerPortalSession() throws ApiException {
        ApiResponse<GetCustomerPortalSession200Response> localVarResponse = this.getCustomerPortalSessionWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<GetCustomerPortalSession200Response> getCustomerPortalSessionWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCustomerPortalSessionRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCustomerPortalSession", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (GetCustomerPortalSession200Response)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<GetCustomerPortalSession200Response>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCustomerPortalSessionRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/subscription/portal-session";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Definition getDefinition(UUID projectID, UUID definitionID) throws ApiException {
        ApiResponse<Definition> localVarResponse = this.getDefinitionWithHttpInfo(projectID, definitionID);
        return localVarResponse.getData();
    }

    public ApiResponse<Definition> getDefinitionWithHttpInfo(UUID projectID, UUID definitionID) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getDefinitionRequestBuilder(projectID, definitionID);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getDefinition", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Definition)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Definition>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getDefinitionRequestBuilder(UUID projectID, UUID definitionID) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling getDefinition");
        }
        if (definitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'definitionID' when calling getDefinition");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/{definitionID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{definitionID}", ApiClient.urlEncode(definitionID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Definition getDefinitionByXMLID(UUID projectID, String xmlDefinitionID, Integer version) throws ApiException {
        ApiResponse<Definition> localVarResponse = this.getDefinitionByXMLIDWithHttpInfo(projectID, xmlDefinitionID, version);
        return localVarResponse.getData();
    }

    public ApiResponse<Definition> getDefinitionByXMLIDWithHttpInfo(UUID projectID, String xmlDefinitionID, Integer version) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getDefinitionByXMLIDRequestBuilder(projectID, xmlDefinitionID, version);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getDefinitionByXMLID", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Definition)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Definition>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getDefinitionByXMLIDRequestBuilder(UUID projectID, String xmlDefinitionID, Integer version) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling getDefinitionByXMLID");
        }
        if (xmlDefinitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'xmlDefinitionID' when calling getDefinitionByXMLID");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/by-xml-id/{xmlDefinitionID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{xmlDefinitionID}", ApiClient.urlEncode(xmlDefinitionID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "version";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("version", version));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Execution getExecution(UUID projectID, UUID executionID) throws ApiException {
        ApiResponse<Execution> localVarResponse = this.getExecutionWithHttpInfo(projectID, executionID);
        return localVarResponse.getData();
    }

    public ApiResponse<Execution> getExecutionWithHttpInfo(UUID projectID, UUID executionID) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getExecutionRequestBuilder(projectID, executionID);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getExecution", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Execution)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Execution>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getExecutionRequestBuilder(UUID projectID, UUID executionID) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling getExecution");
        }
        if (executionID == null) {
            throw new ApiException(400, "Missing the required parameter 'executionID' when calling getExecution");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/executions/{executionID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{executionID}", ApiClient.urlEncode(executionID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public FrontendConfig getFrontendConfig() throws ApiException {
        ApiResponse<FrontendConfig> localVarResponse = this.getFrontendConfigWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<FrontendConfig> getFrontendConfigWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getFrontendConfigRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getFrontendConfig", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (FrontendConfig)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<FrontendConfig>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getFrontendConfigRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/config";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public GetHealth200Response getHealth() throws ApiException {
        ApiResponse<GetHealth200Response> localVarResponse = this.getHealthWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<GetHealth200Response> getHealthWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getHealthRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getHealth", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (GetHealth200Response)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<GetHealth200Response>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getHealthRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/health";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Quota getLimits() throws ApiException {
        ApiResponse<Quota> localVarResponse = this.getLimitsWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<Quota> getLimitsWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getLimitsRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getLimits", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Quota)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Quota>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getLimitsRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/limits";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public OverviewResponse getOverview() throws ApiException {
        ApiResponse<OverviewResponse> localVarResponse = this.getOverviewWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<OverviewResponse> getOverviewWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getOverviewRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getOverview", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (OverviewResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<OverviewResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getOverviewRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/overview";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Project getProject(UUID projectID) throws ApiException {
        ApiResponse<Project> localVarResponse = this.getProjectWithHttpInfo(projectID);
        return localVarResponse.getData();
    }

    public ApiResponse<Project> getProjectWithHttpInfo(UUID projectID) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getProjectRequestBuilder(projectID);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getProject", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Project)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Project>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getProjectRequestBuilder(UUID projectID) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling getProject");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Tier getTier(String tierID) throws ApiException {
        ApiResponse<Tier> localVarResponse = this.getTierWithHttpInfo(tierID);
        return localVarResponse.getData();
    }

    public ApiResponse<Tier> getTierWithHttpInfo(String tierID) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getTierRequestBuilder(tierID);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getTier", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Tier)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Tier>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getTierRequestBuilder(String tierID) throws ApiException {
        if (tierID == null) {
            throw new ApiException(400, "Missing the required parameter 'tierID' when calling getTier");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/tiers/{tierID}".replace("{tierID}", ApiClient.urlEncode(tierID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UserPermissions getUserPermissions() throws ApiException {
        ApiResponse<UserPermissions> localVarResponse = this.getUserPermissionsWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<UserPermissions> getUserPermissionsWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getUserPermissionsRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getUserPermissions", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UserPermissions)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UserPermissions>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getUserPermissionsRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/permissions";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public GetVersion200Response getVersion() throws ApiException {
        ApiResponse<GetVersion200Response> localVarResponse = this.getVersionWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<GetVersion200Response> getVersionWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getVersionRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getVersion", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (GetVersion200Response)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<GetVersion200Response>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getVersionRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/version";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PaginatedDefinitionsResponse listDefinitionVersions(UUID projectID, String definitionId, Integer page, Integer pageSize) throws ApiException {
        ApiResponse<PaginatedDefinitionsResponse> localVarResponse = this.listDefinitionVersionsWithHttpInfo(projectID, definitionId, page, pageSize);
        return localVarResponse.getData();
    }

    public ApiResponse<PaginatedDefinitionsResponse> listDefinitionVersionsWithHttpInfo(UUID projectID, String definitionId, Integer page, Integer pageSize) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listDefinitionVersionsRequestBuilder(projectID, definitionId, page, pageSize);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listDefinitionVersions", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (PaginatedDefinitionsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<PaginatedDefinitionsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listDefinitionVersionsRequestBuilder(UUID projectID, String definitionId, Integer page, Integer pageSize) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling listDefinitionVersions");
        }
        if (definitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'definitionId' when calling listDefinitionVersions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/by-definition-id/{definitionId}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{definitionId}", ApiClient.urlEncode(definitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PaginatedDefinitionsResponse listDefinitions(UUID projectID, Integer page, Integer pageSize) throws ApiException {
        ApiResponse<PaginatedDefinitionsResponse> localVarResponse = this.listDefinitionsWithHttpInfo(projectID, page, pageSize);
        return localVarResponse.getData();
    }

    public ApiResponse<PaginatedDefinitionsResponse> listDefinitionsWithHttpInfo(UUID projectID, Integer page, Integer pageSize) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listDefinitionsRequestBuilder(projectID, page, pageSize);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listDefinitions", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (PaginatedDefinitionsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<PaginatedDefinitionsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listDefinitionsRequestBuilder(UUID projectID, Integer page, Integer pageSize) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling listDefinitions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PaginatedExecutionsResponse listExecutions(UUID projectID, UUID definitionID, String xmlDefinitionId, OffsetDateTime startDate, Integer page, Integer pageSize) throws ApiException {
        ApiResponse<PaginatedExecutionsResponse> localVarResponse = this.listExecutionsWithHttpInfo(projectID, definitionID, xmlDefinitionId, startDate, page, pageSize);
        return localVarResponse.getData();
    }

    public ApiResponse<PaginatedExecutionsResponse> listExecutionsWithHttpInfo(UUID projectID, UUID definitionID, String xmlDefinitionId, OffsetDateTime startDate, Integer page, Integer pageSize) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listExecutionsRequestBuilder(projectID, definitionID, xmlDefinitionId, startDate, page, pageSize);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listExecutions", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (PaginatedExecutionsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<PaginatedExecutionsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listExecutionsRequestBuilder(UUID projectID, UUID definitionID, String xmlDefinitionId, OffsetDateTime startDate, Integer page, Integer pageSize) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling listExecutions");
        }
        if (definitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'definitionID' when calling listExecutions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/{definitionID}/executions".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{definitionID}", ApiClient.urlEncode(definitionID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "xmlDefinitionId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("xmlDefinitionId", xmlDefinitionId));
        localVarQueryParameterBaseName = "start_date";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("start_date", startDate));
        localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PaginatedDefinitionsResponse listLatestDefinitions(UUID projectID, Integer page, Integer pageSize) throws ApiException {
        ApiResponse<PaginatedDefinitionsResponse> localVarResponse = this.listLatestDefinitionsWithHttpInfo(projectID, page, pageSize);
        return localVarResponse.getData();
    }

    public ApiResponse<PaginatedDefinitionsResponse> listLatestDefinitionsWithHttpInfo(UUID projectID, Integer page, Integer pageSize) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listLatestDefinitionsRequestBuilder(projectID, page, pageSize);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listLatestDefinitions", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (PaginatedDefinitionsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<PaginatedDefinitionsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listLatestDefinitionsRequestBuilder(UUID projectID, Integer page, Integer pageSize) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling listLatestDefinitions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/latest".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PaginatedExecutionsResponse listProjectExecutions(UUID projectID, String xmlDefinitionId, Integer page, Integer pageSize) throws ApiException {
        ApiResponse<PaginatedExecutionsResponse> localVarResponse = this.listProjectExecutionsWithHttpInfo(projectID, xmlDefinitionId, page, pageSize);
        return localVarResponse.getData();
    }

    public ApiResponse<PaginatedExecutionsResponse> listProjectExecutionsWithHttpInfo(UUID projectID, String xmlDefinitionId, Integer page, Integer pageSize) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listProjectExecutionsRequestBuilder(projectID, xmlDefinitionId, page, pageSize);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listProjectExecutions", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (PaginatedExecutionsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<PaginatedExecutionsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listProjectExecutionsRequestBuilder(UUID projectID, String xmlDefinitionId, Integer page, Integer pageSize) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling listProjectExecutions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/executions".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "xmlDefinitionId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("xmlDefinitionId", xmlDefinitionId));
        localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "pageSize";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("pageSize", pageSize));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<ProjectMember> listProjectMembers(UUID projectID) throws ApiException {
        ApiResponse<List<ProjectMember>> localVarResponse = this.listProjectMembersWithHttpInfo(projectID);
        return localVarResponse.getData();
    }

    public ApiResponse<List<ProjectMember>> listProjectMembersWithHttpInfo(UUID projectID) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listProjectMembersRequestBuilder(projectID);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listProjectMembers", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<ProjectMember>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listProjectMembersRequestBuilder(UUID projectID) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling listProjectMembers");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/members".replace("{projectID}", ApiClient.urlEncode(projectID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<Project> listProjects() throws ApiException {
        ApiResponse<List<Project>> localVarResponse = this.listProjectsWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<List<Project>> listProjectsWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listProjectsRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listProjects", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Project>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listProjectsRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<Tier> listTiers() throws ApiException {
        ApiResponse<List<Tier>> localVarResponse = this.listTiersWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<List<Tier>> listTiersWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listTiersRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listTiers", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Tier>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listTiersRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/tiers";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<OrganizationUser> listUsers(String search) throws ApiException {
        ApiResponse<List<OrganizationUser>> localVarResponse = this.listUsersWithHttpInfo(search);
        return localVarResponse.getData();
    }

    public ApiResponse<List<OrganizationUser>> listUsersWithHttpInfo(String search) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listUsersRequestBuilder(search);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listUsers", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<OrganizationUser>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listUsersRequestBuilder(String search) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "search";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("search", search));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void removeProjectMember(UUID projectID, String userID) throws ApiException {
        this.removeProjectMemberWithHttpInfo(projectID, userID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> removeProjectMemberWithHttpInfo(UUID projectID, String userID) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.removeProjectMemberRequestBuilder(projectID, userID);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("removeProjectMember", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder removeProjectMemberRequestBuilder(UUID projectID, String userID) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling removeProjectMember");
        }
        if (userID == null) {
            throw new ApiException(400, "Missing the required parameter 'userID' when calling removeProjectMember");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/members/{userID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{userID}", ApiClient.urlEncode(userID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public SimulationResponse runSimulation(UUID projectID, UUID definitionID, SimulationRequest simulationRequest) throws ApiException {
        ApiResponse<SimulationResponse> localVarResponse = this.runSimulationWithHttpInfo(projectID, definitionID, simulationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<SimulationResponse> runSimulationWithHttpInfo(UUID projectID, UUID definitionID, SimulationRequest simulationRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.runSimulationRequestBuilder(projectID, definitionID, simulationRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("runSimulation", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (SimulationResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<SimulationResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder runSimulationRequestBuilder(UUID projectID, UUID definitionID, SimulationRequest simulationRequest) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling runSimulation");
        }
        if (definitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'definitionID' when calling runSimulation");
        }
        if (simulationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'simulationRequest' when calling runSimulation");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/{definitionID}/simulate".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{definitionID}", ApiClient.urlEncode(definitionID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)simulationRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void updateCustomerSettings(UpdateCustomerSettingsRequest updateCustomerSettingsRequest) throws ApiException {
        this.updateCustomerSettingsWithHttpInfo(updateCustomerSettingsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> updateCustomerSettingsWithHttpInfo(UpdateCustomerSettingsRequest updateCustomerSettingsRequest) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.updateCustomerSettingsRequestBuilder(updateCustomerSettingsRequest);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateCustomerSettings", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder updateCustomerSettingsRequestBuilder(UpdateCustomerSettingsRequest updateCustomerSettingsRequest) throws ApiException {
        if (updateCustomerSettingsRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateCustomerSettingsRequest' when calling updateCustomerSettings");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/settings";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateCustomerSettingsRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Definition updateDefinition(UUID projectID, UUID definitionID, UpdateDefinitionRequest updateDefinitionRequest) throws ApiException {
        ApiResponse<Definition> localVarResponse = this.updateDefinitionWithHttpInfo(projectID, definitionID, updateDefinitionRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<Definition> updateDefinitionWithHttpInfo(UUID projectID, UUID definitionID, UpdateDefinitionRequest updateDefinitionRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateDefinitionRequestBuilder(projectID, definitionID, updateDefinitionRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateDefinition", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Definition)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Definition>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateDefinitionRequestBuilder(UUID projectID, UUID definitionID, UpdateDefinitionRequest updateDefinitionRequest) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling updateDefinition");
        }
        if (definitionID == null) {
            throw new ApiException(400, "Missing the required parameter 'definitionID' when calling updateDefinition");
        }
        if (updateDefinitionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateDefinitionRequest' when calling updateDefinition");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/definitions/{definitionID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{definitionID}", ApiClient.urlEncode(definitionID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateDefinitionRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ProjectMember updateProjectMemberRole(UUID projectID, String userID, UpdateProjectMemberRoleRequest updateProjectMemberRoleRequest) throws ApiException {
        ApiResponse<ProjectMember> localVarResponse = this.updateProjectMemberRoleWithHttpInfo(projectID, userID, updateProjectMemberRoleRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<ProjectMember> updateProjectMemberRoleWithHttpInfo(UUID projectID, String userID, UpdateProjectMemberRoleRequest updateProjectMemberRoleRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateProjectMemberRoleRequestBuilder(projectID, userID, updateProjectMemberRoleRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateProjectMemberRole", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ProjectMember)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ProjectMember>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateProjectMemberRoleRequestBuilder(UUID projectID, String userID, UpdateProjectMemberRoleRequest updateProjectMemberRoleRequest) throws ApiException {
        if (projectID == null) {
            throw new ApiException(400, "Missing the required parameter 'projectID' when calling updateProjectMemberRole");
        }
        if (userID == null) {
            throw new ApiException(400, "Missing the required parameter 'userID' when calling updateProjectMemberRole");
        }
        if (updateProjectMemberRoleRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateProjectMemberRoleRequest' when calling updateProjectMemberRole");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/projects/{projectID}/members/{userID}".replace("{projectID}", ApiClient.urlEncode(projectID.toString())).replace("{userID}", ApiClient.urlEncode(userID.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateProjectMemberRoleRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

