/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.lang.NestedCollection;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.Key;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import java.util.function.Supplier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class ZitadelTokenProvider
implements Supplier<String> {
    private final String userId;
    private final String keyId;
    private final PrivateKey privateKey;
    private final String issuer;
    private String cachedToken;
    private Instant tokenExpiry = Instant.MIN;
    private final String projectId;

    public ZitadelTokenProvider(String jsonKeyPath, String issuer, String projectId) throws IOException {
        this(Path.of(jsonKeyPath, new String[0]), issuer, projectId);
    }

    public ZitadelTokenProvider(Path jsonKeyPath, String issuer, String projectId) throws IOException {
        this.issuer = issuer;
        this.projectId = projectId;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(jsonKeyPath.toFile());
        if (!(root.has("userId") && root.has("key") && root.has("keyId"))) {
            throw new IllegalArgumentException("Invalid Zitadel JSON Key file format");
        }
        this.userId = root.get("userId").asText();
        this.keyId = root.get("keyId").asText();
        String keyPem = root.get("key").asText();
        this.privateKey = this.parsePrivateKey(keyPem);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrivateKey parsePrivateKey(String keyPem) {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(keyPem));){
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
            return privateKey;
        }
        catch (Exception e) {
            try (PEMParser pemParser2 = new PEMParser((Reader)new StringReader(keyPem));){
                Object object = pemParser2.readObject();
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                if (object instanceof PEMKeyPair) {
                    PrivateKey privateKey = converter.getPrivateKey(((PEMKeyPair)object).getPrivateKeyInfo());
                    return privateKey;
                }
                if (!(object instanceof PrivateKeyInfo)) throw new IllegalArgumentException("Unknown key format: " + object.getClass().getName());
                PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
                return privateKey;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to parse private key: " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public synchronized String get() {
        if (this.cachedToken != null && Instant.now().isBefore(this.tokenExpiry.minusSeconds(60L))) {
            return this.cachedToken;
        }
        try {
            return this.fetchNewToken();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch Zitadel token", e);
        }
    }

    private String fetchNewToken() throws Exception {
        HttpRequest request;
        String jwt = ((JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder)((NestedCollection)Jwts.builder().issuer(this.userId).subject(this.userId).audience().add((Object)this.issuer)).and()).issuedAt(new Date()).expiration(new Date(System.currentTimeMillis() + 3600000L)).id(UUID.randomUUID().toString()).header().keyId(this.keyId)).and()).signWith((Key)this.privateKey).compact();
        String scope = URLEncoder.encode("openid profile urn:zitadel:iam:user:resourceowner urn:zitadel:iam:org:projects:roles" + (String)(this.projectId != null && !this.projectId.isEmpty() ? " urn:zitadel:iam:org:project:id:" + this.projectId + ":aud" : ""), StandardCharsets.UTF_8);
        String body = "grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&scope=" + scope + "&assertion=" + jwt;
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.issuer + "/oauth/v2/token")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(body)).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new RuntimeException("Token request failed: " + response.statusCode() + " " + response.body());
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode respNode = mapper.readTree(response.body());
        this.cachedToken = respNode.get("access_token").asText();
        int expiresIn = respNode.get("expires_in").asInt();
        this.tokenExpiry = Instant.now().plusSeconds(expiresIn);
        return this.cachedToken;
    }
}

