/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"date", "requests", "credits"})
public class DailyStat {
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDate date;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private Integer requests;
    public static final String JSON_PROPERTY_CREDITS = "credits";
    private Integer credits;

    public DailyStat date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nullable
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public DailyStat requests(Integer requests) {
        this.requests = requests;
        return this;
    }

    @Nullable
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRequests() {
        return this.requests;
    }

    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequests(Integer requests) {
        this.requests = requests;
    }

    public DailyStat credits(Integer credits) {
        this.credits = credits;
        return this;
    }

    @Nullable
    @JsonProperty(value="credits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCredits() {
        return this.credits;
    }

    @JsonProperty(value="credits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyStat dailyStat = (DailyStat)o;
        return Objects.equals(this.date, dailyStat.date) && Objects.equals(this.requests, dailyStat.requests) && Objects.equals(this.credits, dailyStat.credits);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.requests, this.credits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyStat {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    credits: ").append(this.toIndentedString(this.credits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDate() != null) {
            joiner.add(String.format("%sdate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRequests() != null) {
            joiner.add(String.format("%srequests%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRequests()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCredits() != null) {
            joiner.add(String.format("%scredits%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCredits()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

