/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "name", "definition_id", "xml", "version", "created_by", "created_at"})
public class Definition {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DEFINITION_ID = "definition_id";
    private String definitionId;
    public static final String JSON_PROPERTY_XML = "xml";
    private String xml;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_CREATED_BY = "created_by";
    private String createdBy;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;

    public Definition id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public Definition name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Definition definitionId(String definitionId) {
        this.definitionId = definitionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="definition_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDefinitionId() {
        return this.definitionId;
    }

    @JsonProperty(value="definition_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public Definition xml(String xml) {
        this.xml = xml;
        return this;
    }

    @Nonnull
    @JsonProperty(value="xml")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getXml() {
        return this.xml;
    }

    @JsonProperty(value="xml")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setXml(String xml) {
        this.xml = xml;
    }

    public Definition version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersion(Integer version) {
        this.version = version;
    }

    public Definition createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Definition createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Definition definition = (Definition)o;
        return Objects.equals(this.id, definition.id) && Objects.equals(this.name, definition.name) && Objects.equals(this.definitionId, definition.definitionId) && Objects.equals(this.xml, definition.xml) && Objects.equals(this.version, definition.version) && Objects.equals(this.createdBy, definition.createdBy) && Objects.equals(this.createdAt, definition.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.definitionId, this.xml, this.version, this.createdBy, this.createdAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Definition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    definitionId: ").append(this.toIndentedString(this.definitionId)).append("\n");
        sb.append("    xml: ").append(this.toIndentedString(this.xml)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDefinitionId() != null) {
            joiner.add(String.format("%sdefinition_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDefinitionId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getXml() != null) {
            joiner.add(String.format("%sxml%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getXml()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVersion() != null) {
            joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreatedBy() != null) {
            joiner.add(String.format("%screated_by%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedBy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screated_at%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

