/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.quantumdmn.client.model.ProjectUsage;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"limit", "projects"})
public class DefinitionsQuota {
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Integer limit;
    public static final String JSON_PROPERTY_PROJECTS = "projects";
    private List<ProjectUsage> projects;

    public DefinitionsQuota limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public DefinitionsQuota projects(List<ProjectUsage> projects) {
        this.projects = projects;
        return this;
    }

    public DefinitionsQuota addProjectsItem(ProjectUsage projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<ProjectUsage>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="projects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ProjectUsage> getProjects() {
        return this.projects;
    }

    @JsonProperty(value="projects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProjects(List<ProjectUsage> projects) {
        this.projects = projects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefinitionsQuota definitionsQuota = (DefinitionsQuota)o;
        return Objects.equals(this.limit, definitionsQuota.limit) && Objects.equals(this.projects, definitionsQuota.projects);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.projects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DefinitionsQuota {\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLimit() != null) {
            joiner.add(String.format("%slimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLimit()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getProjects() != null) {
            for (int i = 0; i < this.getProjects().size(); ++i) {
                if (this.getProjects().get(i) == null) continue;
                joiner.add(this.getProjects().get(i).toUrlQueryString(String.format("%sprojects%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

