/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"version", "context", "businessId", "decisionServices", "decisions"})
public class EvaluateStoredRequest {
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Map context = new HashMap();
    public static final String JSON_PROPERTY_BUSINESS_ID = "businessId";
    private String businessId;
    public static final String JSON_PROPERTY_DECISION_SERVICES = "decisionServices";
    private List<String> decisionServices;
    public static final String JSON_PROPERTY_DECISIONS = "decisions";
    private List<String> decisions;

    public EvaluateStoredRequest version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Integer version) {
        this.version = version;
    }

    public EvaluateStoredRequest context(Map context) {
        this.context = context;
        return this;
    }

    @Nonnull
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContext(Map context) {
        this.context = context;
    }

    public EvaluateStoredRequest businessId(String businessId) {
        this.businessId = businessId;
        return this;
    }

    @Nullable
    @JsonProperty(value="businessId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessId() {
        return this.businessId;
    }

    @JsonProperty(value="businessId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public EvaluateStoredRequest decisionServices(List<String> decisionServices) {
        this.decisionServices = decisionServices;
        return this;
    }

    public EvaluateStoredRequest addDecisionServicesItem(String decisionServicesItem) {
        if (this.decisionServices == null) {
            this.decisionServices = new ArrayList<String>();
        }
        this.decisionServices.add(decisionServicesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDecisionServices() {
        return this.decisionServices;
    }

    @JsonProperty(value="decisionServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionServices(List<String> decisionServices) {
        this.decisionServices = decisionServices;
    }

    public EvaluateStoredRequest decisions(List<String> decisions) {
        this.decisions = decisions;
        return this;
    }

    public EvaluateStoredRequest addDecisionsItem(String decisionsItem) {
        if (this.decisions == null) {
            this.decisions = new ArrayList<String>();
        }
        this.decisions.add(decisionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDecisions() {
        return this.decisions;
    }

    @JsonProperty(value="decisions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisions(List<String> decisions) {
        this.decisions = decisions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluateStoredRequest evaluateStoredRequest = (EvaluateStoredRequest)o;
        return Objects.equals(this.version, evaluateStoredRequest.version) && Objects.equals(this.context, evaluateStoredRequest.context) && Objects.equals(this.businessId, evaluateStoredRequest.businessId) && Objects.equals(this.decisionServices, evaluateStoredRequest.decisionServices) && Objects.equals(this.decisions, evaluateStoredRequest.decisions);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.context, this.businessId, this.decisionServices, this.decisions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluateStoredRequest {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    businessId: ").append(this.toIndentedString(this.businessId)).append("\n");
        sb.append("    decisionServices: ").append(this.toIndentedString(this.decisionServices)).append("\n");
        sb.append("    decisions: ").append(this.toIndentedString(this.decisions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVersion() != null) {
            joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContext() != null) {
            joiner.add(String.format("%scontext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContext()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBusinessId() != null) {
            joiner.add(String.format("%sbusinessId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBusinessId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDecisionServices() != null) {
            for (i = 0; i < this.getDecisionServices().size(); ++i) {
                joiner.add(String.format("%sdecisionServices%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getDecisionServices().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getDecisions() != null) {
            for (i = 0; i < this.getDecisions().size(); ++i) {
                joiner.add(String.format("%sdecisions%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getDecisions().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

