/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.quantumdmn.client.model.FeelValue;
import com.quantumdmn.client.model.HitRule;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"decisionId", "name", "error", "type", "value", "hitRules", "dependencies"})
public class EvaluationResult {
    public static final String JSON_PROPERTY_DECISION_ID = "decisionId";
    private String decisionId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VALUE = "value";
    private FeelValue value;
    public static final String JSON_PROPERTY_HIT_RULES = "hitRules";
    private List<HitRule> hitRules;
    public static final String JSON_PROPERTY_DEPENDENCIES = "dependencies";
    private List<EvaluationResult> dependencies;

    public EvaluationResult decisionId(String decisionId) {
        this.decisionId = decisionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDecisionId() {
        return this.decisionId;
    }

    @JsonProperty(value="decisionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionId(String decisionId) {
        this.decisionId = decisionId;
    }

    public EvaluationResult name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public EvaluationResult error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(String error) {
        this.error = error;
    }

    public EvaluationResult type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public EvaluationResult value(FeelValue value) {
        this.value = value;
        return this;
    }

    @Nullable
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FeelValue getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(FeelValue value) {
        this.value = value;
    }

    public EvaluationResult hitRules(List<HitRule> hitRules) {
        this.hitRules = hitRules;
        return this;
    }

    public EvaluationResult addHitRulesItem(HitRule hitRulesItem) {
        if (this.hitRules == null) {
            this.hitRules = new ArrayList<HitRule>();
        }
        this.hitRules.add(hitRulesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="hitRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HitRule> getHitRules() {
        return this.hitRules;
    }

    @JsonProperty(value="hitRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHitRules(List<HitRule> hitRules) {
        this.hitRules = hitRules;
    }

    public EvaluationResult dependencies(List<EvaluationResult> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public EvaluationResult addDependenciesItem(EvaluationResult dependenciesItem) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<EvaluationResult>();
        }
        this.dependencies.add(dependenciesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dependencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EvaluationResult> getDependencies() {
        return this.dependencies;
    }

    @JsonProperty(value="dependencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDependencies(List<EvaluationResult> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationResult evaluationResult = (EvaluationResult)o;
        return Objects.equals(this.decisionId, evaluationResult.decisionId) && Objects.equals(this.name, evaluationResult.name) && Objects.equals(this.error, evaluationResult.error) && Objects.equals((Object)this.type, (Object)evaluationResult.type) && Objects.equals(this.value, evaluationResult.value) && Objects.equals(this.hitRules, evaluationResult.hitRules) && Objects.equals(this.dependencies, evaluationResult.dependencies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.decisionId, this.name, this.error, this.type, this.value, this.hitRules, this.dependencies});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluationResult {\n");
        sb.append("    decisionId: ").append(this.toIndentedString(this.decisionId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    hitRules: ").append(this.toIndentedString(this.hitRules)).append("\n");
        sb.append("    dependencies: ").append(this.toIndentedString(this.dependencies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDecisionId() != null) {
            joiner.add(String.format("%sdecisionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDecisionId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getError() != null) {
            joiner.add(String.format("%serror%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getError()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getValue() != null) {
            joiner.add(this.getValue().toUrlQueryString((String)prefix + JSON_PROPERTY_VALUE + suffix));
        }
        if (this.getHitRules() != null) {
            for (i = 0; i < this.getHitRules().size(); ++i) {
                if (this.getHitRules().get(i) == null) continue;
                joiner.add(this.getHitRules().get(i).toUrlQueryString(String.format("%shitRules%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getDependencies() != null) {
            for (i = 0; i < this.getDependencies().size(); ++i) {
                if (this.getDependencies().get(i) == null) continue;
                joiner.add(this.getDependencies().get(i).toUrlQueryString(String.format("%sdependencies%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        DECISION("DECISION"),
        KPI("KPI"),
        DECISION_SERVICE("DECISION_SERVICE"),
        BKM("BKM"),
        INPUT_DATA("INPUT_DATA");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

