/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.quantumdmn.client.model.FeelValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "definition_id", "executed_at", "executed_by", "inputs", "outputs", "xml_definition_id"})
public class Execution {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_DEFINITION_ID = "definition_id";
    private UUID definitionId;
    public static final String JSON_PROPERTY_EXECUTED_AT = "executed_at";
    private OffsetDateTime executedAt;
    public static final String JSON_PROPERTY_EXECUTED_BY = "executed_by";
    private String executedBy;
    public static final String JSON_PROPERTY_INPUTS = "inputs";
    private Map inputs = new HashMap();
    public static final String JSON_PROPERTY_OUTPUTS = "outputs";
    private FeelValue outputs;
    public static final String JSON_PROPERTY_XML_DEFINITION_ID = "xml_definition_id";
    private String xmlDefinitionId;

    public Execution id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public Execution definitionId(UUID definitionId) {
        this.definitionId = definitionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="definition_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDefinitionId() {
        return this.definitionId;
    }

    @JsonProperty(value="definition_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDefinitionId(UUID definitionId) {
        this.definitionId = definitionId;
    }

    public Execution executedAt(OffsetDateTime executedAt) {
        this.executedAt = executedAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="executed_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getExecutedAt() {
        return this.executedAt;
    }

    @JsonProperty(value="executed_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExecutedAt(OffsetDateTime executedAt) {
        this.executedAt = executedAt;
    }

    public Execution executedBy(String executedBy) {
        this.executedBy = executedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="executed_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExecutedBy() {
        return this.executedBy;
    }

    @JsonProperty(value="executed_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutedBy(String executedBy) {
        this.executedBy = executedBy;
    }

    public Execution inputs(Map inputs) {
        this.inputs = inputs;
        return this;
    }

    @Nonnull
    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map getInputs() {
        return this.inputs;
    }

    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInputs(Map inputs) {
        this.inputs = inputs;
    }

    public Execution outputs(FeelValue outputs) {
        this.outputs = outputs;
        return this;
    }

    @Nullable
    @JsonProperty(value="outputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FeelValue getOutputs() {
        return this.outputs;
    }

    @JsonProperty(value="outputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOutputs(FeelValue outputs) {
        this.outputs = outputs;
    }

    public Execution xmlDefinitionId(String xmlDefinitionId) {
        this.xmlDefinitionId = xmlDefinitionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="xml_definition_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getXmlDefinitionId() {
        return this.xmlDefinitionId;
    }

    @JsonProperty(value="xml_definition_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXmlDefinitionId(String xmlDefinitionId) {
        this.xmlDefinitionId = xmlDefinitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execution execution = (Execution)o;
        return Objects.equals(this.id, execution.id) && Objects.equals(this.definitionId, execution.definitionId) && Objects.equals(this.executedAt, execution.executedAt) && Objects.equals(this.executedBy, execution.executedBy) && Objects.equals(this.inputs, execution.inputs) && Objects.equals(this.outputs, execution.outputs) && Objects.equals(this.xmlDefinitionId, execution.xmlDefinitionId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.definitionId, this.executedAt, this.executedBy, this.inputs, this.outputs, this.xmlDefinitionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Execution {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    definitionId: ").append(this.toIndentedString(this.definitionId)).append("\n");
        sb.append("    executedAt: ").append(this.toIndentedString(this.executedAt)).append("\n");
        sb.append("    executedBy: ").append(this.toIndentedString(this.executedBy)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        sb.append("    xmlDefinitionId: ").append(this.toIndentedString(this.xmlDefinitionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDefinitionId() != null) {
            joiner.add(String.format("%sdefinition_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDefinitionId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getExecutedAt() != null) {
            joiner.add(String.format("%sexecuted_at%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExecutedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getExecutedBy() != null) {
            joiner.add(String.format("%sexecuted_by%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExecutedBy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInputs() != null) {
            joiner.add(String.format("%sinputs%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getInputs()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOutputs() != null) {
            joiner.add(this.getOutputs().toUrlQueryString((String)prefix + JSON_PROPERTY_OUTPUTS + suffix));
        }
        if (this.getXmlDefinitionId() != null) {
            joiner.add(String.format("%sxml_definition_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getXmlDefinitionId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

