/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonDeserialize(using=Deserializer.class)
public class FeelValue {
    private final Object value;
    private final Type type;

    private FeelValue(Object value, Type type) {
        this.value = value;
        this.type = type;
    }

    public static FeelValue ofNumber(Number value) {
        return new FeelValue(value instanceof BigDecimal ? value : new BigDecimal(value.toString()), Type.NUMBER);
    }

    public static FeelValue ofString(String value) {
        return new FeelValue(value, Type.STRING);
    }

    public static FeelValue ofBoolean(boolean value) {
        return new FeelValue(value, Type.BOOLEAN);
    }

    public static FeelValue ofList(List<FeelValue> value) {
        return new FeelValue(value, Type.LIST);
    }

    public static FeelValue ofContext(Map<String, FeelValue> value) {
        return new FeelValue(value, Type.CONTEXT);
    }

    public static FeelValue ofNull() {
        return new FeelValue(null, Type.NULL);
    }

    @JsonCreator
    public static FeelValue fromRaw(Object raw) {
        if (raw == null) {
            return FeelValue.ofNull();
        }
        if (raw instanceof Number) {
            return FeelValue.ofNumber((Number)raw);
        }
        if (raw instanceof String) {
            return FeelValue.ofString((String)raw);
        }
        if (raw instanceof Boolean) {
            return FeelValue.ofBoolean((Boolean)raw);
        }
        if (raw instanceof List) {
            List list = (List)raw;
            return FeelValue.ofList(list.stream().map(FeelValue::fromRaw).toList());
        }
        if (raw instanceof Map) {
            Map map = (Map)raw;
            return FeelValue.ofContext(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> FeelValue.fromRaw(e.getValue()))));
        }
        return FeelValue.ofString(raw.toString());
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNumber() {
        return this.type == Type.NUMBER;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public boolean isList() {
        return this.type == Type.LIST;
    }

    public boolean isContext() {
        return this.type == Type.CONTEXT;
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public BigDecimal asNumber() {
        if (!this.isNumber()) {
            throw new IllegalStateException("Not a number: " + String.valueOf((Object)this.type));
        }
        return (BigDecimal)this.value;
    }

    public String asString() {
        if (!this.isString()) {
            throw new IllegalStateException("Not a string: " + String.valueOf((Object)this.type));
        }
        return (String)this.value;
    }

    public boolean asBoolean() {
        if (!this.isBoolean()) {
            throw new IllegalStateException("Not a boolean: " + String.valueOf((Object)this.type));
        }
        return (Boolean)this.value;
    }

    public List<FeelValue> asList() {
        if (!this.isList()) {
            throw new IllegalStateException("Not a list: " + String.valueOf((Object)this.type));
        }
        return (List)this.value;
    }

    public Map<String, FeelValue> asContext() {
        if (!this.isContext()) {
            throw new IllegalStateException("Not a context: " + String.valueOf((Object)this.type));
        }
        return (Map)this.value;
    }

    @JsonValue
    public Object getRawValue() {
        if (this.value == null) {
            return null;
        }
        if (this.isList()) {
            return this.asList().stream().map(FeelValue::getRawValue).toList();
        }
        if (this.isContext()) {
            return this.asContext().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FeelValue)e.getValue()).getRawValue()));
        }
        return this.value;
    }

    public String toUrlQueryString(String prefix) {
        if (this.value == null) {
            return "";
        }
        return prefix + "=" + URLEncoder.encode(String.valueOf(this.getRawValue()), StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeelValue feelValue = (FeelValue)o;
        return this.type == feelValue.type && Objects.equals(this.value, feelValue.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type});
    }

    public String toString() {
        return "FeelValue{type=" + String.valueOf((Object)this.type) + ", value=" + String.valueOf(this.value) + "}";
    }

    public static enum Type {
        NUMBER,
        STRING,
        BOOLEAN,
        LIST,
        CONTEXT,
        NULL;

    }

    public static class Deserializer
    extends JsonDeserializer<FeelValue> {
        public FeelValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return this.deserializeNode(node);
        }

        private FeelValue deserializeNode(JsonNode node) {
            if (node == null || node.isNull()) {
                return FeelValue.ofNull();
            }
            if (node.isNumber()) {
                return FeelValue.ofNumber(node.decimalValue());
            }
            if (node.isTextual()) {
                return FeelValue.ofString(node.asText());
            }
            if (node.isBoolean()) {
                return FeelValue.ofBoolean(node.asBoolean());
            }
            if (node.isArray()) {
                ArrayList<FeelValue> list = new ArrayList<FeelValue>();
                for (JsonNode element : node) {
                    list.add(this.deserializeNode(element));
                }
                return FeelValue.ofList(list);
            }
            if (node.isObject()) {
                LinkedHashMap<String, FeelValue> map = new LinkedHashMap<String, FeelValue>();
                node.fields().forEachRemaining(entry -> map.put((String)entry.getKey(), this.deserializeNode((JsonNode)entry.getValue())));
                return FeelValue.ofContext(map);
            }
            return FeelValue.ofNull();
        }
    }
}

