/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.quantumdmn.client.model.DailyStat;
import com.quantumdmn.client.model.KpiTrend;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"totalCredits", "requestsTrend", "creditsTrend", "kpiTrends"})
public class OverviewResponseStats {
    public static final String JSON_PROPERTY_TOTAL_CREDITS = "totalCredits";
    private Integer totalCredits;
    public static final String JSON_PROPERTY_REQUESTS_TREND = "requestsTrend";
    private List<DailyStat> requestsTrend;
    public static final String JSON_PROPERTY_CREDITS_TREND = "creditsTrend";
    private List<DailyStat> creditsTrend;
    public static final String JSON_PROPERTY_KPI_TRENDS = "kpiTrends";
    private List<KpiTrend> kpiTrends;

    public OverviewResponseStats totalCredits(Integer totalCredits) {
        this.totalCredits = totalCredits;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalCredits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalCredits() {
        return this.totalCredits;
    }

    @JsonProperty(value="totalCredits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCredits(Integer totalCredits) {
        this.totalCredits = totalCredits;
    }

    public OverviewResponseStats requestsTrend(List<DailyStat> requestsTrend) {
        this.requestsTrend = requestsTrend;
        return this;
    }

    public OverviewResponseStats addRequestsTrendItem(DailyStat requestsTrendItem) {
        if (this.requestsTrend == null) {
            this.requestsTrend = new ArrayList<DailyStat>();
        }
        this.requestsTrend.add(requestsTrendItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="requestsTrend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DailyStat> getRequestsTrend() {
        return this.requestsTrend;
    }

    @JsonProperty(value="requestsTrend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestsTrend(List<DailyStat> requestsTrend) {
        this.requestsTrend = requestsTrend;
    }

    public OverviewResponseStats creditsTrend(List<DailyStat> creditsTrend) {
        this.creditsTrend = creditsTrend;
        return this;
    }

    public OverviewResponseStats addCreditsTrendItem(DailyStat creditsTrendItem) {
        if (this.creditsTrend == null) {
            this.creditsTrend = new ArrayList<DailyStat>();
        }
        this.creditsTrend.add(creditsTrendItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="creditsTrend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DailyStat> getCreditsTrend() {
        return this.creditsTrend;
    }

    @JsonProperty(value="creditsTrend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreditsTrend(List<DailyStat> creditsTrend) {
        this.creditsTrend = creditsTrend;
    }

    public OverviewResponseStats kpiTrends(List<KpiTrend> kpiTrends) {
        this.kpiTrends = kpiTrends;
        return this;
    }

    public OverviewResponseStats addKpiTrendsItem(KpiTrend kpiTrendsItem) {
        if (this.kpiTrends == null) {
            this.kpiTrends = new ArrayList<KpiTrend>();
        }
        this.kpiTrends.add(kpiTrendsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="kpiTrends")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KpiTrend> getKpiTrends() {
        return this.kpiTrends;
    }

    @JsonProperty(value="kpiTrends")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKpiTrends(List<KpiTrend> kpiTrends) {
        this.kpiTrends = kpiTrends;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverviewResponseStats overviewResponseStats = (OverviewResponseStats)o;
        return Objects.equals(this.totalCredits, overviewResponseStats.totalCredits) && Objects.equals(this.requestsTrend, overviewResponseStats.requestsTrend) && Objects.equals(this.creditsTrend, overviewResponseStats.creditsTrend) && Objects.equals(this.kpiTrends, overviewResponseStats.kpiTrends);
    }

    public int hashCode() {
        return Objects.hash(this.totalCredits, this.requestsTrend, this.creditsTrend, this.kpiTrends);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OverviewResponseStats {\n");
        sb.append("    totalCredits: ").append(this.toIndentedString(this.totalCredits)).append("\n");
        sb.append("    requestsTrend: ").append(this.toIndentedString(this.requestsTrend)).append("\n");
        sb.append("    creditsTrend: ").append(this.toIndentedString(this.creditsTrend)).append("\n");
        sb.append("    kpiTrends: ").append(this.toIndentedString(this.kpiTrends)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTotalCredits() != null) {
            joiner.add(String.format("%stotalCredits%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotalCredits()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRequestsTrend() != null) {
            for (i = 0; i < this.getRequestsTrend().size(); ++i) {
                if (this.getRequestsTrend().get(i) == null) continue;
                joiner.add(this.getRequestsTrend().get(i).toUrlQueryString(String.format("%srequestsTrend%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getCreditsTrend() != null) {
            for (i = 0; i < this.getCreditsTrend().size(); ++i) {
                if (this.getCreditsTrend().get(i) == null) continue;
                joiner.add(this.getCreditsTrend().get(i).toUrlQueryString(String.format("%screditsTrend%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getKpiTrends() != null) {
            for (i = 0; i < this.getKpiTrends().size(); ++i) {
                if (this.getKpiTrends().get(i) == null) continue;
                joiner.add(this.getKpiTrends().get(i).toUrlQueryString(String.format("%skpiTrends%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

