/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.quantumdmn.client.model.Definition;
import com.quantumdmn.client.model.PaginationMetadata;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"data", "pagination"})
public class PaginatedDefinitionsResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<Definition> data = new ArrayList<Definition>();
    public static final String JSON_PROPERTY_PAGINATION = "pagination";
    private PaginationMetadata pagination;

    public PaginatedDefinitionsResponse data(List<Definition> data) {
        this.data = data;
        return this;
    }

    public PaginatedDefinitionsResponse addDataItem(Definition dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Definition>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Definition> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(List<Definition> data) {
        this.data = data;
    }

    public PaginatedDefinitionsResponse pagination(PaginationMetadata pagination) {
        this.pagination = pagination;
        return this;
    }

    @Nonnull
    @JsonProperty(value="pagination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PaginationMetadata getPagination() {
        return this.pagination;
    }

    @JsonProperty(value="pagination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPagination(PaginationMetadata pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginatedDefinitionsResponse paginatedDefinitionsResponse = (PaginatedDefinitionsResponse)o;
        return Objects.equals(this.data, paginatedDefinitionsResponse.data) && Objects.equals(this.pagination, paginatedDefinitionsResponse.pagination);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.pagination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginatedDefinitionsResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getData() != null) {
            for (int i = 0; i < this.getData().size(); ++i) {
                if (this.getData().get(i) == null) continue;
                joiner.add(this.getData().get(i).toUrlQueryString(String.format("%sdata%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getPagination() != null) {
            joiner.add(this.getPagination().toUrlQueryString((String)prefix + JSON_PROPERTY_PAGINATION + suffix));
        }
        return joiner.toString();
    }
}

