/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"page", "pageSize", "total", "totalPages"})
public class PaginationMetadata {
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page;
    public static final String JSON_PROPERTY_PAGE_SIZE = "pageSize";
    private Integer pageSize;
    public static final String JSON_PROPERTY_TOTAL = "total";
    private Integer total;
    public static final String JSON_PROPERTY_TOTAL_PAGES = "totalPages";
    private Integer totalPages;

    public PaginationMetadata page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public PaginationMetadata pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nonnull
    @JsonProperty(value="pageSize")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="pageSize")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public PaginationMetadata total(Integer total) {
        this.total = total;
        return this;
    }

    @Nonnull
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotal(Integer total) {
        this.total = total;
    }

    public PaginationMetadata totalPages(Integer totalPages) {
        this.totalPages = totalPages;
        return this;
    }

    @Nonnull
    @JsonProperty(value="totalPages")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotalPages() {
        return this.totalPages;
    }

    @JsonProperty(value="totalPages")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginationMetadata paginationMetadata = (PaginationMetadata)o;
        return Objects.equals(this.page, paginationMetadata.page) && Objects.equals(this.pageSize, paginationMetadata.pageSize) && Objects.equals(this.total, paginationMetadata.total) && Objects.equals(this.totalPages, paginationMetadata.totalPages);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.pageSize, this.total, this.totalPages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginationMetadata {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    totalPages: ").append(this.toIndentedString(this.totalPages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPage() != null) {
            joiner.add(String.format("%spage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPageSize() != null) {
            joiner.add(String.format("%spageSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTotal() != null) {
            joiner.add(String.format("%stotal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotal()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTotalPages() != null) {
            joiner.add(String.format("%stotalPages%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotalPages()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

