/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

@JsonPropertyOrder(value={"project_id", "user_id", "role", "username", "email", "created_at"})
public class ProjectMember {
    public static final String JSON_PROPERTY_PROJECT_ID = "project_id";
    private UUID projectId;
    public static final String JSON_PROPERTY_USER_ID = "user_id";
    private String userId;
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;

    public ProjectMember projectId(UUID projectId) {
        this.projectId = projectId;
        return this;
    }

    @Nullable
    @JsonProperty(value="project_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getProjectId() {
        return this.projectId;
    }

    @JsonProperty(value="project_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public ProjectMember userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @JsonProperty(value="user_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ProjectMember role(String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(String role) {
        this.role = role;
    }

    public ProjectMember username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public ProjectMember email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public ProjectMember createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectMember projectMember = (ProjectMember)o;
        return Objects.equals(this.projectId, projectMember.projectId) && Objects.equals(this.userId, projectMember.userId) && Objects.equals(this.role, projectMember.role) && Objects.equals(this.username, projectMember.username) && Objects.equals(this.email, projectMember.email) && Objects.equals(this.createdAt, projectMember.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.userId, this.role, this.username, this.email, this.createdAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectMember {\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getProjectId() != null) {
            joiner.add(String.format("%sproject_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProjectId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUserId() != null) {
            joiner.add(String.format("%suser_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUserId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRole() != null) {
            joiner.add(String.format("%srole%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRole()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUsername() != null) {
            joiner.add(String.format("%susername%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUsername()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEmail() != null) {
            joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screated_at%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

