/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"role", "can_manage_members", "can_edit_definitions", "can_execute", "can_view"})
public class ProjectPermissions {
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_CAN_MANAGE_MEMBERS = "can_manage_members";
    private Boolean canManageMembers;
    public static final String JSON_PROPERTY_CAN_EDIT_DEFINITIONS = "can_edit_definitions";
    private Boolean canEditDefinitions;
    public static final String JSON_PROPERTY_CAN_EXECUTE = "can_execute";
    private Boolean canExecute;
    public static final String JSON_PROPERTY_CAN_VIEW = "can_view";
    private Boolean canView;

    public ProjectPermissions role(String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRole(String role) {
        this.role = role;
    }

    public ProjectPermissions canManageMembers(Boolean canManageMembers) {
        this.canManageMembers = canManageMembers;
        return this;
    }

    @Nonnull
    @JsonProperty(value="can_manage_members")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCanManageMembers() {
        return this.canManageMembers;
    }

    @JsonProperty(value="can_manage_members")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCanManageMembers(Boolean canManageMembers) {
        this.canManageMembers = canManageMembers;
    }

    public ProjectPermissions canEditDefinitions(Boolean canEditDefinitions) {
        this.canEditDefinitions = canEditDefinitions;
        return this;
    }

    @Nonnull
    @JsonProperty(value="can_edit_definitions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCanEditDefinitions() {
        return this.canEditDefinitions;
    }

    @JsonProperty(value="can_edit_definitions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCanEditDefinitions(Boolean canEditDefinitions) {
        this.canEditDefinitions = canEditDefinitions;
    }

    public ProjectPermissions canExecute(Boolean canExecute) {
        this.canExecute = canExecute;
        return this;
    }

    @Nonnull
    @JsonProperty(value="can_execute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCanExecute() {
        return this.canExecute;
    }

    @JsonProperty(value="can_execute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCanExecute(Boolean canExecute) {
        this.canExecute = canExecute;
    }

    public ProjectPermissions canView(Boolean canView) {
        this.canView = canView;
        return this;
    }

    @Nonnull
    @JsonProperty(value="can_view")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCanView() {
        return this.canView;
    }

    @JsonProperty(value="can_view")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCanView(Boolean canView) {
        this.canView = canView;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPermissions projectPermissions = (ProjectPermissions)o;
        return Objects.equals(this.role, projectPermissions.role) && Objects.equals(this.canManageMembers, projectPermissions.canManageMembers) && Objects.equals(this.canEditDefinitions, projectPermissions.canEditDefinitions) && Objects.equals(this.canExecute, projectPermissions.canExecute) && Objects.equals(this.canView, projectPermissions.canView);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.canManageMembers, this.canEditDefinitions, this.canExecute, this.canView);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectPermissions {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    canManageMembers: ").append(this.toIndentedString(this.canManageMembers)).append("\n");
        sb.append("    canEditDefinitions: ").append(this.toIndentedString(this.canEditDefinitions)).append("\n");
        sb.append("    canExecute: ").append(this.toIndentedString(this.canExecute)).append("\n");
        sb.append("    canView: ").append(this.toIndentedString(this.canView)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRole() != null) {
            joiner.add(String.format("%srole%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRole()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCanManageMembers() != null) {
            joiner.add(String.format("%scan_manage_members%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCanManageMembers()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCanEditDefinitions() != null) {
            joiner.add(String.format("%scan_edit_definitions%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCanEditDefinitions()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCanExecute() != null) {
            joiner.add(String.format("%scan_execute%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCanExecute()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCanView() != null) {
            joiner.add(String.format("%scan_view%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCanView()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

