/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"used", "limit"})
public class QuotaItem {
    public static final String JSON_PROPERTY_USED = "used";
    private Integer used;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Integer limit;

    public QuotaItem used(Integer used) {
        this.used = used;
        return this;
    }

    @Nullable
    @JsonProperty(value="used")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUsed() {
        return this.used;
    }

    @JsonProperty(value="used")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsed(Integer used) {
        this.used = used;
    }

    public QuotaItem limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuotaItem quotaItem = (QuotaItem)o;
        return Objects.equals(this.used, quotaItem.used) && Objects.equals(this.limit, quotaItem.limit);
    }

    public int hashCode() {
        return Objects.hash(this.used, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuotaItem {\n");
        sb.append("    used: ").append(this.toIndentedString(this.used)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUsed() != null) {
            joiner.add(String.format("%sused%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUsed()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLimit() != null) {
            joiner.add(String.format("%slimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLimit()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

