/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"xml", "startDate"})
public class SimulationRequest {
    public static final String JSON_PROPERTY_XML = "xml";
    private String xml;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private OffsetDateTime startDate;

    public SimulationRequest xml(String xml) {
        this.xml = xml;
        return this;
    }

    @Nonnull
    @JsonProperty(value="xml")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getXml() {
        return this.xml;
    }

    @JsonProperty(value="xml")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setXml(String xml) {
        this.xml = xml;
    }

    public SimulationRequest startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulationRequest simulationRequest = (SimulationRequest)o;
        return Objects.equals(this.xml, simulationRequest.xml) && Objects.equals(this.startDate, simulationRequest.startDate);
    }

    public int hashCode() {
        return Objects.hash(this.xml, this.startDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimulationRequest {\n");
        sb.append("    xml: ").append(this.toIndentedString(this.xml)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getXml() != null) {
            joiner.add(String.format("%sxml%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getXml()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStartDate() != null) {
            joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

