/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.quantumdmn.client.model.TierFeaturesConfig;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "name", "price", "features", "paddlePriceId"})
public class Tier {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRICE = "price";
    private BigDecimal price;
    public static final String JSON_PROPERTY_FEATURES = "features";
    private TierFeaturesConfig features;
    public static final String JSON_PROPERTY_PADDLE_PRICE_ID = "paddlePriceId";
    private String paddlePriceId;

    public Tier id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Tier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Tier price(BigDecimal price) {
        this.price = price;
        return this;
    }

    @Nullable
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Tier features(TierFeaturesConfig features) {
        this.features = features;
        return this;
    }

    @Nullable
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TierFeaturesConfig getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeatures(TierFeaturesConfig features) {
        this.features = features;
    }

    public Tier paddlePriceId(String paddlePriceId) {
        this.paddlePriceId = paddlePriceId;
        return this;
    }

    @Nullable
    @JsonProperty(value="paddlePriceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaddlePriceId() {
        return this.paddlePriceId;
    }

    @JsonProperty(value="paddlePriceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaddlePriceId(String paddlePriceId) {
        this.paddlePriceId = paddlePriceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tier tier = (Tier)o;
        return Objects.equals(this.id, tier.id) && Objects.equals(this.name, tier.name) && Objects.equals(this.price, tier.price) && Objects.equals(this.features, tier.features) && Objects.equals(this.paddlePriceId, tier.paddlePriceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.price, this.features, this.paddlePriceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tier {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    paddlePriceId: ").append(this.toIndentedString(this.paddlePriceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPrice() != null) {
            joiner.add(String.format("%sprice%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrice()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFeatures() != null) {
            joiner.add(this.getFeatures().toUrlQueryString((String)prefix + JSON_PROPERTY_FEATURES + suffix));
        }
        if (this.getPaddlePriceId() != null) {
            joiner.add(String.format("%spaddlePriceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPaddlePriceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

