/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.quantumdmn.client.model.TierLimits;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"credits", "overchargePricePer100Credits", "limits", "features"})
public class TierFeaturesConfig {
    public static final String JSON_PROPERTY_CREDITS = "credits";
    private Integer credits;
    public static final String JSON_PROPERTY_OVERCHARGE_PRICE_PER100_CREDITS = "overchargePricePer100Credits";
    private Integer overchargePricePer100Credits;
    public static final String JSON_PROPERTY_LIMITS = "limits";
    private TierLimits limits;
    public static final String JSON_PROPERTY_FEATURES = "features";
    private Map<String, Boolean> features = new HashMap<String, Boolean>();

    public TierFeaturesConfig credits(Integer credits) {
        this.credits = credits;
        return this;
    }

    @Nullable
    @JsonProperty(value="credits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCredits() {
        return this.credits;
    }

    @JsonProperty(value="credits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public TierFeaturesConfig overchargePricePer100Credits(Integer overchargePricePer100Credits) {
        this.overchargePricePer100Credits = overchargePricePer100Credits;
        return this;
    }

    @Nullable
    @JsonProperty(value="overchargePricePer100Credits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getOverchargePricePer100Credits() {
        return this.overchargePricePer100Credits;
    }

    @JsonProperty(value="overchargePricePer100Credits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOverchargePricePer100Credits(Integer overchargePricePer100Credits) {
        this.overchargePricePer100Credits = overchargePricePer100Credits;
    }

    public TierFeaturesConfig limits(TierLimits limits) {
        this.limits = limits;
        return this;
    }

    @Nullable
    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TierLimits getLimits() {
        return this.limits;
    }

    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimits(TierLimits limits) {
        this.limits = limits;
    }

    public TierFeaturesConfig features(Map<String, Boolean> features) {
        this.features = features;
        return this;
    }

    public TierFeaturesConfig putFeaturesItem(String key, Boolean featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, Boolean>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeatures(Map<String, Boolean> features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierFeaturesConfig tierFeaturesConfig = (TierFeaturesConfig)o;
        return Objects.equals(this.credits, tierFeaturesConfig.credits) && Objects.equals(this.overchargePricePer100Credits, tierFeaturesConfig.overchargePricePer100Credits) && Objects.equals(this.limits, tierFeaturesConfig.limits) && Objects.equals(this.features, tierFeaturesConfig.features);
    }

    public int hashCode() {
        return Objects.hash(this.credits, this.overchargePricePer100Credits, this.limits, this.features);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TierFeaturesConfig {\n");
        sb.append("    credits: ").append(this.toIndentedString(this.credits)).append("\n");
        sb.append("    overchargePricePer100Credits: ").append(this.toIndentedString(this.overchargePricePer100Credits)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCredits() != null) {
            joiner.add(String.format("%scredits%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCredits()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOverchargePricePer100Credits() != null) {
            joiner.add(String.format("%soverchargePricePer100Credits%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOverchargePricePer100Credits()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLimits() != null) {
            joiner.add(this.getLimits().toUrlQueryString((String)prefix + JSON_PROPERTY_LIMITS + suffix));
        }
        if (this.getFeatures() != null) {
            for (String _key : this.getFeatures().keySet()) {
                joiner.add(String.format("%sfeatures%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getFeatures().get(_key), URLEncoder.encode(String.valueOf(this.getFeatures().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

